package com.locnavi.map.ui.widget;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

//import com.locnavi.map.R;
//import com.xunji.xunjimap.model.bean.CarCheckData;

import com.locnavi.map.R;
import com.locnavi.map.model.bean.CarCheckData;

import java.text.SimpleDateFormat;
import java.util.Date;

public class FindCarCenterDialog {
    private final TextView tvStop;
    private Dialog dialog;
    private View contentView;
    private Context context;





    private ImageView ivCloseFindCar;
    private TextView tvTitle;
    private TextView tvCarFloor;
    private TextView tvCarResgion;
    private TextView tvTofindcar;
    private TextView tvStopCarTime;
    private TextView tvPrice;


    private LinearLayout llFindCar;

    private LinearLayout llFinshFindCar;
    private TextView tvConfirm;
    private TextView tvCancle;
    private CharSequence lasttext;


    public FindCarCenterDialog(Context context , CarCheckData carCheckData ,
                               View.OnClickListener findCarOnClickListener,
                               View.OnClickListener confirmOnclickListener
    ) {
        this.context  = context;
        String regeion = carCheckData.getRegionName();

        String floor = carCheckData.getFloor();
        String price = "0";



        Date stopCarTime = carCheckData.getUpdatedAt();
        SimpleDateFormat format= new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String dataString = "";
        if (stopCarTime != null){
            dataString = format.format(stopCarTime);
        }else {
            dataString = "";
        }




        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_find_car, null);



        llFindCar = (LinearLayout) contentView.findViewById(R.id.ll_find_car);

        ivCloseFindCar = (ImageView) contentView.findViewById(R.id.iv_close_find_car);
        tvTitle = (TextView) contentView.findViewById(R.id.tv_title);
        tvCarFloor = (TextView) contentView.findViewById(R.id.tv_car_floor);
        tvCarResgion = (TextView) contentView.findViewById(R.id.tv_car_resgion);
        tvTofindcar = (TextView) contentView.findViewById(R.id.tv_tofindcar);
        tvStopCarTime = (TextView) contentView.findViewById(R.id.tv_stop_car_time);
        tvPrice = (TextView) contentView.findViewById(R.id.tv_price);
        tvStop = (TextView) contentView.findViewById(R.id.tv_stop);
        tvStop.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                lasttext = tvTitle.getText();
                tvTitle.setText(R.string.ipsmap_stop_service);
                llFindCar.setVisibility(View.GONE);

                llFinshFindCar.setVisibility(View.VISIBLE);

                tvStop.setVisibility(View.GONE);

            }
        });




        llFinshFindCar = (LinearLayout) contentView.findViewById(R.id.ll_finsh_find_car);
        tvConfirm = (TextView) contentView.findViewById(R.id.tv_confirm);
        tvCancle = (TextView) contentView.findViewById(R.id.tv_cancle);



        tvCancle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                tvTitle.setText(lasttext);
                llFinshFindCar.setVisibility(View.GONE);
                llFindCar.setVisibility(View.VISIBLE);
                tvStop.setVisibility(View.VISIBLE);
            }
        });
        tvConfirm.setOnClickListener(confirmOnclickListener);


        ivCloseFindCar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });


        tvStopCarTime.setText(context.getString(R.string.ipsmap_stop_car_time)+dataString);

        Date updatedAt = carCheckData.getUpdatedAt();
        Date date = new Date();
        long longTime = 0;
        if (updatedAt!= null ){
            longTime = date.getTime()- updatedAt.getTime();
//            longTime = date.getTime()+60*1000*60*24 +1000*60*60*3 - updatedAt.getTime();
        }else {
            longTime = 0;
        }

        int min = (int)longTime / 60/1000;
        String duration = min+"";

        if (min < 60){
            if (min == 0){
                tvTitle.setText(context.getString(R.string.ipsmap_stop_car_timelong)+1+context.getString(R.string.ipsmap_minues));
            }else {
                tvTitle.setText(context.getString(R.string.ipsmap_stop_car_timelong)+min+context.getString(R.string.ipsmap_minues));
            }

        }else if (min >=60 && min < (60*24)){
            tvTitle.setText(context.getString(R.string.ipsmap_stop_car_timelong)+min/60+context.getString(R.string.ipsmap_hour)+(min - (min/60)*60)+context.getString(R.string.ipsmap_minues));
        }else if(min >=(60*24)){
            tvTitle.setText(context.getString(R.string.ipsmap_stop_car_timelong)+min/(60*24)+context.getString(R.string.ipsmap_day)+(min - (min/(60*24))*60*24)/60+context.getString(R.string.ipsmap_hour));
        }

        tvTofindcar.setOnClickListener(findCarOnClickListener);

//        tvCarFloor.setText("爱车位于"+floor+"层");
        addForeWiteColorSpan(context.getString(R.string.ipsmap_car_location_2),tvCarFloor);
        addForeColorSpan(floor,tvCarFloor);
        addForeWiteColorSpan(context.getString(R.string.ipsmap_floor),tvCarFloor);


//        tvCarResgion.setText(regeion+"附近");
        addFontSpan(tvCarResgion,regeion,60);
        addFontSpan(tvCarResgion,context.getString(R.string.ipsmap_near),30);


        if (!TextUtils.isEmpty(price)){
            tvPrice.setText(context.getString(R.string.ipsmap_cost)+price+context.getString(R.string.ipsmap_yue_hour));
        }else {
            tvPrice.setText(context.getString(R.string.ipsmap_cost) + "    "+0+context.getString(R.string.ipsmap_yue_hour));
        }

        dialog = new Dialog(context, R.style.IpsmapDialogDimEnabled);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                ViewGroup.LayoutParams.WRAP_CONTENT));
        dialog.setCanceledOnTouchOutside(true);
        Window win = dialog.getWindow();
        win.getDecorView().setPadding(20, 20, 20, 20);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.WRAP_CONTENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
        win.setGravity(Gravity.CENTER);
    }


    public  void setCarDate(CarCheckData carCheckData ){

        String regeion = carCheckData.getRegionName();

        String floor = carCheckData.getFloor();
        String price = "0";

        Date updatedAt = carCheckData.getUpdatedAt();
        Date date = new Date();
        long longTime = 0;
        if (updatedAt!= null ){
            longTime = date.getTime() - updatedAt.getTime();
        }else {
            longTime = 0;
        }

        int min = (int)longTime / 60/1000;
        String duration = min+"";

        Date stopCarTime = carCheckData.getUpdatedAt();
        SimpleDateFormat format= new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String dataString = "";
        if (stopCarTime != null){
            dataString = format.format(stopCarTime);
        }else {
            dataString = "";
        }



    }
    /**
     * 文字颜色
     */
    private void addForeColorSpan(String floor , TextView tv) {
        SpannableString spanString = new SpannableString(floor);
        ForegroundColorSpan span = new ForegroundColorSpan(context.getResources().getColor(R.color.ipsmap_tvOrg1));
        spanString.setSpan(span, 0, floor.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        tv.append(spanString);
    }

  /**
     * 文字颜色
     */
    private void addForeWiteColorSpan(String floor , TextView tv) {
        SpannableString spanString = new SpannableString(floor);
        ForegroundColorSpan span = new ForegroundColorSpan(Color.WHITE);
        spanString.setSpan(span, 0, floor.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        tv.append(spanString);
    }


    /**
     * 字体大小
     */
    private void addFontSpan(TextView tv,String content ,int size ) {
        SpannableString spanString = new SpannableString(content);
        AbsoluteSizeSpan span = new AbsoluteSizeSpan(size);
        spanString.setSpan(span, 0, content.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        tv.append(spanString);
    }


    public void show() {
        if (dialog.isShowing()) {
            return;
        }

        if (((Activity) context).hasWindowFocus()) {
            dialog.show();
        }
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

}
