package com.locnavi.map.ui.activity;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.ImageView;

import com.locnavi.location.xunjimap.model.bean.DataHolder;
import com.locnavi.location.xunjimap.model.bean.LocationRegionData;
import com.locnavi.location.xunjimap.model.bean.LocationRegionIconData;
import com.locnavi.location.xunjimap.model.bean.LocationRegionTagData;
import com.locnavi.location.xunjimap.utils.KeyboardUtils;
import com.locnavi.location.xunjimap.utils.MixpanelConstants;
import com.locnavi.location.xunjimap.utils.MixpanelEvent;
import com.locnavi.location.xunjimap.utils.SpUtils;
import com.locnavi.location.xunjimap.utils.T;
import com.locnavi.map.R;
import com.locnavi.map.base.BasePresenterActivity;
import com.locnavi.map.presenter.IView.IpsMapSearchView;
import com.locnavi.map.presenter.IpsMapSearchPresenter;
import com.locnavi.map.ui.fragment.XJSearchGenreFragment;
import com.locnavi.map.ui.fragment.XJSearchHistoryFragment;
import com.locnavi.map.utils.KeyboardVisibilityEvent.KeyboardVisibilityEvent;
import com.locnavi.map.utils.KeyboardVisibilityEvent.Unregister;


import org.json.JSONArray;
import org.json.JSONException;

import java.util.ArrayList;
import java.util.List;

public class XJSearchActivity extends BasePresenterActivity<IpsMapSearchPresenter> implements View.OnClickListener,
        IpsMapSearchView {

    private ImageView ivSearch;
    private EditText etSearch;
    private XJSearchGenreFragment searchGenreFragment;
    private XJSearchHistoryFragment searchHistoryFragment;
    public static final String
            REQUEST_ID = "id",
            REQUEST_TYPE = "type",
            REQUEST_TYPE_START = "start",
            REQUEST_TYPE_TARGET = "target",
            REQUEST_REGIONS = "regions";
    private String id, type;
    private ArrayList<LocationRegionData> locationRegionDatas;
    private Unregister keyboardRegister;

    protected static Intent getIntent(Context context, String id, String type) {
        Intent intent = new Intent(context, XJSearchActivity.class);
        intent.putExtra(REQUEST_ID, id);
        intent.putExtra(REQUEST_TYPE, type);
//        intent.putExtra(REQUEST_REGIONS, locationRegionDatas);
        return intent;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.ipsmap_activity_search;
    }

    @Override
    public void finish() {
        super.finish();
        KeyboardUtils.hideKeyboard(this);
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        ivSearch = (ImageView) findViewById(R.id.iv_search);
        etSearch = (EditText) findViewById(R.id.et_search);
        findViewById(R.id.iv_back).setOnClickListener(this);
        ivSearch.setOnClickListener(this);
        id = getIntent().getStringExtra(REQUEST_ID);
        type = getIntent().getStringExtra(REQUEST_TYPE);
        locationRegionDatas = DataHolder.getInstance().getLocationRegions();
//        locationRegionDatas = getIntent().getParcelableArrayListExtra(REQUEST_REGIONS);
        showFragment(savedInstanceState);
        if (type.equals(REQUEST_TYPE_TARGET)) {
            etSearch.setHint(R.string.ipsmap_destination);
        } else {
            etSearch.setHint(R.string.ipsmap_starting_point);
        }
        etSearch.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_SEARCH ||
                    (event != null && event.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                String search = etSearch.getText().toString();
                if (TextUtils.isEmpty(search.trim())) {
                    T.showShort(R.string.ipsmap_empty_search_content);
                } else {
                    KeyboardUtils.hideKeyboard(this);
                    queryByName(search, MixpanelConstants.SEARCH_FROM_SEARCH_TEXT);
                }
                return true;
            }
            return false;
        });
        keyboardRegister = KeyboardVisibilityEvent.registerEventListener(this, isOpen -> {
            if (isOpen) {
                getSupportFragmentManager().beginTransaction()
                        .show(searchHistoryFragment)
                        .hide(searchGenreFragment)
                        .commit();

            } else {
                getSupportFragmentManager().beginTransaction()
                        .show(searchGenreFragment)
                        .hide(searchHistoryFragment)
                        .commit();
            }
        });
    }

    @Override
    protected void onDestroy() {
        if (keyboardRegister != null) {
            keyboardRegister.unregister();
        }
        super.onDestroy();
    }

    private void showFragment(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            searchGenreFragment = (XJSearchGenreFragment) getSupportFragmentManager().findFragmentByTag("genre");
            searchHistoryFragment = (XJSearchHistoryFragment) getSupportFragmentManager().findFragmentByTag("history");
            getSupportFragmentManager().beginTransaction()
                    .show(searchGenreFragment)
                    .hide(searchHistoryFragment)
                    .commit();
        } else {
            searchGenreFragment = XJSearchGenreFragment.getInstance(id, type);
            searchHistoryFragment = XJSearchHistoryFragment.getInstance(id, type);
            getSupportFragmentManager().beginTransaction()
                    .add(R.id.flContent, searchGenreFragment, "genre")
                    .add(R.id.flContent, searchHistoryFragment, "history")
                    .hide(searchHistoryFragment)
                    .commit();
        }
    }

    @Override
    protected void initData() {

    }

    private void setSearchHistory(String content) {
        String json = SpUtils.getSearchHistoryJson(context);
        try {
            JSONArray jsonArray = new JSONArray();
            if (!TextUtils.isEmpty(json)) {
                jsonArray = new JSONArray(json);
            }
            boolean firstAdd = true;
            for (int i = 0; i < jsonArray.length(); i++) {
                if (jsonArray.optString(i).equals(content)) {
                    firstAdd = false;
                    break;
                }
            }
            if (firstAdd) {
                jsonArray.put(content);
            }
            SpUtils.setSearchHistory(context, jsonArray.toString());
            searchHistoryFragment.loadHistory();
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void queryByName(String content, String from) {
        setSearchHistory(content);
        presenter.queryByContent(id, content, from, locationRegionDatas);
    }

    //读写sd业务逻辑
    public void doSDCardAndRecordAudio() {
        startSpeechDialog(result -> {
            queryByName(result, MixpanelConstants.SEARCH_FROM_SEARCH_VOICE);
        });
    }


    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.iv_back) {
            finish();
        } else if (v.getId() == R.id.iv_search) {
            if (hasPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE, Manifest.permission.RECORD_AUDIO, Manifest.permission.RECORD_AUDIO)) {
                doSDCardAndRecordAudio();
            } else {
                requestPermission(MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO, Manifest.permission.WRITE_EXTERNAL_STORAGE, Manifest.permission.RECORD_AUDIO);
            }
        }
    }


    @Override
    public void queryByContentSuccess(String content, String from, ArrayList<LocationRegionData> searchRegionDatas) {
        MixpanelEvent.search(content, searchRegionDatas.size(), from);
        if (searchRegionDatas.size() == 0) {
            T.showShort(getString(R.string.ipsmap_no_search_result, content));
        } else {
            Intent intent = new Intent();
            intent.putExtra(XJMapActivity.RESULT_SEARCH_CONTENT, content);
            intent.putExtra(XJMapActivity.RESULT_SEARCH_RESULT, searchRegionDatas);
            intent.putExtra(REQUEST_TYPE, type);
            setResult(RESULT_OK, intent);
            finish();
        }
    }

    @Override
    public void queryByGenreSuccess(LocationRegionIconData locationRegionIconData, ArrayList<LocationRegionData> list) {

    }

    @Override
    public void queryRegionIconDataSuccess(List<LocationRegionIconData> locationRegionIconDatas) {

    }

    @Override
    public void queryRegionTagDataSuccess(List<LocationRegionTagData> locationRegionTagDatas) {

    }

    @Override
    public void queryHotGenreSuccess(List<String> tags, List<LocationRegionIconData> locationRegionIconDatas) {

    }
}
