/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.iflytek.cloud.InitListener;
import com.iflytek.cloud.SpeechUtility;
import com.iflytek.cloud.thirdparty.ao;
import com.iflytek.cloud.thirdparty.ar;
import com.iflytek.speech.ISpeechModule;
import com.iflytek.speech.UtilityConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;

abstract class SpeechModuleAidl<I extends IInterface>
implements ISpeechModule {
    protected Object mSynLock = new Object();
    protected I mService;
    protected Context mContext = null;
    private ServiceConnection mConnection = null;
    private InitListener mInitListener = null;
    private String mBindAction = null;
    private HashMap<String, String> mParams = new HashMap();
    private volatile boolean userDestroy = false;
    private Handler mUiHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message message) {
            if (SpeechModuleAidl.this.mInitListener == null) {
                return;
            }
            SpeechModuleAidl.this.mInitListener.onInit(message.what);
        }
    };

    public SpeechModuleAidl(Context context, InitListener initListener, String string) {
        this.mContext = context;
        this.mInitListener = initListener;
        this.mBindAction = string;
        this.bindService();
    }

    private void bindService() {
        if (!this.isActionInstalled(this.mContext, this.mBindAction)) {
            if (null != this.mInitListener) {
                Message.obtain((Handler)this.mUiHandler, (int)21001, (int)0, (int)0, null).sendToTarget();
            }
            return;
        }
        Intent intent = this.getIntent();
        intent.setAction(this.mBindAction);
        intent.setPackage("com.iflytek.vflynote");
        this.mConnection = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                Object object = SpeechModuleAidl.this.mSynLock;
                synchronized (object) {
                    Log.d((String)SpeechModuleAidl.this.getTag(), (String)"init success");
                    SpeechModuleAidl.this.mService = SpeechModuleAidl.this.getService(iBinder);
                    Log.d((String)SpeechModuleAidl.this.getTag(), (String)("mService :" + SpeechModuleAidl.this.mService));
                    if (null != SpeechModuleAidl.this.mInitListener) {
                        Message.obtain((Handler)SpeechModuleAidl.this.mUiHandler, (int)0, (int)0, (int)0, null).sendToTarget();
                    }
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
                Log.d((String)SpeechModuleAidl.this.getTag(), (String)"onServiceDisconnected");
                SpeechModuleAidl.this.mService = null;
                if (!SpeechModuleAidl.this.userDestroy) {
                    try {
                        SpeechModuleAidl.this.bindService();
                    }
                    catch (Exception exception) {
                        Log.e((String)SpeechModuleAidl.this.getTag(), (String)("rebindService error = " + exception.toString()));
                    }
                }
            }
        };
        try {
            this.mContext.bindService(intent, this.mConnection, 1);
        }
        catch (SecurityException securityException) {
            ao.a(securityException);
        }
    }

    private I getService(IBinder iBinder) {
        try {
            ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
            Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
            String string = clazz.getName();
            Log.d((String)this.getTag(), (String)("className = " + string));
            Class<?> clazz2 = Class.forName(string + "$Stub");
            Method method = clazz2.getDeclaredMethod("asInterface", IBinder.class);
            return (I)((IInterface)method.invoke(null, iBinder));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ao.a(classNotFoundException);
        }
        catch (SecurityException securityException) {
            ao.a(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ao.a(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ao.a(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ao.a(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ao.a(invocationTargetException);
        }
        catch (Exception exception) {
            ao.a(exception);
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return null != this.mService;
    }

    @Override
    public int setParameter(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 20012;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.mParams.remove(string);
            return 0;
        }
        this.mParams.put(string, string2);
        return 0;
    }

    @Override
    public String getParameter(String string) {
        return this.mParams.get(string);
    }

    @Override
    public Intent getIntent() {
        Intent intent = new Intent();
        if (!this.mParams.isEmpty()) {
            for (String object2 : this.mParams.keySet()) {
                intent.putExtra(object2, this.mParams.get(object2));
            }
            ar ar2 = new ar(this.mParams.get("params"), null);
            HashMap<String, String> hashMap = ar2.c();
            if (null != hashMap && !hashMap.isEmpty()) {
                for (String string : hashMap.keySet()) {
                    intent.putExtra(string, hashMap.get(string));
                }
            }
        }
        SpeechUtility speechUtility = SpeechUtility.getUtility();
        intent.putExtra("caller.appid", speechUtility.getParameter("appid"));
        intent.putExtra("caller.name", UtilityConfig.getCallerInfo(this.mContext, "caller.name"));
        intent.putExtra("caller.pkg", UtilityConfig.getCallerInfo(this.mContext, "caller.pkg"));
        intent.putExtra("caller.ver.name", UtilityConfig.getCallerInfo(this.mContext, "caller.ver.name"));
        intent.putExtra("caller.ver.code", UtilityConfig.getCallerInfo(this.mContext, "caller.ver.code"));
        return intent;
    }

    public boolean isActionInstalled(Context context, String string) {
        Intent intent;
        if (null == context || TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveService(intent = new Intent(string), 0);
        return resolveInfo != null;
    }

    @Override
    public boolean destory() {
        Log.d((String)this.getTag(), (String)"destory");
        try {
            this.userDestroy = true;
            if (this.mConnection != null) {
                this.mContext.unbindService(this.mConnection);
                this.mConnection = null;
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ao.a(illegalArgumentException);
            return false;
        }
    }

    protected final String getTag() {
        return this.getClass().toString();
    }
}

