package com.locnavi.map.presenter;

import com.locnavi.location.xunjimap.model.bean.AndroidLSRData;
import com.locnavi.location.xunjimap.model.bean.DataHolder;
import com.locnavi.location.xunjimap.model.bean.LocationRegionData;
import com.locnavi.location.xunjimap.model.bean.PhotoData;
import com.locnavi.location.xunjimap.model.parse.AndroidLSR;
import com.locnavi.location.xunjimap.model.parse.LocationShare;
import com.locnavi.location.xunjimap.model.parse.NavigationPhoto;
import com.locnavi.location.xunjimap.model.parse.POI;
import com.locnavi.location.xunjimap.model.parse.Synonym;
import com.locnavi.location.xunjimap.utils.DateUtils;
import com.locnavi.location.xunjimap.utils.T;
import com.locnavi.map.R;
import com.locnavi.map.base.BasePresenter;
import com.locnavi.map.model.bean.CarCheckData;
import com.locnavi.map.model.parse.CarCheck;
import com.locnavi.map.presenter.IView.IpsMapView;
import com.locnavi.map.ui.widget.ProgressDialog;
//import com.locnavi.map.R;
//import com.xunji.xunjimap.base.BasePresenter;
//import com.xunji.xunjimap.model.bean.CarCheckData;
//import com.xunji.xunjimap.model.parse.CarCheck;
//import com.xunji.xunjimap.presenter.IView.IpsMapView;
//import com.xunji.xunjimap.ui.widget.ProgressDialog;

import com.parse.FindCallback;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseQuery;

import org.json.JSONArray;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * author:chen
 * time:2017/6/29
 * desc:
 */
public class IpsMapPresenter extends BasePresenter<IpsMapView> {

    public void queryNavPhoto(String buildingId) {
        List<PhotoData> photoList = new ArrayList<>();
        ParseQuery.getQuery(NavigationPhoto.class)
                .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                .whereEqualTo("buildingId", buildingId)
                .setLimit(1000)
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    for (int i = 0; i < objects.size(); i++) {
                        PhotoData photoData = new PhotoData();
                        NavigationPhoto navigationPhoto = objects.get(i);
                        photoData.setUrl(navigationPhoto.getUrl());
                        photoData.setBuildingId(navigationPhoto.getBuildingId());
                        photoData.setComment(navigationPhoto.getComment());
                        photoData.setObjectId(navigationPhoto.getObjectId());
                        photoData.setSelfId(navigationPhoto.getSelfId());
                        photoList.add(photoData);
                    }
                    if (isViewAttached()) {
                        getView().queryNavPhotoSuccess(photoList);
                    }
                });
    }

    private void queryPOIByContent(String id, List<String> synonyms) {
        if (synonyms == null || synonyms.size() == 0) {
            return;
        }
        String content = synonyms.get(0);
        ArrayList<LocationRegionData> locationRegionDatas = DataHolder.getInstance().getLocationRegions();
        ParseObject parseObject = ParseObject.createWithoutData("MappingProject", id);
        ParseQuery<POI> poiParseQuery = ParseQuery.getQuery(POI.class)
                .whereEqualTo("project", parseObject)
                .whereContains("name", content);

        ParseQuery<POI> poiParseQuery1 = ParseQuery.getQuery(POI.class)
                .whereEqualTo("project", parseObject)
                .whereContains("name", content.toUpperCase());

        ParseQuery<POI> poiParseQuery2 = ParseQuery.getQuery(POI.class)
                .whereEqualTo("project", parseObject)
                .whereContains("name", content.toLowerCase());

        List<ParseQuery<POI>> queries = new ArrayList<>();
        queries.add(poiParseQuery);
        queries.add(poiParseQuery1);
        queries.add(poiParseQuery2);

        ParseQuery.or(queries)
                .orderByAscending("floor")
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    ArrayList<LocationRegionData> searchRegionDatas = new ArrayList<>();
                    if (objects.size() > 0) {
                        for (POI poi : objects) {
                            LocationRegionData data = new LocationRegionData(poi.getName(), poi.getFloorName(),
                                    poi.getLongitude(), poi.getLatitude());
                            searchRegionDatas.add(data);
                        }
                    }
                    for (LocationRegionData locationRegionData : locationRegionDatas) {
                        for (String name : synonyms) {
                            if (locationRegionData.getName().toUpperCase().contains(name.toUpperCase())) {
                                searchRegionDatas.add(locationRegionData);
                                continue;
                            }
                        }
                    }
                    if (isViewAttached()) {
                        getView().queryPOIByContentSuccess(content, searchRegionDatas);
                    }
                });
    }

    public void queryPOIByContent(String id, String content) {
        List<String> synonyms = new ArrayList<>();
        ParseQuery.getQuery(Synonym.class)
                .whereEqualTo(Synonym.SYNONYM, content)
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    if (objects.size() > 0) {
                        JSONArray jsonArray = objects.get(0).getJSONArray(Synonym.SYNONYM);
                        for (int i = 0; i < jsonArray.length(); i++) {
                            synonyms.add(jsonArray.optString(i));
                        }
                    }
                    if (synonyms.size() == 0) {
                        synonyms.add(content);
                    }
                    queryPOIByContent(id, synonyms);
                });
    }

    public void queryPOIByLink(String id, String link, final ProgressDialog progressDialog) {
        progressDialog.show();
        ParseObject parseObject = ParseObject.createWithoutData("MappingProject", id);
        ParseQuery.getQuery(POI.class)
                .whereEqualTo("project", parseObject)
                .whereEqualTo("link", link)
                .orderByAscending("floor")
                .getFirstInBackground((object, e) -> {
                    progressDialog.dismiss();
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    if (isViewAttached()) {
                        getView().queryPOIByLinkSuccess(object);
                    }
                });
    }

    public void query24hGroup(String id) {
        List<String> groupIds = new ArrayList<>();
        ParseObject parseObject = ParseObject.createWithoutData("MappingProject", id);
        ParseQuery.getQuery(LocationShare.class)
                .whereEqualTo(LocationShare.PROJECT, parseObject)
                .whereEqualTo(LocationShare.OWNER, true)
                .whereGreaterThan(LocationShare.UPDATED_AT, DateUtils.dateDiff(new Date(), -1))
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    for (LocationShare item : objects) {
                        groupIds.add(item.getGroupId());
                    }
                    if (isViewAttached()) {
                        getView().query24hGroupSuccess(groupIds);
                    }

                });
    }

    public void queryGroupInfo(String id, String groupId) {
        ParseObject parseObject = ParseObject.createWithoutData("MappingProject", id);
        ParseQuery.getQuery(LocationShare.class)
                .whereEqualTo(LocationShare.PROJECT, parseObject)
                .whereEqualTo(LocationShare.GROUP_ID, groupId)
                .orderByDescending(LocationShare.CREATED_AT)
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        e.printStackTrace();
                        T.showShort(R.string.ipsmap_wrong_groupId);
                        return;
                    }
                    if (objects.size() == 0) {
                        T.showShort(R.string.ipsmap_wrong_groupId);
                        return;
                    }
                    if (objects.size() >= 9) {
                        T.showShort("群已经满了");
                        return;
                    }
                    if (isViewAttached()) {
                        getView().queryGroupInfoSuccess(groupId, objects);
                    }
                });
    }

    public void queryMyGroup(String id, String groupId, boolean showError) {
        ParseObject parseObject = ParseObject.createWithoutData("MappingProject", id);
        ParseQuery.getQuery(LocationShare.class)
                .whereEqualTo(LocationShare.PROJECT, parseObject)
                .whereNotEqualTo(LocationShare.IS_QUIT, true)
                .whereEqualTo(LocationShare.GROUP_ID, groupId)
                .orderByDescending(LocationShare.UPDATED_AT)
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        e.printStackTrace();
                        if (showError) {
                            T.showShort(R.string.ipsmap_wrong_groupId);
                        }
                        return;
                    }
                    if (isViewAttached()) {
                        getView().queryMyGroupSuccess(groupId, objects);
                    }
                });
    }

    public void queryCarCheck(String deviceID ,String projectId ,ArrayList<CarCheckData> carCheckDatas) {
        ParseObject parseObject = ParseObject.createWithoutData("MappingProject", projectId);

//        SpUtils.setNotificationTime();


        ParseQuery.getQuery(CarCheck.class)
                .whereEqualTo(CarCheck.deviceId,deviceID)
                .whereEqualTo(CarCheck.project,parseObject)
                .whereNotEqualTo(CarCheck.isFinish,true)
                .findInBackground(new FindCallback<CarCheck>() {
                    @Override
                    public void done(List<CarCheck> carChecks, ParseException e) {
                        if (e != null){
                            handleError(e);
                            return;
                        }
                        carCheckDatas.clear();
                        for (int i = 0; i < carChecks.size(); i++) {
                            CarCheck carCheck = carChecks.get(i);
                            CarCheckData carCheckData = new CarCheckData();
                            carCheckData.setProject(carCheck.getProject().getObjectId());
                            carCheckData.setFinish(carCheck.getFinish());
                            carCheckData.setFloor(carCheck.getFloor());
                            carCheckData.setRegionName(carCheck.getRegionName());
//                            carCheckData.setLocation(carCheck.getLocation());
                            carCheckData.setObjectId(carCheck.getObjectId());
                            carCheckData.setUpdatedAt(carCheck.getUpdatedAt());
                            carCheckDatas.add(carCheckData);

                        }
                        if(isViewAttached()){
//                            getView().queryCarCheckSuccess();
                        }

                    }
                });



    }

    public void queryAndroidLSR(ArrayList<AndroidLSRData> androidLSRDatas, String buildingId, String buildingName) {
        ParseQuery.getQuery(AndroidLSR.class)
                .orderByAscending("updatedAt")
                .whereEqualTo("buildingId", buildingId)
                .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                .setLimit(1000)
                .findInBackground(new FindCallback<AndroidLSR>() {
                    @Override
                    public void done(List<AndroidLSR> androidLSRList, ParseException e) {
                        if (e != null) {
                            handleError(e);
                            return;
                        }
                        androidLSRDatas.clear();
                        for (int i = 0; i < androidLSRList.size(); i++) {
                            AndroidLSR androidLSR = androidLSRList.get(i);
                            AndroidLSRData androidLSRData = new AndroidLSRData();
                            androidLSRData.setBuildingId(buildingName);
                            androidLSRData.setName(androidLSR.getName());
                            androidLSRData.setUpdateAt(androidLSR.getUpdatedAt());
                            androidLSRData.setFile(androidLSR.getFileObject());
                            androidLSRDatas.add(androidLSRData);
                        }
                        if (isViewAttached()) {
                            getView().queryAndroidLSRSuccess(androidLSRDatas);
                        }

                    }
                });
    }
}
