/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech.aidl;

import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import com.iflytek.speech.SynthesizerListener;

public interface ISpeechSynthesizer
extends IInterface {
    public int synthesizeToUrl(Intent var1, SynthesizerListener var2);

    public int startSpeaking(Intent var1, SynthesizerListener var2);

    public int pauseSpeaking(SynthesizerListener var1);

    public int resumeSpeaking(SynthesizerListener var1);

    public int stopSpeaking(SynthesizerListener var1);

    public boolean isSpeaking();

    public String getLocalSpeakerList();

    public static abstract class Stub
    extends Binder
    implements ISpeechSynthesizer {
        private static final String DESCRIPTOR = "com.iflytek.speech.aidl.ISpeechSynthesizer";
        static final int TRANSACTION_synthesizeToUrl = 1;
        static final int TRANSACTION_startSpeaking = 2;
        static final int TRANSACTION_pauseSpeaking = 3;
        static final int TRANSACTION_resumeSpeaking = 4;
        static final int TRANSACTION_stopSpeaking = 5;
        static final int TRANSACTION_isSpeaking = 6;
        static final int TRANSACTION_getLocalSpeakerList = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISpeechSynthesizer asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ISpeechSynthesizer) {
                return (ISpeechSynthesizer)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n2, Parcel parcel, Parcel parcel2, int n3) {
            switch (n2) {
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = 0 != parcel.readInt() ? (Intent)Intent.CREATOR.createFromParcel(parcel) : null;
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(parcel.readStrongBinder());
                    int n4 = this.synthesizeToUrl(intent, synthesizerListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = 0 != parcel.readInt() ? (Intent)Intent.CREATOR.createFromParcel(parcel) : null;
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(parcel.readStrongBinder());
                    int n5 = this.startSpeaking(intent, synthesizerListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(n5);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(parcel.readStrongBinder());
                    int n6 = this.pauseSpeaking(synthesizerListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(parcel.readStrongBinder());
                    int n7 = this.resumeSpeaking(synthesizerListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(n7);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(parcel.readStrongBinder());
                    int n8 = this.stopSpeaking(synthesizerListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(n8);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl2 = this.isSpeaking();
                    parcel2.writeNoException();
                    parcel2.writeInt(bl2 ? 1 : 0);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string = this.getLocalSpeakerList();
                    parcel2.writeNoException();
                    parcel2.writeString(string);
                    return true;
                }
            }
            return super.onTransact(n2, parcel, parcel2, n3);
        }

        private static class Proxy
        implements ISpeechSynthesizer {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int synthesizeToUrl(Intent intent, SynthesizerListener synthesizerListener) {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startSpeaking(Intent intent, SynthesizerListener synthesizerListener) {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int pauseSpeaking(SynthesizerListener synthesizerListener) {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int resumeSpeaking(SynthesizerListener synthesizerListener) {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int stopSpeaking(SynthesizerListener synthesizerListener) {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpeaking() {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getLocalSpeakerList() {
                String string;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    string = parcel2.readString();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return string;
            }
        }
    }
}

