/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech.aidl;

import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import com.iflytek.speech.GrammarListener;
import com.iflytek.speech.LexiconListener;
import com.iflytek.speech.RecognizerListener;

public interface ISpeechRecognizer
extends IInterface {
    public void startListening(Intent var1, RecognizerListener var2);

    public void stopListening(RecognizerListener var1);

    public void cancel(RecognizerListener var1);

    public boolean isListening();

    public void buildGrammar(Intent var1, GrammarListener var2);

    public void updateLexicon(Intent var1, LexiconListener var2);

    public void writeAudio(Intent var1, byte[] var2, int var3, int var4);

    public static abstract class Stub
    extends Binder
    implements ISpeechRecognizer {
        private static final String DESCRIPTOR = "com.iflytek.speech.aidl.ISpeechRecognizer";
        static final int TRANSACTION_startListening = 1;
        static final int TRANSACTION_stopListening = 2;
        static final int TRANSACTION_cancel = 3;
        static final int TRANSACTION_isListening = 4;
        static final int TRANSACTION_buildGrammar = 5;
        static final int TRANSACTION_updateLexicon = 6;
        static final int TRANSACTION_writeAudio = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISpeechRecognizer asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ISpeechRecognizer) {
                return (ISpeechRecognizer)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n2, Parcel parcel, Parcel parcel2, int n3) {
            switch (n2) {
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = 0 != parcel.readInt() ? (Intent)Intent.CREATOR.createFromParcel(parcel) : null;
                    RecognizerListener recognizerListener = RecognizerListener.Stub.asInterface(parcel.readStrongBinder());
                    this.startListening(intent, recognizerListener);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    RecognizerListener recognizerListener = RecognizerListener.Stub.asInterface(parcel.readStrongBinder());
                    this.stopListening(recognizerListener);
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    RecognizerListener recognizerListener = RecognizerListener.Stub.asInterface(parcel.readStrongBinder());
                    this.cancel(recognizerListener);
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl2 = this.isListening();
                    parcel2.writeNoException();
                    parcel2.writeInt(bl2 ? 1 : 0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = 0 != parcel.readInt() ? (Intent)Intent.CREATOR.createFromParcel(parcel) : null;
                    GrammarListener grammarListener = GrammarListener.Stub.asInterface(parcel.readStrongBinder());
                    this.buildGrammar(intent, grammarListener);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = 0 != parcel.readInt() ? (Intent)Intent.CREATOR.createFromParcel(parcel) : null;
                    LexiconListener lexiconListener = LexiconListener.Stub.asInterface(parcel.readStrongBinder());
                    this.updateLexicon(intent, lexiconListener);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = 0 != parcel.readInt() ? (Intent)Intent.CREATOR.createFromParcel(parcel) : null;
                    byte[] byArray = parcel.createByteArray();
                    int n4 = parcel.readInt();
                    int n5 = parcel.readInt();
                    this.writeAudio(intent, byArray, n4, n5);
                    parcel2.writeNoException();
                    return true;
                }
            }
            return super.onTransact(n2, parcel, parcel2, n3);
        }

        private static class Proxy
        implements ISpeechRecognizer {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startListening(Intent intent, RecognizerListener recognizerListener) {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(recognizerListener != null ? recognizerListener.asBinder() : null);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopListening(RecognizerListener recognizerListener) {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(recognizerListener != null ? recognizerListener.asBinder() : null);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel(RecognizerListener recognizerListener) {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(recognizerListener != null ? recognizerListener.asBinder() : null);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isListening() {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void buildGrammar(Intent intent, GrammarListener grammarListener) {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(grammarListener != null ? grammarListener.asBinder() : null);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateLexicon(Intent intent, LexiconListener lexiconListener) {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(lexiconListener != null ? lexiconListener.asBinder() : null);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeAudio(Intent intent, byte[] byArray, int n2, int n3) {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeByteArray(byArray);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

