package com.locnavi.map.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;

import com.locnavi.map.R;

public class ConfirmCenterDialog {
    private final ImageView btnClose;
    private final TextView tvContent;
    private final String content;
    private Dialog dialog;
    private View contentView;
    private TextView tvTargetRegion;
    private TextView tvStartRegion;
    private TextView tvDistanceTime;
    private String startRegion;
    private String targetRegion;
    private Context context;


    public ConfirmCenterDialog(Context context, String yes, String no, String content) {
        this.context = context;
        this.content = content;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_confirm_center, null);
        tvStartRegion = (TextView) contentView.findViewById(R.id.tv_start_region);
        tvContent = (TextView) contentView.findViewById(R.id.tv_content);
        tvTargetRegion = (TextView) contentView.findViewById(R.id.tv_target_region);
        if (!TextUtils.isEmpty(yes)) {
            tvStartRegion.setText(yes);
        }
        if (!TextUtils.isEmpty(no)) {
            tvTargetRegion.setText(no);
        }
        if (!TextUtils.isEmpty(content)) {
            tvContent.setText(content);
        }

        btnClose = (ImageView) contentView.findViewById(R.id.btn_close);
        btnClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
//        tvClose.setOnClickListener(onClickListener);
        dialog = new Dialog(context,R.style.IpsmapDialogDimEnabled);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        dialog.setCanceledOnTouchOutside(true);
        Window win = dialog.getWindow();
        win.getDecorView().setPadding(20, 20, 20, 20);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
        win.setGravity(Gravity.CENTER);
        dialog.setCancelable(true);
    }


    public void setHint(String hint) {
        tvDistanceTime.setText(hint);
    }

    public void startRegionClickListener(String hint) {
        tvDistanceTime.setText(hint);
    }


    public void setLeftClickListener(View.OnClickListener startRegionClickListener) {
        tvStartRegion.setOnClickListener(startRegionClickListener);
        dismiss();
    }

    public void setRightClickListener(View.OnClickListener targetRegionClickListener) {
        tvTargetRegion.setOnClickListener(targetRegionClickListener);
        dismiss();
    }


    public void show() {
        if (dialog.isShowing()) {
            return;
        }
        if (!TextUtils.isEmpty(content)) {
            tvContent.setText(content);
        }
        dialog.show();
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

}
