package com.locnavi.map.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.PopupWindow;

import com.locnavi.location.xunjimap.utils.DensityUtils;
import com.locnavi.location.xunjimap.utils.L;
import com.locnavi.map.R;


public class ScanfBluetoothDialog {
    private final Button btnCancle;
    private LinearLayout llReloadBlueTooth;
    private PopupWindow popupWindow;
    private View contentView;
    private CompassView compasView;
    private Button btExit;
    private Context context;
    private int navStatus;


    public ScanfBluetoothDialog(Context context, View.OnClickListener onNavBtnClickListener) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_scanf_bluetooth, null);
        llReloadBlueTooth = (LinearLayout) contentView.findViewById(R.id.ll_reload_blue_tooth);
        btnCancle = (Button) contentView.findViewById(R.id.btn_cancel);
        llReloadBlueTooth.setOnClickListener(onNavBtnClickListener);

        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context),
                DensityUtils.getScreenHeight(context), true);
        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogBottom);
        btnCancle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

    }

    public void show(View view, int navStatus) {
        try {
            this.navStatus = navStatus;
            if (popupWindow == null || popupWindow.isShowing() || view == null) {
                return;
            }
            if (((Activity) context).hasWindowFocus()) {
                popupWindow.showAtLocation(view, Gravity.BOTTOM, 0, 0);
            }
        } catch (WindowManager.BadTokenException e) {
            L.e(context.getString(R.string.ipsmap_find_error), e.toString());
        }
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            popupWindow.dismiss();
        }
    }
}
