/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import com.iflytek.speech.RecognizerResult;

public interface RecognizerListener
extends IInterface {
    public void onVolumeChanged(int var1, byte[] var2);

    public void onBeginOfSpeech();

    public void onEndOfSpeech();

    public void onResult(RecognizerResult var1, boolean var2);

    public void onError(int var1);

    public void onEvent(int var1, int var2, int var3, Bundle var4);

    public static abstract class Stub
    extends Binder
    implements RecognizerListener {
        private static final String DESCRIPTOR = "com.iflytek.speech.RecognizerListener";
        static final int TRANSACTION_onVolumeChanged = 1;
        static final int TRANSACTION_onBeginOfSpeech = 2;
        static final int TRANSACTION_onEndOfSpeech = 3;
        static final int TRANSACTION_onResult = 4;
        static final int TRANSACTION_onError = 5;
        static final int TRANSACTION_onEvent = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static RecognizerListener asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof RecognizerListener) {
                return (RecognizerListener)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n2, Parcel parcel, Parcel parcel2, int n3) {
            switch (n2) {
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    byte[] byArray = parcel.createByteArray();
                    this.onVolumeChanged(n4, byArray);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onBeginOfSpeech();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onEndOfSpeech();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    RecognizerResult recognizerResult = 0 != parcel.readInt() ? (RecognizerResult)RecognizerResult.CREATOR.createFromParcel(parcel) : null;
                    boolean bl2 = 0 != parcel.readInt();
                    this.onResult(recognizerResult, bl2);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = parcel.readInt();
                    this.onError(n5);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = parcel.readInt();
                    int n7 = parcel.readInt();
                    int n8 = parcel.readInt();
                    Bundle bundle = 0 != parcel.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.onEvent(n6, n7, n8, bundle);
                    return true;
                }
            }
            return super.onTransact(n2, parcel, parcel2, n3);
        }

        private static class Proxy
        implements RecognizerListener {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVolumeChanged(int n2, byte[] byArray) {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n2);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(1, parcel, null, 1);
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onBeginOfSpeech() {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, null, 1);
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onEndOfSpeech() {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, null, 1);
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(RecognizerResult recognizerResult, boolean bl2) {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (recognizerResult != null) {
                        parcel.writeInt(1);
                        recognizerResult.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(bl2 ? 1 : 0);
                    this.mRemote.transact(4, parcel, null, 1);
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onError(int n2) {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n2);
                    this.mRemote.transact(5, parcel, null, 1);
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(int n2, int n3, int n4, Bundle bundle) {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, null, 1);
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

