/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.baidu.tts.loopj.AsyncHttpClient;
import com.baidu.tts.loopj.ResponseHandlerInterface;
import com.baidu.tts.loopj.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.util.ByteArrayBuffer;

public abstract class AsyncHttpResponseHandler
implements ResponseHandlerInterface {
    private static final String LOG_TAG = "AsyncHttpRH";
    protected static final int SUCCESS_MESSAGE = 0;
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int START_MESSAGE = 2;
    protected static final int FINISH_MESSAGE = 3;
    protected static final int PROGRESS_MESSAGE = 4;
    protected static final int RETRY_MESSAGE = 5;
    protected static final int CANCEL_MESSAGE = 6;
    protected static final int BUFFER_SIZE = 4096;
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String UTF8_BOM = "\ufeff";
    private String responseCharset = "UTF-8";
    private Handler handler;
    private boolean useSynchronousMode;
    private boolean usePoolThread;
    private URI requestURI = null;
    private Header[] requestHeaders = null;
    private Looper looper = null;
    private WeakReference<Object> TAG = new WeakReference<Object>(null);

    public AsyncHttpResponseHandler() {
        this(null);
    }

    public AsyncHttpResponseHandler(Looper looper) {
        this.looper = looper == null ? Looper.myLooper() : looper;
        this.setUseSynchronousMode(false);
        this.setUsePoolThread(false);
    }

    public AsyncHttpResponseHandler(boolean bl2) {
        this.setUsePoolThread(bl2);
        if (!this.getUsePoolThread()) {
            this.looper = Looper.myLooper();
            this.setUseSynchronousMode(false);
        }
    }

    public void setTag(Object object) {
        this.TAG = new WeakReference<Object>(object);
    }

    public Object getTag() {
        return this.TAG.get();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public Header[] getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestURI(URI uRI) {
        this.requestURI = uRI;
    }

    public void setRequestHeaders(Header[] headerArray) {
        this.requestHeaders = headerArray;
    }

    public boolean getUseSynchronousMode() {
        return this.useSynchronousMode;
    }

    public void setUseSynchronousMode(boolean bl2) {
        if (!bl2 && this.looper == null) {
            bl2 = true;
            AsyncHttpClient.log.w(LOG_TAG, "Current thread has not called Looper.prepare(). Forcing synchronous mode.");
        }
        if (!bl2 && this.handler == null) {
            this.handler = new ResponderHandler(this, this.looper);
        } else if (bl2 && this.handler != null) {
            this.handler = null;
        }
        this.useSynchronousMode = bl2;
    }

    public boolean getUsePoolThread() {
        return this.usePoolThread;
    }

    public void setUsePoolThread(boolean bl2) {
        if (bl2) {
            this.looper = null;
            this.handler = null;
        }
        this.usePoolThread = bl2;
    }

    public void setCharset(String string) {
        this.responseCharset = string;
    }

    public String getCharset() {
        return this.responseCharset == null ? DEFAULT_CHARSET : this.responseCharset;
    }

    public void onProgress(long l2, long l3) {
        AsyncHttpClient.log.v(LOG_TAG, String.format("Progress %d from %d (%2.0f%%)", l2, l3, l3 > 0L ? (double)l2 * 1.0 / (double)l3 * 100.0 : -1.0));
    }

    public void onStart() {
    }

    public void onFinish() {
    }

    public void onPreProcessResponse(ResponseHandlerInterface responseHandlerInterface, HttpResponse httpResponse) {
    }

    public void onPostProcessResponse(ResponseHandlerInterface responseHandlerInterface, HttpResponse httpResponse) {
    }

    public abstract void onSuccess(int var1, Header[] var2, byte[] var3);

    public abstract void onFailure(int var1, Header[] var2, byte[] var3, Throwable var4);

    public void onRetry(int n2) {
        AsyncHttpClient.log.d(LOG_TAG, String.format("Request retry no. %d", n2));
    }

    public void onCancel() {
        AsyncHttpClient.log.d(LOG_TAG, "Request got cancelled");
    }

    public void onUserException(Throwable throwable) {
        AsyncHttpClient.log.e(LOG_TAG, "User-space exception detected!", throwable);
        throw new RuntimeException(throwable);
    }

    public final void sendProgressMessage(long l2, long l3) {
        this.sendMessage(this.obtainMessage(4, new Object[]{l2, l3}));
    }

    public final void sendSuccessMessage(int n2, Header[] headerArray, byte[] byArray) {
        this.sendMessage(this.obtainMessage(0, new Object[]{n2, headerArray, byArray}));
    }

    public final void sendFailureMessage(int n2, Header[] headerArray, byte[] byArray, Throwable throwable) {
        this.sendMessage(this.obtainMessage(1, new Object[]{n2, headerArray, byArray, throwable}));
    }

    public final void sendStartMessage() {
        this.sendMessage(this.obtainMessage(2, null));
    }

    public final void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(3, null));
    }

    public final void sendRetryMessage(int n2) {
        this.sendMessage(this.obtainMessage(5, new Object[]{n2}));
    }

    public final void sendCancelMessage() {
        this.sendMessage(this.obtainMessage(6, null));
    }

    protected void handleMessage(Message message) {
        try {
            switch (message.what) {
                case 0: {
                    Object[] objectArray = (Object[])message.obj;
                    if (objectArray != null && objectArray.length >= 3) {
                        this.onSuccess((Integer)objectArray[0], (Header[])objectArray[1], (byte[])objectArray[2]);
                        break;
                    }
                    AsyncHttpClient.log.e(LOG_TAG, "SUCCESS_MESSAGE didn't got enough params");
                    break;
                }
                case 1: {
                    Object[] objectArray = (Object[])message.obj;
                    if (objectArray != null && objectArray.length >= 4) {
                        this.onFailure((Integer)objectArray[0], (Header[])objectArray[1], (byte[])objectArray[2], (Throwable)objectArray[3]);
                        break;
                    }
                    AsyncHttpClient.log.e(LOG_TAG, "FAILURE_MESSAGE didn't got enough params");
                    break;
                }
                case 2: {
                    this.onStart();
                    break;
                }
                case 3: {
                    this.onFinish();
                    break;
                }
                case 4: {
                    Object[] objectArray = (Object[])message.obj;
                    if (objectArray != null && objectArray.length >= 2) {
                        try {
                            this.onProgress((Long)objectArray[0], (Long)objectArray[1]);
                        }
                        catch (Throwable throwable) {
                            AsyncHttpClient.log.e(LOG_TAG, "custom onProgress contains an error", throwable);
                        }
                        break;
                    }
                    AsyncHttpClient.log.e(LOG_TAG, "PROGRESS_MESSAGE didn't got enough params");
                    break;
                }
                case 5: {
                    Object[] objectArray = (Object[])message.obj;
                    if (objectArray != null && objectArray.length == 1) {
                        this.onRetry((Integer)objectArray[0]);
                        break;
                    }
                    AsyncHttpClient.log.e(LOG_TAG, "RETRY_MESSAGE didn't get enough params");
                    break;
                }
                case 6: {
                    this.onCancel();
                }
            }
        }
        catch (Throwable throwable) {
            this.onUserException(throwable);
        }
    }

    protected void sendMessage(Message message) {
        if (this.getUseSynchronousMode() || this.handler == null) {
            this.handleMessage(message);
        } else if (!Thread.currentThread().isInterrupted()) {
            Utils.asserts(this.handler != null, "handler should not be null!");
            this.handler.sendMessage(message);
        }
    }

    protected void postRunnable(Runnable runnable) {
        if (runnable != null) {
            if (this.getUseSynchronousMode() || this.handler == null) {
                runnable.run();
            } else {
                this.handler.post(runnable);
            }
        }
    }

    protected Message obtainMessage(int n2, Object object) {
        return Message.obtain((Handler)this.handler, (int)n2, (Object)object);
    }

    public void sendResponseMessage(HttpResponse httpResponse) {
        if (!Thread.currentThread().isInterrupted()) {
            StatusLine statusLine = httpResponse.getStatusLine();
            byte[] byArray = this.getResponseData(httpResponse.getEntity());
            if (!Thread.currentThread().isInterrupted()) {
                if (statusLine.getStatusCode() >= 300) {
                    this.sendFailureMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), byArray, (Throwable)new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                } else {
                    this.sendSuccessMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), byArray);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getResponseData(HttpEntity httpEntity) {
        InputStream inputStream;
        byte[] byArray = null;
        if (httpEntity != null && (inputStream = httpEntity.getContent()) != null) {
            long l2 = httpEntity.getContentLength();
            if (l2 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            int n2 = l2 <= 0L ? 4096 : (int)l2;
            try {
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n2);
                try {
                    int n3;
                    byte[] byArray2 = new byte[4096];
                    long l3 = 0L;
                    while ((n3 = inputStream.read(byArray2)) != -1 && !Thread.currentThread().isInterrupted()) {
                        byteArrayBuffer.append(byArray2, 0, n3);
                        this.sendProgressMessage(l3 += (long)n3, l2 <= 0L ? 1L : l2);
                    }
                }
                finally {
                    AsyncHttpClient.silentCloseInputStream(inputStream);
                    AsyncHttpClient.endEntityViaReflection(httpEntity);
                }
                byArray = byteArrayBuffer.toByteArray();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                throw new IOException("File too large to fit into available memory");
            }
        }
        return byArray;
    }

    private static class ResponderHandler
    extends Handler {
        private final AsyncHttpResponseHandler mResponder;

        ResponderHandler(AsyncHttpResponseHandler asyncHttpResponseHandler, Looper looper) {
            super(looper);
            this.mResponder = asyncHttpResponseHandler;
        }

        public void handleMessage(Message message) {
            this.mResponder.handleMessage(message);
        }
    }
}

