package com.locnavi.map.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.locnavi.location.xunjimap.utils.DensityUtils;
import com.locnavi.map.R;
import com.locnavi.map.ui.utils.StatusBarCompat;



public class NavFinishTopDialog {
    private Context context;
    private PopupWindow popupWindow;
    private View contentView;
    private TextView tvTargetRegion;
    private TextView tvStartRegion;
    private TextView tvDistanceTime;
    private String startRegion;
    private String targetRegion;

    public NavFinishTopDialog(Context context) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_nav_finish_top, null);
        tvStartRegion = (TextView) contentView.findViewById(R.id.tv_start_region);
        tvTargetRegion = (TextView) contentView.findViewById(R.id.tv_target_region);
        tvDistanceTime = (TextView) contentView.findViewById(R.id.tv_distance_time);
        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context), ViewGroup.LayoutParams.WRAP_CONTENT, false);
        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogTop);
    }

    public void setStartRegion(String startRegion) {
        this.startRegion = startRegion;
        tvStartRegion.setText(context.getString(R.string.ipsmap_start_postion) + startRegion);
    }

    public String getStartRegion() {
        return startRegion;
    }


    public void setDistanceAndTime(String distanceAndTime) {
        tvDistanceTime.setText(distanceAndTime);
    }

    public void setTargetRegion(String targetRegion) {
        this.targetRegion = targetRegion;
        tvTargetRegion.setText(context.getString(R.string.ipsmap_target) + targetRegion);
    }

    public String getTargetRegion() {
        return targetRegion;
    }

    public void show(View view) {
        if (popupWindow.isShowing()) {
            return;
        }
        popupWindow.showAtLocation(view, Gravity.TOP, 0, 0);
        StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_tvGreen7));
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            tvStartRegion.setText("");
            tvTargetRegion.setText("");
            tvDistanceTime.setText("");
            popupWindow.dismiss();
            StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_colorPrimaryDark));
        }
    }


}
