/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import com.baidu.tts.loopj.AsyncHttpClient;
import com.baidu.tts.loopj.JsonStreamerEntity;
import com.baidu.tts.loopj.ResponseHandlerInterface;
import com.baidu.tts.loopj.SimpleMultipartEntity;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParams
implements Serializable {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON = "application/json";
    protected static final String LOG_TAG = "RequestParams";
    protected boolean isRepeatable;
    protected boolean forceMultipartEntity = false;
    protected boolean useJsonStreamer;
    protected String elapsedFieldInJsonStreamer = "_elapsed";
    protected boolean autoCloseInputStreams;
    protected final ConcurrentHashMap<String, String> urlParams = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, StreamWrapper> streamParams = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, FileWrapper> fileParams = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, List<FileWrapper>> fileArrayParams = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Object> urlParamsWithObjects = new ConcurrentHashMap();
    protected String contentEncoding = "UTF-8";

    public void setContentEncoding(String string) {
        if (string != null) {
            this.contentEncoding = string;
        } else {
            AsyncHttpClient.log.d(LOG_TAG, "setContentEncoding called with null attribute");
        }
    }

    public void setForceMultipartEntityContentType(boolean bl2) {
        this.forceMultipartEntity = bl2;
    }

    public RequestParams() {
        this(null);
    }

    public RequestParams(Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public RequestParams(final String string, final String string2) {
        this((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(string, string2);
            }
        });
    }

    public RequestParams(Object ... objectArray) {
        int n2 = objectArray.length;
        if (n2 % 2 != 0) {
            throw new IllegalArgumentException("Supplied arguments must be even");
        }
        for (int i2 = 0; i2 < n2; i2 += 2) {
            String string = String.valueOf(objectArray[i2]);
            String string2 = String.valueOf(objectArray[i2 + 1]);
            this.put(string, string2);
        }
    }

    public void put(String string, String string2) {
        if (string != null && string2 != null) {
            this.urlParams.put(string, string2);
        }
    }

    public void put(String string, File[] fileArray) {
        this.put(string, fileArray, null, null);
    }

    public void put(String string, File[] fileArray, String string2, String string3) {
        if (string != null) {
            ArrayList<FileWrapper> arrayList = new ArrayList<FileWrapper>();
            for (File file : fileArray) {
                if (file == null || !file.exists()) {
                    throw new FileNotFoundException();
                }
                arrayList.add(new FileWrapper(file, string2, string3));
            }
            this.fileArrayParams.put(string, arrayList);
        }
    }

    public void put(String string, File file) {
        this.put(string, file, null, null);
    }

    public void put(String string, String string2, File file) {
        this.put(string, file, null, string2);
    }

    public void put(String string, File file, String string2) {
        this.put(string, file, string2, null);
    }

    public void put(String string, File file, String string2, String string3) {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        if (string != null) {
            this.fileParams.put(string, new FileWrapper(file, string2, string3));
        }
    }

    public void put(String string, InputStream inputStream) {
        this.put(string, inputStream, null);
    }

    public void put(String string, InputStream inputStream, String string2) {
        this.put(string, inputStream, string2, null);
    }

    public void put(String string, InputStream inputStream, String string2, String string3) {
        this.put(string, inputStream, string2, string3, this.autoCloseInputStreams);
    }

    public void put(String string, InputStream inputStream, String string2, String string3, boolean bl2) {
        if (string != null && inputStream != null) {
            this.streamParams.put(string, StreamWrapper.newInstance(inputStream, string2, string3, bl2));
        }
    }

    public void put(String string, Object object) {
        if (string != null && object != null) {
            this.urlParamsWithObjects.put(string, object);
        }
    }

    public void put(String string, int n2) {
        if (string != null) {
            this.urlParams.put(string, String.valueOf(n2));
        }
    }

    public void put(String string, long l2) {
        if (string != null) {
            this.urlParams.put(string, String.valueOf(l2));
        }
    }

    public void add(String string, String string2) {
        if (string != null && string2 != null) {
            HashSet hashSet = this.urlParamsWithObjects.get(string);
            if (hashSet == null) {
                hashSet = new HashSet();
                this.put(string, hashSet);
            }
            if (hashSet instanceof List) {
                ((List)((Object)hashSet)).add(string2);
            } else if (hashSet instanceof Set) {
                ((Set)hashSet).add(string2);
            }
        }
    }

    public void remove(String string) {
        this.urlParams.remove(string);
        this.streamParams.remove(string);
        this.fileParams.remove(string);
        this.urlParamsWithObjects.remove(string);
        this.fileArrayParams.remove(string);
    }

    public boolean has(String string) {
        return this.urlParams.get(string) != null || this.streamParams.get(string) != null || this.fileParams.get(string) != null || this.urlParamsWithObjects.get(string) != null || this.fileArrayParams.get(string) != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> object2 : this.urlParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(object2.getKey());
            stringBuilder.append("=");
            stringBuilder.append(object2.getValue());
        }
        for (Map.Entry<String, Object> entry : this.streamParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append("STREAM");
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append("FILE");
        }
        for (Map.Entry<String, Object> entry : this.fileArrayParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append("FILES(SIZE=").append(((List)entry.getValue()).size()).append(")");
        }
        List<BasicNameValuePair> list = this.getParamsList(null, this.urlParamsWithObjects);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BasicNameValuePair basicNameValuePair = (BasicNameValuePair)iterator.next();
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(basicNameValuePair.getName());
            stringBuilder.append("=");
            stringBuilder.append(basicNameValuePair.getValue());
        }
        return stringBuilder.toString();
    }

    public void setHttpEntityIsRepeatable(boolean bl2) {
        this.isRepeatable = bl2;
    }

    public void setUseJsonStreamer(boolean bl2) {
        this.useJsonStreamer = bl2;
    }

    public void setElapsedFieldInJsonStreamer(String string) {
        this.elapsedFieldInJsonStreamer = string;
    }

    public void setAutoCloseInputStreams(boolean bl2) {
        this.autoCloseInputStreams = bl2;
    }

    public HttpEntity getEntity(ResponseHandlerInterface responseHandlerInterface) {
        if (this.useJsonStreamer) {
            return this.createJsonStreamerEntity(responseHandlerInterface);
        }
        if (!this.forceMultipartEntity && this.streamParams.isEmpty() && this.fileParams.isEmpty() && this.fileArrayParams.isEmpty()) {
            return this.createFormEntity();
        }
        return this.createMultipartEntity(responseHandlerInterface);
    }

    private HttpEntity createJsonStreamerEntity(ResponseHandlerInterface responseHandlerInterface) {
        JsonStreamerEntity jsonStreamerEntity = new JsonStreamerEntity(responseHandlerInterface, !this.fileParams.isEmpty() || !this.streamParams.isEmpty(), this.elapsedFieldInJsonStreamer);
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            jsonStreamerEntity.addPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.urlParamsWithObjects.entrySet()) {
            jsonStreamerEntity.addPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            jsonStreamerEntity.addPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.streamParams.entrySet()) {
            StreamWrapper streamWrapper = (StreamWrapper)entry.getValue();
            if (streamWrapper.inputStream == null) continue;
            jsonStreamerEntity.addPart(entry.getKey(), StreamWrapper.newInstance(streamWrapper.inputStream, streamWrapper.name, streamWrapper.contentType, streamWrapper.autoClose));
        }
        return jsonStreamerEntity;
    }

    private HttpEntity createFormEntity() {
        try {
            return new UrlEncodedFormEntity(this.getParamsList(), this.contentEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            AsyncHttpClient.log.e(LOG_TAG, "createFormEntity failed", unsupportedEncodingException);
            return null;
        }
    }

    private HttpEntity createMultipartEntity(ResponseHandlerInterface responseHandlerInterface) {
        List<FileWrapper> list;
        SimpleMultipartEntity simpleMultipartEntity = new SimpleMultipartEntity(responseHandlerInterface);
        simpleMultipartEntity.setIsRepeatable(this.isRepeatable);
        for (Map.Entry<String, String> iterator2 : this.urlParams.entrySet()) {
            simpleMultipartEntity.addPartWithCharset(iterator2.getKey(), iterator2.getValue(), this.contentEncoding);
        }
        List<BasicNameValuePair> list2 = this.getParamsList(null, this.urlParamsWithObjects);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            BasicNameValuePair basicNameValuePair = (BasicNameValuePair)iterator.next();
            simpleMultipartEntity.addPartWithCharset(basicNameValuePair.getName(), basicNameValuePair.getValue(), this.contentEncoding);
        }
        for (Map.Entry<String, StreamWrapper> entry : this.streamParams.entrySet()) {
            list = entry.getValue();
            if (((StreamWrapper)((Object)list)).inputStream == null) continue;
            simpleMultipartEntity.addPart(entry.getKey(), ((StreamWrapper)((Object)list)).name, ((StreamWrapper)((Object)list)).inputStream, ((StreamWrapper)((Object)list)).contentType);
        }
        for (Map.Entry<String, FileWrapper> entry : this.fileParams.entrySet()) {
            list = entry.getValue();
            simpleMultipartEntity.addPart(entry.getKey(), ((FileWrapper)((Object)list)).file, ((FileWrapper)((Object)list)).contentType, ((FileWrapper)((Object)list)).customFileName);
        }
        for (Map.Entry<String, List<FileWrapper>> entry : this.fileArrayParams.entrySet()) {
            list = entry.getValue();
            for (FileWrapper fileWrapper : list) {
                simpleMultipartEntity.addPart(entry.getKey(), fileWrapper.file, fileWrapper.contentType, fileWrapper.customFileName);
            }
        }
        return simpleMultipartEntity;
    }

    protected List<BasicNameValuePair> getParamsList() {
        LinkedList<BasicNameValuePair> linkedList = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            linkedList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        linkedList.addAll(this.getParamsList(null, this.urlParamsWithObjects));
        return linkedList;
    }

    private List<BasicNameValuePair> getParamsList(String string, Object object) {
        LinkedList<BasicNameValuePair> linkedList = new LinkedList<BasicNameValuePair>();
        if (object instanceof Map) {
            Map map = (Map)object;
            ArrayList arrayList = new ArrayList(map.keySet());
            if (arrayList.size() > 0 && arrayList.get(0) instanceof Comparable) {
                Collections.sort(arrayList);
            }
            for (Object e2 : arrayList) {
                Object v2;
                if (!(e2 instanceof String) || (v2 = map.get(e2)) == null) continue;
                linkedList.addAll(this.getParamsList(string == null ? (String)e2 : String.format(Locale.US, "%s[%s]", string, e2), v2));
            }
        } else if (object instanceof List) {
            List list = (List)object;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                linkedList.addAll(this.getParamsList(String.format(Locale.US, "%s[%d]", string, i2), list.get(i2)));
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n3 = objectArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                linkedList.addAll(this.getParamsList(String.format(Locale.US, "%s[%d]", string, i3), objectArray[i3]));
            }
        } else if (object instanceof Set) {
            Set set = (Set)object;
            for (Object e3 : set) {
                linkedList.addAll(this.getParamsList(string, e3));
            }
        } else {
            linkedList.add(new BasicNameValuePair(string, object.toString()));
        }
        return linkedList;
    }

    protected String getParamString() {
        return URLEncodedUtils.format(this.getParamsList(), (String)this.contentEncoding);
    }

    public static class StreamWrapper {
        public final InputStream inputStream;
        public final String name;
        public final String contentType;
        public final boolean autoClose;

        public StreamWrapper(InputStream inputStream, String string, String string2, boolean bl2) {
            this.inputStream = inputStream;
            this.name = string;
            this.contentType = string2;
            this.autoClose = bl2;
        }

        static StreamWrapper newInstance(InputStream inputStream, String string, String string2, boolean bl2) {
            return new StreamWrapper(inputStream, string, string2 == null ? RequestParams.APPLICATION_OCTET_STREAM : string2, bl2);
        }
    }

    public static class FileWrapper
    implements Serializable {
        public final File file;
        public final String contentType;
        public final String customFileName;

        public FileWrapper(File file, String string, String string2) {
            this.file = file;
            this.contentType = string;
            this.customFileName = string2;
        }
    }
}

