/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.protocol.HttpContext;

class MyRedirectHandler
extends DefaultRedirectHandler {
    private static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";
    private final boolean enableRedirects;

    public MyRedirectHandler(boolean bl2) {
        this.enableRedirects = bl2;
    }

    public boolean isRedirectRequested(HttpResponse httpResponse, HttpContext httpContext) {
        if (!this.enableRedirects) {
            return false;
        }
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        switch (httpResponse.getStatusLine().getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    public URI getLocationURI(HttpResponse httpResponse, HttpContext httpContext) {
        Object object;
        URI uRI;
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        Object object2 = httpResponse.getFirstHeader("location");
        if (object2 == null) {
            throw new ProtocolException("Received redirect response " + httpResponse.getStatusLine() + " but no location header");
        }
        object2 = object2.getValue().replaceAll(" ", "%20");
        try {
            uRI = new URI((String)object2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid redirect URI: ".concat(String.valueOf(object2)), (Throwable)uRISyntaxException);
        }
        httpResponse = httpResponse.getParams();
        if (!uRI.isAbsolute()) {
            if (httpResponse.isParameterTrue("http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("Relative redirect location '" + uRI + "' not allowed");
            }
            object2 = (HttpHost)httpContext.getAttribute("http.target_host");
            if (object2 == null) {
                throw new IllegalStateException("Target host not available in the HTTP context");
            }
            object = (HttpRequest)httpContext.getAttribute("http.request");
            try {
                uRI = URIUtils.resolve((URI)URIUtils.rewriteURI((URI)new URI(object.getRequestLine().getUri()), (HttpHost)object2, (boolean)true), (URI)uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
            }
        }
        if (httpResponse.isParameterFalse("http.protocol.allow-circular-redirects")) {
            object2 = (RedirectLocations)httpContext.getAttribute(REDIRECT_LOCATIONS);
            if (object2 == null) {
                object2 = new RedirectLocations();
                httpContext.setAttribute(REDIRECT_LOCATIONS, object2);
            }
            if (uRI.getFragment() != null) {
                try {
                    object = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
                    object = URIUtils.rewriteURI((URI)uRI, (HttpHost)object, (boolean)true);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtocolException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
                }
            } else {
                object = uRI;
            }
            if (object2.contains((URI)object)) {
                throw new CircularRedirectException("Circular redirect to '" + object + "'");
            }
            object2.add((URI)object);
        }
        return uRI;
    }
}

