/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.tools;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;

public class FileTools {
    public static boolean isFileExist(String string) {
        return new File(string).exists();
    }

    public static boolean isFileExist(Object ... object) {
        File file = null;
        if (((Object[])object).length == 1) {
            Object object2 = object[0];
            if (object2 instanceof File) {
                file = (File)object2;
            } else if (object2 instanceof String) {
                file = FileTools.createFile((String)object2);
            }
        } else if (((Object[])object).length == 2) {
            String string = (String)object[0];
            object = (String)object[1];
            file = FileTools.createFile(string, (String)object);
        } else {
            throw new UnknownError();
        }
        if (file != null) {
            return file.exists();
        }
        return false;
    }

    public static String jointPathAndName(String string, String string2) {
        string = string.endsWith(File.separator) ? string + string2 : string + File.separator + string2;
        return string;
    }

    public static boolean deleteFile(String string) {
        return FileTools.deleteFile(FileTools.createFile(string));
    }

    public static boolean deleteFile(File file) {
        return !file.exists() || file.delete();
    }

    public static boolean fileCopy(String object, String object2) {
        object = FileTools.createFile((String)object);
        object2 = FileTools.createFile((String)object2);
        return FileTools.fileCopy((File)object, (File)object2);
    }

    public static boolean fileCopy(String object, String object2, String string, String string2) {
        object = FileTools.createFile((String)object, (String)object2);
        object2 = FileTools.createFile(string, string2);
        return FileTools.fileCopy((File)object, (File)object2);
    }

    public static boolean fileCopy(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2) {
        return FileTools.fileCopy(new FileInputStream(fileDescriptor), new FileOutputStream(fileDescriptor2));
    }

    public static boolean fileCopy(File file, File file2) {
        return FileTools.fileCopy(new FileInputStream(file), new FileOutputStream(file2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean fileCopy(FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        boolean bl2 = false;
        try {
            bl2 = FileTools.fileCopy(fileInputStream.getChannel(), fileOutputStream.getChannel());
        }
        catch (Exception exception) {
            try {
                fileInputStream.close();
                fileOutputStream.close();
                return bl2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return bl2;
            }
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
            fileOutputStream.close();
            return bl2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return bl2;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean fileCopy(FileChannel fileChannel, FileChannel fileChannel2) {
        fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        try {
            fileChannel.close();
            fileChannel2.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            try {
                iOException.printStackTrace();
            }
            catch (Throwable throwable) {
                try {
                    fileChannel.close();
                    fileChannel2.close();
                    return true;
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                    return false;
                }
            }
            try {
                fileChannel.close();
                fileChannel2.close();
                return true;
            }
            catch (IOException iOException3) {
                iOException3.printStackTrace();
                return false;
            }
        }
    }

    public static boolean writeFile(String string, File object) {
        try {
            if (!((File)object).exists()) {
                ((File)object).createNewFile();
            }
            object = new FileWriter((File)object, false);
            ((Writer)object).write(string);
            ((OutputStreamWriter)object).flush();
            ((OutputStreamWriter)object).close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static void createDir(String string) {
        new File(string).mkdirs();
    }

    public static String extractFileName(String string) {
        int n2 = string.lastIndexOf(File.separator);
        return string.substring(n2 + 1);
    }

    public static File getFile(String object) {
        File file = new File((String)object);
        if (!file.exists()) {
            if (((String)object).endsWith(File.separator)) {
                file.mkdirs();
            } else {
                int n2 = ((String)object).lastIndexOf(File.separator);
                object = ((String)object).substring(0, n2);
                if (!((File)(object = new File((String)object))).exists()) {
                    ((File)object).mkdirs();
                }
            }
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getFile(String string, String string2) {
        return FileTools.getFile(FileTools.jointPathAndName(string, string2));
    }

    public static File createFile(String string) {
        return FileTools.getFile(string);
    }

    public static File createFile(String string, String string2) {
        return FileTools.getFile(FileTools.jointPathAndName(string, string2));
    }
}

