package com.locnavi.map.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;

import com.locnavi.map.R;

import java.text.SimpleDateFormat;
import java.util.Date;

public class StopCarCenterDialog {

    private final TextView tvTitle;
    private Dialog dialog;
    private View contentView;
    private Context context;


    private ImageView ivCloseFindCar;
    private TextView tvCarFloor;
    private TextView tvCarResgion;
    private TextView tvReStopCar;
    private TextView tvStopCarTime;
    private TextView tvPrice;


    public StopCarCenterDialog(Context context,
                               String regeion,
                               String floor,
                               String price,
                               View.OnClickListener confrimOnClickListener,
                               View.OnClickListener cancleOnclickListener
    ) {
        this.context  = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_stop_car, null);
        ivCloseFindCar = (ImageView) contentView.findViewById(R.id.iv_close_find_car);
        tvCarFloor = (TextView) contentView.findViewById(R.id.tv_car_floor);
        tvCarResgion = (TextView) contentView.findViewById(R.id.tv_car_resgion);
        tvReStopCar = (TextView) contentView.findViewById(R.id.tv_re_stop_car);
        tvStopCarTime = (TextView) contentView.findViewById(R.id.tv_stop_car_time);
        tvTitle = (TextView) contentView.findViewById(R.id.tv_title);
        tvPrice = (TextView) contentView.findViewById(R.id.tv_price);
        ivCloseFindCar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

        tvReStopCar.setOnClickListener(confrimOnClickListener);

//
//        tvCarFloor.setText("爱车位于"+floor+"层");
//        tvCarResgion.setText(regeion+"附近");


        //        tvCarFloor.setText("爱车位于"+floor+"层");
        addForeWiteColorSpan(context.getString(R.string.ipsmap_car_location_2),tvCarFloor);
        addForeColorSpan(floor,tvCarFloor);
        addForeWiteColorSpan(context.getString(R.string.ipsmap_floor),tvCarFloor);


//        tvCarResgion.setText(regeion+"附近");
        addFontSpan(tvCarResgion,regeion,60);
        addFontSpan(tvCarResgion,context.getString(R.string.ipsmap_near),30);


        Date currentTime = new Date();

        SimpleDateFormat format= new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String dataString = format.format(currentTime);
        tvStopCarTime.setText(context.getString(R.string.ipsmap_stop_car_time)+dataString);

        if (!TextUtils.isEmpty(price)){
            tvPrice.setText(context.getString(R.string.ipsmap_cost_stop_car)+price+context.getString(R.string.ipsmap_yue_hour));
        }else {
            tvPrice.setText(context.getString(R.string.ipsmap_cost_stop_car)+0+context.getString(R.string.ipsmap_yue_hour));
        }

        dialog = new Dialog(context, R.style.IpsmapDialogDimEnabled);
//        dialog = new Dialog(context);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                ViewGroup.LayoutParams.WRAP_CONTENT));
        dialog.setCanceledOnTouchOutside(true);
        Window win = dialog.getWindow();
//        win.getDecorView().setPadding(20, 20, 20, 20);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.WRAP_CONTENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
        win.setGravity(Gravity.CENTER);

        dialog.setCancelable(true);
    }


//    ivCloseFindCar = (ImageView) contentView.findViewById(R.id.iv_close_find_car);
//    tvCarFloor = (TextView) contentView.findViewById(R.id.tv_car_floor);
//    tvCarResgion = (TextView) contentView.findViewById(R.id.tv_car_resgion);
//    tvReStopCar = (TextView) contentView.findViewById(R.id.tv_re_stop_car);
//    tvStopCarTime = (TextView) contentView.findViewById(R.id.tv_stop_car_time);
//    tvPrice = (TextView) contentView.findViewById(R.id.tv_price);


    public void setCarFloor(String floor) {
        tvCarFloor.setText("");
        addForeWiteColorSpan(context.getString(R.string.ipsmap_car_location_2),tvCarFloor);
        addForeColorSpan(floor,tvCarFloor);
        addForeWiteColorSpan(context.getString(R.string.ipsmap_floor),tvCarFloor);
    }

    public void setCarResgion(String  regeion) {
//        tvCarResgion.setText(regeion+"附近");
        tvCarResgion.setText("");
        addFontSpan(tvCarResgion,regeion,60);
        addFontSpan(tvCarResgion,context.getString(R.string.ipsmap_near),30);
    }

    public void setTitle(String title){
        tvTitle.setText(context.getString(R.string.ipsmap_update_sucess));
    }

    public void upDataTime(){
        Date currentTime = new Date();
        SimpleDateFormat format= new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String dataString = format.format(currentTime);
        tvStopCarTime.setText(context.getString(R.string.ipsmap_stop_car_time)+dataString);
    }


    /**
     * 文字颜色
     */
    private void addForeColorSpan(String floor , TextView tv) {
        SpannableString spanString = new SpannableString(floor);
        ForegroundColorSpan span = new ForegroundColorSpan(context.getResources().getColor(R.color.ipsmap_tvOrg1));
        spanString.setSpan(span, 0, floor.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        tv.append(spanString);
    }

    /**
     * 文字颜色
     */
    private void addForeWiteColorSpan(String floor , TextView tv) {
        SpannableString spanString = new SpannableString(floor);
        ForegroundColorSpan span = new ForegroundColorSpan(Color.WHITE);
        spanString.setSpan(span, 0, floor.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        tv.append(spanString);
    }


    /**
     * 字体大小
     */
    private void addFontSpan(TextView tv,String content ,int size ) {
        SpannableString spanString = new SpannableString(content);
        AbsoluteSizeSpan span = new AbsoluteSizeSpan(size);
        spanString.setSpan(span, 0, content.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        tv.append(spanString);
    }

    public void show() {
        if (dialog.isShowing()) {
            return;
        }

        dialog.show();

//        if (((Activity) context).hasWindowFocus()) {
//
//        }

    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

}
