package com.locnavi.map.ui.item;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.locnavi.map.R;


public class SearchHistoryDataItem extends BaseRecyclerItemFactory<SearchHistoryDataItem.LocationRegionDataRecyclerItem> {

    Context context;
    OnDeleteClickListener onDeleteClickListener;

    public SearchHistoryDataItem(Context context) {
        this.context = context;
    }

    public void setOnDeleteClickListener(OnDeleteClickListener onDeleteClickListener) {
        this.onDeleteClickListener = onDeleteClickListener;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof String;
    }

    @Override
    public LocationRegionDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new LocationRegionDataRecyclerItem(parent, this);
    }

    public class LocationRegionDataRecyclerItem extends BaseRecyclerItem<String, SearchHistoryDataItem> {

        private TextView tvContent;
        private ImageView ivClose;


        protected LocationRegionDataRecyclerItem(ViewGroup parent, SearchHistoryDataItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.ipsmap_item_search_history, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            tvContent = (TextView) convertView.findViewById(R.id.tv_content);
            ivClose = (ImageView) convertView.findViewById(R.id.iv_close);
        }

        @Override
        protected void onConfigViews(final Context context) {
            ivClose.setOnClickListener(v -> {
                if (onDeleteClickListener != null) {
                    onDeleteClickListener.onDelete(getPosition());
                }
            });
        }

        @Override
        protected void onSetData(int position, String content) {
            tvContent.setText(content);
        }

    }

    public interface OnDeleteClickListener {
        void onDelete(int position);
    }

}
