/*
 * Decompiled with CFR 0.152.
 */
package com.locnavi.map.base;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.MotionEvent;
import com.baidu.tts.client.SpeechSynthesizer;
import com.iflytek.cloud.ui.RecognizerDialog;
import com.locnavi.location.xunjimap.utils.L;
import com.locnavi.location.xunjimap.utils.T;
import com.locnavi.map.R;
import com.locnavi.map.XJMapSDK;
import com.locnavi.map.base.a;
import com.locnavi.map.base.b;
import com.locnavi.map.base.c;
import com.locnavi.map.base.d;
import com.locnavi.map.base.e;
import com.locnavi.map.utils.VoiceManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;

public abstract class BaseActivity
extends AppCompatActivity {
    private HashMap<String, String> mIatResults = new LinkedHashMap<String, String>();
    public Context context;
    private RecognizerDialog recognizerDialog;
    protected static final int MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION = 1;
    protected static final int MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO = 2;
    protected static final int MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO_BAIDU = 3;
    protected e recognizerResultListener;
    private SpeechSynthesizer mSpeechSynthesizer;
    private String mSampleDirPath;
    private static String SAMPLE_DIR_NAME = "baiduTTS";
    private static final String SPEECH_FEMALE_MODEL_NAME = "bd_etts_speech_female.dat";
    private static final String SPEECH_MALE_MODEL_NAME = "bd_etts_speech_male.dat";
    private static final String TEXT_MODEL_NAME = "bd_etts_text.dat";
    private static final String ENGLISH_SPEECH_FEMALE_MODEL_NAME = "bd_etts_speech_female_en.dat";
    private static final String ENGLISH_SPEECH_MALE_MODEL_NAME = "bd_etts_speech_male_en.dat";
    private static final String ENGLISH_TEXT_MODEL_NAME = "bd_etts_text_en.dat";
    public VoiceManager voiceManager;

    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        BaseActivity baseActivity = this;
        baseActivity.setContentView(baseActivity.getLayoutId());
        this.context = this;
        this.setRequestedOrientation(1);
        this.setStatusBar();
        this.initView(bundle);
        this.initData();
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        return super.dispatchTouchEvent(motionEvent);
    }

    private Intent getAppDetailSettingIntent() {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 9) {
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts((String)"package", (String)this.getPackageName(), null));
        } else if (Build.VERSION.SDK_INT <= 8) {
            intent.setAction("android.intent.action.VIEW");
            intent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            intent.putExtra("com.android.settings.ApplicationPkgName", this.getPackageName());
        }
        return intent;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.recognizerDialog != null) {
            this.recognizerDialog.dismiss();
            this.recognizerDialog = null;
        }
    }

    protected abstract int getLayoutId();

    protected abstract void initView(Bundle var1);

    protected abstract void initData();

    protected void setStatusBar() {
        BaseActivity baseActivity = this;
        com.locnavi.map.ui.utils.d.a((Activity)baseActivity, baseActivity.getResources().getColor(R.color.ipsmap_colorPrimaryDark));
    }

    public boolean hasPermission(String ... stringArray) {
        for (String string2 : stringArray) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)string2) == 0) continue;
            return false;
        }
        return true;
    }

    public void requestPermission(int n2, String ... stringArray) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(stringArray, n2);
        }
    }

    public void onRequestPermissionsResult(int n2, @NonNull String[] stringArray, @NonNull int[] nArray) {
        switch (n2) {
            case 2: {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] != -1) continue;
                    T.showShort((int)R.string.ipsmap_please_grant_permission_write);
                    Intent intent = this.getAppDetailSettingIntent();
                    this.startActivity(intent);
                    this.finish();
                    return;
                }
                this.doSDCardAndRecordAudio();
                return;
            }
            case 3: {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] != -1) continue;
                    T.showShort((int)R.string.ipsmap_please_grant_permission_write);
                    Intent intent = this.getAppDetailSettingIntent();
                    this.startActivity(intent);
                    this.finish();
                    return;
                }
                this.initBaiduVioce();
                return;
            }
            case 1: {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] != -1) continue;
                    if (n2 == 0) {
                        T.showShort((int)R.string.ipsmap_please_grant_location);
                    } else if (n2 == 1) {
                        T.showShort((int)R.string.ipsmap_please_grant_permission_write);
                    }
                    Intent intent = this.getAppDetailSettingIntent();
                    this.startActivity(intent);
                    this.finish();
                    return;
                }
                this.permissionGranted();
            }
        }
    }

    public void initBaiduVioce() {
        this.voiceManager = VoiceManager.getInstance(XJMapSDK.context);
    }

    public void doSDCardAndRecordAudio() {
    }

    public void permissionGranted() {
    }

    public void stopSpeaking() {
        if (this.mSpeechSynthesizer != null) {
            this.mSpeechSynthesizer.stop();
        }
    }

    public void volumeIsTooLow() {
        AudioManager audioManager = (AudioManager)this.getSystemService("audio");
        int n2 = audioManager.getStreamMaxVolume(3);
        if ((double)((float)audioManager.getStreamVolume(3) / (float)n2) < 0.8) {
            T.showShort((int)R.string.ipsmap_volume_too_low);
        }
    }

    public void startSpeechDialog(e object) {
        this.recognizerResultListener = object;
        this.recognizerDialog = new RecognizerDialog((Context)this, new c(this));
        object = Locale.getDefault().getLanguage();
        Configuration configuration = this.context.getResources().getConfiguration();
        String string2 = configuration.locale.getCountry();
        L.e((String)"ddd ", (String)(" lang  " + (String)object + " locale " + string2 + " " + (String)object + "_" + string2));
        this.recognizerDialog.setParameter("language", (String)object + "_" + string2);
        this.recognizerDialog.setUILanguage(configuration.locale);
        L.e((String)"ddd ", (String)("TRADITIONAL_CHINESE " + configuration.locale));
        this.recognizerDialog.setParameter("accent", "mandarin");
        this.recognizerDialog.setListener(new d(this));
        this.recognizerDialog.show();
    }

    public void initGPS() {
        if (!((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle((CharSequence)"\u8bf7\u6253\u5f00GPS\u8fde\u63a5");
            builder.setMessage((CharSequence)"\u4e3a\u4e86\u7ed9\u60a8\u63d0\u4f9b\u66f4\u597d\u7684\u4f53\u9a8c\uff0c\u8bf7\u5148\u6253\u5f00GPS");
            builder.setPositiveButton((CharSequence)"\u8bbe\u7f6e", (DialogInterface.OnClickListener)new a(this));
            builder.setNeutralButton((CharSequence)"\u53d6\u6d88", (DialogInterface.OnClickListener)new b(this));
            builder.show();
        }
    }

    static /* synthetic */ HashMap access$000(BaseActivity baseActivity) {
        return baseActivity.mIatResults;
    }
}

