package com.locnavi.map.ui.item;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.locnavi.location.xunjimap.model.bean.LocationRegionData;
import com.locnavi.location.xunjimap.utils.DateUtils;
import com.locnavi.location.xunjimap.utils.IpsUtils;
import com.locnavi.location.xunjimap.utils.L;
//import com.locnavi.map.R;

import com.locnavi.map.R;
import com.sails.engine.SAILS;

public class LocShareFriendItem extends BaseRecyclerItemFactory<LocShareFriendItem.LocationShareFriendDataRecyclerItem> {

    Context context;
    SAILS sails;
    private OnItemClickListener onItemNavClickListener;

    public LocShareFriendItem(Context context, SAILS sails) {
        this.context = context;
        this.sails = sails;
    }

    public void setOnItemNavClickListener(OnItemClickListener onItemNavClickListener) {
        this.onItemNavClickListener = onItemNavClickListener;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof LocationRegionData;
    }

    @Override
    public LocationShareFriendDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new LocationShareFriendDataRecyclerItem(parent, this);
    }

    public class LocationShareFriendDataRecyclerItem extends BaseRecyclerItem<LocationRegionData, LocShareFriendItem> {

        private RelativeLayout rlRoot;
        private TextView tvUserName, tvFloorName, tvUpdatedAt;
        private LinearLayout llNav;

        protected LocationShareFriendDataRecyclerItem(ViewGroup parent, LocShareFriendItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.ipsmap_item_loc_share_friends, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            rlRoot = (RelativeLayout) convertView.findViewById(R.id.rl_root);
            tvFloorName = (TextView) convertView.findViewById(R.id.tv_floor_name);
            tvUserName = (TextView) convertView.findViewById(R.id.tv_user_name);
            tvUpdatedAt = (TextView) convertView.findViewById(R.id.tv_updatedAt);
            llNav = (LinearLayout) convertView.findViewById(R.id.ll_nav);
        }

        @Override
        protected void onConfigViews(final Context context) {
            if (onItemNavClickListener != null) {
                llNav.setOnClickListener(v -> onItemNavClickListener.onClick(getPosition()));
            }
            if (onItemClickListener != null) {
                rlRoot.setOnClickListener(v -> onItemClickListener.onClick(getPosition()));
            }
        }

        @Override
        protected void onSetData(int position, LocationRegionData item) {
            String buildingName = item.getBuildingName();
            String floorName = "";
            if (buildingName != null) {
                floorName += buildingName;
            }
            floorName += IpsUtils.getFloorDescription(sails, item.getFloorName());
            String userName = item.getName();
            if (item.isMe()) {
                userName += context.getString(R.string.ipsmap_my_location_share);
            }
            if (item.getLatitude() == 0 && item.getLongitude() == 0) {
                floorName = context.getString(R.string.ipsmap_not_in_this_map);
            }
            tvUserName.setText(userName);
            tvFloorName.setText(floorName);
            tvUserName.setTextColor(context.getResources().getColor(R.color.ipsmap_tvBlack));
            tvFloorName.setTextColor(context.getResources().getColor(R.color.ipsmap_tvOrg1));
            String time = DateUtils.getTimeBeforeNow(item.getUpdatedAt().getTime());
            tvUpdatedAt.setText(time);
            tvUserName.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey7));
            if (time.contains(context.getString(R.string.ipsmap_before_mine))) {
                int pos = time.lastIndexOf(context.getString(R.string.ipsmap_before_mine));
                String substring = time.substring(0, pos);
                try {
                    int lastMinute = Integer.parseInt(substring);
                    if (lastMinute >= 5) {
                        tvUserName.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                        tvFloorName.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                    }
                } catch (Exception e) {
                    L.e("ddd", e.toString());
                }
            } else if (time.contains(context.getString(R.string.ipsmap_before_hour))) {
                tvUserName.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                tvFloorName.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
            }
            if (!item.isSelected()) {
                rlRoot.setBackgroundResource(R.color.ipsmap_white);
            } else {
                rlRoot.setBackgroundResource(R.color.ipsmap_tvGrey6);
            }
            if (!item.isMe()) {
                llNav.setVisibility(View.VISIBLE);
            } else {
                llNav.setVisibility(View.INVISIBLE);
            }
        }

    }


}
