/*
 * Decompiled with CFR 0.152.
 */
package com.locnavi.map.utils.KeyboardVisibilityEvent;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.locnavi.location.xunjimap.utils.DensityUtils;
import com.locnavi.map.utils.KeyboardVisibilityEvent.KeyboardVisibilityEvent$1;
import com.locnavi.map.utils.KeyboardVisibilityEvent.KeyboardVisibilityEventListener;
import com.locnavi.map.utils.KeyboardVisibilityEvent.SimpleUnregister;
import com.locnavi.map.utils.KeyboardVisibilityEvent.Unregister;

public class KeyboardVisibilityEvent {
    private static final int KEYBOARD_VISIBLE_THRESHOLD_DP = 100;

    public static Unregister registerEventListener(Activity activity, KeyboardVisibilityEventListener object) {
        if (activity == null) {
            throw new NullPointerException("Parameter:activity must not be null");
        }
        int n2 = activity.getWindow().getAttributes().softInputMode;
        if (16 != n2 && n2 != 0) {
            throw new IllegalArgumentException("Parameter:activity window SoftInputMethod is not ADJUST_RESIZE");
        }
        if (object == null) {
            throw new NullPointerException("Parameter:listener must not be null");
        }
        View view = KeyboardVisibilityEvent.getActivityRoot(activity);
        object = new KeyboardVisibilityEvent$1(activity, view, (KeyboardVisibilityEventListener)object);
        view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)object);
        return new SimpleUnregister(activity, (ViewTreeObserver.OnGlobalLayoutListener)object);
    }

    public static boolean isKeyboardVisible(Activity activity) {
        Rect rect = new Rect();
        View view = KeyboardVisibilityEvent.getActivityRoot(activity);
        int n2 = Math.round(DensityUtils.dp2px((Context)activity, (float)100.0f));
        view.getWindowVisibleDisplayFrame(rect);
        return view.getRootView().getHeight() - rect.height() > n2;
    }

    static View getActivityRoot(Activity activity) {
        return ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
    }
}

