package com.locnavi.map.ui.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.locnavi.location.xunjimap.model.bean.LocationRegionIconData;
import com.locnavi.location.xunjimap.utils.DensityUtils;
import com.locnavi.map.R;
import com.locnavi.map.ui.item.RegionIconDataItem;
import com.locnavi.map.ui.utils.MarginDecoration;
//import com.locnavi.map.R;
//
//import com.xunji.xunjimap.ui.item.RegionIconDataItem;
//import com.xunji.xunjimap.ui.utils.MarginDecoration;


import java.util.ArrayList;
import java.util.List;


public class RecyclerviewPagerAdapter extends PagerAdapter implements ViewPager.OnPageChangeListener {

    private List<LocationRegionIconData> datas = new ArrayList<>();
    private LayoutInflater inflater;
    private Context context;
    private OnRegionIconDataClickListener onRegionIconDataClickListener;
    private LinearLayout mIndicators;
    private int mLastPosition;

    public void setDatas(List<LocationRegionIconData> datas, LinearLayout mIndicators) {
        this.datas = datas;
        this.mIndicators = mIndicators;
    }

    public void setOnRegionIconDataClickListener(OnRegionIconDataClickListener onRegionIconDataClickListener) {
        this.onRegionIconDataClickListener = onRegionIconDataClickListener;
    }

    public RecyclerviewPagerAdapter(Context context) {
        this.context = context;
        this.inflater = LayoutInflater.from(context);
    }

    @Override
    public int getCount() {
        if (datas == null) return 0;
        return (int) Math.ceil((float) datas.size() / 8);
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

    }

    @Override
    public final void onPageSelected(int position) {
        if (0 <= position && position < getCount()) {
            mIndicators.getChildAt(mLastPosition).setActivated(false);
            mIndicators.getChildAt(position).setActivated(true);
        }
        mLastPosition = position;
    }

    @Override
    public void onPageScrollStateChanged(int state) {

    }

    @Override
    public Object instantiateItem(ViewGroup container, final int position) {
        View view = inflater.inflate(R.layout.ipsmap_recyclerview, container, false);
        if (view != null) {
            RecyclerView recyclerView = (RecyclerView) view.findViewById(R.id.recyclerView);
            GridLayoutManager manager = new GridLayoutManager(context, 4);
            recyclerView.setLayoutManager(manager);
            MarginDecoration marginDecoration = new MarginDecoration(context);
            int margin = DensityUtils.dp2px(context, 10);
            marginDecoration.setItemMargin(0, margin, 0, 0);
            recyclerView.addItemDecoration(marginDecoration);
            int max = (position + 1) * 8 < datas.size() ? (position + 1) * 8 : datas.size();
            BaseRecyclerAdapter adapter = new BaseRecyclerAdapter(datas.subList(position * 8, max));
            RegionIconDataItem regionIconDataItem = new RegionIconDataItem(context);
            regionIconDataItem.setOnItemClickListener(position1 -> {
                if (onRegionIconDataClickListener != null) {
                    onRegionIconDataClickListener.onClick(datas.get(position1 + position * 8));
                }
            });
            adapter.addItemFactory(regionIconDataItem);
            recyclerView.setAdapter(adapter);
            container.addView(view, 0);
        }
        return view;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View) object);
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view.equals(object);
    }

    @Override
    public void restoreState(Parcelable state, ClassLoader loader) {
    }

    @Override
    public Parcelable saveState() {
        return null;
    }

    private int mChildCount = 0;

    @Override
    public void notifyDataSetChanged() {
        mChildCount = getCount();
        initIndicators();
        onPageSelected(0);
        super.notifyDataSetChanged();
    }

    @Override
    public int getItemPosition(Object object) {
        if (mChildCount > 0) {
            mChildCount--;
            return POSITION_NONE;
        }
        return super.getItemPosition(object);
    }

    public interface OnRegionIconDataClickListener {
        void onClick(LocationRegionIconData locationRegionIconData);
    }

    private void initIndicators() {
        if (mIndicators.getChildCount() != getCount()) {
            mIndicators.removeAllViews();
            Resources res = mIndicators.getResources();
            int size = res.getDimensionPixelOffset(R.dimen.ipsmap_indicator_size);
            int margin = res.getDimensionPixelOffset(R.dimen.ipsmap_indicator_margin);
            for (int i = 0; i < getCount(); i++) {
                ImageView indicator = new ImageView(mIndicators.getContext());
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(size, size);
                lp.setMargins(margin, 0, 0, 0);
                lp.gravity = Gravity.CENTER;
                indicator.setLayoutParams(lp);
                Drawable drawable = res.getDrawable(R.drawable.ipsmap_selector_indicator);
                indicator.setImageDrawable(drawable);
                mIndicators.addView(indicator);
            }
        }
        if (getCount() <= 1) {
            mIndicators.setVisibility(View.GONE);
        } else {
            mIndicators.setVisibility(View.VISIBLE);
        }
    }
}
