/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.inappbrowser;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.HttpAuthHandler;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.Config;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaHttpAuthHandler;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.inappbrowser.InAppBrowserDialog;
import org.apache.cordova.inappbrowser.InAppChromeClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class InAppBrowser
extends CordovaPlugin {
    private static final String NULL = "null";
    protected static final String LOG_TAG = "InAppBrowser";
    private static final String SELF = "_self";
    private static final String SYSTEM = "_system";
    private static final String EXIT_EVENT = "exit";
    private static final String LOCATION = "location";
    private static final String ZOOM = "zoom";
    private static final String HIDDEN = "hidden";
    private static final String LOAD_START_EVENT = "loadstart";
    private static final String LOAD_STOP_EVENT = "loadstop";
    private static final String LOAD_ERROR_EVENT = "loaderror";
    private static final String MESSAGE_EVENT = "message";
    private static final String CLEAR_ALL_CACHE = "clearcache";
    private static final String CLEAR_SESSION_CACHE = "clearsessioncache";
    private static final String HARDWARE_BACK_BUTTON = "hardwareback";
    private static final String MEDIA_PLAYBACK_REQUIRES_USER_ACTION = "mediaPlaybackRequiresUserAction";
    private static final String SHOULD_PAUSE = "shouldPauseOnSuspend";
    private static final Boolean DEFAULT_HARDWARE_BACK = true;
    private static final String USER_WIDE_VIEW_PORT = "useWideViewPort";
    private static final String TOOLBAR_COLOR = "toolbarcolor";
    private static final String CLOSE_BUTTON_CAPTION = "closebuttoncaption";
    private static final String CLOSE_BUTTON_COLOR = "closebuttoncolor";
    private static final String LEFT_TO_RIGHT = "lefttoright";
    private static final String HIDE_NAVIGATION = "hidenavigationbuttons";
    private static final String NAVIGATION_COLOR = "navigationbuttoncolor";
    private static final String HIDE_URL = "hideurlbar";
    private static final String FOOTER = "footer";
    private static final String FOOTER_COLOR = "footercolor";
    private static final String BEFORELOAD = "beforeload";
    private static final List customizableOptions = Arrays.asList("closebuttoncaption", "toolbarcolor", "navigationbuttoncolor", "closebuttoncolor", "footercolor");
    private static final int FILECHOOSER_REQUESTCODE = 1;
    private static final int FILECHOOSER_REQUESTCODE_LOLLIPOP = 2;
    private InAppBrowserDialog dialog;
    private WebView inAppWebView;
    private EditText edittext;
    private CallbackContext callbackContext;
    private boolean showLocationBar = true;
    private boolean showZoomControls = true;
    private boolean openWindowHidden = false;
    private boolean clearAllCache = false;
    private boolean clearSessionCache = false;
    private boolean hadwareBackButton = true;
    private boolean mediaPlaybackRequiresUserGesture = false;
    private boolean shouldPauseInAppBrowser = false;
    private boolean useWideViewPort = true;
    private ValueCallback<Uri> mUploadCallback;
    private ValueCallback<Uri[]> mUploadCallbackLollipop;
    private String closeButtonCaption = "";
    private String closeButtonColor = "";
    private boolean leftToRight = false;
    private int toolbarColor = -3355444;
    private boolean hideNavigationButtons = false;
    private String navigationButtonColor = "";
    private boolean hideUrlBar = false;
    private boolean showFooter = false;
    private String footerColor = "";
    private String beforeload = "";
    private String[] allowedSchemes;
    private InAppBrowserClient currentClient;

    private void injectDeferredObject(final String string2, String string3) {
        if (this.inAppWebView != null) {
            if (string3 != null) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)string2);
                String string4 = jSONArray.toString();
                string2 = string4.substring(1, string4.length() - 1);
                string2 = String.format(string3, string2);
            }
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                @SuppressLint(value={"NewApi"})
                public void run() {
                    if (Build.VERSION.SDK_INT < 19) {
                        InAppBrowser.this.inAppWebView.loadUrl("javascript:" + string2);
                    } else {
                        InAppBrowser.this.inAppWebView.evaluateJavascript(string2, null);
                    }
                }
            });
        } else {
            LOG.d(LOG_TAG, "Can't inject code into the system browser");
        }
    }

    private HashMap<String, String> parseFeature(String object) {
        StringTokenizer stringTokenizer;
        HashMap hashMap;
        if (((String)object).equals(NULL)) {
            return null;
        }
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        StringTokenizer stringTokenizer2 = stringTokenizer;
        stringTokenizer = new StringTokenizer((String)object, ",");
        while (stringTokenizer2.hasMoreElements()) {
            StringTokenizer stringTokenizer3;
            object = stringTokenizer3;
            if (!new StringTokenizer(stringTokenizer2.nextToken(), "=").hasMoreElements()) continue;
            Object object2 = object;
            object = ((StringTokenizer)object2).nextToken();
            String string2 = ((StringTokenizer)object2).nextToken();
            if (!(customizableOptions.contains(object) || string2.equals("yes") || string2.equals("no"))) {
                string2 = "yes";
            }
            hashMap2.put(object, string2);
        }
        return hashMap2;
    }

    private void openExternalExcludeCurrentApp(Intent intent) {
        ArrayList<Intent> arrayList;
        InAppBrowser inAppBrowser = inAppBrowser3;
        String string2 = inAppBrowser.cordova.getActivity().getPackageName();
        boolean bl = false;
        ArrayList<Intent> arrayList2 = arrayList;
        arrayList = new ArrayList<Intent>();
        for (ResolveInfo resolveInfo : inAppBrowser.cordova.getActivity().getPackageManager().queryIntentActivities(intent, 0)) {
            if (!string2.equals(resolveInfo.activityInfo.packageName)) {
                Intent intent2 = (Intent)intent.clone();
                intent2.setPackage(resolveInfo.activityInfo.packageName);
                arrayList2.add(intent2);
                continue;
            }
            bl = true;
        }
        if (bl && arrayList2.size() != 0) {
            if (arrayList2.size() == 1) {
                inAppBrowser3.cordova.getActivity().startActivity((Intent)arrayList2.get(0));
            } else if (arrayList2.size() > 0) {
                InAppBrowser inAppBrowser2 = inAppBrowser3;
                ArrayList<Intent> arrayList3 = arrayList2;
                InAppBrowser inAppBrowser3 = Intent.createChooser((Intent)((Intent)arrayList3.remove(arrayList3.size() - 1)), null);
                inAppBrowser3.putExtra("android.intent.extra.INITIAL_INTENTS", arrayList2.toArray(new Parcelable[0]));
                inAppBrowser2.cordova.getActivity().startActivity((Intent)inAppBrowser3);
            }
        } else {
            inAppBrowser3.cordova.getActivity().startActivity(intent);
        }
    }

    private void goForward() {
        if (this.inAppWebView.canGoForward()) {
            this.inAppWebView.goForward();
        }
    }

    private void navigate(String string2) {
        ((InputMethodManager)this.cordova.getActivity().getSystemService("input_method")).hideSoftInputFromWindow(this.edittext.getWindowToken(), 0);
        if (!string2.startsWith("http") && !string2.startsWith("file:")) {
            this.inAppWebView.loadUrl("http://" + string2);
        } else {
            this.inAppWebView.loadUrl(string2);
        }
        this.inAppWebView.requestFocus();
    }

    private boolean getShowLocationBar() {
        return this.showLocationBar;
    }

    private InAppBrowser getInAppBrowser() {
        return this;
    }

    private void sendUpdate(JSONObject jSONObject, boolean bl) {
        this.sendUpdate(jSONObject, bl, PluginResult.Status.OK);
    }

    private void sendUpdate(JSONObject jSONObject, boolean bl, PluginResult.Status status) {
        if (this.callbackContext != null) {
            PluginResult pluginResult;
            PluginResult pluginResult2 = pluginResult;
            pluginResult2(status, jSONObject);
            pluginResult.setKeepCallback(bl);
            this.callbackContext.sendPluginResult(pluginResult2);
            if (!bl) {
                this.callbackContext = null;
            }
        }
    }

    static /* synthetic */ InAppBrowserDialog access$202(InAppBrowser inAppBrowser, InAppBrowserDialog inAppBrowserDialog) {
        inAppBrowser.dialog = inAppBrowserDialog;
        return inAppBrowserDialog;
    }

    static /* synthetic */ EditText access$1102(InAppBrowser inAppBrowser, EditText editText) {
        inAppBrowser.edittext = editText;
        return editText;
    }

    static /* synthetic */ WebView access$102(InAppBrowser inAppBrowser, WebView webView) {
        inAppBrowser.inAppWebView = webView;
        return webView;
    }

    static /* synthetic */ ValueCallback access$1402(InAppBrowser inAppBrowser, ValueCallback valueCallback) {
        inAppBrowser.mUploadCallbackLollipop = valueCallback;
        return valueCallback;
    }

    static /* synthetic */ ValueCallback access$1502(InAppBrowser inAppBrowser, ValueCallback valueCallback) {
        inAppBrowser.mUploadCallback = valueCallback;
        return valueCallback;
    }

    static /* synthetic */ InAppBrowserClient access$002(InAppBrowser inAppBrowser, InAppBrowserClient inAppBrowserClient) {
        inAppBrowser.currentClient = inAppBrowserClient;
        return inAppBrowserClient;
    }

    static /* synthetic */ String[] access$3000(InAppBrowser inAppBrowser) {
        return inAppBrowser.allowedSchemes;
    }

    static /* synthetic */ CordovaPreferences access$3100(InAppBrowser inAppBrowser) {
        return inAppBrowser.preferences;
    }

    static /* synthetic */ String[] access$3002(InAppBrowser inAppBrowser, String[] stringArray) {
        inAppBrowser.allowedSchemes = stringArray;
        return stringArray;
    }

    @Override
    public boolean execute(String object, CordovaArgs object2, CallbackContext callbackContext) {
        block21: {
            block13: {
                PluginResult pluginResult;
                Object object3;
                block20: {
                    PluginResult pluginResult2;
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block12: {
                                                if (!object.equals("open")) break block12;
                                                CordovaArgs cordovaArgs = object2;
                                                ((InAppBrowser)object3).callbackContext = callbackContext;
                                                object = cordovaArgs.getString(0);
                                                final String string2 = cordovaArgs.optString(1);
                                                if (string2 == null || string2.equals("") || string2.equals(NULL)) {
                                                    string2 = SELF;
                                                }
                                                InAppBrowser inAppBrowser = object3;
                                                object2 = inAppBrowser.parseFeature(((CordovaArgs)object2).optString(2));
                                                LOG.d(LOG_TAG, "target = " + string2);
                                                inAppBrowser.cordova.getActivity().runOnUiThread(new Runnable((String)object, (HashMap)object2, callbackContext){
                                                    final /* synthetic */ String val$url;
                                                    final /* synthetic */ HashMap val$features;
                                                    final /* synthetic */ CallbackContext val$callbackContext;
                                                    {
                                                        this.val$url = string3;
                                                        this.val$features = hashMap;
                                                        this.val$callbackContext = callbackContext;
                                                    }

                                                    @Override
                                                    public void run() {
                                                        PluginResult pluginResult;
                                                        String string22 = "";
                                                        if (InAppBrowser.SELF.equals(pluginResult3.string2)) {
                                                            LOG.d(InAppBrowser.LOG_TAG, "in self");
                                                            Boolean bl = null;
                                                            if (pluginResult3.val$url.startsWith("javascript:")) {
                                                                bl = true;
                                                            }
                                                            if (bl == null) {
                                                                Class<Config> clazz = Config.class;
                                                                Class[] classArray = new Class[1];
                                                                classArray[0] = String.class;
                                                                Method method = clazz.getMethod("isUrlWhiteListed", classArray);
                                                                Object[] objectArray = new Object[1];
                                                                try {
                                                                    objectArray[0] = pluginResult3.val$url;
                                                                    bl = (Boolean)method.invoke(null, objectArray);
                                                                }
                                                                catch (InvocationTargetException invocationTargetException) {
                                                                    LOG.d(InAppBrowser.LOG_TAG, invocationTargetException.getLocalizedMessage());
                                                                }
                                                                catch (IllegalAccessException illegalAccessException) {
                                                                    LOG.d(InAppBrowser.LOG_TAG, illegalAccessException.getLocalizedMessage());
                                                                }
                                                                catch (NoSuchMethodException noSuchMethodException) {
                                                                    LOG.d(InAppBrowser.LOG_TAG, noSuchMethodException.getLocalizedMessage());
                                                                }
                                                            }
                                                            if (bl == null) {
                                                                Class<?> clazz = pluginResult3.InAppBrowser.this.webView.getClass();
                                                                PluginManager pluginManager = (PluginManager)clazz.getMethod("getPluginManager", new Class[0]).invoke((Object)pluginResult3.InAppBrowser.this.webView, new Object[0]);
                                                                Class<?> clazz2 = pluginManager.getClass();
                                                                Class[] classArray = new Class[1];
                                                                classArray[0] = String.class;
                                                                Method method = clazz2.getMethod("shouldAllowNavigation", classArray);
                                                                PluginManager pluginManager2 = pluginManager;
                                                                Object[] objectArray = new Object[1];
                                                                try {
                                                                    objectArray[0] = pluginResult3.val$url;
                                                                    bl = (Boolean)method.invoke((Object)pluginManager2, objectArray);
                                                                }
                                                                catch (InvocationTargetException invocationTargetException) {
                                                                    LOG.d(InAppBrowser.LOG_TAG, invocationTargetException.getLocalizedMessage());
                                                                }
                                                                catch (IllegalAccessException illegalAccessException) {
                                                                    LOG.d(InAppBrowser.LOG_TAG, illegalAccessException.getLocalizedMessage());
                                                                }
                                                                catch (NoSuchMethodException noSuchMethodException) {
                                                                    LOG.d(InAppBrowser.LOG_TAG, noSuchMethodException.getLocalizedMessage());
                                                                }
                                                            }
                                                            if (Boolean.TRUE.equals(bl)) {
                                                                LOG.d(InAppBrowser.LOG_TAG, "loading in webview");
                                                                pluginResult3.InAppBrowser.this.webView.loadUrl(pluginResult3.val$url);
                                                            } else if (pluginResult3.val$url.startsWith("tel:")) {
                                                                Intent intent;
                                                                PluginResult pluginResult2 = pluginResult3;
                                                                LOG.d(InAppBrowser.LOG_TAG, "loading in dialer");
                                                                bl = intent;
                                                                bl("android.intent.action.DIAL");
                                                                intent.setData(Uri.parse((String)pluginResult3.val$url));
                                                                try {
                                                                    pluginResult2.InAppBrowser.this.cordova.getActivity().startActivity((Intent)bl);
                                                                }
                                                                catch (ActivityNotFoundException activityNotFoundException) {
                                                                    LOG.e(InAppBrowser.LOG_TAG, "Error dialing " + pluginResult3.val$url + ": " + activityNotFoundException.toString());
                                                                }
                                                            } else {
                                                                LOG.d(InAppBrowser.LOG_TAG, "loading in InAppBrowser");
                                                                string22 = pluginResult3.InAppBrowser.this.showWebPage(pluginResult3.val$url, pluginResult3.val$features);
                                                            }
                                                        } else if (InAppBrowser.SYSTEM.equals(pluginResult3.string2)) {
                                                            LOG.d(InAppBrowser.LOG_TAG, "in system");
                                                            string22 = pluginResult3.InAppBrowser.this.openExternal(pluginResult3.val$url);
                                                        } else {
                                                            LOG.d(InAppBrowser.LOG_TAG, "in blank");
                                                            string22 = pluginResult3.InAppBrowser.this.showWebPage(pluginResult3.val$url, pluginResult3.val$features);
                                                        }
                                                        1 v18 = pluginResult3;
                                                        PluginResult pluginResult3 = pluginResult;
                                                        new PluginResult(PluginResult.Status.OK, string22).setKeepCallback(true);
                                                        v18.val$callbackContext.sendPluginResult(pluginResult3);
                                                    }
                                                });
                                                break block13;
                                            }
                                            if (!object.equals("close")) break block14;
                                            ((InAppBrowser)object3).closeDialog();
                                            break block13;
                                        }
                                        if (!object.equals("loadAfterBeforeload")) break block15;
                                        if (((InAppBrowser)object3).beforeload == null) {
                                            LOG.e(LOG_TAG, "unexpected loadAfterBeforeload called without feature beforeload=yes");
                                        }
                                        object = ((CordovaArgs)object2).getString(0);
                                        ((CordovaPlugin)object3).cordova.getActivity().runOnUiThread(new Runnable((String)object){
                                            final /* synthetic */ String val$url;
                                            {
                                                this.val$url = string2;
                                            }

                                            @Override
                                            @SuppressLint(value={"NewApi"})
                                            public void run() {
                                                if (Build.VERSION.SDK_INT < 26) {
                                                    ((InAppBrowser)InAppBrowser.this).currentClient.waitForBeforeload = false;
                                                    InAppBrowser.this.inAppWebView.setWebViewClient((WebViewClient)InAppBrowser.this.currentClient);
                                                } else {
                                                    ((InAppBrowserClient)((InAppBrowser)InAppBrowser.this).inAppWebView.getWebViewClient()).waitForBeforeload = false;
                                                }
                                                InAppBrowser.this.inAppWebView.loadUrl(this.val$url);
                                            }
                                        });
                                        break block13;
                                    }
                                    if (!object.equals("injectScriptCode")) break block16;
                                    object = null;
                                    if (((CordovaArgs)object2).getBoolean(1)) {
                                        Object[] objectArray = new Object[1];
                                        object = objectArray;
                                        objectArray[0] = callbackContext.getCallbackId();
                                        object = String.format("(function(){prompt(JSON.stringify([eval(%%s)]), 'gap-iab://%s')})()", object);
                                    }
                                    ((InAppBrowser)object3).injectDeferredObject(((CordovaArgs)object2).getString(0), (String)object);
                                    break block13;
                                }
                                if (!object.equals("injectScriptFile")) break block17;
                                if (((CordovaArgs)object2).getBoolean(1)) {
                                    Object[] objectArray = new Object[1];
                                    object = objectArray;
                                    objectArray[0] = callbackContext.getCallbackId();
                                    object = String.format("(function(d) { var c = d.createElement('script'); c.src = %%s; c.onload = function() { prompt('', 'gap-iab://%s'); }; d.body.appendChild(c); })(document)", object);
                                } else {
                                    object = "(function(d) { var c = d.createElement('script'); c.src = %s; d.body.appendChild(c); })(document)";
                                }
                                ((InAppBrowser)object3).injectDeferredObject(((CordovaArgs)object2).getString(0), (String)object);
                                break block13;
                            }
                            if (!object.equals("injectStyleCode")) break block18;
                            if (((CordovaArgs)object2).getBoolean(1)) {
                                Object[] objectArray = new Object[1];
                                object = objectArray;
                                objectArray[0] = callbackContext.getCallbackId();
                                object = String.format("(function(d) { var c = d.createElement('style'); c.innerHTML = %%s; d.body.appendChild(c); prompt('', 'gap-iab://%s');})(document)", object);
                            } else {
                                object = "(function(d) { var c = d.createElement('style'); c.innerHTML = %s; d.body.appendChild(c); })(document)";
                            }
                            ((InAppBrowser)object3).injectDeferredObject(((CordovaArgs)object2).getString(0), (String)object);
                            break block13;
                        }
                        if (!object.equals("injectStyleFile")) break block19;
                        if (((CordovaArgs)object2).getBoolean(1)) {
                            Object[] objectArray = new Object[1];
                            object = objectArray;
                            objectArray[0] = callbackContext.getCallbackId();
                            object = String.format("(function(d) { var c = d.createElement('link'); c.rel='stylesheet'; c.type='text/css'; c.href = %%s; d.head.appendChild(c); prompt('', 'gap-iab://%s');})(document)", object);
                        } else {
                            object = "(function(d) { var c = d.createElement('link'); c.rel='stylesheet'; c.type='text/css'; c.href = %s; d.head.appendChild(c); })(document)";
                        }
                        ((InAppBrowser)object3).injectDeferredObject(((CordovaArgs)object2).getString(0), (String)object);
                        break block13;
                    }
                    if (!object.equals("show")) break block20;
                    InAppBrowser inAppBrowser = object3;
                    inAppBrowser.cordova.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            InAppBrowser.this.dialog.show();
                        }
                    });
                    object3 = pluginResult2;
                    new PluginResult(PluginResult.Status.OK).setKeepCallback(true);
                    inAppBrowser.callbackContext.sendPluginResult((PluginResult)object3);
                    break block13;
                }
                if (!object.equals("hide")) break block21;
                InAppBrowser inAppBrowser = object3;
                inAppBrowser.cordova.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        InAppBrowser.this.dialog.hide();
                    }
                });
                object3 = pluginResult;
                new PluginResult(PluginResult.Status.OK).setKeepCallback(true);
                inAppBrowser.callbackContext.sendPluginResult((PluginResult)object3);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onReset() {
        this.closeDialog();
    }

    @Override
    public void onPause(boolean bl) {
        if (this.shouldPauseInAppBrowser) {
            this.inAppWebView.onPause();
        }
    }

    @Override
    public void onResume(boolean bl) {
        if (this.shouldPauseInAppBrowser) {
            this.inAppWebView.onResume();
        }
    }

    @Override
    public void onDestroy() {
        this.closeDialog();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String openExternal(String string2) {
        Intent intent;
        block7: {
            Intent intent2;
            Uri uri;
            block6: {
                Intent intent3;
                String string3;
                try {
                    string3 = string2;
                }
                catch (RuntimeException runtimeException) {
                    LOG.d(LOG_TAG, "InAppBrowser: Error loading url " + string2 + ":" + runtimeException.toString());
                    return runtimeException.toString();
                }
                intent = intent3;
                intent3 = new Intent("android.intent.action.VIEW");
                uri = Uri.parse((String)string3);
                if (!"file".equals(uri.getScheme())) break block6;
                intent2 = intent.setDataAndType(uri, this.webView.getResourceApi().getMimeType(uri));
                break block7;
            }
            intent2 = intent.setData(uri);
        }
        Intent intent4 = intent;
        intent4.putExtra("com.android.browser.application_id", this.cordova.getActivity().getPackageName());
        this.openExternalExcludeCurrentApp(intent4);
        return "";
    }

    public void closeDialog() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                JSONObject jSONObject;
                WebView webView = this_.InAppBrowser.this.inAppWebView;
                if (webView == null) {
                    return;
                }
                6 v0 = this_;
                WebView webView2 = webView;
                webView2.setWebViewClient(new WebViewClient(){

                    public void onPageFinished(WebView webView, String string2) {
                        if (InAppBrowser.this.dialog != null) {
                            1 v0 = this;
                            v0.InAppBrowser.this.dialog.dismiss();
                            InAppBrowser.access$202(v0.InAppBrowser.this, null);
                        }
                    }
                });
                webView2.loadUrl("about:blank");
                6 this_ = jSONObject;
                new JSONObject().put("type", (Object)InAppBrowser.EXIT_EVENT);
                try {
                    v0.InAppBrowser.this.sendUpdate((JSONObject)this_, false);
                }
                catch (JSONException jSONException) {
                    LOG.d(InAppBrowser.LOG_TAG, "Should never happen");
                }
            }
        });
    }

    public void goBack() {
        if (this.inAppWebView.canGoBack()) {
            this.inAppWebView.goBack();
        }
    }

    public boolean canGoBack() {
        return this.inAppWebView.canGoBack();
    }

    public boolean hardwareBack() {
        return this.hadwareBackButton;
    }

    public String showWebPage(final String string2, HashMap<String, String> object) {
        Runnable runnable;
        Object object2;
        InAppBrowser inAppBrowser = this;
        inAppBrowser.showLocationBar = true;
        inAppBrowser.showZoomControls = true;
        inAppBrowser.openWindowHidden = false;
        inAppBrowser.mediaPlaybackRequiresUserGesture = false;
        if (object != null) {
            object2 = ((HashMap)object).get(LOCATION);
            if (object2 != null) {
                this.showLocationBar = ((String)object2).equals("yes");
            }
            if (this.showLocationBar) {
                object2 = (String)((HashMap)object).get(HIDE_NAVIGATION);
                String string3 = (String)((HashMap)object).get(HIDE_URL);
                if (object2 != null) {
                    this.hideNavigationButtons = ((String)object2).equals("yes");
                }
                if (string3 != null) {
                    this.hideUrlBar = string3.equals("yes");
                }
            }
            if ((object2 = (String)((HashMap)object).get(ZOOM)) != null) {
                this.showZoomControls = ((String)object2).equals("yes");
            }
            if ((object2 = (String)((HashMap)object).get(HIDDEN)) != null) {
                this.openWindowHidden = ((String)object2).equals("yes");
            }
            this.hadwareBackButton = (object2 = (String)((HashMap)object).get(HARDWARE_BACK_BUTTON)) != null ? ((String)object2).equals("yes") : DEFAULT_HARDWARE_BACK.booleanValue();
            object2 = (String)((HashMap)object).get(MEDIA_PLAYBACK_REQUIRES_USER_ACTION);
            if (object2 != null) {
                this.mediaPlaybackRequiresUserGesture = ((String)object2).equals("yes");
            }
            if ((object2 = (String)((HashMap)object).get(CLEAR_ALL_CACHE)) != null) {
                this.clearAllCache = ((String)object2).equals("yes");
            } else {
                object2 = (String)((HashMap)object).get(CLEAR_SESSION_CACHE);
                if (object2 != null) {
                    this.clearSessionCache = ((String)object2).equals("yes");
                }
            }
            object2 = (String)((HashMap)object).get(SHOULD_PAUSE);
            if (object2 != null) {
                this.shouldPauseInAppBrowser = ((String)object2).equals("yes");
            }
            if ((object2 = (String)((HashMap)object).get(USER_WIDE_VIEW_PORT)) != null) {
                this.useWideViewPort = ((String)object2).equals("yes");
            }
            if ((object2 = (String)((HashMap)object).get(CLOSE_BUTTON_CAPTION)) != null) {
                this.closeButtonCaption = object2;
            }
            if ((object2 = (String)((HashMap)object).get(CLOSE_BUTTON_COLOR)) != null) {
                this.closeButtonColor = object2;
            }
            if ((object2 = (String)((HashMap)object).get(LEFT_TO_RIGHT)) != null) {
                this.leftToRight = ((String)object2).equals("yes");
            }
            if ((object2 = (String)((HashMap)object).get(TOOLBAR_COLOR)) != null) {
                this.toolbarColor = Color.parseColor((String)object2);
            }
            if ((object2 = (String)((HashMap)object).get(NAVIGATION_COLOR)) != null) {
                this.navigationButtonColor = object2;
            }
            if ((object2 = (String)((HashMap)object).get(FOOTER)) != null) {
                this.showFooter = ((String)object2).equals("yes");
            }
            if ((object2 = (String)((HashMap)object).get(FOOTER_COLOR)) != null) {
                this.footerColor = object2;
            }
            if (((HashMap)object).get(BEFORELOAD) != null) {
                this.beforeload = (String)((HashMap)object).get(BEFORELOAD);
            }
        }
        InAppBrowser inAppBrowser2 = this;
        object = inAppBrowser2.webView;
        object2 = runnable;
        runnable = new Runnable((CordovaWebView)object){
            final /* synthetic */ CordovaWebView val$thatWebView;
            {
                this.val$thatWebView = cordovaWebView;
            }

            private int dpToPixels(int n2) {
                float f2 = n2;
                DisplayMetrics displayMetrics = InAppBrowser.this.cordova.getActivity().getResources().getDisplayMetrics();
                return (int)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)displayMetrics);
            }

            private View createCloseButton(int n2) {
                RelativeLayout.LayoutParams layoutParams;
                String string22;
                7 v0 = this;
                Resources resources = v0.InAppBrowser.this.cordova.getActivity().getResources();
                if (v0.InAppBrowser.this.closeButtonCaption != "") {
                    TextView textView;
                    resources = textView;
                    resources((Context)InAppBrowser.this.cordova.getActivity());
                    textView.setText((CharSequence)InAppBrowser.this.closeButtonCaption);
                    textView.setTextSize(20.0f);
                    if (InAppBrowser.this.closeButtonColor != "") {
                        resources.setTextColor(Color.parseColor((String)InAppBrowser.this.closeButtonColor));
                    }
                    resources.setGravity(16);
                    resources.setPadding(this.dpToPixels(10), 0, this.dpToPixels(10), 0);
                } else {
                    ImageButton imageButton;
                    Resources resources2 = resources;
                    resources = imageButton;
                    imageButton = new ImageButton((Context)InAppBrowser.this.cordova.getActivity());
                    string22 = InAppBrowser.this.cordova.getActivity().getPackageName();
                    string22 = resources2.getDrawable(resources2.getIdentifier("ic_action_remove", "drawable", string22));
                    if (InAppBrowser.this.closeButtonColor != "") {
                        resources.setColorFilter(Color.parseColor((String)InAppBrowser.this.closeButtonColor));
                    }
                    Resources resources3 = resources;
                    resources3.setImageDrawable((Drawable)string22);
                    resources3.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    if (Build.VERSION.SDK_INT >= 16) {
                        resources.getAdjustViewBounds();
                    }
                }
                string22 = layoutParams;
                layoutParams = new RelativeLayout.LayoutParams(-2, -1);
                if (InAppBrowser.this.leftToRight) {
                    string22.addRule(9);
                } else {
                    string22.addRule(11);
                }
                resources.setLayoutParams((ViewGroup.LayoutParams)string22);
                if (Build.VERSION.SDK_INT >= 16) {
                    resources.setBackground(null);
                } else {
                    resources.setBackgroundDrawable(null);
                }
                Resources resources4 = resources;
                resources.setContentDescription((CharSequence)"Close Button");
                resources4.setId(Integer.valueOf(n2).intValue());
                resources4.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        InAppBrowser.this.closeDialog();
                    }
                });
                return resources4;
            }

            @Override
            @SuppressLint(value={"NewApi"})
            public void run() {
                WindowManager.LayoutParams layoutParams;
                RelativeLayout relativeLayout;
                RelativeLayout relativeLayout2;
                RelativeLayout.LayoutParams layoutParams2;
                ImageButton imageButton;
                ImageButton imageButton2;
                RelativeLayout.LayoutParams layoutParams3;
                RelativeLayout relativeLayout3;
                RelativeLayout relativeLayout4;
                RelativeLayout relativeLayout5;
                LinearLayout linearLayout;
                if (InAppBrowser.this.dialog != null) {
                    InAppBrowser.this.dialog.dismiss();
                }
                7 v0 = this;
                InAppBrowser inAppBrowser = v0.InAppBrowser.this;
                InAppBrowser.access$202(inAppBrowser, new InAppBrowserDialog((Context)inAppBrowser.cordova.getActivity(), 16973830));
                ((InAppBrowser)v0.InAppBrowser.this).dialog.getWindow().getAttributes().windowAnimations = 16973826;
                v0.InAppBrowser.this.dialog.requestWindowFeature(1);
                v0.InAppBrowser.this.dialog.getWindow().setFlags(1024, 1024);
                v0.InAppBrowser.this.dialog.setCancelable(true);
                v0.InAppBrowser.this.dialog.setInAppBroswer(InAppBrowser.this.getInAppBrowser());
                inAppBrowser = linearLayout;
                new LinearLayout((Context)InAppBrowser.this.cordova.getActivity()).setOrientation(1);
                RelativeLayout relativeLayout6 = relativeLayout5 = relativeLayout4;
                relativeLayout5((Context)InAppBrowser.this.cordova.getActivity());
                relativeLayout6.setBackgroundColor(InAppBrowser.this.toolbarColor);
                relativeLayout6.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.dpToPixels(44)));
                relativeLayout4.setPadding(this.dpToPixels(2), this.dpToPixels(2), this.dpToPixels(2), this.dpToPixels(2));
                if (v0.InAppBrowser.this.leftToRight) {
                    relativeLayout5.setHorizontalGravity(3);
                } else {
                    relativeLayout5.setHorizontalGravity(5);
                }
                relativeLayout5.setVerticalGravity(48);
                RelativeLayout relativeLayout7 = relativeLayout3;
                relativeLayout3 = new RelativeLayout((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams layoutParams4 = layoutParams3;
                layoutParams3 = new RelativeLayout.LayoutParams(-2, -2);
                if (InAppBrowser.this.leftToRight) {
                    layoutParams4.addRule(11);
                } else {
                    layoutParams4.addRule(9);
                }
                RelativeLayout relativeLayout8 = relativeLayout7;
                relativeLayout8.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
                relativeLayout8.setHorizontalGravity(3);
                relativeLayout8.setVerticalGravity(16);
                int n2 = InAppBrowser.this.leftToRight ? Integer.valueOf(5) : Integer.valueOf(1);
                7 v7 = this;
                relativeLayout7.setId(n2);
                ImageButton imageButton3 = imageButton2;
                imageButton2 = new ImageButton((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams layoutParams5 = new RelativeLayout.LayoutParams(-2, -1);
                layoutParams5.addRule(5);
                imageButton2.setLayoutParams((ViewGroup.LayoutParams)layoutParams5);
                imageButton2.setContentDescription((CharSequence)"Back Button");
                imageButton2.setId(Integer.valueOf(2).intValue());
                Resources resources = v7.InAppBrowser.this.cordova.getActivity().getResources();
                String string22 = InAppBrowser.this.cordova.getActivity().getPackageName();
                string22 = resources.getDrawable(resources.getIdentifier("ic_action_previous_item", "drawable", string22));
                if (v7.InAppBrowser.this.navigationButtonColor != "") {
                    imageButton3.setColorFilter(Color.parseColor((String)InAppBrowser.this.navigationButtonColor));
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    imageButton3.setBackground(null);
                } else {
                    imageButton3.setBackgroundDrawable(null);
                }
                7 v10 = this;
                ImageButton imageButton4 = imageButton3;
                imageButton4.setImageDrawable((Drawable)string22);
                imageButton4.setScaleType(ImageView.ScaleType.FIT_CENTER);
                int n3 = v10.dpToPixels(10);
                int n4 = v10.dpToPixels(10);
                imageButton3.setPadding(0, n3, 0, n4);
                if (Build.VERSION.SDK_INT >= 16) {
                    imageButton3.getAdjustViewBounds();
                }
                Resources resources2 = resources;
                imageButton3.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        InAppBrowser.this.goBack();
                    }
                });
                resources = imageButton;
                imageButton = new ImageButton((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams layoutParams6 = new RelativeLayout.LayoutParams(-2, -1);
                layoutParams6.addRule(1, 2);
                imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams6);
                imageButton.setContentDescription((CharSequence)"Forward Button");
                imageButton.setId(Integer.valueOf(3).intValue());
                String string3 = InAppBrowser.this.cordova.getActivity().getPackageName();
                string3 = resources2.getDrawable(resources2.getIdentifier("ic_action_next_item", "drawable", string3));
                if (InAppBrowser.this.navigationButtonColor != "") {
                    resources.setColorFilter(Color.parseColor((String)InAppBrowser.this.navigationButtonColor));
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    resources.setBackground(null);
                } else {
                    resources.setBackgroundDrawable(null);
                }
                7 v15 = this;
                Resources resources3 = resources;
                resources3.setImageDrawable((Drawable)string3);
                resources3.setScaleType(ImageView.ScaleType.FIT_CENTER);
                int n5 = v15.dpToPixels(10);
                n4 = v15.dpToPixels(10);
                resources.setPadding(0, n5, 0, n4);
                if (Build.VERSION.SDK_INT >= 16) {
                    resources.getAdjustViewBounds();
                }
                7 v17 = this;
                resources.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        InAppBrowser.this.goForward();
                    }
                });
                InAppBrowser inAppBrowser2 = v17.InAppBrowser.this;
                InAppBrowser.access$1102(inAppBrowser2, new EditText((Context)inAppBrowser2.cordova.getActivity()));
                inAppBrowser2 = layoutParams2;
                new RelativeLayout.LayoutParams(-1, -1).addRule(1, 1);
                inAppBrowser2.addRule(0, 5);
                v17.InAppBrowser.this.edittext.setLayoutParams((ViewGroup.LayoutParams)inAppBrowser2);
                v17.InAppBrowser.this.edittext.setId(Integer.valueOf(4).intValue());
                v17.InAppBrowser.this.edittext.setSingleLine(true);
                v17.InAppBrowser.this.edittext.setText((CharSequence)string2);
                v17.InAppBrowser.this.edittext.setInputType(16);
                v17.InAppBrowser.this.edittext.setImeOptions(2);
                v17.InAppBrowser.this.edittext.setInputType(0);
                v17.InAppBrowser.this.edittext.setOnKeyListener(new View.OnKeyListener(){

                    public boolean onKey(View view, int n2, KeyEvent keyEvent) {
                        if (keyEvent.getAction() == 0 && n2 == 66) {
                            InAppBrowser inAppBrowser = InAppBrowser.this;
                            inAppBrowser.navigate(inAppBrowser.edittext.getText().toString());
                            return true;
                        }
                        return false;
                    }
                });
                int n6 = v17.InAppBrowser.this.leftToRight ? 1 : 5;
                relativeLayout5.addView(this.createCloseButton(n6));
                RelativeLayout relativeLayout9 = relativeLayout2;
                relativeLayout2 = new RelativeLayout((Context)InAppBrowser.this.cordova.getActivity());
                n4 = InAppBrowser.this.footerColor != "" ? Color.parseColor((String)InAppBrowser.this.footerColor) : -3355444;
                RelativeLayout relativeLayout10 = relativeLayout9;
                relativeLayout10.setBackgroundColor(n4);
                RelativeLayout.LayoutParams layoutParams7 = new RelativeLayout.LayoutParams(-1, this.dpToPixels(44));
                layoutParams7.addRule(12, -1);
                relativeLayout10.setLayoutParams((ViewGroup.LayoutParams)layoutParams7);
                if (InAppBrowser.this.closeButtonCaption != "") {
                    relativeLayout9.setPadding(this.dpToPixels(8), this.dpToPixels(8), this.dpToPixels(8), this.dpToPixels(8));
                }
                7 v22 = this;
                RelativeLayout relativeLayout11 = relativeLayout9;
                relativeLayout11.setHorizontalGravity(3);
                relativeLayout11.setVerticalGravity(80);
                relativeLayout9.addView(this.createCloseButton(7));
                InAppBrowser inAppBrowser3 = v22.InAppBrowser.this;
                InAppBrowser.access$102(inAppBrowser3, new WebView((Context)inAppBrowser3.cordova.getActivity()));
                v22.InAppBrowser.this.inAppWebView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                v22.InAppBrowser.this.inAppWebView.setId(Integer.valueOf(6).intValue());
                7 v24 = this;
                v22.InAppBrowser.this.inAppWebView.setWebChromeClient((WebChromeClient)new InAppChromeClient(v24.val$thatWebView){

                    public boolean onShowFileChooser(WebView object, ValueCallback<Uri[]> valueCallback, WebChromeClient.FileChooserParams fileChooserParams) {
                        Intent intent;
                        LOG.d(InAppBrowser.LOG_TAG, "File Chooser 5.0+");
                        if (this_.InAppBrowser.this.mUploadCallbackLollipop != null) {
                            this_.InAppBrowser.this.mUploadCallbackLollipop.onReceiveValue(null);
                        }
                        5 v0 = this_;
                        InAppBrowser.access$1402(v0.InAppBrowser.this, valueCallback);
                        5 this_ = intent;
                        new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE");
                        this_.setType("*/*");
                        object = v0.InAppBrowser.this;
                        object.cordova.startActivityForResult((CordovaPlugin)object, Intent.createChooser((Intent)this_, (CharSequence)"Select File"), 2);
                        return true;
                    }

                    public void openFileChooser(ValueCallback<Uri> valueCallback, String string2, String string3) {
                        LOG.d(InAppBrowser.LOG_TAG, "File Chooser 4.1+");
                        this.openFileChooser(valueCallback, string2);
                    }

                    public void openFileChooser(ValueCallback<Uri> object, String string2) {
                        Intent intent;
                        5 v0 = this_;
                        LOG.d(InAppBrowser.LOG_TAG, "File Chooser 3.0+");
                        InAppBrowser.access$1502(v0.InAppBrowser.this, object);
                        5 this_ = intent;
                        new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE");
                        object = v0.InAppBrowser.this;
                        object.cordova.startActivityForResult((CordovaPlugin)object, Intent.createChooser((Intent)this_, (CharSequence)"Select File"), 1);
                    }
                });
                inAppBrowser3 = v22.InAppBrowser.this;
                InAppBrowser.access$002(inAppBrowser3, inAppBrowser3.new InAppBrowserClient(this.val$thatWebView, inAppBrowser3.edittext, InAppBrowser.this.beforeload));
                v22.InAppBrowser.this.inAppWebView.setWebViewClient((WebViewClient)InAppBrowser.this.currentClient);
                InAppBrowser inAppBrowser4 = inAppBrowser3 = v22.InAppBrowser.this.inAppWebView.getSettings();
                inAppBrowser4.setJavaScriptEnabled(true);
                inAppBrowser4.setJavaScriptCanOpenWindowsAutomatically(true);
                inAppBrowser3.setBuiltInZoomControls(InAppBrowser.this.showZoomControls);
                inAppBrowser3.setPluginState(WebSettings.PluginState.ON);
                if (Build.VERSION.SDK_INT >= 17) {
                    inAppBrowser3.setMediaPlaybackRequiresUserGesture(InAppBrowser.this.mediaPlaybackRequiresUserGesture);
                    class JsObject {
                        JsObject() {
                        }

                        @JavascriptInterface
                        public void postMessage(String string2) {
                            JSONObject jSONObject;
                            JsObject jsObject = jsObject2;
                            JsObject jsObject2 = jSONObject;
                            new JSONObject().put("type", (Object)InAppBrowser.MESSAGE_EVENT);
                            jsObject2.put("data", new JSONObject(string2));
                            try {
                                jsObject.InAppBrowser.this.sendUpdate((JSONObject)jsObject2, true);
                            }
                            catch (JSONException jSONException) {
                                LOG.e(InAppBrowser.LOG_TAG, "data object passed to postMessage has caused a JSON error.");
                            }
                        }
                    }
                    InAppBrowser.this.inAppWebView.addJavascriptInterface((Object)new JsObject(), "cordova_iab");
                }
                String string4 = InAppBrowser.this.preferences.getString("OverrideUserAgent", null);
                String string5 = InAppBrowser.this.preferences.getString("AppendUserAgent", null);
                if (string4 != null) {
                    inAppBrowser3.setUserAgentString(string4);
                }
                if (string5 != null) {
                    inAppBrowser3.setUserAgentString(inAppBrowser3.getUserAgentString() + string5);
                }
                if ((string4 = InAppBrowser.this.cordova.getActivity().getIntent().getExtras()) == null ? true : string4.getBoolean("InAppBrowserStorageEnabled", true)) {
                    InAppBrowser inAppBrowser5 = inAppBrowser3;
                    inAppBrowser5.setDatabasePath(InAppBrowser.this.cordova.getActivity().getApplicationContext().getDir("inAppBrowserDB", 0).getPath());
                    inAppBrowser5.setDatabaseEnabled(true);
                }
                inAppBrowser3.setDomStorageEnabled(true);
                if (InAppBrowser.this.clearAllCache) {
                    CookieManager.getInstance().removeAllCookie();
                } else if (InAppBrowser.this.clearSessionCache) {
                    CookieManager.getInstance().removeSessionCookie();
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    CookieManager.getInstance().setAcceptThirdPartyCookies(InAppBrowser.this.inAppWebView, true);
                }
                7 v27 = this;
                v27.InAppBrowser.this.inAppWebView.loadUrl(string2);
                v27.InAppBrowser.this.inAppWebView.setId(Integer.valueOf(6).intValue());
                v27.InAppBrowser.this.inAppWebView.getSettings().setLoadWithOverviewMode(true);
                v27.InAppBrowser.this.inAppWebView.getSettings().setUseWideViewPort(InAppBrowser.this.useWideViewPort);
                v27.InAppBrowser.this.inAppWebView.requestFocus();
                v27.InAppBrowser.this.inAppWebView.requestFocusFromTouch();
                relativeLayout7.addView((View)imageButton3);
                relativeLayout7.addView((View)resources);
                if (!InAppBrowser.this.hideNavigationButtons) {
                    relativeLayout5.addView((View)relativeLayout7);
                }
                if (!InAppBrowser.this.hideUrlBar) {
                    relativeLayout5.addView((View)InAppBrowser.this.edittext);
                }
                if (InAppBrowser.this.getShowLocationBar()) {
                    inAppBrowser.addView((View)relativeLayout5);
                }
                relativeLayout5 = relativeLayout;
                relativeLayout5((Context)InAppBrowser.this.cordova.getActivity());
                relativeLayout.addView((View)InAppBrowser.this.inAppWebView);
                inAppBrowser.addView((View)relativeLayout);
                if (InAppBrowser.this.showFooter) {
                    relativeLayout5.addView((View)relativeLayout9);
                }
                7 v29 = this;
                relativeLayout5 = layoutParams;
                relativeLayout5();
                layoutParams.copyFrom(InAppBrowser.this.dialog.getWindow().getAttributes());
                layoutParams.width = -1;
                layoutParams.height = -1;
                v29.InAppBrowser.this.dialog.setContentView((View)inAppBrowser);
                v29.InAppBrowser.this.dialog.show();
                v29.InAppBrowser.this.dialog.getWindow().setAttributes((WindowManager.LayoutParams)relativeLayout5);
                if (v29.InAppBrowser.this.openWindowHidden) {
                    InAppBrowser.this.dialog.hide();
                }
            }
        };
        inAppBrowser2.cordova.getActivity().runOnUiThread((Runnable)object2);
        return "";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onActivityResult(int var1_1, int var2_3, Intent var3_4) {
        block6: {
            block5: {
                block3: {
                    block4: {
                        if (Build.VERSION.SDK_INT < 21) break block3;
                        LOG.d("InAppBrowser", "onActivityResult (For Android >= 5.0)");
                        if (var1_1 != 2 || (var4_5 = this.mUploadCallbackLollipop) == null) break block4;
                        var4_5.onReceiveValue((Object)WebChromeClient.FileChooserParams.parseResult((int)var2_3, (Intent)var3_4));
                        this.mUploadCallbackLollipop = null;
                        break block5;
                    }
                    super.onActivityResult(var1_1, var2_3, var3_4);
                    return;
                }
                LOG.d("InAppBrowser", "onActivityResult (For Android < 5.0)");
                if (var1_1 != 1 || (var4_6 = this.mUploadCallback) == null) break block6;
                if (var4_6 == null) {
                    return;
                }
                if (var3_4 == null) ** GOTO lbl-1000
                this.cordova.getActivity();
                if (var2_3 == -1) {
                    var1_2 = var3_4.getData();
                } else lbl-1000:
                // 2 sources

                {
                    var1_2 = null;
                }
                this.mUploadCallback.onReceiveValue(var1_2);
                this.mUploadCallback = null;
            }
            return;
        }
        super.onActivityResult(var1_1, var2_3, var3_4);
    }

    public class InAppBrowserClient
    extends WebViewClient {
        EditText edittext;
        CordovaWebView webView;
        String beforeload;
        boolean waitForBeforeload;

        public InAppBrowserClient(CordovaWebView cordovaWebView, EditText editText, String string2) {
            this.webView = cordovaWebView;
            this.edittext = editText;
            this.beforeload = string2;
            boolean bl = string2 != null;
            this.waitForBeforeload = bl;
        }

        private boolean sendBeforeLoad(String string2, String string3) {
            JSONObject jSONObject;
            String string4;
            try {
                string4 = string3;
            }
            catch (JSONException jSONException) {
                LOG.e(InAppBrowser.LOG_TAG, "URI passed in has caused a JSON error.");
                return false;
            }
            JSONObject jSONObject2 = jSONObject;
            new JSONObject().put("type", (Object)InAppBrowser.BEFORELOAD);
            jSONObject2.put("url", (Object)string2);
            if (string4 != null) {
                jSONObject2.put("method", (Object)string3);
            }
            InAppBrowser.this.sendUpdate(jSONObject2, true);
            return true;
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            return this.shouldOverrideUrlLoading(string2, null);
        }

        @TargetApi(value=24)
        public boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
            return this.shouldOverrideUrlLoading(webResourceRequest.getUrl().toString(), webResourceRequest.getMethod());
        }

        /*
         * Unable to fully structure code
         */
        public boolean shouldOverrideUrlLoading(String var1_1, String var2_2) {
            block45: {
                block49: {
                    block50: {
                        block47: {
                            block46: {
                                block48: {
                                    var3_7 = false;
                                    var4_8 = false;
                                    var5_9 = null;
                                    if (this.beforeload.equals("yes") && var2_2 == null) {
                                        while (true) {
                                            var4_8 = true;
                                            break;
                                        }
                                    } else {
                                        if (this.beforeload.equals("yes") && !var2_2.equals("POST") || this.beforeload.equals("get") && (var2_2 == null || var2_2.equals("GET"))) ** continue;
                                        if (this.beforeload.equals("post") && (var2_2 == null || var2_2.equals("POST"))) {
                                            var5_9 = "beforeload doesn't yet support POST requests";
                                        }
                                    }
                                    if (var4_8 && this.waitForBeforeload && this.sendBeforeLoad(var1_1, (String)var2_2)) {
                                        return true;
                                    }
                                    if (var5_9 != null) {
                                        v0 = this;
                                        LOG.e("InAppBrowser", var5_9);
                                        var2_2 = v1;
                                        new JSONObject().put("type", (Object)"loaderror");
                                        var2_2.put("url", (Object)var1_1);
                                        var2_2.put("code", -1);
                                        var2_2.put("message", (Object)var5_9);
                                        v2 = v0.InAppBrowser.this;
                                        try {
                                            InAppBrowser.access$2900(v2, (JSONObject)var2_2, true, PluginResult.Status.ERROR);
                                        }
                                        catch (Exception var2_3) {
                                            LOG.e("InAppBrowser", "Error sending loaderror for " + var1_1 + ": " + var2_3.toString());
                                        }
                                    }
                                    if (!var1_1.startsWith("tel:")) break block48;
                                    v3 = this;
                                    var2_2 = v4;
                                    var2_2("android.intent.action.DIAL");
                                    v4.setData(Uri.parse((String)var1_1));
                                    try {
                                        v3.InAppBrowser.this.cordova.getActivity().startActivity((Intent)var2_2);
                                    }
                                    catch (ActivityNotFoundException var2_4) {
                                        LOG.e("InAppBrowser", "Error dialing " + var1_1 + ": " + var2_4.toString());
                                    }
lbl47:
                                    // 3 sources

                                    while (true) {
                                        var3_7 = true;
                                        break block45;
                                        break;
                                    }
                                    break block45;
                                }
                                if (var1_1.startsWith("geo:") || var1_1.startsWith("mailto:") || var1_1.startsWith("market:") || var1_1.startsWith("intent:")) break block49;
                                if (!var1_1.startsWith("sms:")) break block50;
                                v5 = var1_1;
                                var2_2 = v6;
                                v6 = new Intent("android.intent.action.VIEW");
                                var5_10 = v5.indexOf(63);
                                if (var5_10 != -1) break block46;
                                var5_11 = var1_1.substring(4);
                                break block47;
                            }
                            v7 = var1_1;
                            v8 = v7;
                            var5_11 = v7.substring(4, var5_10);
                            var6_13 = Uri.parse((String)v8).getQuery();
                            if (var6_13 == null) break block47;
                            if (!var6_13.startsWith("body=")) break block47;
                            var2_2.putExtra("sms_body", var6_13.substring(5));
                        }
                        v9 = this;
                        v10 = var2_2;
                        v11 = var2_2;
                        var2_2.setData(Uri.parse((String)("sms:" + var5_11)));
                        v11.putExtra("address", var5_11);
                        v10.setType("vnd.android-dir/mms-sms");
                        try {
                            v9.InAppBrowser.this.cordova.getActivity().startActivity((Intent)var2_2);
                            ** GOTO lbl47
                        }
                        catch (ActivityNotFoundException var2_5) {
                            LOG.e("InAppBrowser", "Error sending sms " + var1_1 + ":" + var2_5.toString());
                        }
                        break block45;
                    }
                    if (!var1_1.startsWith("http:") && !var1_1.startsWith("https:") && var1_1.matches("^[A-Za-z0-9+.-]*://.*?$")) {
                        if (InAppBrowser.access$3000(InAppBrowser.this) == null && (var2_2 = InAppBrowser.access$3100(InAppBrowser.this).getString("AllowedSchemes", null)) != null) {
                            InAppBrowser.access$3002(InAppBrowser.this, var2_2.split(","));
                        }
                        if (InAppBrowser.access$3000(InAppBrowser.this) != null) {
                            var2_2 = InAppBrowser.access$3000(InAppBrowser.this);
                            var5_12 = var2_2.length;
                            for (var6_14 = 0; var6_14 < var5_12; ++var6_14) {
                                if (!var1_1.startsWith(var2_2[var6_14])) continue;
                                v12 = this;
                                var7_15 = v13;
                                new JSONObject().put("type", (Object)"customscheme");
                                var7_15.put("url", (Object)var1_1);
                                try {
                                    InAppBrowser.access$300(v12.InAppBrowser.this, var7_15, true);
                                    var3_7 = true;
                                    continue;
                                }
                                catch (JSONException v14) {
                                    LOG.e("InAppBrowser", "Custom Scheme URI passed in has caused a JSON error.");
                                }
                            }
                        }
                    }
                    break block45;
                }
                v15 = this;
                var2_2 = v16;
                var2_2("android.intent.action.VIEW");
                v16.setData(Uri.parse((String)var1_1));
                try {
                    v15.InAppBrowser.this.cordova.getActivity().startActivity((Intent)var2_2);
                    ** continue;
                }
                catch (ActivityNotFoundException var2_6) {
                    LOG.e("InAppBrowser", "Error with " + var1_1 + ": " + var2_6.toString());
                }
            }
            if (var4_8) {
                this.waitForBeforeload = true;
            }
            return var3_7;
        }

        public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
            return this.shouldInterceptRequest(string2, super.shouldInterceptRequest(webView, string2), null);
        }

        @TargetApi(value=21)
        public WebResourceResponse shouldInterceptRequest(WebView webView, WebResourceRequest webResourceRequest) {
            return this.shouldInterceptRequest(webResourceRequest.getUrl().toString(), super.shouldInterceptRequest(webView, webResourceRequest), webResourceRequest.getMethod());
        }

        public WebResourceResponse shouldInterceptRequest(String string2, WebResourceResponse webResourceResponse, String string3) {
            return webResourceResponse;
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            JSONObject jSONObject;
            super.onPageStarted(webView, string2, bitmap);
            if (!(string2.startsWith("http:") || string2.startsWith("https:") || string2.startsWith("file:"))) {
                LOG.e(InAppBrowser.LOG_TAG, "Possible Uncaught/Unknown URI");
                string2 = "http://" + string2;
            }
            if (!string2.equals(inAppBrowserClient2.edittext.getText().toString())) {
                inAppBrowserClient2.edittext.setText((CharSequence)string2);
            }
            InAppBrowserClient inAppBrowserClient = inAppBrowserClient2;
            InAppBrowserClient inAppBrowserClient2 = jSONObject;
            new JSONObject().put("type", (Object)InAppBrowser.LOAD_START_EVENT);
            inAppBrowserClient2.put("url", string2);
            try {
                inAppBrowserClient.InAppBrowser.this.sendUpdate((JSONObject)inAppBrowserClient2, true);
            }
            catch (JSONException jSONException) {
                LOG.e(InAppBrowser.LOG_TAG, "URI passed in has caused a JSON error.");
            }
        }

        public void onPageFinished(WebView webView, String string2) {
            JSONObject jSONObject;
            super.onPageFinished(webView, string2);
            if (Build.VERSION.SDK_INT >= 17) {
                inAppBrowserClient2.InAppBrowser.this.injectDeferredObject("window.webkit={messageHandlers:{cordova_iab:cordova_iab}}", null);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                CookieManager.getInstance().flush();
            } else {
                CookieSyncManager.getInstance().sync();
            }
            InAppBrowserClient inAppBrowserClient = inAppBrowserClient2;
            WebView webView2 = webView;
            webView2.clearFocus();
            webView2.requestFocus();
            InAppBrowserClient inAppBrowserClient2 = jSONObject;
            new JSONObject().put("type", (Object)InAppBrowser.LOAD_STOP_EVENT);
            inAppBrowserClient2.put("url", string2);
            try {
                inAppBrowserClient.InAppBrowser.this.sendUpdate((JSONObject)inAppBrowserClient2, true);
            }
            catch (JSONException jSONException) {
                LOG.d(InAppBrowser.LOG_TAG, "Should never happen");
            }
        }

        public void onReceivedError(WebView webView, int n2, String string2, String string3) {
            JSONObject jSONObject;
            InAppBrowserClient inAppBrowserClient = inAppBrowserClient2;
            super.onReceivedError(webView, n2, string2, string3);
            InAppBrowserClient inAppBrowserClient2 = jSONObject;
            new JSONObject().put("type", (Object)InAppBrowser.LOAD_ERROR_EVENT);
            inAppBrowserClient2.put("url", string3);
            inAppBrowserClient2.put("code", n2);
            inAppBrowserClient2.put(InAppBrowser.MESSAGE_EVENT, string2);
            InAppBrowser inAppBrowser = inAppBrowserClient.InAppBrowser.this;
            try {
                inAppBrowser.sendUpdate((JSONObject)inAppBrowserClient2, true, PluginResult.Status.ERROR);
            }
            catch (JSONException jSONException) {
                LOG.d(InAppBrowser.LOG_TAG, "Should never happen");
            }
        }

        public void onReceivedHttpAuthRequest(WebView webView, HttpAuthHandler httpAuthHandler, String string2, String string3) {
            Object object = null;
            Class<?> clazz = this.webView.getClass();
            try {
                object = (PluginManager)clazz.getMethod("getPluginManager", new Class[0]).invoke((Object)this.webView, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOG.d(InAppBrowser.LOG_TAG, invocationTargetException.getLocalizedMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                LOG.d(InAppBrowser.LOG_TAG, illegalAccessException.getLocalizedMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOG.d(InAppBrowser.LOG_TAG, noSuchMethodException.getLocalizedMessage());
            }
            if (object == null) {
                try {
                    object = (PluginManager)this.webView.getClass().getField("pluginManager").get(this.webView);
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOG.d(InAppBrowser.LOG_TAG, illegalAccessException.getLocalizedMessage());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    LOG.d(InAppBrowser.LOG_TAG, noSuchFieldException.getLocalizedMessage());
                }
            }
            if (object != null) {
                CordovaHttpAuthHandler cordovaHttpAuthHandler;
                PluginManager pluginManager = object;
                object = cordovaHttpAuthHandler;
                ((CordovaHttpAuthHandler)object)(httpAuthHandler);
                if (pluginManager.onReceivedHttpAuthRequest(this.webView, cordovaHttpAuthHandler, string2, string3)) {
                    return;
                }
            }
            super.onReceivedHttpAuthRequest(webView, httpAuthHandler, string2, string3);
        }
    }
}

