/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;

public class NativeToJsMessageQueue {
    private static final String LOG_TAG = "JsMessageQueue";
    private static final boolean FORCE_ENCODE_USING_EVAL = false;
    static final boolean DISABLE_EXEC_CHAINING = false;
    private static int MAX_PAYLOAD_SIZE = 524288000;
    private boolean paused;
    private final LinkedList<JsMessage> queue = new LinkedList();
    private ArrayList<BridgeMode> bridgeModes = new ArrayList();
    private BridgeMode activeBridgeMode;

    private int calculatePackedMessageLength(JsMessage jsMessage) {
        int n2 = jsMessage.calculateEncodedLength();
        return String.valueOf(n2).length() + n2 + 1;
    }

    private void packMessage(JsMessage jsMessage, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.append(jsMessage.calculateEncodedLength()).append(' ');
        jsMessage.encodeAsMessage(stringBuilder2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void enqueueMessage(JsMessage jsMessage) {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            if (nativeToJsMessageQueue.activeBridgeMode == null) {
                LOG.d(LOG_TAG, "Dropping Native->JS message due to disabled bridge");
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            NativeToJsMessageQueue nativeToJsMessageQueue2 = this;
            NativeToJsMessageQueue nativeToJsMessageQueue3 = nativeToJsMessageQueue2;
            nativeToJsMessageQueue2.queue.add(jsMessage);
            {
                if (!nativeToJsMessageQueue3.paused) {
                    this.activeBridgeMode.onNativeToJsMessageAvailable(this);
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
        }
    }

    public void addBridgeMode(BridgeMode bridgeMode) {
        this.bridgeModes.add(bridgeMode);
    }

    public boolean isBridgeEnabled() {
        return this.activeBridgeMode != null;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBridgeMode(int n2) {
        block7: {
            block6: {
                if (n2 < -1 || n2 >= this.bridgeModes.size()) break block6;
                BridgeMode bridgeMode = n2 < 0 ? null : this.bridgeModes.get(n2);
                if (bridgeMode == this.activeBridgeMode) break block7;
                String string2 = LOG_TAG;
                StringBuilder stringBuilder = new StringBuilder().append("Set native->JS mode to ");
                String string3 = bridgeMode == null ? "null" : bridgeMode.getClass().getSimpleName();
                LOG.d(string2, stringBuilder.append(string3).toString());
                synchronized (this) {
                    this.activeBridgeMode = bridgeMode;
                    if (bridgeMode == null) break block7;
                    bridgeMode.reset();
                    if (this.paused) break block7;
                    if (this.queue.isEmpty()) break block7;
                    bridgeMode.onNativeToJsMessageAvailable(this);
                }
            }
            LOG.d(LOG_TAG, "Invalid NativeToJsBridgeMode: " + n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            nativeToJsMessageQueue.queue.clear();
            nativeToJsMessageQueue.setBridgeMode(-1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String popAndEncode(boolean n2) {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            Object object;
            block11: {
                StringBuilder stringBuilder;
                if (nativeToJsMessageQueue.activeBridgeMode == null) {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return null;
                }
                NativeToJsMessageQueue nativeToJsMessageQueue2 = this;
                nativeToJsMessageQueue2.activeBridgeMode.notifyOfFlush(this, n2 != 0);
                if (nativeToJsMessageQueue2.queue.isEmpty()) {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return null;
                }
                n2 = 0;
                int n3 = 0;
                object = this.queue.iterator();
                while (object.hasNext()) {
                    int n4 = this.calculatePackedMessageLength((JsMessage)object.next());
                    if (n3 > 0 && n2 + n4 > MAX_PAYLOAD_SIZE && MAX_PAYLOAD_SIZE > 0) break;
                    n2 += n4;
                    ++n3;
                }
                object = stringBuilder;
                stringBuilder = new StringBuilder(n2);
                for (n2 = 0; n2 < n3; ++n2) {
                    NativeToJsMessageQueue nativeToJsMessageQueue3 = this;
                    nativeToJsMessageQueue3.packMessage(nativeToJsMessageQueue3.queue.removeFirst(), (StringBuilder)object);
                }
                if (this.queue.isEmpty()) break block11;
                ((StringBuilder)object).append('*');
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return ((StringBuilder)object).toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String popAndEncodeAsJs() {
        v0 = this;
        synchronized (v0) {
            block22: {
                if (v0.queue.size() != 0) break block22;
                // ** MonitorExit[this] (shouldn't be in output)
                return null;
            }
            var1_1 = 0;
            var2_2 = 0;
            var3_3 = this.queue.iterator();
            while (true) {
                block23: {
                    if (!var3_3.hasNext()) break;
                    var4_5 = ((JsMessage)var3_3.next()).calculateEncodedLength() + 50;
                    if (var2_2 <= 0) break block23;
                    if (var1_1 + var4_5 <= NativeToJsMessageQueue.MAX_PAYLOAD_SIZE) break block23;
                    if (NativeToJsMessageQueue.MAX_PAYLOAD_SIZE > 0) break;
                }
                var1_1 += var4_5;
                ++var2_2;
            }
            var3_4 = var2_2 == this.queue.size() ? 1 : 0;
            var5_7 = var3_4 != 0 ? 0 : 100;
            var4_6 = new StringBuilder(var1_1 + var5_7);
            for (var1_1 = 0; var1_1 < var2_2; ++var1_1) {
                var5_8 = this.queue.removeFirst();
                if (var3_4 == 0 || var1_1 + 1 != var2_2) ** GOTO lbl40
                var5_8.encodeAsJsMessage(var4_6);
                continue;
lbl40:
                // 1 sources

                v1 = var4_6;
                v2 = var5_8;
                v3 = var4_6;
                v4 = v3;
                v3.append("try{");
                v2.encodeAsJsMessage(v4);
                v1.append("}finally{");
            }
            if (var3_4 == 0) {
                var4_6.append("window.setTimeout(function(){cordova.require('cordova/plugin/android/polling').pollOnce();},0);");
            }
            while (var3_4 < var2_2) {
                var4_6.append('}');
                ++var3_4;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return var4_6.toString();
        }
    }

    public void addJavaScript(String string2) {
        this.enqueueMessage(new JsMessage(string2));
    }

    public void addPluginResult(PluginResult pluginResult, String string2) {
        if (string2 == null) {
            Throwable throwable;
            Throwable throwable2 = throwable;
            throwable = new Throwable();
            LOG.e(LOG_TAG, "Got plugin result with no callbackId", throwable2);
            return;
        }
        boolean bl = pluginResult.getKeepCallback();
        if (pluginResult.getStatus() == PluginResult.Status.NO_RESULT.ordinal() && bl) {
            return;
        }
        super.enqueueMessage(new JsMessage(pluginResult, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPaused(boolean bl) {
        if (this.paused && bl) {
            Throwable throwable;
            Throwable throwable2 = throwable;
            throwable = new Throwable();
            LOG.e(LOG_TAG, "nested call to setPaused detected.", throwable2);
        }
        this.paused = bl;
        if (bl) return;
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            if (nativeToJsMessageQueue.queue.isEmpty()) return;
            if (this.activeBridgeMode == null) return;
            this.activeBridgeMode.onNativeToJsMessageAvailable(this);
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    private static class JsMessage {
        final String jsPayloadOrCallbackId;
        final PluginResult pluginResult;

        JsMessage(String string2) {
            if (string2 != null) {
                JsMessage jsMessage = this;
                jsMessage.jsPayloadOrCallbackId = string2;
                jsMessage.pluginResult = null;
                return;
            }
            throw new NullPointerException();
        }

        JsMessage(PluginResult pluginResult, String string2) {
            if (string2 != null && pluginResult != null) {
                this.jsPayloadOrCallbackId = string2;
                this.pluginResult = pluginResult;
                return;
            }
            throw new NullPointerException();
        }

        static int calculateEncodedLengthHelper(PluginResult pluginResult) {
            switch (pluginResult.getMessageType()) {
                default: {
                    return pluginResult.getMessage().length();
                }
                case 8: {
                    int n2 = 1;
                    for (int i2 = 0; i2 < pluginResult.getMultipartMessagesSize(); ++i2) {
                        int n3 = n2;
                        n2 = JsMessage.calculateEncodedLengthHelper(pluginResult.getMultipartMessage(i2));
                        n2 = n3 + (String.valueOf(n2).length() + 1 + n2);
                    }
                    return n2;
                }
                case 7: {
                    return pluginResult.getMessage().length() + 1;
                }
                case 6: {
                    return pluginResult.getMessage().length() + 1;
                }
                case 4: 
                case 5: {
                    return 1;
                }
                case 3: {
                    return pluginResult.getMessage().length() + 1;
                }
                case 1: 
            }
            return pluginResult.getStrMessage().length() + 1;
        }

        static void encodeAsMessageHelper(StringBuilder stringBuilder, PluginResult pluginResult) {
            switch (pluginResult.getMessageType()) {
                default: {
                    stringBuilder.append(pluginResult.getMessage());
                    break;
                }
                case 8: {
                    stringBuilder.append('M');
                    for (int i2 = 0; i2 < pluginResult.getMultipartMessagesSize(); ++i2) {
                        PluginResult pluginResult2 = pluginResult.getMultipartMessage(i2);
                        StringBuilder stringBuilder2 = stringBuilder;
                        stringBuilder2.append(String.valueOf(JsMessage.calculateEncodedLengthHelper(pluginResult2)));
                        stringBuilder2.append(' ');
                        JsMessage.encodeAsMessageHelper(stringBuilder, pluginResult2);
                    }
                    break;
                }
                case 7: {
                    stringBuilder.append('S');
                    stringBuilder.append(pluginResult.getMessage());
                    break;
                }
                case 6: {
                    stringBuilder.append('A');
                    stringBuilder.append(pluginResult.getMessage());
                    break;
                }
                case 5: {
                    stringBuilder.append('N');
                    break;
                }
                case 4: {
                    stringBuilder.append(pluginResult.getMessage().charAt(0));
                    break;
                }
                case 3: {
                    stringBuilder.append('n').append(pluginResult.getMessage());
                    break;
                }
                case 1: {
                    stringBuilder.append('s');
                    stringBuilder.append(pluginResult.getStrMessage());
                }
            }
        }

        int calculateEncodedLength() {
            PluginResult pluginResult = this.pluginResult;
            if (pluginResult == null) {
                return this.jsPayloadOrCallbackId.length() + 1;
            }
            return String.valueOf(pluginResult.getStatus()).length() + 2 + 1 + this.jsPayloadOrCallbackId.length() + 1 + JsMessage.calculateEncodedLengthHelper(this.pluginResult);
        }

        void encodeAsMessage(StringBuilder stringBuilder) {
            PluginResult pluginResult = this.pluginResult;
            if (pluginResult == null) {
                stringBuilder.append('J').append(this.jsPayloadOrCallbackId);
                return;
            }
            int n2 = pluginResult.getStatus();
            boolean bl = n2 == PluginResult.Status.NO_RESULT.ordinal();
            char c2 = n2 == PluginResult.Status.OK.ordinal() ? (char)'\u0001' : '\u0000';
            boolean bl2 = bl;
            bl = this.pluginResult.getKeepCallback();
            c2 = !bl2 && c2 == '\u0000' ? (char)'F' : 'S';
            StringBuilder stringBuilder2 = stringBuilder.append(c2);
            c2 = bl ? (char)'1' : '0';
            stringBuilder2.append(c2).append(n2).append(' ').append(this.jsPayloadOrCallbackId).append(' ');
            JsMessage.encodeAsMessageHelper(stringBuilder, this.pluginResult);
        }

        void buildJsMessage(StringBuilder stringBuilder) {
            switch (this.pluginResult.getMessageType()) {
                default: {
                    stringBuilder.append(this.pluginResult.getMessage());
                    break;
                }
                case 8: {
                    int n2 = this.pluginResult.getMultipartMessagesSize();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PluginResult pluginResult = this.pluginResult.getMultipartMessage(i2);
                        new JsMessage(pluginResult, this.jsPayloadOrCallbackId).buildJsMessage(stringBuilder);
                        if (i2 >= n2 - 1) continue;
                        stringBuilder.append(",");
                    }
                    break;
                }
                case 7: {
                    stringBuilder.append("atob('").append(this.pluginResult.getMessage()).append("')");
                    break;
                }
                case 6: {
                    stringBuilder.append("cordova.require('cordova/base64').toArrayBuffer('").append(this.pluginResult.getMessage()).append("')");
                    break;
                }
                case 5: {
                    stringBuilder.append("null");
                }
            }
        }

        void encodeAsJsMessage(StringBuilder stringBuilder) {
            PluginResult pluginResult = this.pluginResult;
            if (pluginResult == null) {
                stringBuilder.append(this.jsPayloadOrCallbackId);
            } else {
                int n2 = pluginResult.getStatus();
                boolean bl = n2 == PluginResult.Status.OK.ordinal() || n2 == PluginResult.Status.NO_RESULT.ordinal();
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.append("cordova.callbackFromNative('").append(this.jsPayloadOrCallbackId).append("',").append(bl).append(",").append(n2).append(",[");
                this.buildJsMessage(stringBuilder2);
                stringBuilder.append("],").append(this.pluginResult.getKeepCallback()).append(");");
            }
        }
    }

    public static class EvalBridgeMode
    extends BridgeMode {
        private final CordovaWebViewEngine engine;
        private final CordovaInterface cordova;

        public EvalBridgeMode(CordovaWebViewEngine cordovaWebViewEngine, CordovaInterface cordovaInterface) {
            this.engine = cordovaWebViewEngine;
            this.cordova = cordovaInterface;
        }

        @Override
        public void onNativeToJsMessageAvailable(final NativeToJsMessageQueue nativeToJsMessageQueue) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String string2 = nativeToJsMessageQueue.popAndEncodeAsJs();
                    if (string2 != null) {
                        engine.evaluateJavascript(string2, null);
                    }
                }
            });
        }
    }

    public static class OnlineEventsBridgeMode
    extends BridgeMode {
        private final OnlineEventsBridgeModeDelegate delegate;
        private boolean online;
        private boolean ignoreNextFlush;

        public OnlineEventsBridgeMode(OnlineEventsBridgeModeDelegate onlineEventsBridgeModeDelegate) {
            this.delegate = onlineEventsBridgeModeDelegate;
        }

        static /* synthetic */ boolean access$102(OnlineEventsBridgeMode onlineEventsBridgeMode, boolean bl) {
            onlineEventsBridgeMode.online = bl;
            return bl;
        }

        static /* synthetic */ boolean access$202(OnlineEventsBridgeMode onlineEventsBridgeMode, boolean bl) {
            onlineEventsBridgeMode.ignoreNextFlush = bl;
            return bl;
        }

        @Override
        public void reset() {
            this.delegate.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    1 v0 = this;
                    OnlineEventsBridgeMode.access$102(v0.this, false);
                    OnlineEventsBridgeMode.access$202(v0.this, true);
                    delegate.setNetworkAvailable(true);
                }
            });
        }

        @Override
        public void onNativeToJsMessageAvailable(final NativeToJsMessageQueue nativeToJsMessageQueue) {
            this.delegate.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!nativeToJsMessageQueue.isEmpty()) {
                        2 v0 = this;
                        OnlineEventsBridgeMode.access$202(v0.this, false);
                        delegate.setNetworkAvailable(online);
                    }
                }
            });
        }

        @Override
        public void notifyOfFlush(NativeToJsMessageQueue nativeToJsMessageQueue, boolean bl) {
            if (bl && !this.ignoreNextFlush) {
                this.online ^= true;
            }
        }

        public static interface OnlineEventsBridgeModeDelegate {
            public void setNetworkAvailable(boolean var1);

            public void runOnUiThread(Runnable var1);
        }
    }

    public static class LoadUrlBridgeMode
    extends BridgeMode {
        private final CordovaWebViewEngine engine;
        private final CordovaInterface cordova;

        public LoadUrlBridgeMode(CordovaWebViewEngine cordovaWebViewEngine, CordovaInterface cordovaInterface) {
            this.engine = cordovaWebViewEngine;
            this.cordova = cordovaInterface;
        }

        @Override
        public void onNativeToJsMessageAvailable(final NativeToJsMessageQueue nativeToJsMessageQueue) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String string2 = nativeToJsMessageQueue.popAndEncodeAsJs();
                    if (string2 != null) {
                        engine.loadUrl("javascript:" + string2, false);
                    }
                }
            });
        }
    }

    public static class NoOpBridgeMode
    extends BridgeMode {
        @Override
        public void onNativeToJsMessageAvailable(NativeToJsMessageQueue nativeToJsMessageQueue) {
        }
    }

    public static abstract class BridgeMode {
        public abstract void onNativeToJsMessageAvailable(NativeToJsMessageQueue var1);

        public void notifyOfFlush(NativeToJsMessageQueue nativeToJsMessageQueue, boolean bl) {
        }

        public void reset() {
        }
    }
}

