/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.core.model;

import com.sails.engine.core.model.CoordinatesUtil;
import com.sails.engine.core.model.GeoPoint;
import java.io.Serializable;

public class BoundingBox
implements Serializable {
    private static final long a = 1L;
    public final double maxLatitude;
    public final double maxLongitude;
    public final double minLatitude;
    public final double minLongitude;

    public static BoundingBox fromString(String object) {
        object = CoordinatesUtil.a((String)object, 4);
        return new BoundingBox((double)object[0], (double)object[1], (double)object[2], (double)object[3]);
    }

    public BoundingBox(double d2, double d3, double d4, double d5) {
        CoordinatesUtil.b(d2);
        CoordinatesUtil.c(d3);
        CoordinatesUtil.b(d4);
        CoordinatesUtil.c(d5);
        if (!(d2 > d4)) {
            if (!(d3 > d5)) {
                this.minLatitude = d2;
                this.minLongitude = d3;
                this.maxLatitude = d4;
                this.maxLongitude = d5;
                return;
            }
            throw new IllegalArgumentException("invalid longitude range: " + d3 + ' ' + d5);
        }
        throw new IllegalArgumentException("invalid latitude range: " + d2 + ' ' + d4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(GeoPoint geoPoint) {
        double d2;
        double d3;
        double d4 = geoPoint.latitude;
        if (!(this.minLatitude <= d3)) return false;
        if (!(this.maxLatitude >= d4)) return false;
        d4 = geoPoint.longitude;
        if (!(this.minLongitude <= d2)) return false;
        if (!(this.maxLongitude >= d4)) return false;
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BoundingBox)) {
            return false;
        }
        object = (BoundingBox)object;
        if (Double.doubleToLongBits(this.maxLatitude) != Double.doubleToLongBits(((BoundingBox)object).maxLatitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxLongitude) != Double.doubleToLongBits(((BoundingBox)object).maxLongitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minLatitude) != Double.doubleToLongBits(((BoundingBox)object).minLatitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.minLongitude) == Double.doubleToLongBits(((BoundingBox)object).minLongitude);
    }

    public GeoPoint getCenterPoint() {
        BoundingBox boundingBox = this;
        double d2 = this.minLatitude;
        double d3 = (boundingBox.maxLatitude - d2) / 2.0;
        double d4 = this.minLongitude;
        double d5 = (boundingBox.maxLongitude - d4) / 2.0;
        return new GeoPoint(d2 + d3, d4 + d5);
    }

    public double getLatitudeSpan() {
        return this.maxLatitude - this.minLatitude;
    }

    public double getLongitudeSpan() {
        return this.maxLongitude - this.minLongitude;
    }

    public int hashCode() {
        long l2;
        long l3 = Double.doubleToLongBits(this.maxLatitude);
        long l4 = l2 = Double.doubleToLongBits(this.maxLongitude);
        long l5 = l2 = Double.doubleToLongBits(this.minLatitude);
        long l6 = l2 = Double.doubleToLongBits(this.minLongitude);
        return (((31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32)) * 31 + (int)(l5 ^ l5 >>> 32)) * 31 + (int)(l6 ^ l6 >>> 32);
    }

    public boolean intersects(BoundingBox boundingBox) {
        if (this == boundingBox) {
            return true;
        }
        return this.maxLatitude >= boundingBox.minLatitude && this.maxLongitude >= boundingBox.minLongitude && this.minLatitude <= boundingBox.maxLatitude && this.minLongitude <= boundingBox.maxLongitude;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        StringBuilder stringBuilder4 = stringBuilder2;
        StringBuilder stringBuilder5 = stringBuilder2;
        StringBuilder stringBuilder6 = stringBuilder2;
        stringBuilder6();
        stringBuilder6.append("minLatitude=");
        stringBuilder5.append(this.minLatitude);
        stringBuilder5.append(", minLongitude=");
        stringBuilder4.append(this.minLongitude);
        stringBuilder4.append(", maxLatitude=");
        stringBuilder3.append(this.maxLatitude);
        stringBuilder3.append(", maxLongitude=");
        stringBuilder.append(this.maxLongitude);
        return stringBuilder.toString();
    }
}

