/*
 * Decompiled with CFR 0.152.
 */
package com.android.plugins;

import android.os.Build;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Permissions
extends CordovaPlugin {
    private static final String ACTION_CHECK_PERMISSION = "checkPermission";
    private static final String ACTION_REQUEST_PERMISSION = "requestPermission";
    private static final String ACTION_REQUEST_PERMISSIONS = "requestPermissions";
    private static final int REQUEST_CODE_ENABLE_PERMISSION = 55433;
    private static final String KEY_ERROR = "error";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_RESULT_PERMISSION = "hasPermission";
    private CallbackContext permissionsCallback;

    private void checkPermissionAction(CallbackContext callbackContext, JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() != 0 && jSONArray.length() <= 1) {
            if (Build.VERSION.SDK_INT < 23) {
                JSONObject jSONObject = new JSONObject();
                this.addProperty(jSONObject, KEY_RESULT_PERMISSION, true);
                callbackContext.success(jSONObject);
            } else {
                JSONObject jSONObject;
                CallbackContext callbackContext2 = callbackContext;
                Permissions permissions = this;
                JSONObject jSONObject2 = jSONObject;
                jSONObject = new JSONObject();
                try {
                    permissions.addProperty(jSONObject2, KEY_RESULT_PERMISSION, this.cordova.hasPermission(jSONArray.getString(0)));
                    callbackContext2.success(jSONObject);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        } else {
            JSONObject jSONObject;
            CallbackContext callbackContext3 = callbackContext;
            CallbackContext callbackContext4 = callbackContext = jSONObject;
            callbackContext4();
            this.addProperty((JSONObject)callbackContext4, KEY_ERROR, ACTION_CHECK_PERMISSION);
            this.addProperty((JSONObject)callbackContext, KEY_MESSAGE, "One time one permission only.");
            callbackContext3.error(jSONObject);
        }
    }

    private void requestPermissionAction(CallbackContext stringArray, JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() != 0) {
            if (Build.VERSION.SDK_INT < 23) {
                JSONObject jSONObject = new JSONObject();
                this.addProperty(jSONObject, KEY_RESULT_PERMISSION, true);
                stringArray.success(jSONObject);
            } else if (this.hasAllPermissions(jSONArray)) {
                JSONObject jSONObject = new JSONObject();
                this.addProperty(jSONObject, KEY_RESULT_PERMISSION, true);
                stringArray.success(jSONObject);
            } else {
                Permissions permissions = this;
                this.permissionsCallback = stringArray;
                stringArray = permissions.getPermissions(jSONArray);
                permissions.cordova.requestPermissions(this, 55433, stringArray);
            }
        } else {
            JSONObject jSONObject;
            String[] stringArray2 = stringArray;
            stringArray = jSONObject;
            stringArray();
            this.addProperty((JSONObject)stringArray, KEY_ERROR, ACTION_REQUEST_PERMISSION);
            this.addProperty((JSONObject)stringArray, KEY_MESSAGE, "At least one permission.");
            stringArray2.error(jSONObject);
        }
    }

    private String[] getPermissions(JSONArray jSONArray) {
        String[] stringArray = new String[jSONArray.length()];
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                stringArray[i2] = jSONArray.getString(i2);
                continue;
            }
            catch (JSONException jSONException) {}
        }
        return stringArray;
    }

    private boolean hasAllPermissions(JSONArray jSONArray) {
        Permissions permissions = this;
        return permissions.hasAllPermissions(permissions.getPermissions(jSONArray));
    }

    private boolean hasAllPermissions(String[] stringArray) {
        for (String string : stringArray) {
            if (this.cordova.hasPermission(string)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addProperty(JSONObject jSONObject, String string, Object object) {
        JSONObject jSONObject2;
        if (object == null) {
            jSONObject2 = jSONObject.put(string, JSONObject.NULL);
            return;
        } else {
            try {
                jSONObject2 = jSONObject.put(string, object);
                return;
            }
            catch (JSONException jSONException) {}
        }
    }

    static /* synthetic */ CallbackContext access$302(Permissions permissions, CallbackContext callbackContext) {
        permissions.permissionsCallback = callbackContext;
        return callbackContext;
    }

    @Override
    public boolean execute(String string, final JSONArray jSONArray, final CallbackContext callbackContext) {
        if (ACTION_CHECK_PERMISSION.equals(string)) {
            this.cordova.getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    Permissions.this.checkPermissionAction(callbackContext, jSONArray);
                }
            });
            return true;
        }
        if (!ACTION_REQUEST_PERMISSION.equals(string) && !ACTION_REQUEST_PERMISSIONS.equals(string)) {
            return false;
        }
        this.cordova.getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    this_.Permissions.this.requestPermissionAction(this_.callbackContext, this_.jSONArray);
                }
                catch (Exception exception) {
                    JSONObject jSONObject;
                    exception.printStackTrace();
                    2 v1 = this_;
                    2 this_ = jSONObject;
                    jSONObject = new JSONObject();
                    v1.Permissions.this.addProperty((JSONObject)this_, Permissions.KEY_ERROR, Permissions.ACTION_REQUEST_PERMISSION);
                    v1.Permissions.this.addProperty((JSONObject)this_, Permissions.KEY_MESSAGE, "Request permission has been denied.");
                    v1.callbackContext.error((JSONObject)this_);
                    Permissions.access$302(v1.Permissions.this, null);
                }
            }
        });
        return true;
    }

    @Override
    public void onRequestPermissionResult(int n2, String[] stringArray, int[] nArray) {
        JSONObject jSONObject;
        if (this.permissionsCallback == null) {
            return;
        }
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        if (stringArray != null && stringArray.length > 0) {
            Permissions permissions = this;
            permissions.addProperty(jSONObject2, KEY_RESULT_PERMISSION, this.hasAllPermissions(stringArray));
            permissions.permissionsCallback.success(jSONObject2);
        } else {
            Permissions permissions = this;
            this.addProperty(jSONObject2, KEY_ERROR, ACTION_REQUEST_PERMISSION);
            permissions.addProperty(jSONObject2, KEY_MESSAGE, "Unknown error.");
            permissions.permissionsCallback.error(jSONObject2);
        }
        this.permissionsCallback = null;
    }
}

