/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.view.View;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import org.apache.cordova.CordovaBridge;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.ICordovaCookieManager;
import org.apache.cordova.LOG;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginManager;
import org.apache.cordova.engine.SystemCookieManager;
import org.apache.cordova.engine.SystemExposedJsApi;
import org.apache.cordova.engine.SystemWebView;

public class SystemWebViewEngine
implements CordovaWebViewEngine {
    public static final String TAG = "SystemWebViewEngine";
    protected final SystemWebView webView;
    protected final SystemCookieManager cookieManager;
    protected CordovaPreferences preferences;
    protected CordovaBridge bridge;
    protected CordovaWebViewEngine.Client client;
    protected CordovaWebView parentWebView;
    protected CordovaInterface cordova;
    protected PluginManager pluginManager;
    protected CordovaResourceApi resourceApi;
    protected NativeToJsMessageQueue nativeToJsMessageQueue;
    private BroadcastReceiver receiver;

    public SystemWebViewEngine(Context context, CordovaPreferences cordovaPreferences) {
        this(new SystemWebView(context), cordovaPreferences);
    }

    public SystemWebViewEngine(SystemWebView systemWebView) {
        this(systemWebView, null);
    }

    public SystemWebViewEngine(SystemWebView systemWebView, CordovaPreferences cordovaPreferences) {
        SystemWebViewEngine systemWebViewEngine = this;
        this.preferences = cordovaPreferences;
        systemWebViewEngine.webView = systemWebView;
        systemWebViewEngine.cookieManager = new SystemCookieManager(systemWebView);
    }

    @SuppressLint(value={"NewApi", "SetJavaScriptEnabled"})
    private void initWebViewSettings() {
        IntentFilter intentFilter;
        WebSettings webSettings;
        SystemWebViewEngine systemWebViewEngine = this;
        systemWebViewEngine.webView.setInitialScale(0);
        systemWebViewEngine.webView.setVerticalScrollBarEnabled(false);
        WebSettings webSettings2 = webSettings = systemWebViewEngine.webView.getSettings();
        webSettings2.setJavaScriptEnabled(true);
        webSettings2.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings2.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        LOG.d(TAG, "CordovaWebView is running on device made by: " + Build.MANUFACTURER);
        webSettings2.setSaveFormData(false);
        webSettings2.setSavePassword(false);
        webSettings2.setAllowUniversalAccessFromFileURLs(true);
        webSettings2.setMediaPlaybackRequiresUserGesture(false);
        String string2 = this.webView.getContext().getApplicationContext().getDir("database", 0).getPath();
        webSettings.setDatabaseEnabled(true);
        webSettings.setDatabasePath(string2);
        if ((systemWebViewEngine.webView.getContext().getApplicationContext().getApplicationInfo().flags & 2) != 0) {
            this.enableRemoteDebugging();
        }
        WebSettings webSettings3 = webSettings;
        WebSettings webSettings4 = webSettings;
        webSettings4.setGeolocationDatabasePath(string2);
        webSettings4.setDomStorageEnabled(true);
        webSettings4.setGeolocationEnabled(true);
        webSettings4.setAppCacheMaxSize(0x500000L);
        webSettings3.setAppCachePath(string2);
        webSettings3.setAppCacheEnabled(true);
        string2 = webSettings3.getUserAgentString();
        String string3 = this.preferences.getString("OverrideUserAgent", null);
        if (string3 != null) {
            webSettings.setUserAgentString(string3);
        } else {
            string3 = this.preferences.getString("AppendUserAgent", null);
            if (string3 != null) {
                webSettings.setUserAgentString(string2 + " " + string3);
            }
        }
        string2 = intentFilter;
        new IntentFilter().addAction("android.intent.action.CONFIGURATION_CHANGED");
        if (this.receiver == null) {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    webSettings.getUserAgentString();
                }
            };
            this.webView.getContext().registerReceiver(this.receiver, (IntentFilter)string2);
        }
    }

    private void enableRemoteDebugging() {
        try {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.d(TAG, "You have one job! To turn on Remote Web Debugging! YOU HAVE FAILED! ");
            illegalArgumentException.printStackTrace();
        }
    }

    @SuppressLint(value={"AddJavascriptInterface"})
    private static void exposeJsInterface(WebView webView, CordovaBridge cordovaBridge) {
        webView.addJavascriptInterface((Object)new SystemExposedJsApi(cordovaBridge), "_cordovaNative");
    }

    @Override
    public void init(CordovaWebView cordovaWebView, CordovaInterface cordovaInterface, CordovaWebViewEngine.Client client, CordovaResourceApi cordovaResourceApi, PluginManager pluginManager, NativeToJsMessageQueue nativeToJsMessageQueue) {
        if (this.cordova == null) {
            if (this.preferences == null) {
                this.preferences = cordovaWebView.getPreferences();
            }
            NativeToJsMessageQueue nativeToJsMessageQueue2 = nativeToJsMessageQueue;
            SystemWebViewEngine systemWebViewEngine = this;
            this.parentWebView = cordovaWebView;
            this.cordova = cordovaInterface;
            this.client = client;
            this.resourceApi = cordovaResourceApi;
            this.pluginManager = pluginManager;
            systemWebViewEngine.nativeToJsMessageQueue = nativeToJsMessageQueue;
            systemWebViewEngine.webView.init(this, cordovaInterface);
            systemWebViewEngine.initWebViewSettings();
            nativeToJsMessageQueue2.addBridgeMode(new NativeToJsMessageQueue.OnlineEventsBridgeMode(new NativeToJsMessageQueue.OnlineEventsBridgeMode.OnlineEventsBridgeModeDelegate(){

                @Override
                public void setNetworkAvailable(boolean bl) {
                    SystemWebView systemWebView = systemWebView.SystemWebViewEngine.this.webView;
                    if (systemWebView != null) {
                        systemWebView.setNetworkAvailable(bl);
                    }
                }

                @Override
                public void runOnUiThread(Runnable runnable) {
                    SystemWebViewEngine.this.cordova.getActivity().runOnUiThread(runnable);
                }
            }));
            nativeToJsMessageQueue2.addBridgeMode(new NativeToJsMessageQueue.EvalBridgeMode(this, cordovaInterface));
            this.bridge = new CordovaBridge(pluginManager, nativeToJsMessageQueue);
            SystemWebViewEngine.exposeJsInterface(this.webView, this.bridge);
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public CordovaWebView getCordovaWebView() {
        return this.parentWebView;
    }

    @Override
    public ICordovaCookieManager getCookieManager() {
        return this.cookieManager;
    }

    @Override
    public View getView() {
        return this.webView;
    }

    @Override
    public void loadUrl(String string2, boolean bl) {
        this.webView.loadUrl(string2);
    }

    @Override
    public String getUrl() {
        return this.webView.getUrl();
    }

    @Override
    public void stopLoading() {
        this.webView.stopLoading();
    }

    @Override
    public void clearCache() {
        this.webView.clearCache(true);
    }

    @Override
    public void clearHistory() {
        this.webView.clearHistory();
    }

    @Override
    public boolean canGoBack() {
        return this.webView.canGoBack();
    }

    @Override
    public boolean goBack() {
        if (this.webView.canGoBack()) {
            this.webView.goBack();
            return true;
        }
        return false;
    }

    @Override
    public void setPaused(boolean bl) {
        if (bl) {
            SystemWebViewEngine systemWebViewEngine = this;
            systemWebViewEngine.webView.onPause();
            systemWebViewEngine.webView.pauseTimers();
        } else {
            SystemWebViewEngine systemWebViewEngine = this;
            systemWebViewEngine.webView.onResume();
            systemWebViewEngine.webView.resumeTimers();
        }
    }

    @Override
    public void destroy() {
        SystemWebViewEngine systemWebViewEngine = this;
        systemWebViewEngine.webView.chromeClient.destroyLastDialog();
        systemWebViewEngine.webView.destroy();
        if (systemWebViewEngine.receiver != null) {
            try {
                this.webView.getContext().unregisterReceiver(this.receiver);
            }
            catch (Exception exception) {
                LOG.e(TAG, "Error unregistering configuration receiver: " + exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        this.webView.evaluateJavascript(string2, valueCallback);
    }
}

