/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.CoreAndroid;
import org.apache.cordova.ICordovaCookieManager;
import org.apache.cordova.LOG;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.engine.SystemWebViewEngine;
import org.json.JSONException;
import org.json.JSONObject;

public class CordovaWebViewImpl
implements CordovaWebView {
    public static final String TAG = "CordovaWebViewImpl";
    static final /* synthetic */ boolean $assertionsDisabled;
    private PluginManager pluginManager;
    protected final CordovaWebViewEngine engine;
    private CordovaInterface cordova;
    private int loadUrlTimeout = 0;
    private CordovaResourceApi resourceApi;
    private CordovaPreferences preferences;
    private CoreAndroid appPlugin;
    private NativeToJsMessageQueue nativeToJsMessageQueue;
    private EngineClient engineClient = new EngineClient();
    private boolean hasPausedEver;
    String loadedUrl;
    private View mCustomView;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private Set<Integer> boundKeyCodes = new HashSet<Integer>();

    public static CordovaWebViewEngine createEngine(Context context, CordovaPreferences cordovaPreferences) {
        Class[] classArray;
        Class<?> clazz;
        try {
            clazz = Class.forName(cordovaPreferences.getString("webview", SystemWebViewEngine.class.getCanonicalName()));
            classArray = new Class[2];
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create webview. ", exception);
        }
        classArray[0] = Context.class;
        classArray[1] = CordovaPreferences.class;
        return (CordovaWebViewEngine)clazz.getConstructor(classArray).newInstance(context, cordovaPreferences);
    }

    public CordovaWebViewImpl(CordovaWebViewEngine cordovaWebViewEngine) {
        this.engine = cordovaWebViewEngine;
    }

    private void sendJavascriptEvent(String string2) {
        if (((CordovaWebViewImpl)this).appPlugin == null) {
            ((CordovaWebViewImpl)this).appPlugin = (CoreAndroid)((CordovaWebViewImpl)this).pluginManager.getPlugin("CoreAndroid");
        }
        if ((this = ((CordovaWebViewImpl)this).appPlugin) == null) {
            LOG.w(TAG, "Unable to fire event without existing plugin");
            return;
        }
        ((CoreAndroid)this).fireJavascriptEvent(string2);
    }

    static {
        $assertionsDisabled = CordovaWebViewImpl.class.desiredAssertionStatus() ^ true;
    }

    public void init(CordovaInterface cordovaInterface) {
        this.init(cordovaInterface, new ArrayList<PluginEntry>(), new CordovaPreferences());
    }

    @Override
    @SuppressLint(value={"Assert"})
    public void init(CordovaInterface cordovaInterface, List<PluginEntry> list, CordovaPreferences cordovaPreferences) {
        if (this.cordova == null) {
            CordovaWebViewImpl cordovaWebViewImpl = this;
            this.cordova = cordovaInterface;
            cordovaWebViewImpl.preferences = cordovaPreferences;
            CordovaWebViewImpl cordovaWebViewImpl2 = this;
            cordovaWebViewImpl.pluginManager = new PluginManager(cordovaWebViewImpl2, cordovaWebViewImpl2.cordova, list);
            cordovaWebViewImpl.resourceApi = new CordovaResourceApi(this.engine.getView().getContext(), this.pluginManager);
            cordovaWebViewImpl.nativeToJsMessageQueue = new NativeToJsMessageQueue();
            cordovaWebViewImpl.nativeToJsMessageQueue.addBridgeMode(new NativeToJsMessageQueue.NoOpBridgeMode());
            cordovaWebViewImpl.nativeToJsMessageQueue.addBridgeMode(new NativeToJsMessageQueue.LoadUrlBridgeMode(this.engine, cordovaInterface));
            if (cordovaPreferences.getBoolean("DisallowOverscroll", false)) {
                this.engine.getView().setOverScrollMode(2);
            }
            this.engine.init(this, cordovaInterface, this.engineClient, this.resourceApi, this.pluginManager, this.nativeToJsMessageQueue);
            if (!$assertionsDisabled && !(this.engine.getView() instanceof CordovaWebViewEngine.EngineView)) {
                throw new AssertionError();
            }
            CordovaWebViewImpl cordovaWebViewImpl3 = this;
            cordovaWebViewImpl3.pluginManager.addService("CoreAndroid", "org.apache.cordova.CoreAndroid");
            cordovaWebViewImpl3.pluginManager.init();
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isInitialized() {
        return this.cordova != null;
    }

    @Override
    public void loadUrlIntoView(final String string2, final boolean bl) {
        LOG.d(TAG, ">>> loadUrl(" + string2 + ")");
        if (!string2.equals("about:blank") && !string2.startsWith("javascript:")) {
            Runnable runnable;
            Runnable runnable2;
            bl = bl || this.loadedUrl == null;
            if (bl) {
                if (this.loadedUrl != null) {
                    this.appPlugin = null;
                    this.pluginManager.init();
                }
                this.loadedUrl = string2;
            }
            CordovaWebViewImpl cordovaWebViewImpl = this;
            final int n2 = cordovaWebViewImpl.loadUrlTimeout;
            final int n3 = cordovaWebViewImpl.preferences.getInteger("LoadUrlTimeoutValue", 20000);
            final Runnable runnable3 = runnable2;
            runnable2 = new Runnable(){

                @Override
                public void run() {
                    JSONObject jSONObject;
                    CordovaWebViewImpl.this.stopLoading();
                    LOG.e(CordovaWebViewImpl.TAG, "CordovaWebView: TIMEOUT ERROR!");
                    JSONObject jSONObject2 = jSONObject;
                    try {
                        new JSONObject().put("errorCode", -6);
                    }
                    catch (JSONException jSONException) {}
                    jSONObject2.put("description", (Object)"The connection to the server was unsuccessful.");
                    jSONObject2.put("url", (Object)string2);
                    CordovaWebViewImpl.this.pluginManager.postMessage("onReceivedError", jSONObject2);
                }
            };
            final Runnable runnable4 = runnable;
            runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    2 v0 = this;
                    2 v1 = v0;
                    2 v2 = v0;
                    2 v3 = v0;
                    // MONITORENTER : v0
                    try {
                        v2.wait(v1.n3);
                        // MONITOREXIT : v3
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : this
                        try {
                            throw throwable;
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    if (CordovaWebViewImpl.this.loadUrlTimeout != n2) return;
                    CordovaWebViewImpl.this.cordova.getActivity().runOnUiThread(runnable3);
                }
            };
            cordovaWebViewImpl.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (n3 > 0) {
                        CordovaWebViewImpl.this.cordova.getThreadPool().execute(runnable4);
                    }
                    CordovaWebViewImpl.this.engine.loadUrl(string2, bl);
                }
            });
            return;
        }
        this.engine.loadUrl(string2, false);
    }

    @Override
    public void loadUrl(String string2) {
        this.loadUrlIntoView(string2, true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void showWebPage(String var1_2, boolean var2_3, boolean var3_5, Map<String, Object> var4_7) {
        block12: {
            v0 = new Object[3];
            var4_7 = v0;
            var4_7[0] = var1_2;
            var4_7[1] = var2_3;
            v0[2] = var3_5;
            LOG.d("CordovaWebViewImpl", "showWebPage(%s, %b, %b, HashMap)", var4_7);
            if (var3_5) {
                this.engine.clearHistory();
            }
            if (!var2_3) {
                if (this.pluginManager.shouldAllowNavigation(var1_2)) {
                    this.loadUrlIntoView(var1_2, true);
                    return;
                }
                LOG.w("CordovaWebViewImpl", "showWebPage: Refusing to load URL into webview since it is not in the <allow-navigation> whitelist. URL=" + var1_2);
                return;
            }
            if (!this.pluginManager.shouldOpenExternalUrl(var1_2).booleanValue()) {
                LOG.w("CordovaWebViewImpl", "showWebPage: Refusing to send intent for URL since it is not in the <allow-intent> whitelist. URL=" + var1_2);
                return;
            }
            v1 = var1_2;
            var2_4 = v2;
            new Intent("android.intent.action.VIEW").addCategory("android.intent.category.BROWSABLE");
            var3_6 = Uri.parse((String)v1);
            if (!"file".equals(var3_6.getScheme())) break block12;
            v3 = var2_4.setDataAndType(var3_6, this.resourceApi.getMimeType(var3_6));
lbl30:
            // 2 sources

            while (true) {
                ** GOTO lbl36
                break;
            }
        }
        try {
            v3 = var2_4.setData(var3_6);
            ** continue;
lbl36:
            // 1 sources

            this.cordova.getActivity().startActivity(var2_4);
        }
        catch (ActivityNotFoundException var0_1) {
            LOG.e("CordovaWebViewImpl", "Error loading url " + var1_2, var0_1);
        }
    }

    @Override
    @Deprecated
    public void showCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        LOG.d(TAG, "showing Custom View");
        if (this.mCustomView != null) {
            customViewCallback.onCustomViewHidden();
            return;
        }
        this.mCustomView = view;
        this.mCustomViewCallback = customViewCallback;
        ViewGroup viewGroup = (ViewGroup)this.engine.getView().getParent();
        viewGroup.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        this.engine.getView().setVisibility(8);
        viewGroup.setVisibility(0);
        viewGroup.bringToFront();
    }

    @Override
    @Deprecated
    public void hideCustomView() {
        if (this.mCustomView == null) {
            return;
        }
        CordovaWebViewImpl cordovaWebViewImpl = this;
        LOG.d(TAG, "Hiding Custom View");
        cordovaWebViewImpl.mCustomView.setVisibility(8);
        ((ViewGroup)cordovaWebViewImpl.engine.getView().getParent()).removeView(this.mCustomView);
        cordovaWebViewImpl.mCustomView = null;
        cordovaWebViewImpl.mCustomViewCallback.onCustomViewHidden();
        cordovaWebViewImpl.engine.getView().setVisibility(0);
    }

    @Override
    @Deprecated
    public boolean isCustomViewShowing() {
        return this.mCustomView != null;
    }

    @Override
    @Deprecated
    public void sendJavascript(String string2) {
        this.nativeToJsMessageQueue.addJavaScript(string2);
    }

    @Override
    public void sendPluginResult(PluginResult pluginResult, String string2) {
        this.nativeToJsMessageQueue.addPluginResult(pluginResult, string2);
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public CordovaPreferences getPreferences() {
        return this.preferences;
    }

    @Override
    public ICordovaCookieManager getCookieManager() {
        return this.engine.getCookieManager();
    }

    @Override
    public CordovaResourceApi getResourceApi() {
        return this.resourceApi;
    }

    @Override
    public CordovaWebViewEngine getEngine() {
        return this.engine;
    }

    @Override
    public View getView() {
        return this.engine.getView();
    }

    @Override
    public Context getContext() {
        return this.engine.getView().getContext();
    }

    @Override
    public void setButtonPlumbedToJs(int n2, boolean bl) {
        if (n2 != 4 && n2 != 82 && n2 != 24 && n2 != 25) {
            throw new IllegalArgumentException("Unsupported keycode: " + n2);
        }
        if (bl) {
            this.boundKeyCodes.add(n2);
        } else {
            this.boundKeyCodes.remove(n2);
        }
    }

    @Override
    public boolean isButtonPlumbedToJs(int n2) {
        return this.boundKeyCodes.contains(n2);
    }

    @Override
    public Object postMessage(String string2, Object object) {
        return this.pluginManager.postMessage(string2, object);
    }

    @Override
    public String getUrl() {
        return this.engine.getUrl();
    }

    @Override
    public void stopLoading() {
        ++this.loadUrlTimeout;
    }

    @Override
    public boolean canGoBack() {
        return this.engine.canGoBack();
    }

    @Override
    public void clearCache() {
        this.engine.clearCache();
    }

    @Override
    @Deprecated
    public void clearCache(boolean bl) {
        this.engine.clearCache();
    }

    @Override
    public void clearHistory() {
        this.engine.clearHistory();
    }

    @Override
    public boolean backHistory() {
        return this.engine.goBack();
    }

    @Override
    public void onNewIntent(Intent intent) {
        PluginManager pluginManager = ((CordovaWebViewImpl)((Object)pluginManager)).pluginManager;
        if (pluginManager != null) {
            pluginManager.onNewIntent(intent);
        }
    }

    @Override
    public void handlePause(boolean bl) {
        if (!this.isInitialized()) {
            return;
        }
        CordovaWebViewImpl cordovaWebViewImpl = this;
        cordovaWebViewImpl.hasPausedEver = true;
        cordovaWebViewImpl.pluginManager.onPause(bl);
        cordovaWebViewImpl.sendJavascriptEvent("pause");
        if (!bl) {
            this.engine.setPaused(true);
        }
    }

    @Override
    public void handleResume(boolean bl) {
        if (!this.isInitialized()) {
            return;
        }
        CordovaWebViewImpl cordovaWebViewImpl = this;
        cordovaWebViewImpl.engine.setPaused(false);
        cordovaWebViewImpl.pluginManager.onResume(bl);
        if (cordovaWebViewImpl.hasPausedEver) {
            this.sendJavascriptEvent("resume");
        }
    }

    @Override
    public void handleStart() {
        if (!this.isInitialized()) {
            return;
        }
        this.pluginManager.onStart();
    }

    @Override
    public void handleStop() {
        if (!this.isInitialized()) {
            return;
        }
        this.pluginManager.onStop();
    }

    @Override
    public void handleDestroy() {
        if (!this.isInitialized()) {
            return;
        }
        CordovaWebViewImpl cordovaWebViewImpl = this;
        ++cordovaWebViewImpl.loadUrlTimeout;
        cordovaWebViewImpl.pluginManager.onDestroy();
        cordovaWebViewImpl.loadUrl("about:blank");
        cordovaWebViewImpl.engine.destroy();
        cordovaWebViewImpl.hideCustomView();
    }

    protected class EngineClient
    implements CordovaWebViewEngine.Client {
        protected EngineClient() {
        }

        @Override
        public void clearLoadTimeoutTimer() {
            CordovaWebViewImpl.this.loadUrlTimeout++;
        }

        @Override
        public void onPageStarted(String string2) {
            EngineClient engineClient = this;
            LOG.d(CordovaWebViewImpl.TAG, "onPageDidNavigate(" + string2 + ")");
            engineClient.CordovaWebViewImpl.this.boundKeyCodes.clear();
            engineClient.CordovaWebViewImpl.this.pluginManager.onReset();
            engineClient.CordovaWebViewImpl.this.pluginManager.postMessage("onPageStarted", string2);
        }

        @Override
        public void onReceivedError(int n2, String string2, String string3) {
            JSONObject jSONObject;
            this.clearLoadTimeoutTimer();
            JSONObject jSONObject2 = jSONObject;
            new JSONObject().put("errorCode", n2);
            jSONObject2.put("description", (Object)string2);
            try {
                jSONObject2.put("url", (Object)string3);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            CordovaWebViewImpl.this.pluginManager.postMessage("onReceivedError", jSONObject2);
        }

        @Override
        public void onPageFinishedLoading(String string2) {
            EngineClient engineClient = this;
            LOG.d(CordovaWebViewImpl.TAG, "onPageFinished(" + string2 + ")");
            engineClient.clearLoadTimeoutTimer();
            engineClient.CordovaWebViewImpl.this.pluginManager.postMessage("onPageFinished", string2);
            if (engineClient.CordovaWebViewImpl.this.engine.getView().getVisibility() != 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(2000L);
                            CordovaWebViewImpl.this.cordova.getActivity().runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    CordovaWebViewImpl.this.pluginManager.postMessage("spinner", "stop");
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }).start();
            }
            if (string2.equals("about:blank")) {
                CordovaWebViewImpl.this.pluginManager.postMessage("exit", null);
            }
        }

        @Override
        public Boolean onDispatchKeyEvent(KeyEvent object) {
            int n2 = object.getKeyCode();
            boolean bl = n2 == 4;
            if (object.getAction() == 0) {
                if (bl && CordovaWebViewImpl.this.mCustomView != null) {
                    return true;
                }
                if (CordovaWebViewImpl.this.boundKeyCodes.contains(n2)) {
                    return true;
                }
                if (bl) {
                    return CordovaWebViewImpl.this.engine.canGoBack();
                }
            } else if (object.getAction() == 1) {
                if (bl && CordovaWebViewImpl.this.mCustomView != null) {
                    CordovaWebViewImpl.this.hideCustomView();
                    return true;
                }
                if (CordovaWebViewImpl.this.boundKeyCodes.contains(n2)) {
                    object = null;
                    if (n2 != 4) {
                        if (n2 != 82) {
                            if (n2 != 84) {
                                if (n2 != 24) {
                                    if (n2 == 25) {
                                        object = "volumedownbutton";
                                    }
                                } else {
                                    object = "volumeupbutton";
                                }
                            } else {
                                object = "searchbutton";
                            }
                        } else {
                            object = "menubutton";
                        }
                    } else {
                        object = "backbutton";
                    }
                    if (object != null) {
                        CordovaWebViewImpl.this.sendJavascriptEvent((String)object);
                        return true;
                    }
                } else if (bl) {
                    return CordovaWebViewImpl.this.engine.goBack();
                }
            }
            return null;
        }

        @Override
        public boolean onNavigationAttempt(String string2) {
            if (CordovaWebViewImpl.this.pluginManager.onOverrideUrlLoading(string2)) {
                return true;
            }
            if (CordovaWebViewImpl.this.pluginManager.shouldAllowNavigation(string2)) {
                return false;
            }
            if (CordovaWebViewImpl.this.pluginManager.shouldOpenExternalUrl(string2).booleanValue()) {
                CordovaWebViewImpl.this.showWebPage(string2, true, false, null);
                return true;
            }
            LOG.w(CordovaWebViewImpl.TAG, "Blocked (possibly sub-frame) navigation to non-allowed URL: " + string2);
            return true;
        }
    }
}

