/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Pair;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.cordova.CallbackMap;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CoreAndroid;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.ResumeCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class CordovaInterfaceImpl
implements CordovaInterface {
    private static final String TAG = "CordovaInterfaceImpl";
    protected Activity activity;
    protected ExecutorService threadPool;
    protected PluginManager pluginManager;
    protected ActivityResultHolder savedResult;
    protected CallbackMap permissionResultCallbacks;
    protected CordovaPlugin activityResultCallback;
    protected String initCallbackService;
    protected int activityResultRequestCode;
    protected boolean activityWasDestroyed;
    protected Bundle savedPluginState;

    public CordovaInterfaceImpl(Activity activity) {
        this(activity, Executors.newCachedThreadPool());
    }

    public CordovaInterfaceImpl(Activity activity, ExecutorService executorService) {
        CordovaInterfaceImpl cordovaInterfaceImpl = this;
        this.activityWasDestroyed = false;
        this.activity = activity;
        cordovaInterfaceImpl.threadPool = executorService;
        cordovaInterfaceImpl.permissionResultCallbacks = new CallbackMap();
    }

    @Override
    public void startActivityForResult(CordovaPlugin cordovaPlugin, Intent intent, int n2) {
        CordovaInterfaceImpl cordovaInterfaceImpl = this;
        cordovaInterfaceImpl.setActivityResultCallback(cordovaPlugin);
        try {
            cordovaInterfaceImpl.activity.startActivityForResult(intent, n2);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.activityResultCallback = null;
            throw runtimeException;
        }
    }

    @Override
    public void setActivityResultCallback(CordovaPlugin cordovaPlugin) {
        CordovaPlugin cordovaPlugin2 = this.activityResultCallback;
        if (cordovaPlugin2 != null) {
            cordovaPlugin2.onActivityResult(this.activityResultRequestCode, 0, null);
        }
        this.activityResultCallback = cordovaPlugin;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public Context getContext() {
        return this.activity;
    }

    @Override
    public Object onMessage(String string2, Object object) {
        if ("exit".equals(string2)) {
            this.activity.finish();
        }
        return null;
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void onCordovaInit(PluginManager pluginManager) {
        block3: {
            JSONObject jSONObject;
            block2: {
                ((CordovaInterfaceImpl)this).pluginManager = pluginManager;
                ActivityResultHolder activityResultHolder = ((CordovaInterfaceImpl)this).savedResult;
                if (activityResultHolder == null) break block2;
                ((CordovaInterfaceImpl)this).onActivityResult(activityResultHolder.requestCode, ((CordovaInterfaceImpl)this).savedResult.resultCode, ((CordovaInterfaceImpl)this).savedResult.intent);
                break block3;
            }
            if (!((CordovaInterfaceImpl)this).activityWasDestroyed) break block3;
            ((CordovaInterfaceImpl)this).activityWasDestroyed = false;
            if (pluginManager == null || (this = (CoreAndroid)pluginManager.getPlugin("CoreAndroid")) == null) break block3;
            pluginManager = jSONObject;
            try {
                new JSONObject().put("action", (Object)"resume");
            }
            catch (JSONException jSONException) {
                LOG.e(TAG, "Failed to create event message", jSONException);
            }
            ((CoreAndroid)this).sendResumeEvent(new PluginResult(PluginResult.Status.OK, (JSONObject)pluginManager));
        }
    }

    public boolean onActivityResult(int n2, int n3, Intent intent) {
        CordovaPlugin cordovaPlugin = ((CordovaInterfaceImpl)((Object)string3)).activityResultCallback;
        if (cordovaPlugin == null && ((CordovaInterfaceImpl)((Object)string3)).initCallbackService != null) {
            ((CordovaInterfaceImpl)((Object)string3)).savedResult = new ActivityResultHolder(n2, n3, intent);
            PluginManager pluginManager = ((CordovaInterfaceImpl)((Object)string3)).pluginManager;
            if (pluginManager != null && (cordovaPlugin = pluginManager.getPlugin(((CordovaInterfaceImpl)((Object)string3)).initCallbackService)) != null) {
                cordovaPlugin.onRestoreStateForActivityResult(((CordovaInterfaceImpl)((Object)string3)).savedPluginState.getBundle(cordovaPlugin.getServiceName()), new ResumeCallback(cordovaPlugin.getServiceName(), ((CordovaInterfaceImpl)((Object)string3)).pluginManager));
            }
        }
        ((CordovaInterfaceImpl)((Object)string3)).activityResultCallback = null;
        if (cordovaPlugin != null) {
            String string2 = string3;
            LOG.d(TAG, "Sending activity result to plugin");
            ((CordovaInterfaceImpl)((Object)string2)).initCallbackService = null;
            ((CordovaInterfaceImpl)((Object)string2)).savedResult = null;
            cordovaPlugin.onActivityResult(n2, n3, intent);
            return true;
        }
        CordovaInterfaceImpl cordovaInterfaceImpl = string3;
        String string3 = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("Got an activity result, but no plugin was registered to receive it");
        String string4 = cordovaInterfaceImpl.savedResult != null ? " yet!" : ".";
        LOG.w(string3, stringBuilder.append(string4).toString());
        return false;
    }

    public void setActivityResultRequestCode(int n2) {
        this.activityResultRequestCode = n2;
    }

    public void onSaveInstanceState(Bundle bundle) {
        CordovaPlugin cordovaPlugin = ((CordovaInterfaceImpl)this).activityResultCallback;
        if (cordovaPlugin != null) {
            bundle.putString("callbackService", cordovaPlugin.getServiceName());
        }
        if ((this = ((CordovaInterfaceImpl)this).pluginManager) != null) {
            bundle.putBundle("plugin", ((PluginManager)this).onSaveInstanceState());
        }
    }

    public void restoreInstanceState(Bundle bundle) {
        CordovaInterfaceImpl cordovaInterfaceImpl = this;
        this.initCallbackService = bundle.getString("callbackService");
        cordovaInterfaceImpl.savedPluginState = bundle.getBundle("plugin");
        cordovaInterfaceImpl.activityWasDestroyed = true;
    }

    public void onRequestPermissionResult(int n2, String[] stringArray, int[] nArray) {
        Pair<CordovaPlugin, Integer> pair = pair.permissionResultCallbacks.getAndRemoveCallback(n2);
        if (pair != null) {
            ((CordovaPlugin)pair.first).onRequestPermissionResult((Integer)pair.second, stringArray, nArray);
        }
    }

    @Override
    public void requestPermission(CordovaPlugin cordovaPlugin, int n2, String string2) {
        this.requestPermissions(cordovaPlugin, n2, new String[]{string2});
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void requestPermissions(CordovaPlugin cordovaPlugin, int n2, String[] stringArray) {
        CordovaInterfaceImpl cordovaInterfaceImpl = this;
        int n3 = cordovaInterfaceImpl.permissionResultCallbacks.registerCallback(cordovaPlugin, n2);
        cordovaInterfaceImpl.getActivity().requestPermissions(stringArray, n3);
    }

    @Override
    public boolean hasPermission(String string2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.activity.checkSelfPermission(string2) == 0;
        }
        return true;
    }

    private static class ActivityResultHolder {
        private int requestCode;
        private int resultCode;
        private Intent intent;

        public ActivityResultHolder(int n2, int n3, Intent intent) {
            this.requestCode = n2;
            this.resultCode = n3;
            this.intent = intent;
        }
    }
}

