/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.cordova.Config;
import org.apache.cordova.ConfigXmlParser;
import org.apache.cordova.CordovaInterfaceImpl;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.CordovaWebViewImpl;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginManager;
import org.json.JSONException;
import org.json.JSONObject;

public class CordovaActivity
extends Activity {
    public static String TAG = "CordovaActivity";
    private static int ACTIVITY_STARTING = 0;
    private static int ACTIVITY_RUNNING = 1;
    private static int ACTIVITY_EXITING = 2;
    protected CordovaWebView appView;
    protected boolean keepRunning = true;
    protected boolean immersiveMode;
    protected CordovaPreferences preferences;
    protected String launchUrl;
    protected ArrayList<PluginEntry> pluginEntries;
    protected CordovaInterfaceImpl cordovaInterface;

    public void onCreate(Bundle bundle) {
        CordovaActivity cordovaActivity = this;
        cordovaActivity.loadConfig();
        LOG.setLogLevel(cordovaActivity.preferences.getString("loglevel", "ERROR"));
        LOG.i(TAG, "Apache Cordova native platform version 8.1.0 is starting");
        LOG.d(TAG, "CordovaActivity.onCreate()");
        if (!cordovaActivity.preferences.getBoolean("ShowTitle", false)) {
            this.getWindow().requestFeature(1);
        }
        if (this.preferences.getBoolean("SetFullscreen", false)) {
            LOG.d(TAG, "The SetFullscreen configuration is deprecated in favor of Fullscreen, and will be removed in a future version.");
            this.preferences.set("Fullscreen", true);
        }
        if (this.preferences.getBoolean("Fullscreen", false)) {
            if (!this.preferences.getBoolean("FullscreenNotImmersive", false)) {
                this.immersiveMode = true;
            } else {
                this.getWindow().setFlags(1024, 1024);
            }
        } else {
            this.getWindow().setFlags(2048, 2048);
        }
        CordovaActivity cordovaActivity2 = this;
        super.onCreate(bundle);
        cordovaActivity2.cordovaInterface = cordovaActivity2.makeCordovaInterface();
        if (bundle != null) {
            this.cordovaInterface.restoreInstanceState(bundle);
        }
    }

    protected void init() {
        CordovaActivity cordovaActivity = this;
        cordovaActivity.appView = cordovaActivity.makeWebView();
        cordovaActivity.createViews();
        if (!cordovaActivity.appView.isInitialized()) {
            this.appView.init(this.cordovaInterface, this.pluginEntries, this.preferences);
        }
        CordovaActivity cordovaActivity2 = this;
        cordovaActivity2.cordovaInterface.onCordovaInit(this.appView.getPluginManager());
        if ("media".equals(cordovaActivity2.preferences.getString("DefaultVolumeStream", "").toLowerCase(Locale.ENGLISH))) {
            this.setVolumeControlStream(3);
        }
    }

    protected void loadConfig() {
        ConfigXmlParser configXmlParser;
        ConfigXmlParser configXmlParser2;
        ConfigXmlParser configXmlParser3 = configXmlParser2 = configXmlParser;
        configXmlParser2();
        configXmlParser3.parse((Context)this);
        this.preferences = configXmlParser3.getPreferences();
        this.preferences.setPreferencesBundle(this.getIntent().getExtras());
        this.launchUrl = configXmlParser2.getLaunchUrl();
        this.pluginEntries = configXmlParser2.getPluginEntries();
        Config.parser = configXmlParser;
    }

    protected void createViews() {
        CordovaActivity cordovaActivity = this;
        cordovaActivity.appView.getView().setId(100);
        cordovaActivity.appView.getView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        cordovaActivity.setContentView(cordovaActivity.appView.getView());
        if (cordovaActivity.preferences.contains("BackgroundColor")) {
            CordovaActivity cordovaActivity2 = this;
            CordovaActivity cordovaActivity3 = cordovaActivity2;
            int n2 = cordovaActivity2.preferences.getInteger("BackgroundColor", -16777216);
            try {
                cordovaActivity3.appView.getView().setBackgroundColor(n2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        this.appView.getView().requestFocusFromTouch();
    }

    protected CordovaWebView makeWebView() {
        return new CordovaWebViewImpl(this.makeWebViewEngine());
    }

    protected CordovaWebViewEngine makeWebViewEngine() {
        CordovaActivity cordovaActivity = this;
        return CordovaWebViewImpl.createEngine((Context)cordovaActivity, cordovaActivity.preferences);
    }

    protected CordovaInterfaceImpl makeCordovaInterface() {
        CordovaActivity cordovaActivity = this;
        return new CordovaInterfaceImpl(cordovaActivity){

            @Override
            public Object onMessage(String string2, Object object) {
                return CordovaActivity.this.onMessage(string2, object);
            }
        };
    }

    public void loadUrl(String string2) {
        if (this.appView == null) {
            this.init();
        }
        CordovaActivity cordovaActivity = this;
        cordovaActivity.keepRunning = cordovaActivity.preferences.getBoolean("KeepRunning", true);
        cordovaActivity.appView.loadUrlIntoView(string2, true);
    }

    protected void onPause() {
        CordovaActivity cordovaActivity = this;
        super.onPause();
        LOG.d(TAG, "Paused the activity.");
        if (cordovaActivity.appView != null) {
            boolean bl = this.keepRunning || this.cordovaInterface.activityResultCallback != null;
            this.appView.handlePause(bl);
        }
    }

    protected void onNewIntent(Intent intent) {
        CordovaActivity cordovaActivity = cordovaWebView;
        super.onNewIntent(intent);
        CordovaWebView cordovaWebView = cordovaActivity.appView;
        if (cordovaWebView != null) {
            cordovaWebView.onNewIntent(intent);
        }
    }

    protected void onResume() {
        CordovaActivity cordovaActivity = this;
        super.onResume();
        LOG.d(TAG, "Resumed the activity.");
        if (cordovaActivity.appView == null) {
            return;
        }
        if (!this.getWindow().getDecorView().hasFocus()) {
            this.getWindow().getDecorView().requestFocus();
        }
        this.appView.handleResume(this.keepRunning);
    }

    protected void onStop() {
        CordovaActivity cordovaActivity = cordovaWebView;
        super.onStop();
        LOG.d(TAG, "Stopped the activity.");
        CordovaWebView cordovaWebView = cordovaActivity.appView;
        if (cordovaWebView == null) {
            return;
        }
        cordovaWebView.handleStop();
    }

    protected void onStart() {
        CordovaActivity cordovaActivity = cordovaWebView;
        super.onStart();
        LOG.d(TAG, "Started the activity.");
        CordovaWebView cordovaWebView = cordovaActivity.appView;
        if (cordovaWebView == null) {
            return;
        }
        cordovaWebView.handleStart();
    }

    public void onDestroy() {
        CordovaActivity cordovaActivity = cordovaWebView;
        LOG.d(TAG, "CordovaActivity.onDestroy()");
        super.onDestroy();
        CordovaWebView cordovaWebView = cordovaActivity.appView;
        if (cordovaWebView != null) {
            cordovaWebView.handleDestroy();
        }
    }

    @SuppressLint(value={"InlinedApi"})
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl && this.immersiveMode) {
            this.getWindow().getDecorView().setSystemUiVisibility(5894);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void startActivityForResult(Intent intent, int n2, Bundle bundle) {
        this.cordovaInterface.setActivityResultRequestCode(n2);
        super.startActivityForResult(intent, n2, bundle);
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        CordovaActivity cordovaActivity = this;
        LOG.d(TAG, "Incoming Result. Request code = " + n2);
        super.onActivityResult(n2, n3, intent);
        cordovaActivity.cordovaInterface.onActivityResult(n2, n3, intent);
    }

    public void onReceivedError(int n2, String string2, String string3) {
        final String string4 = this.preferences.getString("errorUrl", null);
        if (string4 != null && !string3.equals(string4) && this.appView != null) {
            final CordovaActivity cordovaActivity = this;
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    cordovaActivity.appView.showWebPage(string4, false, true, null);
                }
            });
        } else {
            n2 = n2 != -2 ? 1 : 0;
            this.runOnUiThread(new Runnable(n2 != 0, this, string2, string3){
                final /* synthetic */ boolean val$exit;
                final /* synthetic */ CordovaActivity val$me;
                final /* synthetic */ String val$description;
                final /* synthetic */ String val$failingUrl;
                {
                    this.val$exit = bl;
                    this.val$me = cordovaActivity2;
                    this.val$description = string2;
                    this.val$failingUrl = string3;
                }

                @Override
                public void run() {
                    if (string2.val$exit) {
                        3 v0 = string2;
                        v0.val$me.appView.getView().setVisibility(8);
                        3 v1 = string2;
                        String string2 = string2.val$description + " (" + string2.val$failingUrl + ")";
                        boolean bl = v1.val$exit;
                        v0.val$me.displayError("Application Error", string2, "OK", bl);
                    }
                }
            });
        }
    }

    public void displayError(final String string2, final String string3, final String string4, final boolean bl) {
        final CordovaActivity cordovaActivity = this;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder;
                AlertDialog.Builder builder2 = builder;
                4 v1 = this;
                AlertDialog.Builder builder3 = builder2;
                AlertDialog.Builder builder4 = builder3;
                AlertDialog.Builder builder5 = builder3;
                4 v5 = this;
                builder2((Context)cordovaActivity);
                builder2.setMessage((CharSequence)string3);
                builder4.setTitle((CharSequence)v5.string2);
                builder5.setCancelable(false);
                builder.setPositiveButton((CharSequence)v1.string4, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n2) {
                        dialogInterface.dismiss();
                        4 this_ = this_.this;
                        if (this_.bl) {
                            this_.CordovaActivity.this.finish();
                        }
                    }
                });
                builder.create();
                try {
                    builder.show();
                }
                catch (Exception exception) {
                    CordovaActivity.this.finish();
                }
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        CordovaWebView cordovaWebView = this.appView;
        if (cordovaWebView != null) {
            cordovaWebView.getPluginManager().postMessage("onCreateOptionsMenu", menu);
        }
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        CordovaWebView cordovaWebView = ((CordovaActivity)((Object)cordovaWebView)).appView;
        if (cordovaWebView != null) {
            cordovaWebView.getPluginManager().postMessage("onPrepareOptionsMenu", menu);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        CordovaWebView cordovaWebView = ((CordovaActivity)((Object)cordovaWebView)).appView;
        if (cordovaWebView != null) {
            cordovaWebView.getPluginManager().postMessage("onOptionsItemSelected", menuItem);
        }
        return true;
    }

    public Object onMessage(String string2, Object object) {
        if ("onReceivedError".equals(string2)) {
            CordovaActivity cordovaActivity = cordovaActivity2;
            CordovaActivity cordovaActivity2 = (JSONObject)object;
            try {
                cordovaActivity.onReceivedError(cordovaActivity2.getInt("errorCode"), cordovaActivity2.getString("description"), cordovaActivity2.getString("url"));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        } else if ("exit".equals(string2)) {
            cordovaActivity2.finish();
        }
        return null;
    }

    protected void onSaveInstanceState(Bundle bundle) {
        this.cordovaInterface.onSaveInstanceState(bundle);
        super.onSaveInstanceState(bundle);
    }

    public void onConfigurationChanged(Configuration configuration) {
        CordovaActivity cordovaActivity = object;
        super.onConfigurationChanged(configuration);
        Object object = cordovaActivity.appView;
        if (object == null) {
            return;
        }
        if ((object = object.getPluginManager()) != null) {
            ((PluginManager)object).onConfigurationChanged(configuration);
        }
    }

    public void onRequestPermissionsResult(int n2, String[] stringArray, int[] nArray) {
        try {
            this.cordovaInterface.onRequestPermissionResult(n2, stringArray, nArray);
        }
        catch (JSONException jSONException) {
            LOG.d(TAG, "JSONException: Parameters fed into the method are not valid");
            jSONException.printStackTrace();
        }
    }
}

