/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.annotation.TargetApi;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.cordova.AuthenticationToken;
import org.apache.cordova.CordovaClientCertRequest;
import org.apache.cordova.CordovaHttpAuthHandler;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.ICordovaClientCertRequest;
import org.apache.cordova.ICordovaHttpAuthHandler;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginManager;
import org.apache.cordova.engine.SystemWebViewEngine;

public class SystemWebViewClient
extends WebViewClient {
    private static final String TAG = "SystemWebViewClient";
    protected final SystemWebViewEngine parentEngine;
    private boolean doClearHistory = false;
    boolean isCurrentlyLoading;
    private Hashtable<String, AuthenticationToken> authenticationTokens = new Hashtable();

    public SystemWebViewClient(SystemWebViewEngine systemWebViewEngine) {
        this.parentEngine = systemWebViewEngine;
    }

    private static boolean needsKitKatContentUrlFix(Uri uri) {
        return "content".equals(uri.getScheme());
    }

    private static boolean needsSpecialsInAssetUrlFix(Uri uri) {
        if (CordovaResourceApi.getUriType(uri) != 1) {
            return false;
        }
        if (uri.getQuery() == null && uri.getFragment() == null) {
            if (!uri.toString().contains("%")) {
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
        return this.parentEngine.client.onNavigationAttempt(string2);
    }

    public void onReceivedHttpAuthRequest(WebView webView, HttpAuthHandler httpAuthHandler, String string2, String string3) {
        Object object = this.getAuthenticationToken(string2, string3);
        if (object != null) {
            httpAuthHandler.proceed(((AuthenticationToken)object).getUserName(), ((AuthenticationToken)object).getPassword());
            return;
        }
        object = this.parentEngine.pluginManager;
        if (object != null) {
            CordovaHttpAuthHandler cordovaHttpAuthHandler;
            Object object2 = object;
            object = cordovaHttpAuthHandler;
            cordovaHttpAuthHandler = new CordovaHttpAuthHandler(httpAuthHandler);
            if (((PluginManager)object2).onReceivedHttpAuthRequest(null, (ICordovaHttpAuthHandler)object, string2, string3)) {
                this.parentEngine.client.clearLoadTimeoutTimer();
                return;
            }
        }
        super.onReceivedHttpAuthRequest(webView, httpAuthHandler, string2, string3);
    }

    @TargetApi(value=21)
    public void onReceivedClientCertRequest(WebView webView, ClientCertRequest clientCertRequest) {
        Object object = this.parentEngine.pluginManager;
        if (object != null) {
            CordovaClientCertRequest cordovaClientCertRequest;
            PluginManager pluginManager = object;
            object = cordovaClientCertRequest;
            cordovaClientCertRequest = new CordovaClientCertRequest(clientCertRequest);
            if (pluginManager.onReceivedClientCertRequest(null, (ICordovaClientCertRequest)object)) {
                this.parentEngine.client.clearLoadTimeoutTimer();
                return;
            }
        }
        super.onReceivedClientCertRequest(webView, clientCertRequest);
    }

    public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
        SystemWebViewClient systemWebViewClient = this;
        super.onPageStarted(webView, string2, bitmap);
        systemWebViewClient.isCurrentlyLoading = true;
        systemWebViewClient.parentEngine.bridge.reset();
        systemWebViewClient.parentEngine.client.onPageStarted(string2);
    }

    public void onPageFinished(WebView webView, String string2) {
        SystemWebViewClient systemWebViewClient = this;
        super.onPageFinished(webView, string2);
        if (!systemWebViewClient.isCurrentlyLoading && !string2.startsWith("about:")) {
            return;
        }
        this.isCurrentlyLoading = false;
        if (this.doClearHistory) {
            webView.clearHistory();
            this.doClearHistory = false;
        }
        this.parentEngine.client.onPageFinishedLoading(string2);
    }

    public void onReceivedError(WebView webView, int n2, String string2, String string3) {
        if (!this.isCurrentlyLoading) {
            return;
        }
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        objectArray[1] = string2;
        objectArray[2] = string3;
        LOG.d(TAG, "CordovaWebViewClient.onReceivedError: Error code=%s Description=%s URL=%s", objectArray2);
        if (n2 == -10) {
            this.parentEngine.client.clearLoadTimeoutTimer();
            if (webView.canGoBack()) {
                webView.goBack();
                return;
            }
            super.onReceivedError(webView, n2, string2, string3);
        }
        this.parentEngine.client.onReceivedError(n2, string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
        SystemWebViewClient systemWebViewClient = this;
        String string2 = systemWebViewClient.parentEngine.cordova.getActivity().getPackageName();
        try {
            if ((systemWebViewClient.parentEngine.cordova.getActivity().getPackageManager().getApplicationInfo((String)string2, (int)128).flags & 2) != 0) {
                sslErrorHandler.proceed();
                return;
            }
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
        }
    }

    public void setAuthenticationToken(AuthenticationToken authenticationToken, String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        this.authenticationTokens.put(string2.concat(string3), authenticationToken);
    }

    public AuthenticationToken removeAuthenticationToken(String string2, String string3) {
        return this.authenticationTokens.remove(string2.concat(string3));
    }

    public AuthenticationToken getAuthenticationToken(String object, String string2) {
        AuthenticationToken authenticationToken = this.authenticationTokens.get(((String)object).concat(string2));
        if (authenticationToken == null) {
            if ((object = this.authenticationTokens.get(object)) == null) {
                object = this.authenticationTokens.get(string2);
            }
            if (object == null) {
                object = this.authenticationTokens.get("");
            }
        } else {
            object = authenticationToken;
        }
        return object;
    }

    public void clearAuthenticationTokens() {
        this.authenticationTokens.clear();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
        Object object;
        try {
            if (!((SystemWebViewClient)((Object)object)).parentEngine.pluginManager.shouldAllowRequest(string2)) {
                LOG.w(TAG, "URL blocked by whitelist: " + string2);
                return new WebResourceResponse("text/plain", "UTF-8", null);
            }
            object = ((SystemWebViewClient)((Object)object)).parentEngine.resourceApi;
            webView = Uri.parse((String)string2);
        }
        catch (IOException iOException) {
            if (!(iOException instanceof FileNotFoundException)) {
                LOG.e(TAG, "Error occurred while loading a file (returning a 404).", iOException);
            }
            return new WebResourceResponse("text/plain", "UTF-8", null);
        }
        {
            string2 = ((CordovaResourceApi)object).remapUri((Uri)webView);
        }
        {
            if (webView.equals((Object)string2) && !SystemWebViewClient.needsSpecialsInAssetUrlFix((Uri)webView) && !SystemWebViewClient.needsKitKatContentUrlFix((Uri)webView)) {
                return null;
            }
            object = ((CordovaResourceApi)object).openForRead((Uri)string2, true);
            return new WebResourceResponse(((CordovaResourceApi.OpenForReadResult)object).mimeType, "UTF-8", ((CordovaResourceApi.OpenForReadResult)object).inputStream);
        }
    }
}

