/*
 * Decompiled with CFR 0.152.
 */
package com.unarin.cordova.beacon;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class PausableThreadPoolExecutor
extends ThreadPoolExecutor {
    private static int NUMBER_OF_CORES = 1;
    private static int KEEP_ALIVE_SECONDS = 30;
    private boolean paused;
    private ReentrantLock pauseLock;
    private Condition unpaused;

    public PausableThreadPoolExecutor(BlockingQueue<Runnable> blockingQueue) {
        PausableThreadPoolExecutor pausableThreadPoolExecutor = this;
        int n2 = NUMBER_OF_CORES;
        super(n2, n2, KEEP_ALIVE_SECONDS, TimeUnit.SECONDS, blockingQueue);
        pausableThreadPoolExecutor.pauseLock = new ReentrantLock();
        pausableThreadPoolExecutor.unpaused = pausableThreadPoolExecutor.pauseLock.newCondition();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        Throwable throwable2;
        block6: {
            PausableThreadPoolExecutor pausableThreadPoolExecutor = this;
            super.beforeExecute(thread, runnable);
            pausableThreadPoolExecutor.pauseLock.lock();
            while (true) {
                if (!this.paused) {
                    this.pauseLock.unlock();
                    return;
                }
                this.unpaused.await();
            }
            {
                catch (Throwable throwable2) {
                    break block6;
                }
                catch (InterruptedException interruptedException) {}
                {
                    thread.interrupt();
                    this.pauseLock.unlock();
                }
            }
            return;
        }
        this.pauseLock.unlock();
        throw throwable2;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        PausableThreadPoolExecutor pausableThreadPoolExecutor = this;
        pausableThreadPoolExecutor.pauseLock.lock();
        try {
            pausableThreadPoolExecutor.paused = true;
            pausableThreadPoolExecutor.pauseLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            this.pauseLock.unlock();
            throw throwable;
        }
    }

    public void resume() {
        PausableThreadPoolExecutor pausableThreadPoolExecutor = this;
        pausableThreadPoolExecutor.pauseLock.lock();
        try {
            pausableThreadPoolExecutor.paused = false;
            pausableThreadPoolExecutor.unpaused.signalAll();
            pausableThreadPoolExecutor.pauseLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            this.pauseLock.unlock();
            throw throwable;
        }
    }
}

