/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const DEFAULT_UUIDS = ["FDA50693-A4E2-4FB1-AFCF-C6EB07647825"];
// const baseUrl = 'https://i-linkup.com';
// const baseUrl = 'https://ilt.e-path.cn';
// const baseUrl = 'https://dev2.e-path.cn/?k=c48ffs325a9e';
// var baseUrl = 'https://ma.locnavi.com?id=HHrzBwF5dY&poi=3015&appKey=nqB6HPIU2C'
var baseUrl = 'https://ma.locnavi.com';

function showMap(value) {
    baseUrl = value;
    var permissions = cordova.plugins.permissions;
    permissions.requestPermission(permissions.ACCESS_COARSE_LOCATION, status => app.hasPermission(status));
}


var ref;
var watchCompassID;
var app = {
    // Application Constructor
    initialize: function () {
        console.log("HJXDEBUG： h5 js initialize");
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },


    // deviceready Event Handler
    //
    // Bind any cordova events here. Common events are:
    // 'pause', 'resume', etc.
    onDeviceReady: function () {
        this.receivedEvent('deviceready');
        console.log("HJXDEBUG： deviceready");

        var success = function(status) {
            console.log("cordova cache", "clear cache")
        };
        var error = function(status) {
            console.log('cordova cache: ' + status);
        };
        window.CacheClear(success, error);
        // var permissions = cordova.plugins.permissions;
        // permissions.requestPermission(permissions.ACCESS_COARSE_LOCATION, status => this.hasPermission(status));

    },

    hasPermission: function (status) {
        var permissions = cordova.plugins.permissions;
        if (status.hasPermission) {
            console.log("ACCESS_COARSE_LOCATION", "yes");
            this.initData();
        }
        else {
            console.log("ACCESS_COARSE_LOCATION", "no");
            navigator.app.exitApp();
        }
    },

    getQueryVariable: function (variable) {
        var query = window.location.search.substring(1);
        var vars = query.split("&");
        for (var i = 0; i < vars.length; i++) {
            var pair = vars[i].split("=");
            if (pair[0] == variable) {
                return pair[1];
            }
        }
        return (false);
    },

    initData: function () {
        // const shortLink = getQueryVariable('shortLink');
        // let url = baseUrl + '?inApp=true'
        // if (!!shortLink) {
        //     url = baseUrl + `/${shortLink}?inApp=true`
        // }
        var url = baseUrl;
        ref = window.open(url, '_blank', 'location=no,footer=no,toolbar=no');
        // ref = window.open('http://192.168.55.33:8000?inApp=true', '_blank', 'location=no');
        // ref = window.open('http://192.168.55.33:8080/#/home', '_blank', 'location=no');
        // ref = window.open('https://dev2.e-path.cn?k=c48ffs325a9e', '_blank', 'location=no,footer=no,toolbar=no');
        ref.addEventListener('exit', () => {
            navigator.app.exitApp();
        });

        //启动定时器
        var loop = setInterval(() => {
            console.log("HJX time to interval!!!!!");

            ref.executeScript({ code: "(()=>{return !!window.deviceMessenger})();" }, (params) => {

                var detectData = params[0];
                // detectData = true;
                if (detectData) {
                    console.log("detectData", detectData);
                    // console.log(detectData);
                    // 调用浏览器内部页面的js方法
                    // ref.executeScript({ code: `sayHello({text: '${JSON.stringify(params)}'})` }, (params) => {
                    //     console.log(params);
                    // });

                    this.scanBeaconIndex = {};
                    this.startScan();
                    this.startCompass();

                    //销毁定时器
                    clearInterval(loop);
                    // ref.close();
                }
            });
        }, 500);
    },

    // Update DOM on a Received Event
    receivedEvent: function (id) {
        // var parentElement = document.getElementById(id);
        // var listeningElement = parentElement.querySelector('.listening');
        // var receivedElement = parentElement.querySelector('.received');
        //
        // listeningElement.setAttribute('style', 'display:none;');
        // receivedElement.setAttribute('style', 'display:block;');

        console.log('Received Event: ' + id);
    },


    startScan: function () {
        this.checkBluetooth();

        this.subscribeBeacons();

        this.startRangingBeacons();
    },


    startRangingBeacons: function () {

        cordova.plugins.locationManager.requestWhenInUseAuthorization();

        let uuids = DEFAULT_UUIDS;
        for (let i = 0; i < uuids.length; i++) {
            var uuid = uuids[i];
            var identifier = `rangingId-${i}`;
            var major = undefined;
            var minor = undefined;

            var beaconRegion = new cordova.plugins.locationManager.BeaconRegion(identifier, uuid, major, minor);

            console.log("HJXDEBUG js扫描beacons:", beaconRegion);
            cordova.plugins.locationManager.startRangingBeaconsInRegion(beaconRegion)
                .fail((e) => {
                    console.error(e);
                })
                .done();
        }

    },

    subscribeBeacons: function () {
        const delegate = new cordova.plugins.locationManager.Delegate();
        delegate.didRangeBeaconsInRegion = (pluginResult) => {

            let realBeaconsAry = pluginResult.beacons;
            var time = Date.now();

            realBeaconsAry = realBeaconsAry
                .filter(a => {
                    return a.rssi != 0;
                })
                .sort((a, b) => {
                    return b.rssi - a.rssi;
                });
            if (realBeaconsAry.length > 50) {
                realBeaconsAry.length = 50;
            }

            for (let i = 0, len = realBeaconsAry.length; i < len; i++) {
                //查找相同beacon
                var index =
                    realBeaconsAry[i].uuid +
                    "-" +
                    realBeaconsAry[i].major +
                    "-" +
                    realBeaconsAry[i].minor;
                var beacon = this.scanBeaconIndex[index];
                if (beacon) {
                    if (
                        //realBeaconsAry[i].rssi != beacon.rssi &&
                        realBeaconsAry[i].rssi > -100
                    ) {
                        //替换
                        beacon.time = time;
                        beacon.rssi = realBeaconsAry[i].rssi;
                    }
                } else {
                    beacon = realBeaconsAry[i];
                    beacon.time = time;
                    this.scanBeaconIndex[index] = beacon;
                }
            }


            this.sendBeaconsData();

        };
        cordova.plugins.locationManager.setDelegate(delegate);
    },

    sendBeaconsData: function () {
        const realBeacons = this.filterBeacons();

        ref.executeScript({ code: `window.deviceMessenger.pushBeacons(${JSON.stringify({ beacons: realBeacons })})` }, (params) => {
            console.log(params);
        });
    },

    //过滤ibeacon信号
    filterBeacons: function () {
        //删除更新不及时的beacons
        let beaconsTemp = [];
        let time = Date.now();
        for (var key in this.scanBeaconIndex) {
            if (this.scanBeaconIndex[key].time && time - this.scanBeaconIndex[key].time <= 5000) {
                beaconsTemp.push(this.scanBeaconIndex[key]);
            } else {
                if (time - this.scanBeaconIndex[key].time > 60000) delete this.scanBeaconIndex[key];
            }
        }

        beaconsTemp.sort((a, b) => {
            return b.rssi - a.rssi;
        });
        if (beaconsTemp.length > 50) {
            beaconsTemp.length = 50;
        }

        return beaconsTemp;
    },

    //检查蓝牙是否开启
    checkBluetooth: function () {
        cordova.plugins.locationManager.isBluetoothEnabled()
            .then(function (isEnabled) {
                console.log("Bluetooth isEnabled: " + isEnabled);
                if (!isEnabled) {
                    cordova.plugins.locationManager.enableBluetooth();
                }
            })
            .fail(function (e) {
                console.error(e);
            })
            .done();
    },

    //提供手机朝向
    startCompass() {

        function onSuccess(heading) {
            ref.executeScript({ code: `window.deviceMessenger.pushCompass(${JSON.stringify({ heading: heading.magneticHeading })})` }, (params) => {
                console.log(params);
            });
        };

        function onError(compassError) {
            console.log('Compass error: ' + compassError.code);
        };
        // Update every 1 seconds
        var options = {
            frequency: 1000
        };
        watchCompassID = navigator.compass.watchHeading(onSuccess, onError, options);

        //关闭方向监听
        // navigator.compass.clearWatch(watchCompassID);
    }

};

app.initialize();
