/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telephony.TelephonyManager;
import java.util.HashMap;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CoreAndroid
extends CordovaPlugin {
    public static final String PLUGIN_NAME = "CoreAndroid";
    protected static final String TAG = "CordovaApp";
    private BroadcastReceiver telephonyReceiver;
    private CallbackContext messageChannel;
    private PluginResult pendingResume;
    private PluginResult pendingPause;
    private final Object messageChannelLock = new Object();

    private void initTelephonyReceiver() {
        IntentFilter intentFilter;
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.intent.action.PHONE_STATE");
        this.telephonyReceiver = new BroadcastReceiver(){

            public void onReceive(Context object, Intent intent) {
                if (intent != null && intent.getAction().equals("android.intent.action.PHONE_STATE") && intent.hasExtra("state")) {
                    object = intent.getStringExtra("state");
                    if (((String)object).equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                        LOG.i(CoreAndroid.TAG, "Telephone RINGING");
                        CoreAndroid.this.webView.getPluginManager().postMessage("telephone", "ringing");
                    } else if (((String)object).equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                        LOG.i(CoreAndroid.TAG, "Telephone OFFHOOK");
                        CoreAndroid.this.webView.getPluginManager().postMessage("telephone", "offhook");
                    } else if (((String)object).equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                        LOG.i(CoreAndroid.TAG, "Telephone IDLE");
                        CoreAndroid.this.webView.getPluginManager().postMessage("telephone", "idle");
                    }
                }
            }
        };
        this.webView.getContext().registerReceiver(this.telephonyReceiver, intentFilter2);
    }

    private void sendEventMessage(String string2) {
        PluginResult pluginResult;
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        try {
            new JSONObject().put("action", (Object)string2);
        }
        catch (JSONException jSONException) {
            LOG.e(TAG, "Failed to create event message", jSONException);
        }
        PluginResult pluginResult2 = pluginResult;
        pluginResult = new PluginResult(PluginResult.Status.OK, jSONObject2);
        if (this.messageChannel == null) {
            LOG.i(TAG, "Request to send event before messageChannel initialised: " + string2);
            if ("pause".equals(string2)) {
                this.pendingPause = pluginResult2;
            } else if ("resume".equals(string2)) {
                this.pendingPause = null;
            }
        } else {
            this.sendEventMessage(pluginResult2);
        }
    }

    private void sendEventMessage(PluginResult pluginResult) {
        pluginResult.setKeepCallback(true);
        CallbackContext callbackContext = ((CoreAndroid)((Object)callbackContext)).messageChannel;
        if (callbackContext != null) {
            callbackContext.sendPluginResult(pluginResult);
        }
    }

    public static Object getBuildConfigValue(Context context, String string2) {
        try {
            return Class.forName(context.getPackageName() + ".BuildConfig").getField(string2).get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.d(TAG, "Illegal Access Exception: Let's print a stack trace.");
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOG.d(TAG, string2 + " is not a valid field. Check your build.gradle");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.d(TAG, "Unable to get the BuildConfig, is this built with ANT?");
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    public void fireJavascriptEvent(String string2) {
        this.sendEventMessage(string2);
    }

    @Override
    public void pluginInitialize() {
        this.initTelephonyReceiver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute(String var1_1, JSONArray var2_2, CallbackContext var3_3) {
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        var4_4 = PluginResult.Status.OK;
                                        var5_5 = "";
                                        if (!var1_1.equals("clearCache")) break block9;
                                        this.clearCache();
                                        ** GOTO lbl62
                                    }
                                    if (!var1_1.equals("show")) break block10;
                                    this.cordova.getActivity().runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            CoreAndroid.this.webView.getPluginManager().postMessage("spinner", "stop");
                                        }
                                    });
                                    ** GOTO lbl62
                                }
                                if (!var1_1.equals("loadUrl")) break block11;
                                this.loadUrl(var2_2.getString(0), var2_2.optJSONObject(1));
                                ** GOTO lbl62
                            }
                            if (var1_1.equals("cancelLoadUrl")) ** GOTO lbl62
                            if (!var1_1.equals("clearHistory")) break block12;
                            this.clearHistory();
                            ** GOTO lbl62
                        }
                        if (!var1_1.equals("backHistory")) break block13;
                        this.backHistory();
                        ** GOTO lbl62
                    }
                    if (!var1_1.equals("overrideButton")) break block14;
                    this.overrideButton(var2_2.getString(0), var2_2.getBoolean(1));
                    ** GOTO lbl62
                }
                if (!var1_1.equals("overrideBackbutton")) break block15;
                this.overrideBackbutton(var2_2.getBoolean(0));
                ** GOTO lbl62
            }
            if (!var1_1.equals("exitApp")) break block16;
            this.exitApp();
            ** GOTO lbl62
        }
        if (!var1_1.equals("messageChannel")) ** GOTO lbl62
        v0 = this;
        v1 = v0;
        v2 = v0;
        v3 = var3_3;
        var1_1 = this.messageChannelLock;
        {
            catch (JSONException v4) {
                var3_3.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
                return false;
            }
        }
        try {
            v1.messageChannel = v3;
            if (v2.pendingPause != null) {
                v5 = this;
                v5.sendEventMessage(v5.pendingPause);
                v5.pendingPause = null;
            }
            if (this.pendingResume != null) {
                v6 = this;
                v6.sendEventMessage(v6.pendingResume);
                v6.pendingResume = null;
            }
            // MONITOREXIT : var1_1
            return true;
        }
        catch (Throwable v7) {
            // MONITOREXIT : var1_1
            throw v7;
lbl62:
            // 10 sources

            var3_3.sendPluginResult(new PluginResult(var4_4, var5_5));
            return true;
        }
    }

    public void clearCache() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CoreAndroid.this.webView.clearCache();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void loadUrl(String string2, JSONObject jSONObject) {
        HashMap<String, Object> hashMap;
        LOG.d("App", "App.loadUrl(" + string2 + "," + jSONObject + ")");
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap = new HashMap<String, Object>();
        if (jSONObject != null) {
            JSONArray jSONArray = jSONObject.names();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                String string3 = jSONArray.getString(i2);
                if (string3.equals("wait")) {
                    n2 = jSONObject.getInt(string3);
                    continue;
                }
                if (string3.equalsIgnoreCase("openexternal")) {
                    bl = jSONObject.getBoolean(string3);
                    continue;
                }
                if (string3.equalsIgnoreCase("clearhistory")) {
                    bl2 = jSONObject.getBoolean(string3);
                    continue;
                }
                Object object = jSONObject.get(string3);
                if (object == null) continue;
                if (object.getClass().equals(String.class)) {
                    hashMap2.put(string3, (String)object);
                    continue;
                }
                if (object.getClass().equals(Boolean.class)) {
                    hashMap2.put(string3, (Boolean)object);
                    continue;
                }
                if (!object.getClass().equals(Integer.class)) continue;
                hashMap2.put(string3, (Integer)object);
            }
        }
        if (n2 > 0) {
            CoreAndroid coreAndroid = this;
            CoreAndroid coreAndroid2 = coreAndroid;
            CoreAndroid coreAndroid3 = coreAndroid;
            // MONITORENTER : this
            long l2 = n2;
            try {
                coreAndroid2.wait(l2);
                // MONITOREXIT : coreAndroid3
            }
            catch (Throwable throwable) {
                // MONITOREXIT : this
                try {
                    throw throwable;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        this.webView.showWebPage(string2, bl, bl2, hashMap2);
    }

    public void clearHistory() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CoreAndroid.this.webView.clearHistory();
            }
        });
    }

    public void backHistory() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CoreAndroid.this.webView.backHistory();
            }
        });
    }

    public void overrideBackbutton(boolean bl) {
        LOG.i("App", "WARNING: Back Button Default Behavior will be overridden.  The backbutton event will be fired!");
        this.webView.setButtonPlumbedToJs(4, bl);
    }

    public void overrideButton(String string2, boolean bl) {
        LOG.i("App", "WARNING: Volume Button Default Behavior will be overridden.  The volume event will be fired!");
        if (string2.equals("volumeup")) {
            this.webView.setButtonPlumbedToJs(24, bl);
        } else if (string2.equals("volumedown")) {
            this.webView.setButtonPlumbedToJs(25, bl);
        } else if (string2.equals("menubutton")) {
            this.webView.setButtonPlumbedToJs(82, bl);
        }
    }

    public boolean isBackbuttonOverridden() {
        return this.webView.isButtonPlumbedToJs(4);
    }

    public void exitApp() {
        this.webView.getPluginManager().postMessage("exit", null);
    }

    @Override
    public void onDestroy() {
        this.webView.getContext().unregisterReceiver(this.telephonyReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendResumeEvent(PluginResult pluginResult) {
        CoreAndroid coreAndroid = this;
        Object object = coreAndroid.messageChannelLock;
        synchronized (object) {
            if (coreAndroid.messageChannel != null) {
                this.sendEventMessage(pluginResult);
            } else {
                this.pendingResume = pluginResult;
            }
            return;
        }
    }
}

