/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.net.Uri;
import android.os.Looper;
import android.util.Base64;
import android.webkit.MimeTypeMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Locale;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginManager;

public class CordovaResourceApi {
    private static final String LOG_TAG = "CordovaResourceApi";
    public static final int URI_TYPE_FILE = 0;
    public static final int URI_TYPE_ASSET = 1;
    public static final int URI_TYPE_CONTENT = 2;
    public static final int URI_TYPE_RESOURCE = 3;
    public static final int URI_TYPE_DATA = 4;
    public static final int URI_TYPE_HTTP = 5;
    public static final int URI_TYPE_HTTPS = 6;
    public static final int URI_TYPE_PLUGIN = 7;
    public static final int URI_TYPE_UNKNOWN = -1;
    public static final String PLUGIN_URI_SCHEME = "cdvplugin";
    private static final String[] LOCAL_FILE_PROJECTION = new String[]{"_data"};
    public static Thread jsThread;
    private final AssetManager assetManager;
    private final ContentResolver contentResolver;
    private final PluginManager pluginManager;
    private boolean threadCheckingEnabled = true;

    public CordovaResourceApi(Context context, PluginManager pluginManager) {
        this.contentResolver = context.getContentResolver();
        this.assetManager = context.getAssets();
        this.pluginManager = pluginManager;
    }

    public static int getUriType(Uri uri) {
        Uri uri2 = uri;
        CordovaResourceApi.assertNonRelative(uri2);
        String string2 = uri2.getScheme();
        if ("content".equalsIgnoreCase(string2)) {
            return 2;
        }
        if ("android.resource".equalsIgnoreCase(string2)) {
            return 3;
        }
        if ("file".equalsIgnoreCase(string2)) {
            if (uri.getPath().startsWith("/android_asset/")) {
                return 1;
            }
            return 0;
        }
        if ("data".equalsIgnoreCase(string2)) {
            return 4;
        }
        if ("http".equalsIgnoreCase(string2)) {
            return 5;
        }
        if ("https".equalsIgnoreCase(string2)) {
            return 6;
        }
        if (PLUGIN_URI_SCHEME.equalsIgnoreCase(string2)) {
            return 7;
        }
        return -1;
    }

    private String getMimeTypeFromPath(String string2) {
        String string3;
        int n2 = string2.lastIndexOf(46);
        if (n2 != -1) {
            string2 = string2.substring(n2 + 1);
        }
        if ((string3 = string2.toLowerCase(Locale.getDefault())).equals("3ga")) {
            return "audio/3gpp";
        }
        if (string3.equals("js")) {
            return "text/javascript";
        }
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
    }

    private void assertBackgroundThread() {
        if (((CordovaResourceApi)((Object)thread)).threadCheckingEnabled) {
            Thread thread = Thread.currentThread();
            if (thread != Looper.getMainLooper().getThread()) {
                if (thread == jsThread) {
                    throw new IllegalStateException("Tried to perform an IO operation on the WebCore thread. Use CordovaInterface.getThreadPool() instead.");
                }
            } else {
                throw new IllegalStateException("Do not perform IO operations on the UI thread. Use CordovaInterface.getThreadPool() instead.");
            }
        }
    }

    private String getDataUriMimeType(Uri uri) {
        Object object = uri.getSchemeSpecificPart();
        int n2 = object.indexOf(44);
        if (n2 == -1) {
            return null;
        }
        if (((String[])(object = object.substring(0, n2).split(";"))).length > 0) {
            return object[0];
        }
        return null;
    }

    private OpenForReadResult readDataUri(Uri uri) {
        ByteArrayInputStream byteArrayInputStream;
        Object object = uri.getSchemeSpecificPart();
        int n2 = ((String)object).indexOf(44);
        if (n2 == -1) {
            return null;
        }
        String[] stringArray = ((String)object).substring(0, n2).split(";");
        String string2 = null;
        boolean bl = false;
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            if (!"base64".equalsIgnoreCase(stringArray[i2])) continue;
            bl = true;
        }
        object = ((String)object).substring(n2 + 1);
        if (bl) {
            object = Base64.decode((String)object, (int)0);
        } else {
            try {
                object = ((String)object).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = ((String)object).getBytes();
            }
        }
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        return new OpenForReadResult(uri, byteArrayInputStream2, string2, ((Object)object).length, null);
    }

    private static void assertNonRelative(Uri uri) {
        if (uri.isAbsolute()) {
            return;
        }
        throw new IllegalArgumentException("Relative URIs are not supported.");
    }

    public void setThreadCheckingEnabled(boolean bl) {
        this.threadCheckingEnabled = bl;
    }

    public boolean isThreadCheckingEnabled() {
        return this.threadCheckingEnabled;
    }

    public Uri remapUri(Uri uri) {
        CordovaResourceApi.assertNonRelative(uri);
        CordovaResourceApi cordovaResourceApi = cordovaResourceApi.pluginManager.remapUri(uri);
        if (cordovaResourceApi == null) {
            cordovaResourceApi = uri;
        }
        return cordovaResourceApi;
    }

    public String remapPath(String string2) {
        return this.remapUri(Uri.fromFile((File)new File(string2))).getPath();
    }

    public File mapUriToFile(Uri uri) {
        block9: {
            this.assertBackgroundThread();
            int n2 = CordovaResourceApi.getUriType(uri);
            if (n2 == 0) break block9;
            if (n2 == 2 && (this = this.contentResolver.query(uri, LOCAL_FILE_PROJECTION, null, null, null)) != null) {
                block8: {
                    int n3;
                    try {
                        n3 = this.getColumnIndex(LOCAL_FILE_PROJECTION[0]);
                        if (n3 == -1) break block8;
                    }
                    catch (Throwable throwable) {
                        this.close();
                        throw throwable;
                    }
                    if (this.getCount() <= 0) break block8;
                    CordovaResourceApi cordovaResourceApi = this;
                    int n4 = n3;
                    this.moveToFirst();
                    String string2 = cordovaResourceApi.getString(n4);
                    if (string2 == null) break block8;
                    File file = new File(string2);
                    this.close();
                    return file;
                }
                this.close();
            }
            return null;
        }
        return new File(uri.getPath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMimeType(Uri uri) {
        switch (CordovaResourceApi.getUriType(uri)) {
            default: {
                return null;
            }
            case 5: 
            case 6: {
                try {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(uri.toString()).openConnection();
                    httpURLConnection.setDoInput(false);
                    httpURLConnection.setRequestMethod("HEAD");
                    String string2 = httpURLConnection.getHeaderField("Content-Type");
                    if (string2 == null) return string2;
                }
                catch (IOException iOException) {
                    return null;
                }
                return string2.split(";")[0];
            }
            case 4: {
                return ((CordovaResourceApi)((Object)string2)).getDataUriMimeType(uri);
            }
            case 2: 
            case 3: {
                return ((CordovaResourceApi)((Object)string2)).contentResolver.getType(uri);
            }
            case 0: 
            case 1: {
                return ((CordovaResourceApi)((Object)string2)).getMimeTypeFromPath(uri.getPath());
            }
        }
    }

    public OpenForReadResult openForRead(Uri uri) {
        return this.openForRead(uri, false);
    }

    public OpenForReadResult openForRead(Uri uri, boolean bl) {
        if (!bl) {
            ((CordovaResourceApi)object).assertBackgroundThread();
        }
        switch (CordovaResourceApi.getUriType(uri)) {
            default: {
                break;
            }
            case 7: {
                CordovaResourceApi cordovaResourceApi = object;
                Object object = uri.getHost();
                object = cordovaResourceApi.pluginManager.getPlugin((String)object);
                if (object != null) {
                    return ((CordovaPlugin)object).handleOpenForRead(uri);
                }
                throw new FileNotFoundException("Invalid plugin ID in URI: " + uri);
            }
            case 5: 
            case 6: {
                Object object = (HttpURLConnection)new URL(uri.toString()).openConnection();
                ((URLConnection)object).setDoInput(true);
                String string2 = ((URLConnection)object).getHeaderField("Content-Type");
                if (string2 != null) {
                    string2 = string2.split(";")[0];
                }
                Object object2 = object;
                int n2 = ((URLConnection)object2).getContentLength();
                InputStream inputStream = ((URLConnection)object2).getInputStream();
                return new OpenForReadResult(uri, inputStream, string2, n2, null);
            }
            case 4: {
                Object object = ((CordovaResourceApi)object).readDataUri(uri);
                if (object == null) break;
                return object;
            }
            case 2: 
            case 3: {
                CordovaResourceApi cordovaResourceApi = object;
                Object object = cordovaResourceApi.contentResolver.getType(uri);
                AssetFileDescriptor assetFileDescriptor = cordovaResourceApi.contentResolver.openAssetFileDescriptor(uri, "r");
                FileInputStream fileInputStream = assetFileDescriptor.createInputStream();
                long l2 = assetFileDescriptor.getLength();
                return new OpenForReadResult(uri, fileInputStream, (String)object, l2, assetFileDescriptor);
            }
            case 1: {
                long l3;
                String string3 = uri.getPath().substring(15);
                AssetFileDescriptor assetFileDescriptor = null;
                assetFileDescriptor = ((CordovaResourceApi)object).assetManager.openFd(string3);
                InputStream inputStream = assetFileDescriptor.createInputStream();
                try {
                    l3 = assetFileDescriptor.getLength();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    inputStream = ((CordovaResourceApi)object).assetManager.open(string3);
                    l3 = inputStream.available();
                }
                Object object = super.getMimeTypeFromPath(string3);
                return new OpenForReadResult(uri, inputStream, (String)object, l3, assetFileDescriptor);
            }
            case 0: {
                FileInputStream fileInputStream;
                CordovaResourceApi cordovaResourceApi = object;
                Object object = fileInputStream;
                fileInputStream = new FileInputStream(uri.getPath());
                String string4 = cordovaResourceApi.getMimeTypeFromPath(uri.getPath());
                long l4 = ((FileInputStream)object).getChannel().size();
                return new OpenForReadResult(uri, (InputStream)object, string4, l4, null);
            }
        }
        throw new FileNotFoundException("URI not supported by CordovaResourceApi: " + uri);
    }

    public OutputStream openOutputStream(Uri uri) {
        return this.openOutputStream(uri, false);
    }

    public OutputStream openOutputStream(Uri object, boolean bl) {
        File file;
        Object object2;
        ((CordovaResourceApi)object2).assertBackgroundThread();
        int n2 = CordovaResourceApi.getUriType((Uri)object);
        if (n2 != 0) {
            if (n2 != 2 && n2 != 3) {
                throw new FileNotFoundException("URI not supported by CordovaResourceApi: " + object);
            }
            object2 = ((CordovaResourceApi)object2).contentResolver;
            String string2 = bl ? "wa" : "w";
            return object2.openAssetFileDescriptor((Uri)object, string2).createOutputStream();
        }
        object2 = file;
        if ((object = new File(object.getPath()).getParentFile()) != null) {
            ((File)object).mkdirs();
        }
        return new FileOutputStream((File)object2, bl);
    }

    public HttpURLConnection createHttpConnection(Uri uri) {
        this.assertBackgroundThread();
        return (HttpURLConnection)new URL(uri.toString()).openConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyResource(OpenForReadResult openForReadResult, OutputStream outputStream) {
        block10: {
            ((CordovaResourceApi)object).assertBackgroundThread();
            Object object = openForReadResult.inputStream;
            if (!(object instanceof FileInputStream) || !(outputStream instanceof FileOutputStream)) break block10;
            OpenForReadResult openForReadResult2 = openForReadResult;
            object = ((FileInputStream)openForReadResult.inputStream).getChannel();
            FileChannel fileChannel = ((FileOutputStream)outputStream).getChannel();
            long l2 = 0L;
            long l3 = openForReadResult2.length;
            if (openForReadResult2.assetFd != null) {
                l2 = openForReadResult.assetFd.getStartOffset();
            }
            FileChannel fileChannel2 = fileChannel;
            Object object2 = object;
            Object object3 = object2;
            ((FileChannel)object2).position(l2);
            fileChannel2.transferFrom((ReadableByteChannel)object3, 0L, l3);
            return;
        }
        try {
            int n2;
            byte[] byArray = new byte[8192];
            while ((n2 = ((InputStream)object).read(byArray, 0, 8192)) > 0) {
                outputStream.write(byArray, 0, n2);
            }
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            openForReadResult.inputStream.close();
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public void copyResource(Uri uri, OutputStream outputStream) {
        CordovaResourceApi cordovaResourceApi = this;
        cordovaResourceApi.copyResource(cordovaResourceApi.openForRead(uri), outputStream);
    }

    public void copyResource(Uri uri, Uri uri2) {
        CordovaResourceApi cordovaResourceApi = this;
        cordovaResourceApi.copyResource(cordovaResourceApi.openForRead(uri), this.openOutputStream(uri2));
    }

    public static final class OpenForReadResult {
        public final Uri uri;
        public final InputStream inputStream;
        public final String mimeType;
        public final long length;
        public final AssetFileDescriptor assetFd;

        public OpenForReadResult(Uri uri, InputStream inputStream, String string2, long l2, AssetFileDescriptor assetFileDescriptor) {
            this.uri = uri;
            this.inputStream = inputStream;
            this.mimeType = string2;
            this.length = l2;
            this.assetFd = assetFileDescriptor;
        }
    }
}

