/*
 * Decompiled with CFR 0.152.
 */
package com.unarin.cordova.beacon;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import com.unarin.cordova.beacon.IBeaconServiceNotifier;
import com.unarin.cordova.beacon.ILocationManagerCommand;
import com.unarin.cordova.beacon.PausableThreadPoolExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.BeaconTransmitter;
import org.altbeacon.beacon.BleNotAvailableException;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.MonitorNotifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.service.ArmaRssiFilter;
import org.altbeacon.beacon.service.RangedBeacon;
import org.altbeacon.beacon.service.RunningAverageRssiFilter;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=16)
public class LocationManager
extends CordovaPlugin
implements BeaconConsumer {
    public static final String TAG = "com.unarin.beacon";
    private static final int PERMISSION_REQUEST_COARSE_LOCATION = 1;
    private static final String FOREGROUND_BETWEEN_SCAN_PERIOD_NAME = "com.unarin.cordova.beacon.android.altbeacon.ForegroundBetweenScanPeriod";
    private static final String FOREGROUND_SCAN_PERIOD_NAME = "com.unarin.cordova.beacon.android.altbeacon.ForegroundScanPeriod";
    private static final int DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD = 0;
    private static final String SAMPLE_EXPIRATION_MILLISECOND = "com.unarin.cordova.beacon.android.altbeacon.SampleExpirationMilliseconds";
    private static final int DEFAULT_SAMPLE_EXPIRATION_MILLISECOND = 20000;
    private static final String ENABLE_ARMA_FILTER_NAME = "com.unarin.cordova.beacon.android.altbeacon.EnableArmaFilter";
    private static final boolean DEFAULT_ENABLE_ARMA_FILTER = false;
    private static final String REQUEST_BT_PERMISSION_NAME = "com.unarin.cordova.beacon.android.altbeacon.RequestBtPermission";
    private static final boolean DEFAULT_REQUEST_BT_PERMISSION = true;
    private static final int DEFAULT_FOREGROUND_SCAN_PERIOD = 1100;
    private static int CDV_LOCATION_MANAGER_DOM_DELEGATE_TIMEOUT = 30;
    private static final int BUILD_VERSION_CODES_M = 23;
    private BeaconTransmitter beaconTransmitter;
    private BeaconManager iBeaconManager;
    private BlockingQueue<Runnable> queue;
    private PausableThreadPoolExecutor threadPoolExecutor;
    private boolean debugEnabled = true;
    private IBeaconServiceNotifier beaconServiceNotifier;
    private BroadcastReceiver broadcastReceiver;
    private BluetoothAdapter bluetoothAdapter;

    private void initLocationManager() {
        LocationManager locationManager = this;
        locationManager.iBeaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout("m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24"));
        locationManager.iBeaconManager.bind((BeaconConsumer)this);
    }

    private BeaconTransmitter createOrGetBeaconTransmitter() {
        if (this.beaconTransmitter == null) {
            BeaconParser beaconParser = new BeaconParser().setBeaconLayout("m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24");
            this.beaconTransmitter = new BeaconTransmitter(this.getApplicationContext(), beaconParser);
        }
        return this.beaconTransmitter;
    }

    @TargetApi(value=23)
    private void tryToRequestMarshmallowLocationPermission() {
        AlertDialog.Builder builder;
        Object object;
        Activity activity;
        block16: {
            block15: {
                if (Build.VERSION.SDK_INT < 23) {
                    Log.i((String)TAG, (String)("tryToRequestMarshmallowLocationPermission() skipping because API code is below criteria: " + String.valueOf(Build.VERSION.SDK_INT)));
                    return;
                }
                LocationManager locationManager = this;
                activity = locationManager.cordova.getActivity();
                object = locationManager.getCheckSelfPermissionMethod();
                if (object == null) {
                    Log.e((String)TAG, (String)"Could not obtain the method Activity.checkSelfPermission method. Will not check for ACCESS_COARSE_LOCATION even though we seem to be on a supported version of Android.");
                    return;
                }
                object = (Integer)((Method)object).invoke((Object)activity, "android.permission.ACCESS_COARSE_LOCATION");
                Log.i((String)TAG, (String)("Permission check result for ACCESS_COARSE_LOCATION: " + String.valueOf(object)));
                if ((Integer)object != 0) break block15;
                Log.i((String)TAG, (String)"Permission for ACCESS_COARSE_LOCATION has already been granted.");
                return;
            }
            object = this.getRequestPermissionsMethod();
            if (object != null) break block16;
            Log.e((String)TAG, (String)"Could not obtain the method Activity.requestPermissions. Will not ask for ACCESS_COARSE_LOCATION even though we seem to be on a supported version of Android.");
            return;
        }
        AlertDialog.Builder builder2 = builder;
        AlertDialog.Builder builder3 = builder;
        AlertDialog.Builder builder4 = builder;
        builder = new AlertDialog.Builder((Context)activity);
        AlertDialog.Builder builder5 = builder;
        builder.setTitle((CharSequence)"This app needs location access");
        builder3.setMessage((CharSequence)"Please grant location access so this app can detect beacons.");
        builder4.setPositiveButton(17039370, null);
        builder5.setOnDismissListener(new DialogInterface.OnDismissListener((Method)object, activity){
            final /* synthetic */ Method val$requestPermissionsMethod;
            final /* synthetic */ Activity val$activity;
            {
                this.val$requestPermissionsMethod = method;
                this.val$activity = activity;
            }

            @SuppressLint(value={"NewApi"})
            public void onDismiss(DialogInterface dialogInterface) {
                Method method = this.val$requestPermissionsMethod;
                Activity activity = this.val$activity;
                Object[] objectArray = new Object[2];
                objectArray[0] = new String[]{"android.permission.ACCESS_COARSE_LOCATION"};
                try {
                    objectArray[1] = 1;
                    method.invoke((Object)activity, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e((String)LocationManager.TAG, (String)"InvocationTargetException while requesting permission for ACCESS_COARSE_LOCATION:", (Throwable)invocationTargetException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e((String)LocationManager.TAG, (String)"IllegalAccessException while requesting permission for ACCESS_COARSE_LOCATION:", (Throwable)illegalAccessException);
                }
            }
        });
        try {
            builder2.show();
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.w((String)TAG, (String)"InvocationTargetException while checking for ACCESS_COARSE_LOCATION:", (Throwable)invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.w((String)TAG, (String)"IllegalAccessException while checking for ACCESS_COARSE_LOCATION:", (Throwable)illegalAccessException);
        }
    }

    private Method getCheckSelfPermissionMethod() {
        Class<Activity> clazz;
        try {
            clazz = Activity.class;
        }
        catch (Exception exception) {
            return null;
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        return clazz.getMethod("checkSelfPermission", classArray);
    }

    private Method getRequestPermissionsMethod() {
        Class[] classArray;
        try {
            classArray = new Class[2];
        }
        catch (Exception exception) {
            return null;
        }
        Class[] classArray2 = classArray;
        classArray[0] = String[].class;
        classArray[1] = Integer.TYPE;
        Class<Activity> clazz = Activity.class;
        return clazz.getMethod("requestPermissions", classArray2);
    }

    @TargetApi(value=18)
    private void initBluetoothAdapter() {
        this.bluetoothAdapter = ((BluetoothManager)this.cordova.getActivity().getSystemService("bluetooth")).getAdapter();
    }

    private void pauseEventPropagationToDom() {
        LocationManager locationManager = this;
        locationManager.checkEventQueue();
        locationManager.threadPoolExecutor.pause();
    }

    private void resumeEventPropagationToDom() {
        LocationManager locationManager = this;
        locationManager.checkEventQueue();
        locationManager.threadPoolExecutor.resume();
    }

    private void initBluetoothListener() {
        IntentFilter intentFilter;
        LocationManager locationManager;
        if (!this.hasBlueToothPermission()) {
            this.debugWarn("Cannot listen to Bluetooth service when BLUETOOTH permission is not added");
            return;
        }
        try {
            LocationManager locationManager2 = this;
            locationManager = locationManager2;
            locationManager2.iBeaconManager.checkAvailability();
        }
        catch (Exception exception) {
            this.debugWarn("Unexpected exception checking for Bluetooth service: " + exception.getMessage());
            return;
        }
        catch (BleNotAvailableException bleNotAvailableException) {
            this.debugWarn("Cannot listen to Bluetooth service: " + bleNotAvailableException.getMessage());
            return;
        }
        if (locationManager.broadcastReceiver != null) {
            this.debugWarn("Already listening to Bluetooth service, not adding again");
            return;
        }
        this.broadcastReceiver = new BroadcastReceiver(){

            private String getStateDescription(int n2) {
                if (n2 != Integer.MIN_VALUE) {
                    switch (n2) {
                        default: {
                            return "ERROR" + n2;
                        }
                        case 13: {
                            return "STATE_TURNING_OFF";
                        }
                        case 12: {
                            return "STATE_ON";
                        }
                        case 11: {
                            return "STATE_TURNING_ON";
                        }
                        case 10: 
                    }
                    return "STATE_OFF";
                }
                return "ERROR";
            }

            public void onReceive(Context context, Intent intent) {
                block1: {
                    block2: {
                        int n2;
                        block3: {
                            block4: {
                                if (!intent.getAction().equals("android.bluetooth.adapter.action.STATE_CHANGED")) break block1;
                                int n3 = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                                n2 = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", Integer.MIN_VALUE);
                                LocationManager.this.debugLog("Bluetooth Service state changed from " + this.getStateDescription(n2) + " to " + this.getStateDescription(n3));
                                if (n3 == Integer.MIN_VALUE) break block2;
                                if (n3 == 10) break block3;
                                if (n3 == 12) break block4;
                                if (n3 == 13) break block3;
                                break block1;
                            }
                            LocationManager.this.beaconServiceNotifier.didChangeAuthorizationStatus("AuthorizationStatusAuthorized");
                            break block1;
                        }
                        if (n2 == 12) {
                            LocationManager.this.beaconServiceNotifier.didChangeAuthorizationStatus("AuthorizationStatusDenied");
                        }
                        break block1;
                    }
                    LocationManager.this.beaconServiceNotifier.didChangeAuthorizationStatus("AuthorizationStatusNotDetermined");
                }
            }
        };
        IntentFilter intentFilter2 = intentFilter;
        intentFilter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        this.cordova.getActivity().registerReceiver(this.broadcastReceiver, intentFilter2);
        return;
    }

    private void initEventQueue() {
        LocationManager locationManager = this;
        locationManager.queue = new LinkedBlockingQueue<Runnable>();
        locationManager.threadPoolExecutor = new PausableThreadPoolExecutor(this.queue);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                LocationManager.this.checkIfDomSignaldDelegateReady();
            }
        }, (long)(CDV_LOCATION_MANAGER_DOM_DELEGATE_TIMEOUT * 1000));
    }

    private void checkEventQueue() {
        if (this.threadPoolExecutor != null && this.queue != null) {
            return;
        }
        this.debugWarn("WARNING event queue should not be null.");
        this.queue = new LinkedBlockingQueue<Runnable>();
        this.threadPoolExecutor = new PausableThreadPoolExecutor(this.queue);
    }

    private void checkIfDomSignaldDelegateReady() {
        PausableThreadPoolExecutor pausableThreadPoolExecutor = ((LocationManager)((Object)string2)).threadPoolExecutor;
        if (pausableThreadPoolExecutor != null && !pausableThreadPoolExecutor.isPaused()) {
            return;
        }
        LocationManager locationManager = string2;
        String string2 = "WARNING did not receive delegate ready callback from DOM after " + CDV_LOCATION_MANAGER_DOM_DELEGATE_TIMEOUT + " seconds!";
        locationManager.debugWarn(string2);
        locationManager.webView.sendJavascript("console.warn('" + (String)string2 + "')");
    }

    private void createMonitorCallbacks(final CallbackContext callbackContext) {
        this.iBeaconManager.setMonitorNotifier(new MonitorNotifier(){

            private void dispatchMonitorState(final String string2, final int n2, final Region region, final CallbackContext callbackContext2) {
                LocationManager.this.threadPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        PluginResult pluginResult;
                        JSONObject jSONObject;
                        block9: {
                            JSONObject jSONObject2;
                            1 v0 = this;
                            jSONObject = jSONObject2;
                            jSONObject2 = new JSONObject();
                            jSONObject2.put("eventType", (Object)string2);
                            jSONObject2.put("region", (Object)LocationManager.this.mapOfRegion(region));
                            if (!v0.string2.equals("didDetermineStateForRegion")) break block9;
                            jSONObject.put("state", (Object)LocationManager.this.nameOfRegionState(n2));
                        }
                        1 v2 = this;
                        PluginResult pluginResult2 = pluginResult;
                        try {
                            new PluginResult(PluginResult.Status.OK, jSONObject).setKeepCallback(true);
                            v2.callbackContext2.sendPluginResult(pluginResult2);
                        }
                        catch (Exception exception) {
                            Log.e((String)LocationManager.TAG, (String)("'monitoringDidFailForRegion' exception " + exception.getCause()));
                            LocationManager.this.beaconServiceNotifier.monitoringDidFailForRegion(region, exception);
                        }
                    }
                });
            }

            public void didEnterRegion(Region region) {
                4 v0 = callbackContext2;
                v0.LocationManager.this.debugLog("didEnterRegion INSIDE for " + region.getUniqueId());
                CallbackContext callbackContext2 = v0.callbackContext;
                v0.dispatchMonitorState("didEnterRegion", 1, region, callbackContext2);
            }

            public void didExitRegion(Region region) {
                4 v0 = callbackContext2;
                v0.LocationManager.this.debugLog("didExitRegion OUTSIDE for " + region.getUniqueId());
                CallbackContext callbackContext2 = v0.callbackContext;
                v0.dispatchMonitorState("didExitRegion", 0, region, callbackContext2);
            }

            public void didDetermineStateForRegion(int n2, Region region) {
                4 v0 = callbackContext2;
                v0.LocationManager.this.debugLog("didDetermineStateForRegion '" + callbackContext2.LocationManager.this.nameOfRegionState(n2) + "' for region: " + region.getUniqueId());
                CallbackContext callbackContext2 = v0.callbackContext;
                v0.dispatchMonitorState("didDetermineStateForRegion", n2, region, callbackContext2);
            }
        });
    }

    private void createRangingCallbacks(final CallbackContext callbackContext) {
        this.iBeaconManager.setRangeNotifier(new RangeNotifier(){

            public void didRangeBeaconsInRegion(final Collection<Beacon> collection, final Region region) {
                LocationManager.this.threadPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        PluginResult pluginResult;
                        JSONArray jSONArray;
                        JSONObject jSONObject;
                        1 v0 = this;
                        JSONObject jSONObject2 = jSONObject;
                        jSONObject = new JSONObject();
                        Object object = jSONArray;
                        jSONArray = new JSONArray();
                        Iterator iterator = v0.collection.iterator();
                        while (true) {
                            if (!iterator.hasNext()) break;
                            JSONArray jSONArray2 = object;
                            1 v4 = this;
                            Beacon beacon = (Beacon)iterator.next();
                            jSONArray2.put((Object)v4.LocationManager.this.mapOfBeacon(beacon));
                        }
                        1 v5 = this;
                        1 v6 = v5;
                        1 v7 = v5;
                        JSONObject jSONObject3 = jSONObject2;
                        JSONObject jSONObject4 = jSONObject3;
                        JSONObject jSONObject5 = jSONObject3;
                        jSONObject3.put("eventType", (Object)"didRangeBeaconsInRegion");
                        jSONObject5.put("region", (Object)LocationManager.this.mapOfRegion(region));
                        jSONObject4.put("beacons", object);
                        v6.LocationManager.this.debugLog("didRangeBeacons: " + jSONObject2.toString());
                        object = pluginResult;
                        try {
                            new PluginResult(PluginResult.Status.OK, jSONObject2).setKeepCallback(true);
                            v7.callbackContext.sendPluginResult((PluginResult)object);
                        }
                        catch (Exception exception) {
                            Log.e((String)LocationManager.TAG, (String)("'rangingBeaconsDidFailForRegion' exception " + exception.getCause()));
                            LocationManager.this.beaconServiceNotifier.rangingBeaconsDidFailForRegion(region, exception);
                        }
                    }
                });
            }
        });
    }

    private void createManagerCallbacks(final CallbackContext callbackContext) {
        this.beaconServiceNotifier = new IBeaconServiceNotifier(){

            private void sendFailEvent(String string2, Region region, Exception exception, CallbackContext callbackContext3) {
                JSONObject jSONObject;
                CallbackContext callbackContext2 = callbackContext3;
                JSONObject jSONObject2 = jSONObject;
                new JSONObject().put("eventType", (Object)string2);
                jSONObject2.put("region", (Object)LocationManager.this.mapOfRegion(region));
                jSONObject2.put("error", (Object)exception.getMessage());
                try {
                    PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, jSONObject2);
                    pluginResult.setKeepCallback(true);
                    callbackContext2.sendPluginResult(pluginResult);
                }
                catch (Exception exception2) {
                    Log.e((String)LocationManager.TAG, (String)(string2 + " error " + exception2.getMessage()));
                    callbackContext3.error(string2 + " error " + exception2.getMessage());
                }
            }

            @Override
            public void rangingBeaconsDidFailForRegion(final Region region, final Exception exception) {
                LocationManager.this.threadPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        6 v0 = this_.this;
                        1 v1 = this_;
                        1 this_ = v1.region;
                        Exception exception2 = v1.exception;
                        CallbackContext callbackContext = v0.callbackContext;
                        v0.sendFailEvent("rangingBeaconsDidFailForRegion", (Region)this_, exception2, callbackContext);
                    }
                });
            }

            @Override
            public void monitoringDidFailForRegion(final Region region, final Exception exception) {
                LocationManager.this.threadPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        6 v0 = this_.this;
                        2 v1 = this_;
                        2 this_ = v1.region;
                        Exception exception2 = v1.exception;
                        CallbackContext callbackContext = v0.callbackContext;
                        v0.sendFailEvent("monitoringDidFailForRegionWithError", (Region)this_, exception2, callbackContext);
                    }
                });
            }

            @Override
            public void didStartMonitoringForRegion(final Region region) {
                LocationManager.this.threadPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        PluginResult pluginResult;
                        JSONObject jSONObject;
                        3 v0 = this;
                        3 v1 = v0;
                        3 v2 = v0;
                        JSONObject jSONObject2 = jSONObject;
                        new JSONObject().put("eventType", (Object)"didStartMonitoringForRegion");
                        jSONObject2.put("region", (Object)LocationManager.this.mapOfRegion(region));
                        v1.LocationManager.this.debugLog("didStartMonitoringForRegion: " + jSONObject2.toString());
                        PluginResult pluginResult2 = pluginResult;
                        try {
                            new PluginResult(PluginResult.Status.OK, jSONObject2).setKeepCallback(true);
                            v2.callbackContext.sendPluginResult(pluginResult2);
                        }
                        catch (Exception exception) {
                            Log.e((String)LocationManager.TAG, (String)("'startMonitoringForRegion' exception " + exception.getCause()));
                            this.monitoringDidFailForRegion(region, exception);
                        }
                    }
                });
            }

            @Override
            public void didChangeAuthorizationStatus(final String string2) {
                LocationManager.this.threadPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        PluginResult pluginResult;
                        JSONObject jSONObject;
                        4 v0 = this;
                        4 v1 = v0;
                        4 v2 = v0;
                        JSONObject jSONObject2 = jSONObject;
                        new JSONObject().put("eventType", (Object)"didChangeAuthorizationStatus");
                        jSONObject2.put("authorizationStatus", (Object)string2);
                        v1.LocationManager.this.debugLog("didChangeAuthorizationStatus: " + jSONObject2.toString());
                        PluginResult pluginResult2 = pluginResult;
                        try {
                            new PluginResult(PluginResult.Status.OK, jSONObject2).setKeepCallback(true);
                            v2.callbackContext.sendPluginResult(pluginResult2);
                        }
                        catch (Exception exception) {
                            callbackContext.error("didChangeAuthorizationStatus error: " + exception.getMessage());
                        }
                    }
                });
            }
        };
    }

    private void onDomDelegateReady(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                LocationManager.this.resumeEventPropagationToDom();
                return new PluginResult(PluginResult.Status.OK);
            }
        });
    }

    private void isBluetoothEnabled(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                boolean bl;
                block5: {
                    block4: {
                        try {
                            if (LocationManager.this.bluetoothAdapter == null) break block4;
                        }
                        catch (Exception exception) {
                            LocationManager.this.debugWarn("'isBluetoothEnabled' exception " + exception.getMessage());
                            return new PluginResult(PluginResult.Status.ERROR, exception.getMessage());
                        }
                        if (!LocationManager.this.bluetoothAdapter.isEnabled()) break block4;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                return new PluginResult(PluginResult.Status.OK, bl);
            }
        });
    }

    private void enableBluetooth(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                try {
                    LocationManager.this.bluetoothAdapter.enable();
                }
                catch (Exception exception) {
                    Log.e((String)LocationManager.TAG, (String)("'enableBluetooth' service error: " + exception.getCause()));
                    return new PluginResult(PluginResult.Status.ERROR, exception.getMessage());
                }
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK);
                pluginResult.setKeepCallback(true);
                return pluginResult;
            }
        });
    }

    private void disableBluetooth(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                try {
                    LocationManager.this.bluetoothAdapter.disable();
                }
                catch (Exception exception) {
                    Log.e((String)LocationManager.TAG, (String)("'disableBluetooth' service error: " + exception.getCause()));
                    return new PluginResult(PluginResult.Status.ERROR, exception.getMessage());
                }
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK);
                pluginResult.setKeepCallback(true);
                return pluginResult;
            }
        });
    }

    private void disableDebugNotifications(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                LocationManager.access$1102(LocationManager.this, false);
                BeaconManager.setDebug((boolean)false);
                return new PluginResult(PluginResult.Status.OK);
            }
        });
    }

    private void enableDebugNotifications(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                LocationManager.access$1102(LocationManager.this, true);
                BeaconManager.setDebug((boolean)true);
                return new PluginResult(PluginResult.Status.OK);
            }
        });
    }

    private void disableDebugLogs(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                LocationManager.access$1102(LocationManager.this, false);
                BeaconManager.setDebug((boolean)false);
                return new PluginResult(PluginResult.Status.OK);
            }
        });
    }

    private void enableDebugLogs(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                LocationManager.access$1102(LocationManager.this, true);
                BeaconManager.setDebug((boolean)true);
                return new PluginResult(PluginResult.Status.OK);
            }
        });
    }

    private void appendToDeviceLog(final String string2, CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                String string22 = string2;
                if (string22 != null && !string22.isEmpty()) {
                    LocationManager.this.debugLog("[DOM] " + string2);
                    return new PluginResult(PluginResult.Status.OK, string2);
                }
                return new PluginResult(PluginResult.Status.ERROR, "Log message not provided");
            }
        });
    }

    private void startMonitoringForRegion(final JSONObject jSONObject, CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                16 v0 = this;
                Region region = null;
                region = v0.LocationManager.this.parseRegion(jSONObject);
                v0.LocationManager.this.iBeaconManager.startMonitoringBeaconsInRegion(region);
                try {
                    PluginResult pluginResult = new PluginResult(PluginResult.Status.OK);
                    pluginResult.setKeepCallback(true);
                    LocationManager.this.beaconServiceNotifier.didStartMonitoringForRegion(region);
                    return pluginResult;
                }
                catch (Exception exception) {
                    Log.e((String)LocationManager.TAG, (String)("'startMonitoringForRegion' exception " + exception.getCause()));
                    LocationManager.this.beaconServiceNotifier.monitoringDidFailForRegion(region, exception);
                    return new PluginResult(PluginResult.Status.ERROR, exception.getMessage());
                }
                catch (RemoteException remoteException) {
                    Log.e((String)LocationManager.TAG, (String)("'startMonitoringForRegion' service error: " + remoteException.getCause()));
                    LocationManager.this.beaconServiceNotifier.monitoringDidFailForRegion(region, (Exception)((Object)remoteException));
                    return new PluginResult(PluginResult.Status.ERROR, remoteException.getMessage());
                }
            }
        });
    }

    private void stopMonitoringForRegion(final JSONObject jSONObject, CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                17 v0 = this_;
                17 v1 = v0;
                17 this_ = v0.LocationManager.this.parseRegion(this_.jSONObject);
                try {
                    v1.LocationManager.this.iBeaconManager.stopMonitoringBeaconsInRegion((Region)this_);
                    PluginResult pluginResult = new PluginResult(PluginResult.Status.OK);
                    pluginResult.setKeepCallback(true);
                    return pluginResult;
                }
                catch (Exception exception) {
                    Log.e((String)LocationManager.TAG, (String)("'stopMonitoringForRegion' exception " + exception.getCause()));
                    return new PluginResult(PluginResult.Status.ERROR, exception.getMessage());
                }
                catch (RemoteException remoteException) {
                    Log.e((String)LocationManager.TAG, (String)("'stopMonitoringForRegion' service error: " + remoteException.getCause()));
                    return new PluginResult(PluginResult.Status.ERROR, remoteException.getMessage());
                }
            }
        });
    }

    private void startRangingBeaconsInRegion(final JSONObject jSONObject, CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                18 v0 = this_;
                18 v1 = v0;
                18 this_ = v0.LocationManager.this.parseRegion(this_.jSONObject);
                try {
                    v1.LocationManager.this.iBeaconManager.startRangingBeaconsInRegion((Region)this_);
                    PluginResult pluginResult = new PluginResult(PluginResult.Status.OK);
                    pluginResult.setKeepCallback(true);
                    return pluginResult;
                }
                catch (Exception exception) {
                    Log.e((String)LocationManager.TAG, (String)("'startRangingBeaconsInRegion' exception " + exception.getCause()));
                    return new PluginResult(PluginResult.Status.ERROR, exception.getMessage());
                }
                catch (RemoteException remoteException) {
                    Log.e((String)LocationManager.TAG, (String)("'startRangingBeaconsInRegion' service error: " + remoteException.getCause()));
                    return new PluginResult(PluginResult.Status.ERROR, remoteException.getMessage());
                }
            }
        });
    }

    private void stopRangingBeaconsInRegion(final JSONObject jSONObject, CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                19 v0 = this_;
                19 v1 = v0;
                19 this_ = v0.LocationManager.this.parseRegion(this_.jSONObject);
                try {
                    v1.LocationManager.this.iBeaconManager.stopRangingBeaconsInRegion((Region)this_);
                    PluginResult pluginResult = new PluginResult(PluginResult.Status.OK);
                    pluginResult.setKeepCallback(true);
                    return pluginResult;
                }
                catch (Exception exception) {
                    Log.e((String)LocationManager.TAG, (String)("'stopRangingBeaconsInRegion' exception " + exception.getCause()));
                    return new PluginResult(PluginResult.Status.ERROR, exception.getMessage());
                }
                catch (RemoteException remoteException) {
                    Log.e((String)LocationManager.TAG, (String)("'stopRangingBeaconsInRegion' service error: " + remoteException.getCause()));
                    return new PluginResult(PluginResult.Status.ERROR, remoteException.getMessage());
                }
            }
        });
    }

    private void getAuthorizationStatus(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PluginResult run() {
                JSONObject jSONObject;
                String string2;
                try {
                    if (!LocationManager.this.hasBlueToothPermission()) {
                        return new PluginResult(PluginResult.Status.ERROR, "Application does not BLUETOOTH or BLUETOOTH_ADMIN permissions");
                    }
                    string2 = LocationManager.this.iBeaconManager.checkAvailability() ? "AuthorizationStatusAuthorized" : "AuthorizationStatusDenied";
                }
                catch (Exception exception) {
                    LocationManager.this.debugWarn("'getAuthorizationStatus' exception " + exception.getMessage());
                    return new PluginResult(PluginResult.Status.ERROR, exception.getMessage());
                }
                catch (BleNotAvailableException bleNotAvailableException) {
                    LocationManager.this.debugLog("'getAuthorizationStatus' Device not supported: " + bleNotAvailableException.getMessage());
                    return new PluginResult(PluginResult.Status.ERROR, bleNotAvailableException.getMessage());
                }
                JSONObject jSONObject2 = jSONObject;
                {
                    new JSONObject().put("authorizationStatus", (Object)string2);
                }
                return new PluginResult(PluginResult.Status.OK, jSONObject2);
            }
        });
    }

    private void requestWhenInUseAuthorization(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                return new PluginResult(PluginResult.Status.OK);
            }
        });
    }

    private void requestAlwaysAuthorization(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                return new PluginResult(PluginResult.Status.OK);
            }
        });
    }

    private void getMonitoredRegions(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                JSONArray jSONArray;
                Collection collection = LocationManager.this.iBeaconManager.getMonitoredRegions();
                JSONArray jSONArray2 = jSONArray;
                jSONArray = new JSONArray();
                Iterator iterator = collection.iterator();
                while (true) {
                    if (!iterator.hasNext()) break;
                    JSONArray jSONArray3 = jSONArray2;
                    23 v3 = this;
                    Region region = (Region)iterator.next();
                    jSONArray3.put((Object)v3.LocationManager.this.mapOfRegion(region));
                }
                try {
                    return new PluginResult(PluginResult.Status.OK, jSONArray2);
                }
                catch (JSONException jSONException) {
                    LocationManager.this.debugWarn("'getMonitoredRegions' exception: " + jSONException.getMessage());
                    return new PluginResult(PluginResult.Status.ERROR, jSONException.getMessage());
                }
            }
        });
    }

    private void getRangedRegions(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                JSONArray jSONArray;
                Collection collection = LocationManager.this.iBeaconManager.getRangedRegions();
                JSONArray jSONArray2 = jSONArray;
                jSONArray = new JSONArray();
                Iterator iterator = collection.iterator();
                while (true) {
                    if (!iterator.hasNext()) break;
                    JSONArray jSONArray3 = jSONArray2;
                    24 v3 = this;
                    Region region = (Region)iterator.next();
                    jSONArray3.put((Object)v3.LocationManager.this.mapOfRegion(region));
                }
                try {
                    return new PluginResult(PluginResult.Status.OK, jSONArray2);
                }
                catch (JSONException jSONException) {
                    LocationManager.this.debugWarn("'getRangedRegions' exception: " + jSONException.getMessage());
                    return new PluginResult(PluginResult.Status.ERROR, jSONException.getMessage());
                }
            }
        });
    }

    private void requestStateForRegion(JSONObject jSONObject, CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                PluginResult pluginResult = new PluginResult(PluginResult.Status.ERROR, "Manual request for monitoring update is not supported on Android");
                pluginResult.setKeepCallback(true);
                return pluginResult;
            }
        });
    }

    private void isRangingAvailable(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                boolean bl = LocationManager.this.iBeaconManager.checkAvailability();
                try {
                    return new PluginResult(PluginResult.Status.OK, bl);
                }
                catch (Exception exception) {
                    LocationManager.this.debugWarn("'isRangingAvailable' exception " + exception.getMessage());
                    return new PluginResult(PluginResult.Status.ERROR, exception.getMessage());
                }
                catch (BleNotAvailableException bleNotAvailableException) {
                    LocationManager.this.debugLog("'isRangingAvailable' Device not supported: " + bleNotAvailableException.getMessage());
                    return new PluginResult(PluginResult.Status.ERROR, bleNotAvailableException.getMessage());
                }
            }
        });
    }

    private void registerDelegateCallbackId(JSONObject jSONObject, final CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                27 v0 = this;
                v0.LocationManager.this.debugLog("Registering delegate callback ID: " + callbackContext.getCallbackId());
                v0.LocationManager.this.createMonitorCallbacks(callbackContext);
                v0.LocationManager.this.createRangingCallbacks(callbackContext);
                v0.LocationManager.this.createManagerCallbacks(callbackContext);
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK);
                pluginResult.setKeepCallback(true);
                return pluginResult;
            }
        });
    }

    private void isMonitoringAvailableForClass(final JSONObject jSONObject, CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                boolean bl = true;
                try {
                    LocationManager.this.parseRegion(jSONObject);
                }
                catch (Exception exception) {
                    bl = false;
                }
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, bl);
                pluginResult.setKeepCallback(true);
                return pluginResult;
            }
        });
    }

    private void isAdvertisingAvailable(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                if (Build.VERSION.SDK_INT >= 21) {
                    PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, true);
                    pluginResult.setKeepCallback(true);
                    return pluginResult;
                }
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, false);
                pluginResult.setKeepCallback(true);
                return pluginResult;
            }
        });
    }

    private void isAdvertising(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, false);
                pluginResult.setKeepCallback(true);
                return pluginResult;
            }
        });
    }

    private void startAdvertising(JSONArray jSONArray, CallbackContext callbackContext) {
        this.debugLog("Advertisement start START BEACON ");
        this.debugLog(jSONArray.toString(4));
        Object object = jSONArray.optJSONObject(0);
        object.getString("identifier");
        final String string2 = object.has("uuid") && !object.isNull("uuid") ? object.getString("uuid") : null;
        final String string3 = object.has("major") && !object.isNull("major") ? object.getString("major") : null;
        object = object.has("minor") && !object.isNull("minor") ? object.getString("minor") : null;
        int n2 = jSONArray.length() > 1 ? jSONArray.getInt(1) : -55;
        if (string3 == null && object != null) {
            throw new UnsupportedOperationException("Unsupported combination of 'major' and 'minor' parameters.");
        }
        this._handleCallSafely(callbackContext, new ILocationManagerCommand((String)object, n2){
            final /* synthetic */ String val$minor;
            final /* synthetic */ int val$measuredPower;
            {
                this.val$minor = string4;
                this.val$measuredPower = n2;
            }

            @Override
            public PluginResult run() {
                31 v0 = this;
                v0.LocationManager.this.debugLog("Advertisement start STEP Beacon.Builder ");
                Beacon beacon = new Beacon.Builder().setId1(string2).setId2(string3).setId3(this.val$minor).setManufacturer(76).setTxPower(this.val$measuredPower).setDataFields(Arrays.asList(0L)).build();
                v0.LocationManager.this.debugLog("[DEBUG] Beacon.Builder: " + beacon);
                v0.LocationManager.this.debugLog("Advertisement start STEP BeaconParser ");
                v0.LocationManager.this.debugLog("Advertisement start STEP BeaconTransmitter ");
                BeaconTransmitter beaconTransmitter = v0.LocationManager.this.createOrGetBeaconTransmitter();
                LocationManager.this.debugLog("[DEBUG] BeaconTransmitter: " + beaconTransmitter);
                beaconTransmitter.startAdvertising(beacon, new AdvertiseCallback(){

                    public void onStartFailure(int n2) {
                        LocationManager.this.debugWarn("Advertisement start failed with code: " + n2);
                    }

                    public void onStartSuccess(AdvertiseSettings advertiseSettings) {
                        LocationManager.this.debugWarn("startAdvertising start succeeded.");
                    }
                });
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, false);
                pluginResult.setKeepCallback(true);
                return pluginResult;
            }
        });
    }

    private void stopAdvertising(CallbackContext callbackContext) {
        this._handleCallSafely(callbackContext, new ILocationManagerCommand(){

            @Override
            public PluginResult run() {
                32 v0 = this;
                v0.LocationManager.this.debugInfo("LocationManager::stopAdvertising::STOPPING...");
                v0.LocationManager.this.createOrGetBeaconTransmitter().stopAdvertising();
                v0.LocationManager.this.debugInfo("LocationManager::stopAdvertising::DONE");
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, "iBeacon Advertising stopped.");
                pluginResult.setKeepCallback(true);
                return pluginResult;
            }
        });
    }

    private Region parseRegion(JSONObject jSONObject) {
        if (jSONObject.has("typeName")) {
            if (jSONObject.has("identifier")) {
                String string2 = jSONObject.getString("typeName");
                if (string2.equals("BeaconRegion")) {
                    return this.parseBeaconRegion(jSONObject);
                }
                if (string2.equals("CircularRegion")) {
                    return this.parseCircularRegion(jSONObject);
                }
                throw new UnsupportedOperationException("Unsupported region type");
            }
            throw new InvalidKeyException("'identifier' is missing, cannot parse Region.");
        }
        throw new InvalidKeyException("'typeName' is missing, cannot parse Region.");
    }

    private Region parseCircularRegion(JSONObject jSONObject) {
        if (jSONObject.has("latitude")) {
            if (jSONObject.has("longitude")) {
                if (!jSONObject.has("radius")) {
                    throw new InvalidKeyException("'radius' is missing, cannot parse CircularRegion.");
                }
                throw new UnsupportedOperationException("Circular regions are not supported at present");
            }
            throw new InvalidKeyException("'longitude' is missing, cannot parse CircularRegion.");
        }
        throw new InvalidKeyException("'latitude' is missing, cannot parse CircularRegion.");
    }

    private Region parseBeaconRegion(JSONObject object) {
        JSONObject jSONObject = object;
        String string2 = jSONObject.getString("identifier");
        String string3 = jSONObject.has("uuid") && !object.isNull("uuid") ? object.getString("uuid") : null;
        String string4 = object.has("major") && !object.isNull("major") ? object.getString("major") : null;
        object = object.has("minor") && !object.isNull("minor") ? object.getString("minor") : null;
        if (string4 == null && object != null) {
            throw new UnsupportedOperationException("Unsupported combination of 'major' and 'minor' parameters.");
        }
        string3 = string3 != null ? Identifier.parse((String)string3) : null;
        string4 = string4 != null ? Identifier.parse((String)string4) : null;
        object = object != null ? Identifier.parse((String)object) : null;
        return new Region(string2, (Identifier)string3, (Identifier)string4, (Identifier)object);
    }

    private String nameOfRegionState(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                return "ErrorUnknownCLRegionStateObjectReceived";
            }
            return "CLRegionStateInside";
        }
        return "CLRegionStateOutside";
    }

    private JSONObject mapOfRegion(Region region) {
        return this.mapOfBeaconRegion(region);
    }

    private JSONObject mapOfBeaconRegion(Region region) {
        JSONObject jSONObject;
        LocationManager locationManager = jSONObject;
        jSONObject = new JSONObject();
        if (region.getUniqueId() != null) {
            locationManager.put("identifier", region.getUniqueId());
        }
        locationManager.put("uuid", region.getId1());
        if (region.getId2() != null) {
            locationManager.put("major", region.getId2());
        }
        if (region.getId3() != null) {
            locationManager.put("minor", region.getId3());
        }
        LocationManager locationManager2 = locationManager;
        locationManager2.put("typeName", "BeaconRegion");
        return locationManager2;
    }

    private JSONObject mapOfBeacon(Beacon beacon) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject2.put("uuid", (Object)beacon.getId1());
        jSONObject2.put("major", (Object)beacon.getId2());
        jSONObject2.put("minor", (Object)beacon.getId3());
        jSONObject2.put("proximity", (Object)this.nameOfProximity(beacon.getDistance()));
        jSONObject2.put("rssi", beacon.getRssi());
        jSONObject2.put("tx", beacon.getTxPower());
        double d2 = (double)Math.round(beacon.getDistance() * 100.0) / 100.0;
        jSONObject.put("accuracy", d2);
        return jSONObject;
    }

    private String nameOfProximity(double d2) {
        if (d2 < 0.0) {
            return "ProximityUnknown";
        }
        if (d2 < 0.5) {
            return "ProximityImmediate";
        }
        if (d2 <= 4.0) {
            return "ProximityNear";
        }
        return "ProximityFar";
    }

    private boolean hasBlueToothPermission() {
        LocationManager locationManager = locationManager.cordova.getActivity();
        int n2 = locationManager.checkCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN");
        return locationManager.checkCallingOrSelfPermission("android.permission.BLUETOOTH") == 0 && n2 == 0;
    }

    private void _handleCallSafely(CallbackContext callbackContext, ILocationManagerCommand iLocationManagerCommand) {
        this._handleCallSafely(callbackContext, iLocationManagerCommand, true);
    }

    private void _handleCallSafely(final CallbackContext callbackContext, final ILocationManagerCommand iLocationManagerCommand, boolean bl) {
        if (bl) {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... voidArray) {
                    try {
                        LocationManager.this._sendResultOfCommand(callbackContext, iLocationManagerCommand.run());
                    }
                    catch (Exception exception) {
                        LocationManager.this._handleExceptionOfCommand(callbackContext, exception);
                    }
                    return null;
                }
            }.execute((Object[])new Void[0]);
        } else {
            try {
                this._sendResultOfCommand(callbackContext, iLocationManagerCommand.run());
            }
            catch (Exception exception) {
                this._handleExceptionOfCommand(callbackContext, exception);
            }
        }
    }

    private void _handleExceptionOfCommand(CallbackContext callbackContext, Exception exception) {
        Log.e((String)TAG, (String)("Uncaught exception: " + exception.getMessage()));
        Log.e((String)TAG, (String)("Stack trace: " + Arrays.toString(exception.getStackTrace())));
        if (callbackContext == null) {
            return;
        }
        callbackContext.error(exception.getMessage());
    }

    private void _sendResultOfCommand(CallbackContext callbackContext, PluginResult pluginResult) {
        if (pluginResult.getStatus() != PluginResult.Status.OK.ordinal()) {
            this.debugWarn("WARNING: " + PluginResult.StatusMessages[pluginResult.getStatus()]);
        }
        if (callbackContext == null) {
            return;
        }
        callbackContext.sendPluginResult(pluginResult);
    }

    private void debugInfo(String string2) {
        if (this.debugEnabled) {
            Log.i((String)TAG, (String)string2);
        }
    }

    private void debugLog(String string2) {
        if (this.debugEnabled) {
            Log.d((String)TAG, (String)string2);
        }
    }

    private void debugWarn(String string2) {
        if (this.debugEnabled) {
            Log.w((String)TAG, (String)string2);
        }
    }

    static /* synthetic */ boolean access$1102(LocationManager locationManager, boolean bl) {
        locationManager.debugEnabled = bl;
        return bl;
    }

    @Override
    public void initialize(CordovaInterface cordovaInterface, CordovaWebView cordovaWebView) {
        LocationManager locationManager = this;
        super.initialize(cordovaInterface, cordovaWebView);
        Activity activity = cordovaInterface.getActivity();
        LocationManager locationManager2 = this;
        int n2 = locationManager2.preferences.getInteger(FOREGROUND_BETWEEN_SCAN_PERIOD_NAME, 0);
        int n3 = locationManager2.preferences.getInteger(FOREGROUND_SCAN_PERIOD_NAME, 1100);
        Log.i((String)TAG, (String)("Determined config value FOREGROUND_SCAN_PERIOD: " + String.valueOf(n3)));
        locationManager.iBeaconManager = BeaconManager.getInstanceForApplication((Context)activity);
        locationManager.iBeaconManager.setForegroundBetweenScanPeriod((long)n2);
        locationManager.iBeaconManager.setForegroundScanPeriod((long)n3);
        n2 = locationManager.preferences.getInteger(SAMPLE_EXPIRATION_MILLISECOND, 20000);
        Log.i((String)TAG, (String)("Determined config value SAMPLE_EXPIRATION_MILLISECOND: " + String.valueOf(n2)));
        if (locationManager.preferences.getBoolean(ENABLE_ARMA_FILTER_NAME, false)) {
            BeaconManager.setRssiFilterImplClass(ArmaRssiFilter.class);
        } else {
            BeaconManager.setRssiFilterImplClass(RunningAverageRssiFilter.class);
            RunningAverageRssiFilter.setSampleExpirationMilliseconds((long)n2);
        }
        LocationManager locationManager3 = this;
        RangedBeacon.setSampleExpirationMilliseconds((long)n2);
        locationManager3.initBluetoothListener();
        locationManager3.initEventQueue();
        locationManager3.pauseEventPropagationToDom();
        locationManager3.initLocationManager();
        locationManager3.debugEnabled = true;
        if (Build.VERSION.SDK_INT >= 18) {
            this.initBluetoothAdapter();
        }
        if (this.preferences.getBoolean(REQUEST_BT_PERMISSION_NAME, true)) {
            this.tryToRequestMarshmallowLocationPermission();
        }
    }

    @Override
    public void onDestroy() {
        LocationManager locationManager = this;
        locationManager.iBeaconManager.unbind((BeaconConsumer)this);
        if (locationManager.broadcastReceiver != null) {
            this.cordova.getActivity().unregisterReceiver(this.broadcastReceiver);
            this.broadcastReceiver = null;
        }
        super.onDestroy();
    }

    @Override
    public boolean execute(String string2, JSONArray jSONArray, CallbackContext callbackContext) {
        block28: {
            block3: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block18: {
                                                        block17: {
                                                            block16: {
                                                                block15: {
                                                                    block14: {
                                                                        block13: {
                                                                            block12: {
                                                                                block11: {
                                                                                    block10: {
                                                                                        block9: {
                                                                                            block8: {
                                                                                                block7: {
                                                                                                    block6: {
                                                                                                        block5: {
                                                                                                            block4: {
                                                                                                                block2: {
                                                                                                                    if (!string2.equals("onDomDelegateReady")) break block2;
                                                                                                                    this.onDomDelegateReady(callbackContext);
                                                                                                                    break block3;
                                                                                                                }
                                                                                                                if (!string2.equals("disableDebugNotifications")) break block4;
                                                                                                                this.disableDebugNotifications(callbackContext);
                                                                                                                break block3;
                                                                                                            }
                                                                                                            if (!string2.equals("enableDebugNotifications")) break block5;
                                                                                                            this.enableDebugNotifications(callbackContext);
                                                                                                            break block3;
                                                                                                        }
                                                                                                        if (!string2.equals("disableDebugLogs")) break block6;
                                                                                                        this.disableDebugLogs(callbackContext);
                                                                                                        break block3;
                                                                                                    }
                                                                                                    if (!string2.equals("enableDebugLogs")) break block7;
                                                                                                    this.enableDebugLogs(callbackContext);
                                                                                                    break block3;
                                                                                                }
                                                                                                if (!string2.equals("appendToDeviceLog")) break block8;
                                                                                                this.appendToDeviceLog(jSONArray.optString(0), callbackContext);
                                                                                                break block3;
                                                                                            }
                                                                                            if (!string2.equals("startMonitoringForRegion")) break block9;
                                                                                            this.startMonitoringForRegion(jSONArray.optJSONObject(0), callbackContext);
                                                                                            break block3;
                                                                                        }
                                                                                        if (!string2.equals("stopMonitoringForRegion")) break block10;
                                                                                        this.stopMonitoringForRegion(jSONArray.optJSONObject(0), callbackContext);
                                                                                        break block3;
                                                                                    }
                                                                                    if (!string2.equals("startRangingBeaconsInRegion")) break block11;
                                                                                    this.startRangingBeaconsInRegion(jSONArray.optJSONObject(0), callbackContext);
                                                                                    break block3;
                                                                                }
                                                                                if (!string2.equals("stopRangingBeaconsInRegion")) break block12;
                                                                                this.stopRangingBeaconsInRegion(jSONArray.optJSONObject(0), callbackContext);
                                                                                break block3;
                                                                            }
                                                                            if (!string2.equals("isRangingAvailable")) break block13;
                                                                            this.isRangingAvailable(callbackContext);
                                                                            break block3;
                                                                        }
                                                                        if (!string2.equals("getAuthorizationStatus")) break block14;
                                                                        this.getAuthorizationStatus(callbackContext);
                                                                        break block3;
                                                                    }
                                                                    if (!string2.equals("requestWhenInUseAuthorization")) break block15;
                                                                    this.requestWhenInUseAuthorization(callbackContext);
                                                                    break block3;
                                                                }
                                                                if (!string2.equals("requestAlwaysAuthorization")) break block16;
                                                                this.requestAlwaysAuthorization(callbackContext);
                                                                break block3;
                                                            }
                                                            if (!string2.equals("getMonitoredRegions")) break block17;
                                                            this.getMonitoredRegions(callbackContext);
                                                            break block3;
                                                        }
                                                        if (!string2.equals("getRangedRegions")) break block18;
                                                        this.getRangedRegions(callbackContext);
                                                        break block3;
                                                    }
                                                    if (!string2.equals("requestStateForRegion")) break block19;
                                                    this.requestStateForRegion(jSONArray.optJSONObject(0), callbackContext);
                                                    break block3;
                                                }
                                                if (!string2.equals("registerDelegateCallbackId")) break block20;
                                                this.registerDelegateCallbackId(jSONArray.optJSONObject(0), callbackContext);
                                                break block3;
                                            }
                                            if (!string2.equals("isMonitoringAvailableForClass")) break block21;
                                            this.isMonitoringAvailableForClass(jSONArray.optJSONObject(0), callbackContext);
                                            break block3;
                                        }
                                        if (!string2.equals("isAdvertisingAvailable")) break block22;
                                        this.isAdvertisingAvailable(callbackContext);
                                        break block3;
                                    }
                                    if (!string2.equals("isAdvertising")) break block23;
                                    this.isAdvertising(callbackContext);
                                    break block3;
                                }
                                if (!string2.equals("startAdvertising")) break block24;
                                this.startAdvertising(jSONArray, callbackContext);
                                break block3;
                            }
                            if (!string2.equals("stopAdvertising")) break block25;
                            this.stopAdvertising(callbackContext);
                            break block3;
                        }
                        if (!string2.equals("isBluetoothEnabled")) break block26;
                        this.isBluetoothEnabled(callbackContext);
                        break block3;
                    }
                    if (!string2.equals("enableBluetooth")) break block27;
                    this.enableBluetooth(callbackContext);
                    break block3;
                }
                if (!string2.equals("disableBluetooth")) break block28;
                this.disableBluetooth(callbackContext);
            }
            return true;
        }
        return false;
    }

    public void onBeaconServiceConnect() {
        this.debugLog("Connected to IBeacon service");
    }

    public Context getApplicationContext() {
        return this.cordova.getActivity();
    }

    public void unbindService(ServiceConnection serviceConnection) {
        LocationManager locationManager = this;
        locationManager.debugLog("Unbind from IBeacon service");
        locationManager.cordova.getActivity().unbindService(serviceConnection);
    }

    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int n2) {
        LocationManager locationManager = this;
        locationManager.debugLog("Bind to IBeacon service");
        return locationManager.cordova.getActivity().bindService(intent, serviceConnection, n2);
    }
}

