/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import com.sails.engine.LocationRegion;
import com.sails.engine.MapView;
import com.sails.engine.MapViewPosition;
import com.sails.engine.MarkerManager;
import com.sails.engine.PathRoutingManager;
import com.sails.engine.PinMarkerManager;
import com.sails.engine.SAILS;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.MapPosition;
import com.sails.engine.overlay.Circle;
import com.sails.engine.overlay.ListOverlay;
import com.sails.engine.overlay.MapJPGOverlay;
import com.sails.engine.overlay.Marker;
import com.sails.engine.overlay.OrientationMarker;
import com.sails.engine.overlay.PolygonalChain;
import com.sails.engine.overlay.Polyline;
import com.sails.engine.overlay.ScreenDensity;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class SAILSMapView
extends MapView
implements Serializable {
    public static int GENERAL = 0;
    public static int LOCATION_CENTER_LOCK = 1;
    public static int FOLLOW_PHONE_HEADING = 2;
    public static int AUTO_FLOOR_SWITCH = 4;
    public static int ALWAYS_LOCK_MAP = 8;
    final Context a;
    private MarkerManager w;
    private PathRoutingManager x;
    private PinMarkerManager y;
    private Paint z;
    SAILS b;
    private OrientationMarker A;
    private Bitmap B;
    private Bitmap C;
    private ListOverlay D;
    private ListOverlay E;
    private ListOverlay F;
    private List<SAILS.GeoNode> G;
    private Paint H;
    MapJPGOverlay c;
    private Polyline I;
    private Marker J;
    private Circle K;
    private int L;
    private boolean M;
    private String N;
    private double O;
    OnMoveListener d;
    OnModeChangedListener e;
    OnZoomChangedListener f;
    OnRegionClickListener g;
    OnRegionLongClickListener h;
    OnClickNothingListener s;
    OnFloorChangedListener t;
    OnMapClickListener u;
    private String P;
    private int Q;
    private boolean R;
    OnFeedPathListCallBack v;
    private a S;
    private boolean T;
    private boolean U;

    public SAILSMapView(Context context) {
        this(context, null);
    }

    public SAILSMapView(Context context, AttributeSet attributeSet) {
        SAILSMapView sAILSMapView = this;
        super(context, attributeSet);
        this.w = new MarkerManager(this);
        this.x = null;
        this.y = new PinMarkerManager(this);
        this.b = null;
        this.A = new OrientationMarker(new GeoPoint(0.0, 0.0), null);
        this.B = null;
        this.C = null;
        this.D = new ListOverlay();
        this.E = new ListOverlay();
        this.F = new ListOverlay();
        this.G = new ArrayList<SAILS.GeoNode>();
        this.H = new Paint(1);
        this.c = new MapJPGOverlay(null);
        this.M = false;
        this.N = "1";
        this.O = 0.28;
        this.d = null;
        this.e = null;
        this.f = null;
        this.g = null;
        this.h = null;
        this.s = null;
        this.t = null;
        this.u = null;
        this.P = "";
        this.Q = Integer.MAX_VALUE;
        this.R = false;
        this.v = null;
        this.S = new a(this);
        this.T = false;
        this.U = false;
        sAILSMapView.a = context;
        sAILSMapView.getOverlays().add(this.F);
        sAILSMapView.getDynamicOverlays().add(this.D);
        sAILSMapView.getDynamicOverlays().add(this.E);
        sAILSMapView.setJPGOverlay(sAILSMapView.c);
        sAILSMapView.c.mMapView = this;
        sAILSMapView.z = new Paint(1);
        sAILSMapView.z.setStyle(Paint.Style.FILL);
        sAILSMapView.z.setColor(Color.rgb((int)53, (int)179, (int)229));
        sAILSMapView.z.setAlpha(40);
        sAILSMapView.z.setStrokeWidth(5.0f);
        sAILSMapView.z.setStrokeJoin(Paint.Join.ROUND);
        sAILSMapView.M = true;
        sAILSMapView.p = new MapView.ZoomFinishCallback(){

            @Override
            public void onZoomFinish() {
                SAILSMapView.this.d();
            }
        };
    }

    private void e() {
        if (!this.isBaseMapLoaded) {
            File file;
            File file2 = this.b.a("-20");
            if (file2 == null) {
                return;
            }
            File file3 = file;
            if (!new File(file2.getParentFile(), "render.xml").exists()) {
                return;
            }
            this.a(file2, file3);
        }
    }

    static Bitmap a(File file, int n2, int n3) {
        BitmapFactory.Options options;
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options2);
        options.inSampleSize = SAILSMapView.a(options, n2, n3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options2);
    }

    static int a(BitmapFactory.Options options, int n2, int n3) {
        int n4 = options.outHeight;
        int n5 = options.outWidth;
        int n6 = 1;
        if (n4 > n3 || n5 > n2) {
            int n7 = n5;
            n5 = n4 / 2;
            n4 = n7 / 2;
            while (n5 / n6 > n3 && n4 / n6 > n2) {
                n6 *= 2;
            }
        }
        return n6;
    }

    private Bitmap a(Context context, int n2) {
        return BitmapFactory.decodeStream((InputStream)context.getResources().openRawResource(n2), null, (BitmapFactory.Options)this.a(1));
    }

    private BitmapFactory.Options a(int n2) {
        new BitmapFactory.Options().inSampleSize = n2;
        return new BitmapFactory.Options();
    }

    private Bitmap a(Bitmap bitmap, int n2) {
        float f2 = 1.0f;
        if (this.getResources() != null) {
            f2 = this.getResources().getDisplayMetrics().density;
        }
        int n3 = (int)((float)n2 * f2 + 0.5f);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n3, (int)n3, (boolean)true);
    }

    private GeoPoint a(GeoPoint geoPoint, double d2) {
        int n2 = this.L;
        int n3 = LOCATION_CENTER_LOCK;
        if ((n2 & n3) == n3 && (n2 & (n2 = FOLLOW_PHONE_HEADING)) == n2) {
            SAILSMapView sAILSMapView = this;
            geoPoint = sAILSMapView.getProjection().toPixels(geoPoint, null);
            d2 = -d2;
            ((Point)geoPoint).y = (int)((double)((Point)geoPoint).y + (double)((float)(-this.getHeight()) / ScreenDensity.density) * this.O * Math.cos(Math.toRadians(d2)));
            ((Point)geoPoint).x = (int)((double)((Point)geoPoint).x + (double)((float)(-this.getHeight()) / ScreenDensity.density) * this.O * Math.sin(Math.toRadians(d2)));
            return sAILSMapView.getProjection().fromPixels(((Point)geoPoint).x, ((Point)geoPoint).y);
        }
        return geoPoint;
    }

    public void setSAILSEngine(SAILS sAILS) {
        sAILS = this.b = sAILS;
        if (sAILS.m == null) {
            sAILS.m = this;
        }
        if (this.x == null) {
            this.x = new PathRoutingManager(this);
        }
        ScreenDensity.density = this.getResources().getDisplayMetrics().density;
    }

    public void setBaseMapFloorName(@NonNull String string2) {
        this.N = string2;
    }

    public void setNavigationModeYOffsetHeightRatio(double d2) {
        this.O = d2;
    }

    public boolean isCenterLock() {
        return (this.L & LOCATION_CENTER_LOCK) != 0;
    }

    public void setCenterLock(boolean bl) {
        block3: {
            OnModeChangedListener onModeChangedListener;
            block4: {
                block2: {
                    if (!bl) break block2;
                    SAILSMapView sAILSMapView = this;
                    sAILSMapView.L |= LOCATION_CENTER_LOCK;
                    onModeChangedListener = sAILSMapView.e;
                    if (onModeChangedListener == null) break block3;
                    break block4;
                }
                SAILSMapView sAILSMapView = this;
                sAILSMapView.L &= ~LOCATION_CENTER_LOCK;
                onModeChangedListener = sAILSMapView.e;
                if (onModeChangedListener == null) break block3;
            }
            onModeChangedListener.onModeChanged(this.L);
        }
    }

    public int getMode() {
        return this.L;
    }

    public void setMode(int n2) {
        if (((SAILSMapView)((Object)onModeChangedListener)).L != n2) {
            ((SAILSMapView)((Object)onModeChangedListener)).L = n2;
            int n3 = LOCATION_CENTER_LOCK;
            if ((n2 & n3) == n3 && (n2 & (n3 = FOLLOW_PHONE_HEADING)) != n3) {
                ((SAILSMapView)((Object)onModeChangedListener)).setAnimatingToRotationAngle(0.0f);
            }
            SAILSMapView sAILSMapView = onModeChangedListener;
            sAILSMapView.S.a();
            OnModeChangedListener onModeChangedListener = sAILSMapView.e;
            if (onModeChangedListener != null) {
                onModeChangedListener.onModeChanged(n2);
            }
        }
    }

    public String getCurrentBrowseFloorName() {
        if (!this.P.equals("")) {
            return this.P;
        }
        return null;
    }

    @Override
    public MapViewPosition getMapViewPosition() {
        return super.getMapViewPosition();
    }

    public PinMarkerManager getPinMarkerManager() {
        return this.y;
    }

    public MarkerManager getMarkerManager() {
        return this.w;
    }

    public PathRoutingManager getRoutingManager() {
        return this.x;
    }

    public boolean isInLocationFloor() {
        SAILS sAILS = this.b;
        if (sAILS == null) {
            return false;
        }
        return sAILS.getFloor().equals(this.P);
    }

    public void setLocationMarker(int n2, int n3, Paint paint, int n4) {
        if (n2 != 0) {
            SAILSMapView sAILSMapView = this;
            sAILSMapView.B = sAILSMapView.a(sAILSMapView.a(sAILSMapView.a, n2), n4);
        }
        if (n3 != 0) {
            SAILSMapView sAILSMapView = this;
            sAILSMapView.C = sAILSMapView.a(sAILSMapView.a(sAILSMapView.a, n3), n4);
        }
        if (paint != null) {
            this.z = paint;
        }
        this.setLocatorMarkerVisible(true);
    }

    void a(int n2, SAILS.GeoNode geoNode) {
        SAILSMapView sAILSMapView = this;
        Drawable drawable = sAILSMapView.a.getResources().getDrawable(n2);
        Marker marker = sAILSMapView.J;
        if (marker == null) {
            this.J = new Marker(new GeoPoint(geoNode.latitude, geoNode.longitude), Marker.boundCenterBottom(drawable));
            this.E.getOverlayItems().add(this.J);
        } else {
            marker.setDrawable(Marker.boundCenterBottom(drawable));
            this.J.setGeoPoint(new GeoPoint(geoNode.latitude, geoNode.longitude));
        }
    }

    public void setLocatorMarkerVisible(boolean bl) {
        if (!bl) {
            SAILSMapView sAILSMapView = this;
            sAILSMapView.S.c();
            if (sAILSMapView.D.getOverlayItems().indexOf(this.A) >= 0) {
                SAILSMapView sAILSMapView2 = this;
                sAILSMapView2.D.getOverlayItems().remove(this.A);
                sAILSMapView2.D.getOverlayItems().remove(this.K);
            }
        } else {
            if (this.A != null) {
                if (!this.getDynamicOverlays().contains(this.D)) {
                    this.getDynamicOverlays().add(this.D);
                }
                if (this.D.getOverlayItems().indexOf(this.A) < 0) {
                    SAILSMapView sAILSMapView = this;
                    sAILSMapView.A.setBitmap(null);
                    sAILSMapView.K = new Circle(new GeoPoint(0.0, 0.0), 0.0f, this.z, null);
                    sAILSMapView.K.setRadius(0.0f);
                    sAILSMapView.D.getOverlayItems().add(this.K);
                    sAILSMapView.D.getOverlayItems().add(this.A);
                }
            }
            this.S.d();
        }
    }

    void setGoalMarkerVisible(boolean bl) {
        if (!bl) {
            if (this.E.getOverlayItems().indexOf(this.J) >= 0) {
                this.E.getOverlayItems().remove(this.J);
            }
        } else if (this.J != null && this.E.getOverlayItems().indexOf(this.J) < 0) {
            this.E.getOverlayItems().add(this.J);
        }
    }

    void setPathVisible(boolean bl) {
        if (!bl) {
            if (this.F.getOverlayItems().indexOf(this.I) >= 0) {
                this.F.getOverlayItems().remove(this.I);
            }
        } else if (this.F.getOverlayItems().indexOf(this.I) < 0) {
            this.F.getOverlayItems().add(this.I);
        }
    }

    void setAutoRefreshLocation(boolean bl) {
        if (!bl) {
            this.b.setOnLocationChangeEventListener(null);
        }
    }

    public void lockMapRotationOnTraceAngle(boolean bl) {
        this.M = bl;
    }

    public void clear() {
        this.clearMap();
    }

    public void enableRotate(boolean bl) {
        this.l = bl;
    }

    public void enableZoomInOut(boolean bl) {
        this.m = bl;
    }

    public void setOnRegionClickListener(OnRegionClickListener onRegionClickListener) {
        this.g = onRegionClickListener;
    }

    public void setOnRegionLongClickListener(OnRegionLongClickListener onRegionLongClickListener) {
        this.h = onRegionLongClickListener;
    }

    public void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.u = onMapClickListener;
    }

    public void setOnFloorChangedListener(OnFloorChangedListener onFloorChangedListener) {
        this.t = onFloorChangedListener;
    }

    public void setOnClickNothingListener(OnClickNothingListener onClickNothingListener) {
        this.s = onClickNothingListener;
    }

    public void setOnModeChangedListener(OnModeChangedListener onModeChangedListener) {
        this.e = onModeChangedListener;
    }

    public void setOnMoveListener(OnMoveListener onMoveListener) {
        this.d = onMoveListener;
    }

    public void setOnZoomChangedListener(OnZoomChangedListener onZoomChangedListener) {
        this.f = onZoomChangedListener;
    }

    public boolean loadCurrentLocationFloorMap() {
        if (this.P.equals(this.b.getFloor())) {
            return true;
        }
        SAILSMapView sAILSMapView = this;
        return sAILSMapView.loadFloorMap(sAILSMapView.b.getFloor());
    }

    void a() {
        this.R = true;
    }

    public boolean loadFloorMap(String object) {
        if (this.b == null) {
            return false;
        }
        SAILSMapView sAILSMapView = this;
        sAILSMapView.e();
        Object object2 = sAILSMapView.R ? SAILSMapFormat.JPG : this.b.getMapFormat((String)object);
        if (object2 == SAILSMapFormat.VOID) {
            return false;
        }
        if (!this.P.equals(object)) {
            this.stopAnimation();
        }
        if (this.t != null && !this.P.equals("")) {
            this.t.onFloorChangedBefore(this.P);
        }
        SAILSMapView sAILSMapView2 = this;
        sAILSMapView2.P = object;
        sAILSMapView2.baseMapMaskEnabled = sAILSMapView2.P.equals(this.N) ^ true;
        sAILSMapView2.w.a();
        sAILSMapView2.y.refreshMarker();
        if (sAILSMapView2.b.getFloor().equals(this.P)) {
            if (!this.getDynamicOverlays().contains(this.D)) {
                this.getDynamicOverlays().add(this.D);
            }
        } else {
            this.setCenterLock(false);
        }
        SAILSMapView sAILSMapView3 = this;
        sAILSMapView3.clearMap();
        sAILSMapView3.setJPGOverlay(null);
        sAILSMapView3.redraw();
        if (object2 == SAILSMapFormat.Vector) {
            File file;
            if ((object = this.b.a((String)object)) == null) {
                return false;
            }
            object2 = file;
            if (!new File(((File)object).getParentFile(), "render.xml").exists()) {
                return false;
            }
            SAILSMapView sAILSMapView4 = this;
            sAILSMapView4.setMapAndRenderFile((File)object, (File)object2);
            sAILSMapView4.setJPGOverlay(null);
            object = sAILSMapView4.t;
            if (object != null) {
                object.onFloorChangedAfter(this.P);
            }
            return true;
        }
        if (object2 == SAILSMapFormat.JPG) {
            this.R = false;
            if ((object = this.b.b((String)object)) == null) {
                return false;
            }
            if (this.c.isLoadMap()) {
                this.c.clear();
            }
            SAILSMapView sAILSMapView5 = this;
            object = SAILSMapView.a((File)object, 384, 512);
            sAILSMapView5.c.loadJPGMap((Bitmap)object);
            sAILSMapView5.setJPGOverlay(sAILSMapView5.c);
            sAILSMapView5.getRidOfMapBoundary();
            sAILSMapView5.getMapZoomControls().b(14.0f);
            sAILSMapView5.getMapZoomControls().a(22.0f);
            sAILSMapView5.clearMap();
            sAILSMapView5.redrawMapItems();
            sAILSMapView5.getMapViewPosition().setMapPosition(new MapPosition(this.c.getBMPCenter(), 15.0f));
            sAILSMapView5.setRotationAngle(0.0f);
            object = sAILSMapView5.t;
            if (object != null) {
                object.onFloorChangedAfter(this.P);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
        SAILSMapView sAILSMapView = this;
        super.onSaveInstanceState(bundle);
        bundle.putString("sailsmap_floor", sAILSMapView.P);
        bundle.putInt("sailsmap_mode", this.L);
        if (this.b != null) {
            bundle.putBoolean("sailsmap_sailsengine_started", this.T);
        }
    }

    @Override
    public void loadSavedInstanceState(Bundle bundle) {
        Object object;
        super.loadSavedInstanceState(bundle);
        this.loadFloorMap(bundle.getString("sailsmap_floor"));
        if (bundle.getBoolean("sailsmap_sailsengine_started", false) && (object = this.b) != null) {
            Runnable runnable;
            ((SAILS)object).startLocatingEngine();
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    SAILSMapView.this.setLocatorMarkerVisible(true);
                }
            };
            new Handler().postDelayed((Runnable)object, 100L);
        }
        this.L = bundle.getInt("sailsmap_mode", GENERAL);
    }

    @Override
    public void autoSetMapZoomAndView() {
        super.autoSetMapZoomAndView();
    }

    @Override
    public void autoSetMapZoomAndView(List<GeoPoint> list) {
        super.autoSetMapZoomAndView(list);
    }

    @Override
    public void autoSetMapZoomAndView(List<GeoPoint> list, int n2) {
        super.autoSetMapZoomAndView(list, n2);
    }

    @Override
    public float getRotationAngle() {
        return super.getRotationAngle();
    }

    @Override
    public void redraw() {
        super.redraw();
    }

    @Override
    public void setAnimatingToRotationAngle(float f2) {
        super.setAnimatingToRotationAngle(f2);
    }

    @Override
    public void setAnimationToZoom(float f2) {
        super.setAnimationToZoom(f2);
    }

    @Override
    public void setRotationAngle(float f2) {
        super.setRotationAngle(f2);
    }

    @Override
    public void setAnimationMoveMapTo(GeoPoint geoPoint) {
        super.setAnimationMoveMapTo(geoPoint);
    }

    public void setAnimationMoveMapToMyLocation() {
        GeoPoint geoPoint = null;
        SAILS sAILS = this.b;
        if (!(sAILS == null || Double.isNaN(sAILS.getLatitude()) && Double.isNaN(this.b.getLongitude()))) {
            GeoPoint geoPoint2;
            geoPoint = geoPoint2;
            geoPoint2 = new GeoPoint(this.b.getLongitude(), this.b.getLatitude());
        }
        this.setAnimationMoveMapTo(geoPoint);
    }

    @Override
    public void zoomIn() {
        super.zoomIn();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                SAILSMapView.this.S.a();
            }
        }, 300L);
    }

    @Override
    public void zoomOut() {
        super.zoomOut();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                SAILSMapView.this.S.a();
            }
        }, 300L);
    }

    public void onResume() {
        SAILS sAILS = this.b;
        if (sAILS != null && this.T) {
            sAILS.startLocatingEngine();
            this.setLocatorMarkerVisible(true);
        }
        if (this.U) {
            this.x.g = true;
            this.x.sleep(2000L);
        }
    }

    public void onPause() {
        Object object = this.b;
        if (object != null) {
            this.T = ((SAILS)object).isLocationEngineStarted();
            this.b.stopLocatingEngine();
        }
        this.U = false;
        object = this.x;
        if (object != null && ((PathRoutingManager)object).g) {
            this.U = true;
            ((PathRoutingManager)object).g = false;
        }
    }

    public void setZoomLevelMin(byte by) {
        this.getMapZoomControls().b((float)by);
    }

    @Override
    protected boolean onClickWithoutConvert(int n2, int n3) {
        MarkerManager.LocationRegionMarker locationRegionMarker;
        OnMapClickListener onMapClickListener = this.u;
        if (onMapClickListener != null) {
            return onMapClickListener.onClick(n2, n3);
        }
        if (this.getPinMarkerManager().c != null && (locationRegionMarker = this.getPinMarkerManager().a(n2, n3)) != null) {
            this.getPinMarkerManager().c.OnClick(locationRegionMarker);
        }
        return false;
    }

    @Override
    protected void onLongClick(int n2, int n3) {
        SAILSMapView sAILSMapView = this;
        super.onLongClick(n2, n3);
        Object object = sAILSMapView.b;
        if (object != null && this.h != null) {
            ArrayList<LocationRegion> arrayList;
            object = ((SAILS)object).getLocationRegionList(this.P);
            ArrayList<LocationRegion> arrayList2 = arrayList;
            arrayList = new ArrayList<LocationRegion>();
            if (object == null) {
                return;
            }
            GeoPoint geoPoint = this.getProjection().fromPixels(n2, n3);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (LocationRegion)iterator.next();
                if (!((LocationRegion)object).isInRegion(geoPoint.longitude, geoPoint.latitude)) continue;
                arrayList2.add((LocationRegion)object);
            }
            if (arrayList2.size() > 0) {
                Collections.sort(arrayList2, new LocationRegion.RegionByLevelComparator());
                this.h.onLongClick(arrayList2);
            }
            return;
        }
    }

    @Override
    protected void onClick(int n2, int n3) {
        ArrayList<LocationRegion> arrayList;
        if (((SAILSMapView)((Object)onClickNothingListener)).b == null) {
            return;
        }
        SAILSMapView sAILSMapView = onClickNothingListener;
        sAILSMapView.getPinMarkerManager().a(n2, n3, ((SAILSMapView)((Object)onClickNothingListener)).b);
        if (sAILSMapView.g == null && ((SAILSMapView)((Object)onClickNothingListener)).s == null) {
            return;
        }
        Object object = ((SAILSMapView)((Object)onClickNothingListener)).b.getLocationRegionList(((SAILSMapView)((Object)onClickNothingListener)).P);
        ArrayList<LocationRegion> arrayList2 = arrayList;
        arrayList = new ArrayList<LocationRegion>();
        if (object == null) {
            return;
        }
        GeoPoint geoPoint = ((MapView)((Object)onClickNothingListener)).getProjection().fromPixels(n2, n3);
        Iterator<LocationRegion> iterator = object.iterator();
        while (iterator.hasNext()) {
            String string2;
            object = iterator.next();
            if (!((LocationRegion)object).isInRegion(geoPoint.longitude, geoPoint.latitude) || (string2 = ((LocationRegion)object).type) != null && (string2.equals("boundary") || ((LocationRegion)object).type.equals("freedom") || ((LocationRegion)object).type.equals("plaza") || ((LocationRegion)object).type.equals("lock") || ((LocationRegion)object).type.equals("parking"))) continue;
            arrayList2.add((LocationRegion)object);
        }
        if (arrayList2.size() > 0) {
            Collections.sort(arrayList2, new LocationRegion.RegionByAreaComparator());
            ((SAILSMapView)((Object)onClickNothingListener)).g.onClick(arrayList2);
        } else {
            OnClickNothingListener onClickNothingListener = ((SAILSMapView)((Object)onClickNothingListener)).s;
            if (onClickNothingListener != null) {
                onClickNothingListener.onClick();
            }
        }
    }

    @Override
    protected void onMove(int n2, int n3) {
        SAILSMapView sAILSMapView = this;
        super.onMove(n2, n3);
        int n4 = sAILSMapView.L;
        int n5 = ALWAYS_LOCK_MAP;
        if ((n4 & n5) != n5) {
            SAILSMapView sAILSMapView2 = this;
            sAILSMapView2.L = n4 & ~LOCATION_CENTER_LOCK;
            sAILSMapView2.L &= ~FOLLOW_PHONE_HEADING;
            OnModeChangedListener onModeChangedListener = sAILSMapView2.e;
            if (onModeChangedListener != null) {
                onModeChangedListener.onModeChanged(((SAILSMapView)this).L);
            }
        }
        if ((this = ((SAILSMapView)this).d) != null) {
            this.onMove(n2, n3);
        }
    }

    @Override
    protected void onRotate() {
        int n2 = this.L;
        int n3 = ALWAYS_LOCK_MAP;
        if ((n2 & n3) != n3) {
            this.L = n2 & ~FOLLOW_PHONE_HEADING;
            OnModeChangedListener onModeChangedListener = this.e;
            if (onModeChangedListener != null) {
                onModeChangedListener.onModeChanged(this.L);
            }
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    void setFeedPathListCallBack(OnFeedPathListCallBack onFeedPathListCallBack) {
        SAILSMapView sAILSMapView = this;
        sAILSMapView.v = onFeedPathListCallBack;
        sAILSMapView.H.setStyle(Paint.Style.STROKE);
        sAILSMapView.H.setColor(-65536);
        sAILSMapView.H.setAlpha(100);
        sAILSMapView.H.setStrokeWidth(5.0f);
        sAILSMapView.H.setStrokeJoin(Paint.Join.ROUND);
        sAILSMapView.I = new Polyline(new PolygonalChain(null), this.H);
        sAILSMapView.F.getOverlayItems().clear();
        sAILSMapView.F.getOverlayItems().add(this.I);
    }

    void b() {
        this.S.d();
    }

    void c() {
        this.S.c();
    }

    void d() {
        this.S.a();
    }

    @Override
    public void onZoomLevelChange(float f2) {
        int n2;
        int n3;
        SAILSMapView sAILSMapView = this;
        super.onZoomLevelChange(f2);
        OnZoomChangedListener onZoomChangedListener = sAILSMapView.f;
        if (onZoomChangedListener != null) {
            onZoomChangedListener.onZoomChanged(f2);
        }
        if (((n3 = this.L) & (n2 = LOCATION_CENTER_LOCK)) == n2 && (n3 & (n3 = FOLLOW_PHONE_HEADING)) == n3) {
            SAILS sAILS = this.b;
            if (sAILS != null && sAILS.isLocationFix()) {
                SAILSMapView sAILSMapView2 = this;
                double d2 = sAILSMapView2.b.getProcessLongitude();
                double d3 = sAILSMapView2.b.getProcessLatitude();
                if (!Double.isNaN(d3) && !Double.isNaN(d2)) {
                    double d4 = d3;
                    if (this.isInMap(new GeoPoint(d4, d4))) {
                        GeoPoint geoPoint;
                        SAILSMapView sAILSMapView3 = this;
                        double d5 = sAILSMapView3.b.getMapViewRotation();
                        GeoPoint geoPoint2 = geoPoint;
                        geoPoint2(d3, d2);
                        sAILSMapView3.setAnimationMoveMapTo(sAILSMapView3.a(geoPoint, d5));
                        sAILSMapView3.setAnimatingToRotationAngle((float)(-d5));
                        return;
                    }
                }
                return;
            }
            return;
        }
    }

    static class com.sails.engine.SAILSMapView$a
    extends Handler {
        public boolean a;
        public int b;
        int c;
        boolean d;
        private float e;
        private WeakReference<SAILSMapView> f;
        private float g;
        private int h;

        private int e() {
            try {
                class A
                implements FileFilter {
                    A() {
                    }

                    @Override
                    public boolean accept(File file) {
                        return Pattern.matches("cpu[0-9]+", file.getName());
                    }
                }
                return new File("/sys/devices/system/cpu/").listFiles(new A()).length;
            }
            catch (Exception exception) {
                return 1;
            }
        }

        com.sails.engine.SAILSMapView$a(SAILSMapView sAILSMapView) {
            com.sails.engine.SAILSMapView$a a2 = this;
            a2.a = true;
            a2.b = 20;
            a2.c = 0;
            a2.d = true;
            a2.e = 0.0f;
            a2.g = 0.0f;
            a2.h = 0;
            a2.f = new WeakReference<SAILSMapView>(sAILSMapView);
            if (a2.e() == 1) {
                this.b = 100;
            }
        }

        void a() {
            com.sails.engine.SAILSMapView$a a2 = this;
            a2.d = true;
            a2.c = 1000;
        }

        public void b() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handleMessage(Message object) {
            block21: {
                double d2;
                double d3;
                block25: {
                    block22: {
                        block24: {
                            GeoPoint geoPoint;
                            double d4;
                            double d5;
                            block23: {
                                GeoPoint geoPoint2;
                                SAILS sAILS;
                                object = (SAILSMapView)this.f.get();
                                if (object == null || (sAILS = ((SAILSMapView)object).b) == null || !sAILS.isLocationEngineStarted()) break block21;
                                d3 = ((SAILSMapView)object).b.getLongitude();
                                Object object2 = object;
                                d2 = ((SAILSMapView)object2).b.getLatitude();
                                d5 = ((SAILSMapView)object2).b.getProcessLongitude();
                                d4 = ((SAILSMapView)object2).b.getProcessLatitude();
                                double d6 = ((SAILSMapView)object2).b.getAccuracy();
                                if (Double.isNaN(d3) || Double.isNaN(d2) || Double.isNaN(d6)) break block22;
                                if (!((SAILSMapView)object).b.isUseGPS()) break block23;
                                double d7 = Double.isNaN(d2) ? 0.0 : d2;
                                double d8 = Double.isNaN(d3) ? 0.0 : d3;
                                GeoPoint geoPoint3 = geoPoint2;
                                geoPoint3(d7, d8);
                                if (!((MapView)((Object)object)).isInMap(geoPoint3)) break block22;
                            }
                            if (!((SAILSMapView)object).b.getFloor().equals(((SAILSMapView)object).P)) break block24;
                            if (!((MapView)((Object)object)).getDynamicOverlays().contains(((SAILSMapView)object).D)) {
                                ((MapView)((Object)object)).getDynamicOverlays().add(((SAILSMapView)object).D);
                            }
                            Object object3 = object;
                            GeoPoint geoPoint4 = geoPoint;
                            geoPoint = new GeoPoint(d4, d5);
                            ((SAILSMapView)object3).A.setGeoPoint(geoPoint4);
                            if (((SAILSMapView)object3).K != null) {
                                Object object4 = object;
                                ((SAILSMapView)object4).K.setGeoPoint(geoPoint4);
                                d5 = ((SAILSMapView)object4).b.getAccuracy();
                                this.e = (float)((double)this.e * 0.98 + d5 * 0.02 * ((SAILSMapView)object).b.getMapScale());
                                ((SAILSMapView)object).K.setRadius(this.e);
                            }
                            Object object5 = object;
                            float f2 = (float)((SAILSMapView)object5).b.getUserHeading();
                            if (((SAILSMapView)object5).b.isHeadingAvailable()) {
                                Object object6 = object;
                                ((SAILSMapView)object6).A.setBitmap(((SAILSMapView)object).C);
                                ((SAILSMapView)object6).A.setRotation(f2);
                            } else {
                                Object object7 = object;
                                ((SAILSMapView)object7).A.setBitmap(((SAILSMapView)object).B);
                                ((SAILSMapView)object7).A.setRotation(f2);
                            }
                            if (((SAILSMapView)object).M) {
                                f2 = (float)((SAILSMapView)object).b.getMapViewRotation();
                            }
                            int n2 = LOCATION_CENTER_LOCK;
                            if ((((SAILSMapView)object).L & n2) == n2) {
                                Object object8 = object;
                                double d9 = f2;
                                GeoPoint geoPoint5 = ((SAILSMapView)object8).a(geoPoint4, d9);
                                geoPoint5 = ((MapView)((Object)object8)).getProjection().toPixels(geoPoint5, null);
                                Point point = ((MapView)((Object)object)).getProjection().toPixels(((SAILSMapView)object).getMapViewPosition().getCenter(), null);
                                boolean bl = false;
                                boolean bl2 = false;
                                if (Math.pow(Math.pow(((Point)geoPoint5).x - point.x, 2.0) + Math.pow(((Point)geoPoint5).y - point.y, 2.0), 0.5) / (double)ScreenDensity.density > 10.0 || this.c > 150) {
                                    bl = true;
                                    this.c = 0;
                                }
                                int n3 = FOLLOW_PHONE_HEADING;
                                if ((((SAILSMapView)object).L & n3) == n3 && ((SAILSMapView)object).b.isHeadingAvailable()) {
                                    if (!(Math.cos(Math.toRadians(this.g - f2)) < 0.995) && !this.d) {
                                        this.h = Math.cos(Math.toRadians(this.g - f2)) < 0.999 ? ++this.h : 0;
                                    } else {
                                        com.sails.engine.SAILSMapView$a a2 = this;
                                        a2.g = f2;
                                        bl = true;
                                        bl2 = true;
                                        a2.c = 0;
                                        a2.h = 0;
                                    }
                                    if (this.h > 20) {
                                        com.sails.engine.SAILSMapView$a a3 = this;
                                        a3.h = 0;
                                        a3.d = true;
                                    } else {
                                        this.d = false;
                                    }
                                }
                                if (bl) {
                                    Object object9 = object;
                                    ((SAILSMapView)object9).setAnimationMoveMapTo(((SAILSMapView)object9).a(geoPoint4, d9));
                                }
                                if (bl2) {
                                    ((SAILSMapView)object).setAnimatingToRotationAngle(-f2);
                                }
                                break block25;
                            } else {
                                this.d = true;
                            }
                            break block25;
                        }
                        if (((MapView)((Object)object)).getDynamicOverlays().contains(((SAILSMapView)object).D)) {
                            ((MapView)((Object)object)).getDynamicOverlays().remove(((SAILSMapView)object).D);
                        }
                        break block25;
                    }
                    if (((SAILSMapView)object).A != null) {
                        ((SAILSMapView)object).A.setBitmap(null);
                    }
                    if (((SAILSMapView)object).K != null) {
                        ((SAILSMapView)object).K.setRadius(0.0f);
                    }
                    this.c = 100;
                }
                if (!((SAILSMapView)object).b.getFloor().equals(((SAILSMapView)object).P)) {
                    int n4 = AUTO_FLOOR_SWITCH;
                    if (!((((SAILSMapView)object).L & n4) != n4 || ((SAILSMapView)object).b.getFloor().equals("") || Double.isNaN(d3) || Double.isNaN(d2))) {
                        ((SAILSMapView)object).loadCurrentLocationFloorMap();
                    }
                }
                ++this.c;
                object.invalidate();
            }
            if (this.a) {
                com.sails.engine.SAILSMapView$a a4 = this;
                a4.a(a4.b);
            }
        }

        public void c() {
            this.a = false;
        }

        public void d() {
            this.a = true;
            this.a(0L);
        }

        public void a(long l2) {
            com.sails.engine.SAILSMapView$a a2 = this;
            a2.removeMessages(0);
            a2.sendMessageDelayed(a2.obtainMessage(0), l2);
        }
    }

    static interface OnFeedPathListCallBack {
        public void onFeed();
    }

    public static interface OnZoomChangedListener {
        public void onZoomChanged(float var1);
    }

    public static interface OnMoveListener {
        public void onMove(int var1, int var2);
    }

    public static interface OnModeChangedListener {
        public void onModeChanged(int var1);
    }

    public static interface OnFloorChangedListener {
        public void onFloorChangedBefore(String var1);

        public void onFloorChangedAfter(String var1);
    }

    public static interface OnRegionLongClickListener {
        public void onLongClick(List<LocationRegion> var1);
    }

    public static interface OnRegionClickListener {
        public void onClick(List<LocationRegion> var1);
    }

    public static interface OnClickNothingListener {
        public void onClick();
    }

    public static interface OnMapClickListener {
        public boolean onClick(int var1, int var2);
    }

    public static enum SAILSMapFormat {
        Vector,
        JPG,
        VOID;

    }
}

