package com.locnavi.location.uploadlocation;

import com.locnavi.location.xunjimap.XJClient;
import com.locnavi.location.xunjimap.model.bean.BackgroundData;
import com.locnavi.location.xunjimap.model.parse.Background;
import com.locnavi.location.xunjimap.utils.IpsException;
import com.locnavi.location.xunjimap.utils.L;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseQuery;

import java.util.ArrayList;
import java.util.List;

/**
 * author:chen
 * time:2017/6/29
 * desc:
 */
public class XJGetUserBackGroundDatas {

    private int page = 1, limit = 30;

    private List<BackgroundData> backgroundDatas = new ArrayList<>();


    public XJGetUserBackGroundDatas() {
    }

    public void handleError(ParseException e) {
        e.printStackTrace();
        IpsException ipsException = new IpsException(e, e.getCode());
        if (XJClient.userAllBackgroundDataListener != null){
            XJClient.userAllBackgroundDataListener.onError(ipsException);
        }

//
//        if (isViewAttached()) {
//            getView().handleThrowable(ipsException);
//        }
    }

    public void queryBackgroundData(String mapId, String deviceId) {
        ArrayList<BackgroundData> newBackgroundDatas = new ArrayList<>();
        ParseQuery.getQuery(Background.class)
                .whereEqualTo("project", ParseObject.createWithoutData("MappingProject", mapId))
                .whereEqualTo(Background.deviceId, deviceId)
                .orderByAscending(Background.enterAt)
                .setLimit(limit)
                .setSkip(limit * (page - 1))
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    for (int i = 0; i < objects.size(); i++) {
                        Background background = objects.get(i);
                        BackgroundData backgroundData = new BackgroundData();
                        backgroundData.setLocationRegion(background.getLocationRegion());
                        backgroundData.setLocationRegions((ArrayList) background.getLocationRegions());
                        backgroundData.setFloorName(background.getFloorName());
                        backgroundData.setEnterAt(background.getEnterAt());
                        backgroundData.setLeaveAt(background.getLeaveAt());
                        backgroundData.setLonLat(background.getLonLat());
                        backgroundData.setDurationTime(background.getDurationTime());
                        backgroundData.setUserDescription(background.getUserDescription());
                        backgroundData.setPhoneNumber(background.getPhoneNumber());
                        backgroundData.setDeviceId(background.getDeviceId());
                        newBackgroundDatas.add(backgroundData);
                    }
//                    handleData(newBackgroundDatas);
                    if (XJClient.userAllBackgroundDataListener!= null){
                        XJClient.userAllBackgroundDataListener.onSuccess(newBackgroundDatas);
                    }else {
                        L.e("ipsmap","ipsmap client userAllBackgroundDataListener not init!");
                    }

                });
    }



    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public boolean hasNext() {
        int size = backgroundDatas.size();
        return (size != 0 && size == page * limit) ? true : false;
    }

}
