/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.deviceorientation;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Looper;
import java.util.List;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONObject;

public class CompassListener
extends CordovaPlugin
implements SensorEventListener {
    public static int STOPPED = 0;
    public static int STARTING = 1;
    public static int RUNNING = 2;
    public static int ERROR_FAILED_TO_START = 3;
    public long TIMEOUT;
    int status;
    float heading;
    long timeStamp;
    long lastAccessTime;
    int accuracy;
    private SensorManager sensorManager;
    Sensor mSensor;
    private CallbackContext callbackContext;

    public CompassListener() {
        CompassListener compassListener = this;
        compassListener.TIMEOUT = 30000L;
        compassListener.heading = 0.0f;
        compassListener.timeStamp = 0L;
        compassListener.setStatus(STOPPED);
    }

    private void timeout() {
        if (((CompassListener)((Object)callbackContext)).status == STARTING) {
            CompassListener compassListener = callbackContext;
            compassListener.setStatus(ERROR_FAILED_TO_START);
            CallbackContext callbackContext = compassListener.callbackContext;
            if (callbackContext != null) {
                callbackContext.error("Compass listener failed to start.");
            }
        }
    }

    private void setStatus(int n2) {
        this.status = n2;
    }

    private JSONObject getCompassHeading() {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2 = jSONObject;
        jSONObject2();
        double d2 = this.getHeading();
        jSONObject2.put("magneticHeading", d2);
        d2 = this.getHeading();
        jSONObject3.put("trueHeading", d2);
        jSONObject3.put("headingAccuracy", 0);
        long l2 = this.timeStamp;
        jSONObject.put("timestamp", l2);
        return jSONObject;
    }

    @Override
    public void initialize(CordovaInterface cordovaInterface, CordovaWebView cordovaWebView) {
        super.initialize(cordovaInterface, cordovaWebView);
        this.sensorManager = (SensorManager)cordovaInterface.getActivity().getSystemService("sensor");
    }

    @Override
    public boolean execute(String string2, JSONArray jSONArray, CallbackContext callbackContext) {
        block11: {
            block6: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block5: {
                                    if (!string2.equals("start")) break block5;
                                    this.start();
                                    break block6;
                                }
                                if (!string2.equals("stop")) break block7;
                                this.stop();
                                break block6;
                            }
                            if (!string2.equals("getStatus")) break block8;
                            int n2 = this.getStatus();
                            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, n2));
                            break block6;
                        }
                        if (!string2.equals("getHeading")) break block9;
                        if (this.status != RUNNING) {
                            if (this.start() == ERROR_FAILED_TO_START) {
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, ERROR_FAILED_TO_START));
                                return true;
                            }
                            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    CompassListener.this.timeout();
                                }
                            }, 2000L);
                        }
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.getCompassHeading()));
                        break block6;
                    }
                    if (!string2.equals("setTimeout")) break block10;
                    this.setTimeout(jSONArray.getLong(0));
                    break block6;
                }
                if (!string2.equals("getTimeout")) break block11;
                long l2 = this.getTimeout();
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, l2));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onDestroy() {
        this.stop();
    }

    @Override
    public void onReset() {
        this.stop();
    }

    public int start() {
        int n2 = this.status;
        if (n2 != RUNNING && n2 != STARTING) {
            List list = this.sensorManager.getSensorList(3);
            if (list != null && list.size() > 0) {
                CompassListener compassListener = this;
                compassListener.mSensor = (Sensor)list.get(0);
                CompassListener compassListener2 = this;
                compassListener.sensorManager.registerListener((SensorEventListener)compassListener2, compassListener2.mSensor, 3);
                compassListener.lastAccessTime = System.currentTimeMillis();
                compassListener.setStatus(STARTING);
            } else {
                this.setStatus(ERROR_FAILED_TO_START);
            }
            return this.status;
        }
        return this.status;
    }

    public void stop() {
        if (this.status != STOPPED) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
        this.setStatus(STOPPED);
    }

    public void onAccuracyChanged(Sensor sensor, int n2) {
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        CompassListener compassListener = this;
        this.timeStamp = System.currentTimeMillis();
        compassListener.heading = sensorEvent.values[0];
        compassListener.setStatus(RUNNING);
        if (compassListener.timeStamp - this.lastAccessTime > this.TIMEOUT) {
            this.stop();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public float getHeading() {
        this.lastAccessTime = System.currentTimeMillis();
        return this.heading;
    }

    public void setTimeout(long l2) {
        this.TIMEOUT = l2;
    }

    public long getTimeout() {
        return this.TIMEOUT;
    }
}

