/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Debug;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.ICordovaClientCertRequest;
import org.apache.cordova.ICordovaHttpAuthHandler;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginResult;
import org.json.JSONException;

public class PluginManager {
    private static String TAG = "PluginManager";
    private static final int SLOW_EXEC_WARNING_THRESHOLD = Debug.isDebuggerConnected() ? 60 : 16;
    private final LinkedHashMap<String, CordovaPlugin> pluginMap = new LinkedHashMap();
    private final LinkedHashMap<String, PluginEntry> entryMap = new LinkedHashMap();
    private final CordovaInterface ctx;
    private final CordovaWebView app;
    private boolean isInitialized;
    private CordovaPlugin permissionRequester;

    public PluginManager(CordovaWebView cordovaWebView, CordovaInterface cordovaInterface, Collection<PluginEntry> collection) {
        this.ctx = cordovaInterface;
        this.app = cordovaWebView;
        this.setPluginEntries(collection);
    }

    private void startupPlugins() {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            if (pluginEntry.onload) {
                this.getPlugin(pluginEntry.service);
                continue;
            }
            this.pluginMap.put(pluginEntry.service, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CordovaPlugin instantiatePlugin(String string2) {
        Exception exception2;
        block4: {
            Class<?> clazz;
            block3: {
                Object this_ = null;
                clazz = null;
                if (string2 != null) {
                    try {
                        if ("".equals(string2)) break block3;
                        clazz = Class.forName(string2);
                    }
                    catch (Exception exception2) {
                        break block4;
                    }
                }
            }
            boolean bl = clazz != null;
            if (!(bl & CordovaPlugin.class.isAssignableFrom(clazz))) return this_;
            return (CordovaPlugin)clazz.newInstance();
        }
        exception2.printStackTrace();
        System.out.println("Error adding plugin " + string2 + ".");
        return this_;
    }

    public Collection<PluginEntry> getPluginEntries() {
        return this.entryMap.values();
    }

    public void setPluginEntries(Collection<PluginEntry> object) {
        if (this.isInitialized) {
            PluginManager pluginManager = this;
            pluginManager.onPause(false);
            pluginManager.onDestroy();
            pluginManager.pluginMap.clear();
            pluginManager.entryMap.clear();
        }
        object = object.iterator();
        while (object.hasNext()) {
            this.addService((PluginEntry)object.next());
        }
        if (this.isInitialized) {
            this.startupPlugins();
        }
    }

    public void init() {
        PluginManager pluginManager = this;
        LOG.d(TAG, "init()");
        pluginManager.isInitialized = true;
        pluginManager.onPause(false);
        pluginManager.onDestroy();
        pluginManager.pluginMap.clear();
        pluginManager.startupPlugins();
    }

    public void exec(String string2, String string3, String string4, String object) {
        block10: {
            boolean bl;
            block9: {
                CallbackContext callbackContext;
                CordovaPlugin cordovaPlugin = ((PluginManager)((Object)pluginResult2)).getPlugin(string2);
                if (cordovaPlugin == null) {
                    PluginResult pluginResult;
                    PluginManager pluginManager = pluginResult2;
                    LOG.d(TAG, "exec() call to unknown plugin: " + string2);
                    PluginResult pluginResult2 = pluginResult;
                    pluginResult = new PluginResult(PluginResult.Status.CLASS_NOT_FOUND_EXCEPTION);
                    pluginManager.app.sendPluginResult(pluginResult2, string4);
                    return;
                }
                String string5 = object;
                object = callbackContext;
                long l2 = System.currentTimeMillis();
                bl = cordovaPlugin.execute(string3, string5, new CallbackContext(string4, ((PluginManager)((Object)pluginResult2)).app));
                l2 = System.currentTimeMillis() - l2;
                if (l2 <= (long)SLOW_EXEC_WARNING_THRESHOLD) break block9;
                LOG.w(TAG, "THREAD WARNING: exec() call to " + string2 + "." + string3 + " blocked the main thread for " + l2 + "ms. Plugin should use CordovaInterface.getThreadPool().");
            }
            if (bl) break block10;
            try {
                ((CallbackContext)object).sendPluginResult(new PluginResult(PluginResult.Status.INVALID_ACTION));
            }
            catch (Exception exception) {
                LOG.e(TAG, "Uncaught exception from plugin", exception);
                ((CallbackContext)object).error(exception.getMessage());
            }
            catch (JSONException jSONException) {
                ((CallbackContext)object).sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
            }
        }
    }

    public CordovaPlugin getPlugin(String string2) {
        CordovaPlugin cordovaPlugin;
        Object object = this.pluginMap.get(string2);
        if (object == null) {
            object = this.entryMap.get(string2);
            if (object == null) {
                return null;
            }
            cordovaPlugin = ((PluginEntry)object).plugin;
            if (cordovaPlugin == null) {
                cordovaPlugin = this.instantiatePlugin(((PluginEntry)object).pluginClass);
            }
            CordovaWebView cordovaWebView = this.app;
            cordovaPlugin.privateInitialize(string2, this.ctx, cordovaWebView, cordovaWebView.getPreferences());
            this.pluginMap.put(string2, cordovaPlugin);
        } else {
            cordovaPlugin = object;
        }
        return cordovaPlugin;
    }

    public void addService(String string2, String string3) {
        this.addService(new PluginEntry(string2, string3, false));
    }

    public void addService(PluginEntry pluginEntry) {
        this.entryMap.put(pluginEntry.service, pluginEntry);
        CordovaPlugin cordovaPlugin = pluginEntry.plugin;
        if (cordovaPlugin != null) {
            CordovaWebView cordovaWebView = this.app;
            cordovaPlugin.privateInitialize(pluginEntry.service, this.ctx, cordovaWebView, cordovaWebView.getPreferences());
            this.pluginMap.put(pluginEntry.service, pluginEntry.plugin);
        }
    }

    public void onPause(boolean bl) {
        for (CordovaPlugin cordovaPlugin : ((PluginManager)this).pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onPause(bl);
        }
    }

    public boolean onReceivedHttpAuthRequest(CordovaWebView object, ICordovaHttpAuthHandler iCordovaHttpAuthHandler, String string2, String string3) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null || !cordovaPlugin.onReceivedHttpAuthRequest(this.app, iCordovaHttpAuthHandler, string2, string3)) continue;
            return true;
        }
        return false;
    }

    public boolean onReceivedClientCertRequest(CordovaWebView object, ICordovaClientCertRequest iCordovaClientCertRequest) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null || !cordovaPlugin.onReceivedClientCertRequest(this.app, iCordovaClientCertRequest)) continue;
            return true;
        }
        return false;
    }

    public void onResume(boolean bl) {
        for (CordovaPlugin cordovaPlugin : ((PluginManager)this).pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onResume(bl);
        }
    }

    public void onStart() {
        for (CordovaPlugin cordovaPlugin : ((PluginManager)this).pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onStart();
        }
    }

    public void onStop() {
        for (CordovaPlugin cordovaPlugin : ((PluginManager)this).pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onStop();
        }
    }

    public void onDestroy() {
        for (CordovaPlugin cordovaPlugin : ((PluginManager)this).pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onDestroy();
        }
    }

    public Object postMessage(String string2, Object object) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            Object object2;
            if (cordovaPlugin == null || (object2 = cordovaPlugin.onMessage(string2, object)) == null) continue;
            return object2;
        }
        return this.ctx.onMessage(string2, object);
    }

    public void onNewIntent(Intent intent) {
        for (CordovaPlugin cordovaPlugin : ((PluginManager)this).pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onNewIntent(intent);
        }
    }

    public boolean shouldAllowRequest(String string2) {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            Boolean bl;
            CordovaPlugin cordovaPlugin = this.pluginMap.get(pluginEntry.service);
            if (cordovaPlugin == null || (bl = cordovaPlugin.shouldAllowRequest(string2)) == null) continue;
            return bl;
        }
        if (!(string2.startsWith("blob:") || string2.startsWith("data:") || string2.startsWith("about:blank"))) {
            if (string2.startsWith("https://ssl.gstatic.com/accessibility/javascript/android/")) {
                return true;
            }
            if (string2.startsWith("file://")) {
                return string2.contains("/app_webview/") ^ true;
            }
            return false;
        }
        return true;
    }

    public boolean shouldAllowNavigation(String string2) {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            Boolean bl;
            CordovaPlugin cordovaPlugin = this.pluginMap.get(pluginEntry.service);
            if (cordovaPlugin == null || (bl = cordovaPlugin.shouldAllowNavigation(string2)) == null) continue;
            return bl;
        }
        return string2.startsWith("file://") || string2.startsWith("about:blank");
    }

    public boolean shouldAllowBridgeAccess(String string2) {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            Boolean bl;
            CordovaPlugin cordovaPlugin = this.pluginMap.get(pluginEntry.service);
            if (cordovaPlugin == null || (bl = cordovaPlugin.shouldAllowBridgeAccess(string2)) == null) continue;
            return bl;
        }
        return string2.startsWith("file://");
    }

    public Boolean shouldOpenExternalUrl(String string2) {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            Boolean bl;
            CordovaPlugin cordovaPlugin = this.pluginMap.get(pluginEntry.service);
            if (cordovaPlugin == null || (bl = cordovaPlugin.shouldOpenExternalUrl(string2)) == null) continue;
            return bl;
        }
        return false;
    }

    public boolean onOverrideUrlLoading(String string2) {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            CordovaPlugin object = this.pluginMap.get(pluginEntry.service);
            if (object == null || !object.onOverrideUrlLoading(string2)) continue;
            return true;
        }
        return false;
    }

    public void onReset() {
        for (CordovaPlugin cordovaPlugin : ((PluginManager)this).pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onReset();
        }
    }

    Uri remapUri(Uri uri) {
        for (CordovaPlugin cordovaPlugin : ((PluginManager)this).pluginMap.values()) {
            if (cordovaPlugin == null || (cordovaPlugin = cordovaPlugin.remapUri(uri)) == null) continue;
            return cordovaPlugin;
        }
        return null;
    }

    public void onConfigurationChanged(Configuration configuration) {
        for (CordovaPlugin cordovaPlugin : ((PluginManager)this).pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onConfigurationChanged(configuration);
        }
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle;
        PluginManager pluginManager = pluginManager2;
        PluginManager pluginManager2 = bundle;
        bundle = new Bundle();
        for (CordovaPlugin cordovaPlugin : pluginManager.pluginMap.values()) {
            Bundle bundle2;
            if (cordovaPlugin == null || (bundle2 = cordovaPlugin.onSaveInstanceState()) == null) continue;
            pluginManager2.putBundle(cordovaPlugin.getServiceName(), bundle2);
        }
        return pluginManager2;
    }
}

