/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import java.security.SecureRandom;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.LOG;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginManager;
import org.json.JSONArray;
import org.json.JSONException;

public class CordovaBridge {
    private static final String LOG_TAG = "CordovaBridge";
    private PluginManager pluginManager;
    private NativeToJsMessageQueue jsMessageQueue;
    private volatile int expectedBridgeSecret = -1;

    public CordovaBridge(PluginManager pluginManager, NativeToJsMessageQueue nativeToJsMessageQueue) {
        this.pluginManager = pluginManager;
        this.jsMessageQueue = nativeToJsMessageQueue;
    }

    private boolean verifySecret(String string2, int n2) {
        if (!this.jsMessageQueue.isBridgeEnabled()) {
            if (n2 == -1) {
                LOG.d(LOG_TAG, string2 + " call made before bridge was enabled.");
            } else {
                LOG.d(LOG_TAG, "Ignoring " + string2 + " from previous page load.");
            }
            return false;
        }
        if (this.expectedBridgeSecret >= 0 && n2 == this.expectedBridgeSecret) {
            return true;
        }
        LOG.e(LOG_TAG, "Bridge access attempt with wrong secret token, possibly from malicious code. Disabling exec() bridge!");
        this.clearBridgeSecret();
        throw new IllegalAccessException();
    }

    public String jsExec(int n2, String string2, String string3, String string4, String string5) {
        String string6;
        if (!this.verifySecret("exec()", n2)) {
            return null;
        }
        if (string5 == null) {
            return "@Null arguments.";
        }
        CordovaBridge cordovaBridge = this;
        cordovaBridge.jsMessageQueue.setPaused(true);
        try {
            CordovaResourceApi.jsThread = Thread.currentThread();
            cordovaBridge.pluginManager.exec(string2, string3, string4, string5);
            string6 = cordovaBridge.jsMessageQueue.popAndEncode(false);
            this.jsMessageQueue.setPaused(false);
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                this.jsMessageQueue.setPaused(false);
                return "";
            }
            catch (Throwable throwable2) {
                this.jsMessageQueue.setPaused(false);
                throw throwable2;
            }
        }
        return string6;
    }

    public void jsSetNativeToJsBridgeMode(int n2, int n3) {
        if (!this.verifySecret("setNativeToJsBridgeMode()", n2)) {
            return;
        }
        this.jsMessageQueue.setBridgeMode(n3);
    }

    public String jsRetrieveJsMessages(int n2, boolean bl) {
        if (!this.verifySecret("retrieveJsMessages()", n2)) {
            return null;
        }
        return this.jsMessageQueue.popAndEncode(bl);
    }

    void clearBridgeSecret() {
        this.expectedBridgeSecret = -1;
    }

    public boolean isSecretEstablished() {
        return this.expectedBridgeSecret != -1;
    }

    @SuppressLint(value={"TrulyRandom"})
    int generateBridgeSecret() {
        this.expectedBridgeSecret = new SecureRandom().nextInt(Integer.MAX_VALUE);
        return this.expectedBridgeSecret;
    }

    public void reset() {
        CordovaBridge cordovaBridge = this;
        cordovaBridge.jsMessageQueue.reset();
        cordovaBridge.clearBridgeSecret();
    }

    public String promptOnJsPrompt(String string2, String string3, String string4) {
        Object object;
        if (string4 != null && string4.length() > 3 && string4.startsWith("gap:")) {
            JSONArray jSONArray;
            CordovaBridge cordovaBridge = object;
            object = jSONArray;
            try {
                object = cordovaBridge.jsExec(new JSONArray(string4.substring(4)).getInt(0), object.getString(1), object.getString(2), object.getString(3), string3);
                if (object == null) {
                    object = "";
                }
                return object;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return "";
        }
        if (string4 != null && string4.startsWith("gap_bridge_mode:")) {
            try {
                ((CordovaBridge)object).jsSetNativeToJsBridgeMode(Integer.parseInt(string4.substring(16)), Integer.parseInt(string3));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            return "";
        }
        if (string4 != null && string4.startsWith("gap_poll:")) {
            try {
                object = ((CordovaBridge)object).jsRetrieveJsMessages(Integer.parseInt(string4.substring(9)), "1".equals(string3));
                if (object == null) {
                    object = "";
                }
                return object;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return "";
            }
        }
        if (string4 != null && string4.startsWith("gap_init:")) {
            if (((CordovaBridge)object).pluginManager.shouldAllowBridgeAccess(string2)) {
                CordovaBridge cordovaBridge = object;
                int n2 = Integer.parseInt(string4.substring(9));
                cordovaBridge.jsMessageQueue.setBridgeMode(n2);
                return "" + cordovaBridge.generateBridgeSecret();
            }
            LOG.e(LOG_TAG, "gap_init called from restricted origin: " + string2);
            return "";
        }
        return null;
    }
}

