package com.locnavi.location.xunjimap.utils;

import com.sails.engine.SensorElement;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by liberty on 2017/8/9.
 */

public class JsonToArrayListUtils {
        private String json;
        private List<SensorElement> recordList;

        public JsonToArrayListUtils(String json, List<SensorElement> recordList) {
            this.json = json;
            this.recordList = recordList;
        }

        public void invoke() {
            try {
                JSONArray jsonArray1 = new JSONArray(json);
                for (int i = 0 ; i < jsonArray1.length() ; i++){
                    JSONObject jsonObject = jsonArray1.getJSONObject(i);
                    SensorElement sensorElement = new SensorElement();
                    if (jsonObject.has("scanResult")){
                        sensorElement.beacon(new ArrayList<>());
                        JSONArray scanResult = jsonObject.getJSONArray("scanResult");
                        List<SensorElement.Beacon> scanResult2 = new ArrayList<>() ;
                        for (int k = 0 ; k < scanResult.length() ; k++){
                            JSONObject jsonObject1 = scanResult.getJSONObject(k);
                            SensorElement.Beacon beacon = new SensorElement.Beacon();
                            if (jsonObject1.has("id_btle")){
                                long id_btle = jsonObject1.getLong("id_btle");
                                beacon.id_btle = id_btle;
                            }
                            if (jsonObject1.has("rssi")){
                                double rssi = jsonObject1.getDouble("rssi");
                                beacon.rssi = rssi;
                            }
                            scanResult2.add(beacon);
                        }
                        if (scanResult.length() > 0){
                            List<SensorElement.Beacon> scanResult1 = sensorElement.scanResult;
                            if (scanResult1!= null){
                                sensorElement.scanResult.addAll(scanResult2);
                            }else {
                                L.e("dddd","ddd");
                            }
                        }
                    }

                    if (jsonObject.has("type")){
                        int type  = jsonObject.getInt("type");
                        sensorElement.type = type;
                    }

                    if (jsonObject.has("step")){
                        int step = jsonObject.getInt("step");
                        sensorElement.step = step;
                    }
                    if (jsonObject.has("timestamp")){
                        long timestamp = jsonObject.getLong("timestamp");
                        sensorElement.timestamp = timestamp;
                    }

                    if (jsonObject.has("heading")){
                        double heading = jsonObject.getDouble("heading");
                        sensorElement.heading = heading;
                    }

                    if (jsonObject.has("longitude")){
                        double longitude = jsonObject.getDouble("longitude");
                        sensorElement.longitude = longitude;
                    }

                    if (jsonObject.has("latitude")){
                        double latitude = jsonObject.getDouble("latitude");
                        sensorElement.latitude = latitude;
                    }

                    if (jsonObject.has("accuracy")){
                        double accuracy = jsonObject.getDouble("accuracy");
                        sensorElement.accuracy = accuracy;
                    }
                    if (jsonObject.has("speed")){
                        double speed = jsonObject.getDouble("speed");
                        sensorElement.speed = speed;
                    }
                    recordList.add(sensorElement);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

}
