package com.locnavi.location.xunjimap.service;

import com.locnavi.location.xunjimap.utils.IpsConstants;
import com.sails.engine.SAILS;

import java.util.ArrayList;
import java.util.List;


/**
 * Created by hdp on 17/3/24.
 */

public class NavigationData {

    //关闭 准备 播放过
    public static int STATUS_OFF = 0, STATUS_READY = 1, STATUS_PLAYED = 2, STATUS_FAILED = 3;
    public static int INDEX_SWERVE = 0, INDEX_SWERVE_FRONT = 1, INDEX_UPDOWN = 2, INDEX_NEXT_FLOOR = 3,
            INDEX_STRAIGHT = 4, INDEX_STRAIGHT1 = 5, INDEX_STRAIGHT2 = 6, INDEX_STRAIGHT3 = 7,
            INDEX_STRAIGHT4 = 8, INDEX_STRAIGHT5 = 9, INDEX_TURN_ROUND = 10, INDEX_NEAR_DESTINATION = 11;
    private SAILS.GeoNode geoNode;
    private String navigationText;//横幅显示文字
    private String navigationVoiceText;//语音播报文字
    private int naviDirection;//角度计算的方向
    private int changeFloorMode;//换楼层方式
    private String preFloor; //上一电梯/扶梯到的楼层名
    private String toFloor;//到达电梯/扶梯到的楼层名
    private int self;//楼梯标志号
    private String subtype;//上下楼方式
    private boolean isForcePlay = false;//上下电梯强制播放
    private int voicePointIndex;//播报时在voicePoints的index
    private List<VoicePoint> voicePoints;


    public NavigationData() {
        setDeafultVoicePoints();
    }

    public SAILS.GeoNode getGeoNode() {
        return geoNode;
    }

    public void setGeoNode(SAILS.GeoNode geoNode) {
        this.geoNode = geoNode;
    }

    public String getNavigationText() {
        return navigationText;
    }

    public void setNavigationText(String navigationText) {
        this.navigationText = navigationText;
    }

    public String getNavigationVoiceText() {
        return navigationVoiceText;
    }

    public void setNavigationVoiceText(String navigationVoiceText) {
        this.navigationVoiceText = navigationVoiceText;
    }

    public String getPreFloor() {
        return preFloor;
    }

    public void setPreFloor(String preFloor) {
        this.preFloor = preFloor;
    }

    public String getToFloor() {
        return toFloor;
    }

    public void setToFloor(String toFloor) {
        this.toFloor = toFloor;
    }

    public int getSelf() {
        return self;
    }

    public void setSelf(int self) {
        this.self = self;
    }

    public int getNaviDirection() {
        return naviDirection;
    }

    public void setNaviDirection(int naviDirection) {
        this.naviDirection = naviDirection;
    }

    public int getChangeFloorMode() {
        return changeFloorMode;
    }

    public void setChangeFloorMode(int changeFloorMode) {
        this.changeFloorMode = changeFloorMode;
    }

    public int getVoicePointIndex() {
        return voicePointIndex;
    }

    public void setVoicePointIndex(int voicePointIndex) {
        this.voicePointIndex = voicePointIndex;
    }

    public List<VoicePoint> getVoicePoints() {
        return voicePoints;
    }

    public void setVoicePoints(List<VoicePoint> voicePoints) {
        this.voicePoints = voicePoints;
    }

    public String getSubtype() {
        return subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public boolean isForcePlay() {
        return isForcePlay;
    }

    public void setForcePlay(boolean forcePlay) {
        isForcePlay = forcePlay;
    }


    public void setDeafultVoicePoints() {
        voicePoints = new ArrayList<>();
        voicePoints.add(new VoicePoint(IpsConstants.SWERVE_DISTANCE, 0, 1));
        voicePoints.add(new VoicePoint(IpsConstants.SWERVE_FRONT_DISTANCE, 0, 1));
        voicePoints.add(new VoicePoint(IpsConstants.UPDOWN_DISTANCE, 0, 1));
        voicePoints.add(new VoicePoint(IpsConstants.UPDOWN_DISTANCE, 0, 0));//到达楼层播报信息
        voicePoints.add(new VoicePoint(IpsConstants.STRAIGHT_DISTANCE, 0, 10000));
        voicePoints.add(new VoicePoint(IpsConstants.STRAIGHT_ONE_DISTANCE, 5, 1));
        voicePoints.add(new VoicePoint(IpsConstants.STRAIGHT_ONE_DISTANCE * 2, 5, 1));
        voicePoints.add(new VoicePoint(IpsConstants.STRAIGHT_ONE_DISTANCE * 3, 5, 1));
        voicePoints.add(new VoicePoint(IpsConstants.STRAIGHT_ONE_DISTANCE * 4, 5, 1));
        voicePoints.add(new VoicePoint(IpsConstants.STRAIGHT_ONE_DISTANCE * 5, 0, 1000));
        voicePoints.add(new VoicePoint(IpsConstants.TURN_ROUND_DISTANCE, 0, 12));
        voicePoints.add(new VoicePoint(0, 0, 10000));//到达目的地
    }

    public class VoicePoint { //语音播报节点
        private double milestone;
        private double floorOffset;
        private double ceilOffset;
        private int playStatus;

        public VoicePoint(double milestone, double flooroffset, double ceiloffset) {
            this.milestone = milestone;
            this.floorOffset = flooroffset;
            this.ceilOffset = ceiloffset;
            this.playStatus = STATUS_OFF;
        }

        public double getMilestone() {
            return milestone;
        }

        public void setMilestone(double milestone) {
            this.milestone = milestone;
        }

        public double getFloorOffset() {
            return floorOffset;
        }

        public void setFloorOffset(double floorOffset) {
            this.floorOffset = floorOffset;
        }

        public double getCeilOffset() {
            return ceilOffset;
        }

        public void setCeilOffset(double ceilOffset) {
            this.ceilOffset = ceilOffset;
        }

        public int getPlayStatus() {
            return playStatus;
        }

        public void setPlayStatus(int playStatus) {
            this.playStatus = playStatus;
        }


        @Override
        public String toString() {
            return "VoicePoint{" +
                    "milestone=" + milestone +
                    ", floorOffset=" + floorOffset +
                    ", ceilOffset=" + ceilOffset +
                    ", playStatus=" + playStatus +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "NavigationData{" +
                "geoNode=" + geoNode +
                ", navigationText='" + navigationText + '\'' +
                ", navigationVoiceText='" + navigationVoiceText + '\'' +
                ", naviDirection=" + naviDirection +
                ", changeFloorMode=" + changeFloorMode +
                ", preFloor='" + preFloor + '\'' +
                ", toFloor='" + toFloor + '\'' +
                ", self=" + self +
                ", subtype='" + subtype + '\'' +
                ", isForcePlay=" + isForcePlay +
                ", voicePointIndex=" + voicePointIndex +
                ", voicePoints=" + voicePoints +
                '}';
    }
}
