package com.locnavi.location.uploadlocation.engine.model;


import com.sails.engine.core.util.MercatorProjection;

import java.util.Comparator;

/**
 * Created by Rocky on 2013/8/16.
 */
/*Replace*/ public class Satellite {
    public Beacon mBP;
    double x,y;
    double avgPower;
    private double rssi=0;
    private double rssiTarget=0;
    private long lastTimeStamp;
    private static double K_FACTOR=0.9;

    public Satellite clone() {
        Satellite satellite=new Satellite(this.mBP);
        satellite.x=this.x;
        satellite.y=this.y;
        satellite.avgPower=this.avgPower;
        satellite.rssi=this.rssi;
        satellite.rssiTarget=this.rssiTarget;
        satellite.lastTimeStamp=this.lastTimeStamp;
        return satellite;
    }
    /*Replace*/ public Satellite(Beacon mBP){
        this.mBP=mBP;
//        double[] latlon=MercatorProjection.WGS84toGoogleBing(mBP.lon,mBP.lat);
//        this.x=latlon[0];
//        this.y=latlon[1];

        this.x= MercatorProjection.longitudeToPixelX(mBP.lon,(byte)22);
        this.y= MercatorProjection.latitudeToPixelY(mBP.lat, (byte) 22);
    }

    public double getRSSI() {
        return rssi;
    }
    public void clearRSSI() {
        rssiTarget=0;
    }
    public void refreshRSSI() {
        if(rssi==0) {
            rssi=rssiTarget;
        }
        rssi=K_FACTOR*rssi+(1-K_FACTOR)*rssiTarget;
    }
    /*Replace*/ public void checkInRSSI(double rssi) {
        rssiTarget=rssi;
        lastTimeStamp=System.currentTimeMillis();
    }

    static public void setKfactor(double value){
        K_FACTOR=value;
    }

    static public double getKfactor(){
       return K_FACTOR;
    }

    public long getLastTimeStamp() {
        return lastTimeStamp;
    }

    static long BSSIDStringToLongInt(String BSSID) {
        long id = Long.valueOf(
                BSSID.substring(0, 2)+ BSSID.substring(3, 5)
                        + BSSID.substring(6, 8)+ BSSID.substring(9, 11)
                        + BSSID.substring(12, 14)+ BSSID.substring(15, 17), 16);
        return id;
    }


    /*Replace*/ public static class ComparatorSatelliteWiFiById implements Comparator<Satellite> {

        @Override
        public int compare(Satellite lhs, Satellite rhs) {
            if (lhs.mBP.id_wifi > rhs.mBP.id_wifi)
                return 1;
            else if (lhs.mBP.id_wifi == rhs.mBP.id_wifi)
                return lhs.mBP.ssid.compareTo(rhs.mBP.ssid);
            return -1;
        }
    }

    /*Replace*/ public static class ComparatorSatelliteBTLEById implements Comparator<Satellite> {

        @Override
        public int compare(Satellite lhs, Satellite rhs) {
            if (lhs.mBP.id_btle > rhs.mBP.id_btle)
                return 1;
            else if (lhs.mBP.id_btle == rhs.mBP.id_btle)
                return 0;

            return -1;
        }
    }

    /*Replace*/ public static class ComparatorSatelliteBTLEByRSSI implements Comparator<Satellite> {
        @Override
        public int compare(Satellite ScanResult, Satellite ScanResult2) {
            if (ScanResult.getRSSI() > ScanResult2.getRSSI())
                return -1;
            if (ScanResult.getRSSI() == ScanResult2.getRSSI())
                return 0;
            return 1;
        }
    }
}
