/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.cordova.CordovaDialogsHelper;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.engine.SystemWebViewEngine;

public class SystemWebChromeClient
extends WebChromeClient {
    private static final int FILECHOOSER_RESULTCODE = 5173;
    private static final String LOG_TAG = "SystemWebChromeClient";
    private long MAX_QUOTA;
    protected final SystemWebViewEngine parentEngine;
    private View mVideoProgressView;
    private CordovaDialogsHelper dialogsHelper;
    private Context appContext;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private View mCustomView;

    public SystemWebChromeClient(SystemWebViewEngine systemWebViewEngine) {
        SystemWebChromeClient systemWebChromeClient = this;
        this.MAX_QUOTA = 0x6400000L;
        this.parentEngine = systemWebViewEngine;
        systemWebChromeClient.appContext = systemWebViewEngine.webView.getContext();
        systemWebChromeClient.dialogsHelper = new CordovaDialogsHelper(this.appContext);
    }

    public boolean onJsAlert(WebView webView, String string2, String string3, final JsResult jsResult) {
        this.dialogsHelper.showAlert(string3, new CordovaDialogsHelper.Result(){

            @Override
            public void gotResult(boolean bl, String string2) {
                if (bl) {
                    jsResult.confirm();
                } else {
                    jsResult.cancel();
                }
            }
        });
        return true;
    }

    public boolean onJsConfirm(WebView webView, String string2, String string3, final JsResult jsResult) {
        this.dialogsHelper.showConfirm(string3, new CordovaDialogsHelper.Result(){

            @Override
            public void gotResult(boolean bl, String string2) {
                if (bl) {
                    jsResult.confirm();
                } else {
                    jsResult.cancel();
                }
            }
        });
        return true;
    }

    public boolean onJsPrompt(WebView object, String string2, String string3, String string4, final JsPromptResult jsPromptResult) {
        object = this.parentEngine.bridge.promptOnJsPrompt(string2, string3, string4);
        if (object != null) {
            jsPromptResult.confirm((String)object);
        } else {
            this.dialogsHelper.showPrompt(string3, string4, new CordovaDialogsHelper.Result(){

                @Override
                public void gotResult(boolean bl, String string2) {
                    if (bl) {
                        jsPromptResult.confirm(string2);
                    } else {
                        jsPromptResult.cancel();
                    }
                }
            });
        }
        return true;
    }

    public void onExceededDatabaseQuota(String string2, String string3, long l2, long l3, long l4, WebStorage.QuotaUpdater quotaUpdater) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[3];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = l3;
        objectArray3[1] = l2;
        objectArray2[2] = l4;
        LOG.d(LOG_TAG, "onExceededDatabaseQuota estimatedSize: %d  currentQuota: %d  totalUsedQuota: %d", objectArray3);
        quotaUpdater.updateQuota(objectArray.MAX_QUOTA);
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        if (consoleMessage.message() != null) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = consoleMessage.sourceId();
            objectArray2[1] = consoleMessage.lineNumber();
            objectArray[2] = consoleMessage.message();
            LOG.d(LOG_TAG, "%s: Line %d : %s", objectArray2);
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public void onGeolocationPermissionsShowPrompt(String string2, GeolocationPermissions.Callback callback) {
        super.onGeolocationPermissionsShowPrompt(string2, callback);
        callback.invoke(string2, true, false);
        CordovaPlugin cordovaPlugin = ((SystemWebChromeClient)((Object)cordovaPlugin)).parentEngine.pluginManager.getPlugin("Geolocation");
        if (cordovaPlugin != null && !cordovaPlugin.hasPermisssion()) {
            cordovaPlugin.requestPermissions(0);
        }
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.parentEngine.getCordovaWebView().showCustomView(view, customViewCallback);
    }

    public void onHideCustomView() {
        this.parentEngine.getCordovaWebView().hideCustomView();
    }

    public View getVideoLoadingProgressView() {
        if (this.mVideoProgressView == null) {
            LinearLayout linearLayout = new LinearLayout(this.parentEngine.getView().getContext());
            linearLayout.setOrientation(1);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ProgressBar progressBar = new ProgressBar(this.parentEngine.getView().getContext());
            new LinearLayout.LayoutParams(-2, -2).gravity = 17;
            progressBar.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            linearLayout.addView((View)progressBar);
            this.mVideoProgressView = linearLayout;
        }
        return this.mVideoProgressView;
    }

    public void openFileChooser(ValueCallback<Uri> valueCallback) {
        this.openFileChooser(valueCallback, "*/*");
    }

    public void openFileChooser(ValueCallback<Uri> valueCallback, String string2) {
        this.openFileChooser(valueCallback, string2, null);
    }

    public void openFileChooser(final ValueCallback<Uri> valueCallback, String string2, String string3) {
        Intent intent;
        string2 = intent;
        new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE");
        string2.setType("*/*");
        this.parentEngine.cordova.startActivityForResult(new CordovaPlugin(){

            @Override
            public void onActivityResult(int n2, int n3, Intent intent) {
                Uri uri = intent != null && n3 == -1 ? intent.getData() : null;
                LOG.d(SystemWebChromeClient.LOG_TAG, "Receive file chooser URL: " + uri);
                valueCallback.onReceiveValue((Object)uri);
            }
        }, (Intent)string2, 5173);
    }

    @TargetApi(value=21)
    public boolean onShowFileChooser(WebView object, final ValueCallback<Uri[]> valueCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        object = false;
        if (fileChooserParams.getMode() == 1) {
            object = true;
        }
        fileChooserParams = fileChooserParams.createIntent();
        fileChooserParams.putExtra("android.intent.extra.ALLOW_MULTIPLE", (Serializable)object);
        CordovaInterface cordovaInterface = this.parentEngine.cordova;
        try {
            cordovaInterface.startActivityForResult(new CordovaPlugin(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void onActivityResult(int var1_1, int var2_4, Intent var3_6) {
                    var1_2 = null;
                    if (var2_4 != -1 || var3_6 == null) ** GOTO lbl-1000
                    if (var3_6.getClipData() != null) {
                        var1_3 = var3_6.getClipData().getItemCount();
                        var2_5 = new Uri[var1_3];
                        for (var4_7 = 0; var4_7 < var1_3; ++var4_7) {
                            var2_5[var4_7] = var3_6.getClipData().getItemAt(var4_7).getUri();
                            LOG.d("SystemWebChromeClient", "Receive file chooser URL: " + var2_5[var4_7]);
                        }
                    } else if (var3_6.getData() != null) {
                        var2_5 = WebChromeClient.FileChooserParams.parseResult((int)var2_4, (Intent)var3_6);
                        LOG.d("SystemWebChromeClient", "Receive file chooser URL: " + var2_5);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_5 = var1_2;
                    }
                    valueCallback.onReceiveValue(var2_5);
                }
            }, (Intent)fileChooserParams, 5173);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            LOG.w("No activity found to handle file chooser intent.", activityNotFoundException);
            valueCallback.onReceiveValue(null);
        }
        return true;
    }

    @TargetApi(value=21)
    public void onPermissionRequest(PermissionRequest permissionRequest) {
        PermissionRequest permissionRequest2 = permissionRequest;
        LOG.d(LOG_TAG, "onPermissionRequest: " + Arrays.toString(permissionRequest.getResources()));
        permissionRequest2.grant(permissionRequest2.getResources());
    }

    public void destroyLastDialog() {
        this.dialogsHelper.destroyLastDialog();
    }
}

