/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine;

import android.graphics.Point;
import com.sails.engine.MapView;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.MapPosition;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayController;
import com.sails.engine.overlay.ScreenDensity;

public class MapViewPosition {
    private double a;
    private double b;
    private final MapView c;
    private float d;

    MapViewPosition(MapView mapView) {
        MapViewPosition mapViewPosition = this;
        mapViewPosition.c = mapView;
        mapViewPosition.a = 0.0;
        mapViewPosition.b = 0.0;
        mapViewPosition.d = 0.0f;
    }

    private float a(float f2) {
        MapViewPosition mapViewPosition = this;
        float f3 = mapViewPosition.c.getMapZoomControls().c();
        return Math.max(Math.min(f2, mapViewPosition.c.getZoomLevelMax()), f3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(GeoPoint serializable) {
        MapViewPosition mapViewPosition = mapViewPosition3;
        GeoPoint geoPoint = serializable;
        GeoPoint geoPoint2 = serializable;
        MapViewPosition mapViewPosition2 = mapViewPosition3;
        serializable = mapViewPosition2.getMapPosition();
        serializable = mapViewPosition2.c.getProjection().toPoint(((MapPosition)serializable).geoPoint, null, ((MapPosition)serializable).zoomLevel);
        synchronized (mapViewPosition2) {
            mapViewPosition3.a = geoPoint2.latitude;
            mapViewPosition.b = geoPoint.longitude;
            // ** MonitorExit[v0] (shouldn't be in output)
            MapPosition mapPosition = mapViewPosition.getMapPosition();
            MapViewPosition mapViewPosition3 = mapViewPosition.c.getProjection().toPoint(mapViewPosition3.getCenter(), null, mapPosition.zoomLevel);
            mapViewPosition.c.getOverlayController().postTranslate(((Point)serializable).x - ((Point)mapViewPosition3).x, ((Point)serializable).y - ((Point)mapViewPosition3).y);
            return;
        }
    }

    private synchronized float b(float f2) {
        MapViewPosition mapViewPosition = this;
        return mapViewPosition.d(mapViewPosition.d + f2);
    }

    private void c(float f2) {
        MapViewPosition mapViewPosition = this;
        float f3 = mapViewPosition.d(f2);
        int n2 = mapViewPosition.c.getWidth() / 2;
        int n3 = mapViewPosition.c.getHeight() / 2;
        float f4 = f3;
        mapViewPosition.c.getOverlayController().postScale(f4, f4, n2, n3);
    }

    private synchronized float d(float f2) {
        float f3 = f2;
        f2 = this.d;
        float f4 = this.a(f3);
        if (f4 == f2) {
            return 1.0f;
        }
        MapViewPosition mapViewPosition = this;
        mapViewPosition.d = f4;
        mapViewPosition.c.onZoomLevelChange(f4);
        mapViewPosition.c.getMapZoomControls().c(f4);
        double d2 = f4 - f2;
        return (float)Math.pow(2.0, d2);
    }

    public synchronized BoundingBox getBoundingBox() {
        MapViewPosition mapViewPosition = this;
        double d2 = MercatorProjection.longitudeToPixelX(mapViewPosition.b, this.d);
        double d3 = MercatorProjection.latitudeToPixelY(mapViewPosition.a, this.d);
        int n2 = mapViewPosition.c.getWidth() / 2;
        int n3 = mapViewPosition.c.getHeight() / 2;
        double d4 = n2;
        double d5 = d2 - d4;
        d5 = Math.max(0.0, d5);
        double d6 = n3;
        double d7 = d3 - d6;
        d7 = Math.max(0.0, d7);
        double d8 = MercatorProjection.getMapSize(mapViewPosition.d);
        double d9 = Math.min(d8, d2 + d4);
        d2 = MercatorProjection.pixelYToLatitude(Math.min(d8, d3 + d6), this.d);
        d3 = MercatorProjection.pixelXToLongitude(d5, this.d);
        d4 = MercatorProjection.pixelYToLatitude(d7, this.d);
        d5 = MercatorProjection.pixelXToLongitude(d9, this.d);
        return new BoundingBox(d2, d3, d4, d5);
    }

    public synchronized BoundingBox getBoundingBox(float f2) {
        MapViewPosition mapViewPosition = this;
        double d2 = MercatorProjection.longitudeToPixelX(mapViewPosition.b, f2);
        double d3 = MercatorProjection.latitudeToPixelY(mapViewPosition.a, f2);
        int n2 = mapViewPosition.c.getWidth() / 2;
        int n3 = mapViewPosition.c.getHeight() / 2;
        double d4 = n2;
        double d5 = d2 - d4 / (double)ScreenDensity.density;
        d5 = Math.max(0.0, d5);
        double d6 = n3;
        double d7 = d3 - d6 / (double)ScreenDensity.density;
        d7 = Math.max(0.0, d7);
        double d8 = MercatorProjection.getMapSize(f2);
        double d9 = Math.min(d8, d2 + d4 / (double)ScreenDensity.density);
        double d10 = MercatorProjection.pixelYToLatitude(Math.min(d8, d3 + d6 / (double)ScreenDensity.density), f2);
        d2 = MercatorProjection.pixelXToLongitude(d5, f2);
        d3 = MercatorProjection.pixelYToLatitude(d7, f2);
        d4 = MercatorProjection.pixelXToLongitude(d9, f2);
        return new BoundingBox(d10, d2, d3, d4);
    }

    public synchronized BoundingBox getBoundingBox(double d2, double d3, int n2, float f2) {
        double d4 = MercatorProjection.longitudeToPixelX(d3, f2);
        double d5 = MercatorProjection.latitudeToPixelY(d2, f2);
        int n3 = n2 / 2;
        double d6 = n3;
        double d7 = d4 - d6 / (double)ScreenDensity.density;
        d7 = Math.max(0.0, d7);
        double d8 = d5 - d6 / (double)ScreenDensity.density;
        d8 = Math.max(0.0, d8);
        double d9 = MercatorProjection.getMapSize(f2);
        double d10 = Math.min(d9, d4 + d6 / (double)ScreenDensity.density);
        d4 = MercatorProjection.pixelYToLatitude(Math.min(d9, d5 + d6 / (double)ScreenDensity.density), f2);
        d5 = MercatorProjection.pixelXToLongitude(d7, f2);
        d6 = MercatorProjection.pixelYToLatitude(d8, f2);
        d7 = MercatorProjection.pixelXToLongitude(d10, f2);
        return new BoundingBox(d4, d5, d6, d7);
    }

    public synchronized BoundingBox getBoundingBox(double d2, double d3, float f2) {
        MapViewPosition mapViewPosition = this;
        double d4 = MercatorProjection.longitudeToPixelX(d3, f2);
        double d5 = MercatorProjection.latitudeToPixelY(d2, f2);
        int n2 = mapViewPosition.c.getWidth() / 2;
        int n3 = mapViewPosition.c.getHeight() / 2;
        double d6 = n2;
        double d7 = d4 - d6 / (double)ScreenDensity.density;
        d7 = Math.max(0.0, d7);
        double d8 = n3;
        double d9 = d5 - d8 / (double)ScreenDensity.density;
        d9 = Math.max(0.0, d9);
        double d10 = MercatorProjection.getMapSize(f2);
        double d11 = Math.min(d10, d4 + d6 / (double)ScreenDensity.density);
        d4 = MercatorProjection.pixelYToLatitude(Math.min(d10, d5 + d8 / (double)ScreenDensity.density), f2);
        d5 = MercatorProjection.pixelXToLongitude(d7, f2);
        double d12 = MercatorProjection.pixelYToLatitude(d9, f2);
        d6 = MercatorProjection.pixelXToLongitude(d11, f2);
        return new BoundingBox(d4, d5, d12, d6);
    }

    public synchronized GeoPoint getCenter() {
        return new GeoPoint(this.a, this.b);
    }

    public synchronized MapPosition getMapPosition() {
        return new MapPosition(this.getCenter(), this.d);
    }

    public synchronized float getZoomLevel() {
        return this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveCenter(float f2, float f3) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            double d2 = MercatorProjection.longitudeToPixelX(mapViewPosition.b, this.d) - (double)f2;
            double d3 = MercatorProjection.latitudeToPixelY(mapViewPosition.a, this.d) - (double)f3;
            long l2 = MercatorProjection.getMapSize(mapViewPosition.d);
            double d4 = Math.max(0.0, d2);
            d2 = l2;
            double d5 = Math.min(d4, d2);
            MapViewPosition mapViewPosition2 = this;
            d3 = MercatorProjection.pixelYToLatitude(Math.min(Math.max(0.0, d3), d2), this.d);
            d2 = MercatorProjection.pixelXToLongitude(d5, mapViewPosition2.d);
            mapViewPosition.a(new GeoPoint(d3, d2));
            // MONITOREXIT @DISABLED, blocks:[6, 7] lbl20 : MonitorExitStatement: MONITOREXIT : v41124
            mapViewPosition.c.redraw();
            return;
        }
    }

    public void setCenter(GeoPoint geoPoint) {
        MapViewPosition mapViewPosition = this;
        mapViewPosition.a(geoPoint);
        mapViewPosition.c.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapPosition(MapPosition mapPosition) {
        MapViewPosition mapViewPosition = this;
        synchronized (this) {
            this.a(mapPosition.geoPoint);
            mapViewPosition.c(mapPosition.zoomLevel);
            // ** MonitorExit[v0] (shouldn't be in output)
            mapViewPosition.c.redrawMapItems();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapScale(float f2) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            int n2 = mapViewPosition.c.getWidth() / 2;
            int n3 = mapViewPosition.c.getHeight() / 2;
            OverlayController overlayController = mapViewPosition.c.getOverlayController();
            float f3 = f2;
            overlayController.postScale(f3, f3, n2, n3);
            // MONITOREXIT @DISABLED, blocks:[3, 4] lbl12 : MonitorExitStatement: MONITOREXIT : v41201
            mapViewPosition.c.redraw();
            return;
        }
    }

    public void setZoomLevel(float f2) {
        MapViewPosition mapViewPosition = this;
        mapViewPosition.c(f2);
        mapViewPosition.c.redrawMapItems();
    }

    public void zoom(float f2, float f3) {
        MapViewPosition mapViewPosition = this;
        mapViewPosition.b(f2);
        int cfr_ignored_0 = mapViewPosition.c.getWidth() / 2;
        int cfr_ignored_1 = mapViewPosition.c.getHeight() / 2;
    }

    public void zoomIn() {
        this.zoom(1.0f, 1.0f);
    }

    public void zoomOut() {
        this.zoom(-1.0f, 1.0f);
    }
}

