export class BeaconsScanner {//定义了一个名字为Person的类

    constructor(iab, configs) {//constructor是一个构造方法，用来接收参数
        this.iab = iab;
        if (configs instanceof ScannerConfig) {
            this.configs = configs
        }
        this.scanBeaconIndex = {};
    }

    updateConfigs(configs) {
        if (configs instanceof ScannerConfig) {
            this.configs = configs
        }
    }

    startScan() {
        this.checkBluetooth();

        this.subscribeBeacons();

        this.startRangingBeacons();
    }


    startRangingBeacons() {

        let uuids = this.configs.uuids;
        for(let i=0;i<uuids.length;i++){
            var uuid = uuids[i];
            var identifier = `rangingId-${i}`;
            var major = 0;
            var minor = 0;
            var beaconRegion = new cordova.plugins.locationManager.BeaconRegion(identifier, uuid, major, minor);


            cordova.plugins.locationManager.requestWhenInUseAuthorization();

            cordova.plugins.locationManager.startRangingBeaconsInRegion(beaconRegion)
                .fail((e) => {
                    console.error(e);
                })
                .done();
        }

    }

    subscribeBeacons() {
        const delegate = new cordova.plugins.locationManager.Delegate();
        delegate.didRangeBeaconsInRegion = (pluginResult) => {

            let realBeaconsAry = pluginResult.beacons;
            var time = Date.now();

            realBeaconsAry = realBeaconsAry
                .filter(a => {
                    return a.rssi != 0;
                })
                .sort((a, b) => {
                    return b.rssi - a.rssi;
                });
            if (realBeaconsAry.length > 50) {
                realBeaconsAry.length = 50;
            }

            for (let i = 0, len = realBeaconsAry.length; i < len; i++) {
                //查找相同beacon
                var index =
                    realBeaconsAry[i].uuid +
                    "-" +
                    realBeaconsAry[i].major +
                    "-" +
                    realBeaconsAry[i].minor;
                var beacon = this.scanBeaconIndex[index];
                if (beacon) {
                    if (
                        //realBeaconsAry[i].rssi != beacon.rssi &&
                        realBeaconsAry[i].rssi > -100
                    ) {
                        //替换
                        beacon.time = time;
                        beacon.rssi = realBeaconsAry[i].rssi;
                    }
                } else {
                    beacon = realBeaconsAry[i];
                    beacon.time = time;
                    this.scanBeaconIndex[index] = beacon;
                }
            }


            this.sendBeaconsData();

        };
        cordova.plugins.locationManager.setDelegate(delegate);
    }

    sendBeaconsData() {
        var realBeacons = this.filterBeacons();

        this.iab.executeScript({code: `window.pushBeacons(${JSON.stringify({beacons:realBeacons})})`}, (params) => {
            console.log(params);
        });
    }

    //过滤ibeacon信号
    filterBeacons() {
        //删除更新不及时的beacons
        let beaconsTemp = [];
        let time = Date.now();
        for (var key in this.scanBeaconIndex) {
            if (this.scanBeaconIndex[key].time && time - this.scanBeaconIndex[key].time <= 5000) {
                beaconsTemp.push(this.scanBeaconIndex[key]);
            } else {
                if (time - this.scanBeaconIndex[key].time > 60000) delete this.scanBeaconIndex[key];
            }
        }

        beaconsTemp.sort((a, b) => {
            return b.rssi - a.rssi;
        });
        if (beaconsTemp.length > 50) {
            beaconsTemp.length = 50;
        }

        return beaconsTemp;
    }

    checkBluetooth() {
        cordova.plugins.locationManager.isBluetoothEnabled()
            .then(function (isEnabled) {
                console.log("isEnabled: " + isEnabled);
                if (!isEnabled) {
                    cordova.plugins.locationManager.enableBluetooth();
                }
            })
            .fail(function (e) {
                console.error(e);
            })
            .done();
    }
}


//发送beacon信号的时间间隔
const BEACON_INTERVAL = 500;
const SEARCH_INTERVAL = 3000;
const DEFAULT_UUIDS = ["FDA50693-A4E2-4FB1-AFCF-C6EB07647825"];

export class ScannerConfig {


    constructor() {
        this.uuids = DEFAULT_UUIDS;
        this.beaconInterval = BEACON_INTERVAL;
    }

    setUuids(uuids) {
        this.uuids = uuids;
    }


}
