/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.device;

import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;
import java.util.TimeZone;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.json.JSONArray;
import org.json.JSONObject;

public class Device
extends CordovaPlugin {
    public static final String TAG = "Device";
    public static String platform;
    public static String uuid;
    private static final String ANDROID_PLATFORM = "Android";
    private static final String AMAZON_PLATFORM = "amazon-fireos";
    private static final String AMAZON_DEVICE = "Amazon";

    public void initialize(CordovaInterface cordovaInterface, CordovaWebView cordovaWebView) {
        Device device = this;
        super.initialize(cordovaInterface, cordovaWebView);
        uuid = device.getUuid();
    }

    public boolean execute(String string2, JSONArray jSONArray, CallbackContext callbackContext) {
        if ("getDeviceInfo".equals(string2)) {
            JSONObject jSONObject;
            String string3 = string2 = jSONObject;
            string3();
            string3.put("uuid", (Object)uuid);
            string2.put("version", (Object)this.getOSVersion());
            string2.put("platform", (Object)this.getPlatform());
            string2.put("model", (Object)this.getModel());
            string2.put("manufacturer", (Object)this.getManufacturer());
            string2.put("isVirtual", this.isVirtual());
            jSONObject.put("serial", (Object)this.getSerialNumber());
            callbackContext.success(jSONObject);
            return true;
        }
        return false;
    }

    public String getPlatform() {
        return this.isAmazonDevice() ? AMAZON_PLATFORM : ANDROID_PLATFORM;
    }

    public String getUuid() {
        return Settings.Secure.getString((ContentResolver)this.cordova.getActivity().getContentResolver(), (String)"android_id");
    }

    public String getModel() {
        return Build.MODEL;
    }

    public String getProductName() {
        return Build.PRODUCT;
    }

    public String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public String getSerialNumber() {
        return Build.SERIAL;
    }

    public String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    public String getSDKVersion() {
        return Build.VERSION.SDK;
    }

    public String getTimeZoneID() {
        return TimeZone.getDefault().getID();
    }

    public boolean isAmazonDevice() {
        return Build.MANUFACTURER.equals(AMAZON_DEVICE);
    }

    public boolean isVirtual() {
        return Build.FINGERPRINT.contains("generic") || Build.PRODUCT.contains("sdk");
    }
}

