/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;

public class Marker
implements OverlayItem {
    private Drawable a;
    private GeoPoint b;
    private Rect c = new Rect();
    private int d = 255;

    public static Drawable boundCenter(Drawable drawable) {
        Drawable drawable2 = drawable;
        int n2 = drawable2.getIntrinsicWidth();
        int n3 = drawable.getIntrinsicHeight();
        drawable2.setBounds(n2 / -2, n3 / -2, n2 / 2, n3 / 2);
        return drawable2;
    }

    public static Drawable boundCenterBottom(Drawable drawable) {
        Drawable drawable2 = drawable;
        int n2 = drawable2.getIntrinsicWidth();
        int n3 = drawable.getIntrinsicHeight();
        drawable2.setBounds(n2 / -2, -n3, n2 / 2, 0);
        return drawable2;
    }

    private static boolean a(Canvas canvas, float f2, float f3, float f4, float f5) {
        return f4 >= 0.0f && f2 <= (float)canvas.getWidth() && f5 >= 0.0f && f3 <= (float)canvas.getHeight();
    }

    public Marker(GeoPoint geoPoint, Drawable drawable) {
        this.b = geoPoint;
        this.a = drawable;
    }

    public void setTransparency(int n2) {
        this.d = n2;
    }

    @Override
    public synchronized boolean draw(BoundingBox serializable, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        serializable = this.b;
        if (serializable != null && this.a != null) {
            int n4 = (int)(MercatorProjection.longitudeToPixelX(((GeoPoint)serializable).longitude, f2) - point.x);
            float f4 = ScreenDensity.density;
            double d2 = (float)(n4 - n2) * f4;
            double d3 = (float)((int)(MercatorProjection.latitudeToPixelY(((GeoPoint)serializable).latitude, f2) - point.y) - n3) * f4;
            double d4 = d3;
            double d5 = (double)(-f3) / 180.0 * Math.PI;
            d4 = d2 * Math.cos(d5) + d4 * Math.sin(d5);
            d2 = d3 * Math.cos(d5) - d2 * Math.sin(d5);
            double d6 = (double)n3 + d2;
            int n5 = (int)((double)n2 + d4);
            int n6 = (int)d6;
            Rect rect = this.a.copyBounds();
            int n7 = rect.left;
            int n8 = n5 + n7;
            int n9 = n6;
            int n10 = n5;
            int n11 = n6;
            n6 = rect.top;
            n5 = n11 + n6;
            int n12 = rect.right;
            int n13 = n10 + n12;
            int n14 = rect.bottom;
            int n15 = n9 + n14;
            Rect rect2 = this.c;
            int n16 = (int)d4;
            rect2.left = n16 + n7;
            int n17 = (int)d2;
            rect2.top = n17 + n6;
            rect2.right = n16 + n12;
            this.c.bottom = n17 + n14;
            if (!Marker.a(canvas, n8, n5, n13, n15)) {
                return false;
            }
            Marker marker = this;
            marker.a.setAlpha(this.d);
            marker.a.setBounds(n8, n5, n13, n15);
            marker.a.draw(canvas);
            marker.a.setBounds(rect);
            return true;
        }
        return false;
    }

    public boolean isInMarker(int n2, int n3) {
        Marker marker = marker.c;
        return n2 > ((Rect)marker).left && n2 < ((Rect)marker).right && n3 > ((Rect)marker).top && n3 < ((Rect)marker).bottom;
    }

    public synchronized Drawable getDrawable() {
        return this.a;
    }

    public synchronized GeoPoint getGeoPoint() {
        return this.b;
    }

    public synchronized void setDrawable(Drawable drawable) {
        this.a = drawable;
    }

    public synchronized void setGeoPoint(GeoPoint geoPoint) {
        this.b = geoPoint;
    }
}

