/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.widget.ImageButton;
import com.sails.engine.MapView;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class MapJPGOverlay
implements OverlayItem {
    public static int LOGLEVEL = 0;
    public static boolean WARN = LOGLEVEL > 1;
    public static boolean DEBUG = LOGLEVEL > 0;
    public static final int DefaultRefreshPeriod = 100;
    public MapView mMapView = null;
    public ImageButton mLockButton = null;
    private Bitmap c = null;
    private final Paint d;
    private android.graphics.Point e = new android.graphics.Point();
    private android.graphics.Point f = new android.graphics.Point();
    GeoPoint a = new GeoPoint(0.0, 0.0);
    GeoPoint b = new GeoPoint(0.01, 0.01);

    public MapJPGOverlay(Bitmap bitmap) {
        this.c = bitmap;
        this.d = new Paint(1);
        this.d.setFilterBitmap(true);
    }

    public boolean isLoadMap() {
        return this.c != null;
    }

    public synchronized void loadJPGMap(Bitmap bitmap) {
        Bitmap bitmap2 = this.c;
        if (bitmap2 != null) {
            bitmap2.recycle();
        }
        this.c = bitmap;
    }

    public boolean toSaveBMP(File file) {
        FileOutputStream fileOutputStream;
        MapJPGOverlay mapJPGOverlay;
        if (((MapJPGOverlay)((Object)fileOutputStream2)).c == null) {
            return false;
        }
        try {
            mapJPGOverlay = fileOutputStream2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        FileOutputStream fileOutputStream2 = fileOutputStream;
        fileOutputStream = new FileOutputStream(file);
        mapJPGOverlay.c.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream2);
        return true;
    }

    public GeoPoint getBMPCenter() {
        Bitmap bitmap = this.c;
        if (bitmap == null) {
            return new GeoPoint(0.0, 0.0);
        }
        return new GeoPoint(-this.b.longitude / (double)bitmap.getWidth() * (double)this.c.getHeight() / 2.0, this.b.longitude / 2.0);
    }

    public synchronized void clear() {
        Bitmap bitmap = this.c;
        if (bitmap != null) {
            bitmap.recycle();
        }
        this.c = null;
    }

    @Override
    public synchronized boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        Matrix matrix;
        if (this.c == null) {
            return true;
        }
        MapJPGOverlay mapJPGOverlay = this;
        mapJPGOverlay.mMapView.getProjection().toPixels(this.a, this.e);
        mapJPGOverlay.mMapView.getProjection().toPixels(this.b, this.f);
        android.graphics.Point point2 = mapJPGOverlay.e;
        float f4 = ScreenDensity.density;
        double d2 = (float)(point2.x - n2) * f4;
        double d3 = (float)(point2.y - n3) * f4;
        new android.graphics.Point();
        float f5 = (float)(mapJPGOverlay.f.x - this.e.x) * ScreenDensity.density / (float)this.c.getWidth();
        Matrix matrix2 = matrix;
        float f6 = f5;
        matrix2();
        matrix2.postScale(f6, f6);
        matrix2.postTranslate((float)((int)d2 + n2) + (float)(canvas.getWidth() * 1465 / 10000) * ScreenDensity.density, (float)((int)d3 + n3) + (float)(canvas.getHeight() * 1465 / 10000) * ScreenDensity.density);
        matrix.postRotate(f3, (float)n2, (float)n3);
        canvas.drawBitmap(mapJPGOverlay.c, matrix2, this.d);
        return true;
    }
}

