/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.whitelist;

import android.content.Context;
import org.apache.cordova.ConfigXmlParser;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.Whitelist;
import org.xmlpull.v1.XmlPullParser;

public class WhitelistPlugin
extends CordovaPlugin {
    private static final String LOG_TAG = "WhitelistPlugin";
    private Whitelist allowedNavigations;
    private Whitelist allowedIntents;
    private Whitelist allowedRequests;

    public WhitelistPlugin() {
    }

    public WhitelistPlugin(Context context) {
        this(new Whitelist(), new Whitelist(), null);
        new CustomConfigXmlParser().parse(context);
    }

    public WhitelistPlugin(XmlPullParser xmlPullParser) {
        this(new Whitelist(), new Whitelist(), null);
        new CustomConfigXmlParser().parse(xmlPullParser);
    }

    public WhitelistPlugin(Whitelist whitelist, Whitelist whitelist2, Whitelist whitelist3) {
        if (whitelist3 == null) {
            Whitelist whitelist4;
            whitelist3 = whitelist4;
            new Whitelist().addWhiteListEntry("file:///*", false);
            whitelist3.addWhiteListEntry("data:*", false);
        }
        this.allowedNavigations = whitelist;
        this.allowedIntents = whitelist2;
        this.allowedRequests = whitelist3;
    }

    public void pluginInitialize() {
        if (this.allowedNavigations == null) {
            WhitelistPlugin whitelistPlugin = this;
            whitelistPlugin.allowedNavigations = new Whitelist();
            whitelistPlugin.allowedIntents = new Whitelist();
            whitelistPlugin.allowedRequests = new Whitelist();
            new CustomConfigXmlParser().parse(this.webView.getContext());
        }
    }

    public Boolean shouldAllowNavigation(String string2) {
        if (this.allowedNavigations.isUrlWhiteListed(string2)) {
            return true;
        }
        return null;
    }

    public Boolean shouldAllowRequest(String string2) {
        if (Boolean.TRUE == this.shouldAllowNavigation(string2)) {
            return true;
        }
        if (this.allowedRequests.isUrlWhiteListed(string2)) {
            return true;
        }
        return null;
    }

    public Boolean shouldOpenExternalUrl(String string2) {
        if (this.allowedIntents.isUrlWhiteListed(string2)) {
            return true;
        }
        return null;
    }

    public Whitelist getAllowedNavigations() {
        return this.allowedNavigations;
    }

    public void setAllowedNavigations(Whitelist whitelist) {
        this.allowedNavigations = whitelist;
    }

    public Whitelist getAllowedIntents() {
        return this.allowedIntents;
    }

    public void setAllowedIntents(Whitelist whitelist) {
        this.allowedIntents = whitelist;
    }

    public Whitelist getAllowedRequests() {
        return this.allowedRequests;
    }

    public void setAllowedRequests(Whitelist whitelist) {
        this.allowedRequests = whitelist;
    }

    private class CustomConfigXmlParser
    extends ConfigXmlParser {
        private CustomConfigXmlParser() {
        }

        public void handleStartTag(XmlPullParser object) {
            Object object2;
            String string2 = object.getName();
            if (string2.equals("content")) {
                CustomConfigXmlParser customConfigXmlParser = object2;
                object2 = object.getAttributeValue(null, "src");
                customConfigXmlParser.WhitelistPlugin.this.allowedNavigations.addWhiteListEntry((String)object2, false);
            } else if (string2.equals("allow-navigation")) {
                if ("*".equals(object = object.getAttributeValue(null, "href"))) {
                    Object object3 = object2;
                    object3.WhitelistPlugin.this.allowedNavigations.addWhiteListEntry("http://*/*", false);
                    object3.WhitelistPlugin.this.allowedNavigations.addWhiteListEntry("https://*/*", false);
                    object3.WhitelistPlugin.this.allowedNavigations.addWhiteListEntry("data:*", false);
                } else {
                    object2.WhitelistPlugin.this.allowedNavigations.addWhiteListEntry((String)object, false);
                }
            } else if (string2.equals("allow-intent")) {
                Object object4 = object2;
                object2 = object.getAttributeValue(null, "href");
                object4.WhitelistPlugin.this.allowedIntents.addWhiteListEntry((String)object2, false);
            } else if (string2.equals("access")) {
                Object object5 = object;
                object = object5.getAttributeValue(null, "origin");
                string2 = object5.getAttributeValue(null, "subdomains");
                boolean bl = object5.getAttributeValue(null, "launch-external") != null;
                if (object != null) {
                    if (bl) {
                        LOG.w((String)WhitelistPlugin.LOG_TAG, (String)"Found <access launch-external> within config.xml. Please use <allow-intent> instead.");
                        object2 = object2.WhitelistPlugin.this.allowedIntents;
                        boolean bl2 = string2 != null && string2.compareToIgnoreCase("true") == 0;
                        object2.addWhiteListEntry((String)object, bl2);
                    } else if ("*".equals(object)) {
                        Object object6 = object2;
                        object6.WhitelistPlugin.this.allowedRequests.addWhiteListEntry("http://*/*", false);
                        object6.WhitelistPlugin.this.allowedRequests.addWhiteListEntry("https://*/*", false);
                    } else {
                        object2 = object2.WhitelistPlugin.this.allowedRequests;
                        boolean bl3 = string2 != null && string2.compareToIgnoreCase("true") == 0;
                        object2.addWhiteListEntry((String)object, bl3);
                    }
                }
            }
        }

        public void handleEndTag(XmlPullParser xmlPullParser) {
        }
    }
}

