/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.statusbar;

import android.graphics.Color;
import android.os.Build;
import android.view.Window;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;
import org.json.JSONException;

public class StatusBar
extends CordovaPlugin {
    private static final String TAG = "StatusBar";

    private void setStatusBarBackgroundColor(String string2) {
        if (Build.VERSION.SDK_INT >= 21 && string2 != null && !string2.isEmpty()) {
            StatusBar statusBar = statusBar.cordova.getActivity().getWindow();
            statusBar.clearFlags(0x4000000);
            statusBar.addFlags(Integer.MIN_VALUE);
            Class<?> clazz = ((Object)((Object)statusBar)).getClass();
            Class[] classArray = new Class[1];
            classArray[0] = Integer.TYPE;
            Method method = clazz.getMethod("setStatusBarColor", classArray);
            StatusBar statusBar2 = statusBar;
            Object[] objectArray = new Object[1];
            try {
                objectArray[0] = Color.parseColor((String)string2);
                method.invoke((Object)statusBar2, objectArray);
            }
            catch (Exception exception) {
                LOG.w((String)TAG, (String)("Method window.setStatusBarColor not found for SDK level " + Build.VERSION.SDK_INT));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.e((String)TAG, (String)"Invalid hexString argument, use f.i. '#999999'");
            }
        }
    }

    private void setStatusBarTransparent(boolean bl) {
        if (Build.VERSION.SDK_INT >= 21) {
            StatusBar statusBar = statusBar.cordova.getActivity().getWindow();
            if (bl) {
                StatusBar statusBar2 = statusBar;
                statusBar2.getDecorView().setSystemUiVisibility(1280);
                statusBar2.setStatusBarColor(0);
            } else {
                statusBar.getDecorView().setSystemUiVisibility(256);
            }
        }
    }

    private void setStatusBarStyle(String string2) {
        if (Build.VERSION.SDK_INT >= 23 && string2 != null && !string2.isEmpty()) {
            StatusBar statusBar = statusBar.cordova.getActivity().getWindow().getDecorView();
            int n2 = statusBar.getSystemUiVisibility();
            String[] stringArray = new String[3];
            String[] stringArray2 = stringArray;
            stringArray[0] = "lightcontent";
            stringArray[1] = "blacktranslucent";
            stringArray[2] = "blackopaque";
            if (Arrays.asList("default").contains(string2.toLowerCase())) {
                statusBar.setSystemUiVisibility(n2 | 0x2000);
                return;
            }
            if (Arrays.asList(stringArray2).contains(string2.toLowerCase())) {
                statusBar.setSystemUiVisibility(n2 & 0xFFFFDFFF);
                return;
            }
            LOG.e((String)TAG, (String)"Invalid style, must be either 'default', 'lightcontent' or the deprecated 'blacktranslucent' and 'blackopaque'");
        }
    }

    public void initialize(final CordovaInterface cordovaInterface, CordovaWebView cordovaWebView) {
        StatusBar statusBar = this;
        LOG.v((String)TAG, (String)"StatusBar: initialization");
        super.initialize(cordovaInterface, cordovaWebView);
        statusBar.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                1 v0 = this;
                v0.cordovaInterface.getActivity().getWindow().clearFlags(2048);
                StatusBar statusBar = v0.StatusBar.this;
                statusBar.setStatusBarBackgroundColor(statusBar.preferences.getString("StatusBarBackgroundColor", "#000000"));
                StatusBar statusBar2 = v0.StatusBar.this;
                statusBar2.setStatusBarStyle(statusBar2.preferences.getString("StatusBarStyle", "lightcontent"));
            }
        });
    }

    public boolean execute(String string2, final CordovaArgs cordovaArgs, CallbackContext callbackContext) {
        LOG.v((String)TAG, (String)("Executing action: " + string2));
        final Window window = this.cordova.getActivity().getWindow();
        if ("_ready".equals(string2)) {
            boolean bl = (window.getAttributes().flags & 0x400) == 0;
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, bl));
            return true;
        }
        if ("show".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 19) {
                        2 v0 = this;
                        int n2 = v0.window.getDecorView().getSystemUiVisibility() & 0xFFFFFBFF & 0xFFFFFFFB;
                        v0.window.getDecorView().setSystemUiVisibility(n2);
                    }
                    window.clearFlags(1024);
                }
            });
            return true;
        }
        if ("hide".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 19) {
                        3 v0 = this;
                        int n2 = v0.window.getDecorView().getSystemUiVisibility() | 0x400 | 4;
                        v0.window.getDecorView().setSystemUiVisibility(n2);
                    }
                    window.addFlags(1024);
                }
            });
            return true;
        }
        if ("backgroundColorByHexString".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        StatusBar.this.setStatusBarBackgroundColor(cordovaArgs.getString(0));
                    }
                    catch (JSONException jSONException) {
                        LOG.e((String)StatusBar.TAG, (String)"Invalid hexString argument, use f.i. '#777777'");
                    }
                }
            });
            return true;
        }
        if ("overlaysWebView".equals(string2)) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.cordova.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            StatusBar.this.setStatusBarTransparent(cordovaArgs.getBoolean(0));
                        }
                        catch (JSONException jSONException) {
                            LOG.e((String)StatusBar.TAG, (String)"Invalid boolean argument");
                        }
                    }
                });
                return true;
            }
            return cordovaArgs.getBoolean(0) ^ true;
        }
        if ("styleDefault".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.setStatusBarStyle("default");
                }
            });
            return true;
        }
        if ("styleLightContent".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.setStatusBarStyle("lightcontent");
                }
            });
            return true;
        }
        if ("styleBlackTranslucent".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.setStatusBarStyle("blacktranslucent");
                }
            });
            return true;
        }
        if ("styleBlackOpaque".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.setStatusBarStyle("blackopaque");
                }
            });
            return true;
        }
        return false;
    }
}

